
/***************************************************************************
**
**    $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMTYPE.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
**    $Log:   D:/EP196/SRC/LOG/SYMSVR/SYMTYPE.H__  $
** 
**    Rev 1.0   15 Aug 1997 14:04:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: typetbl.h
**
** Title: Type Table
**
** Purpose:
**  Create and manage all simple and complex data types
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EP196/SRC/LOG/SYMSVR/SYMTYPE.H__   1.0   15 Aug 1997 14:04:24   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _TYPETBL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class TypeTable : public Table {

private:

   TABLE_OFFSET availMemOffset;  // acts as ptr to start of available mem ;
                                 // also equals the number of bytes used ;
   U16 bytesThrownAway;          // measurement of memory loss ;
   TYPE_INDEX typeIndex;         // index to the last type header added. ;
                                 // all future put bytes will operate using ;
                                 // this index.
   TYPE_INDEX maxTypeIndex;      // holds the value of the largest type ;
                                 // index stored away so far. ;

public:
   // constructor ;
   TypeTable();

//---------------------------------------------------------------------------
// AllocBytes
//
// Purpose:
//    Allocate 1 to 64k bytes into table.  Returns offset to start of data.
//
// Input parameters:
//    size: number of bytes
//
// Output parameters:
//    tableDataOffset: offset to start of stored bytes.
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE AllocBytes(U16 size, TABLE_OFFSET& tableDataOffset);


//---------------------------------------------------------------------------
// GetAvailMemOffset
//
// Purpose:
//    Return the value of the variable that points to the next available
//    location in the table to add data.
//
//---------------------------------------------------------------------------
TABLE_OFFSET GetAvailMemOffset() {return availMemOffset;};


//---------------------------------------------------------------------------
// GetBytesThrownAway
//
// Purpose:
//    FOR TESTING.
//    Return the value of the variable holding the number of bytes that were
//    "discarded" when it crossed the allocated boundary (which required
//    ReAlloc)
//
//---------------------------------------------------------------------------
U16 GetBytesThrownAway() { return bytesThrownAway; };


// GetMaxTypeIndex
//
// Purpose:
//    Returns the largest type index used so far ;
//
//---------------------------------------------------------------------------
RETCODE GetMaxTypeIndex(TYPE_INDEX &typeIndexMax) { 
   typeIndexMax = maxTypeIndex;
   return GOOD;
};


//---------------------------------------------------------------------------
// GetTypeIndex
//
// Purpose:
//    Returns the type index of the current type header. ;
//
//---------------------------------------------------------------------------
U32 GetTypeIndex(VOID) { return typeIndex; };


//---------------------------------------------------------------------------
// IncrementMemberCount
//
// Purpose:
//    Every time a type is added to the table the member count in the type ;
//    header must be incremented.
//
//---------------------------------------------------------------------------
RETCODE IncrementMemberCount(VOID);


//---------------------------------------------------------------------------
// InitBasicTypes
//
// Purpose:
//    Initialize the builtin language types ;
//
//---------------------------------------------------------------------------
RETCODE InitBasicTypes(VOID);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// PutBytes
//
// Purpose:
//    Insert 1 to 64K bytes into table.  Uses type index from last type_hdr.
//    This routine is used for putting structures into the table by passing
//    a pointer to the structure with size = sizeof(struct).
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//
// Output parameters:
//    offset: offset to head of data just stored
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE PutBytes(U8 *inputDataPtr, U16 size, TABLE_OFFSET &offset);


//---------------------------------------------------------------------------
// PutHeader
//
// Purpose:
//    Insert a type header into the type table.  
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//    index: the index for the header to be added
//
// Output parameters:
//    none:
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//
//------------------------------------------------------------------------
RETCODE PutHeader(U8 *inputDataPtr, U16 size, TYPE_INDEX index);


//---------------------------------------------------------------------------
// SetAvailableMem
//
// Purpose:
//    TESTING ONLY!!  Positions the unused memory pointer to a new location.
//---------------------------------------------------------------------------
VOID SetAvailableMem(U32 setValue) {

   availMemOffset = min(setValue, tableSize);
}


//---------------------------------------------------------------------------
// UpdateMAUSize
//
// Purpose:
//    When a new type is added the size of the new type in MAU's needs to ;
//    be updated. ;
//---------------------------------------------------------------------------
RETCODE UpdateMAUSize(TYPE_INDEX prevIndex);


//---------------------------------------------------------------------------
// UpdateRecordSize
//
// Purpose:
//    When a new type is added the size of the entire type record needs to ;
//    be updated. ;
//---------------------------------------------------------------------------
RETCODE UpdateRecordSize(U16 setValue);

};  // end of class MemPool

#endif

#define _TYPETBL_
#endif
/******************************** E O F *************************************/
