#ifndef _trcins_h
#define _trcins_h

#include "trcobj.h"

#include "dadob.h"
#include "dad196.h"   

                                          
class CTraceDqMem : public CBaseDADMem
{
public:
	CTraceDqMem() {};
	enum { ERR_FRAME_INVALID = 2200, ERR_FRAME_ADDR_LEAP};	

protected:
	CFramePos 	m_SiteFrom; // from site
	CFramePos 	m_SiteTo; // end site
	CFramePos 	m_SiteCur; // current site
	
	BOOL		m_bInsStart;

private:           
	CDADAddr	m_lastAddr;
	
	CFramePos	m_SaveSiteCur;
	BOOL		m_bSaveInsStart;  
	CDADAddr	m_SaveCurAddr;

protected:
	BOOL		SetCurAddr();
			
public:
	virtual 	BOOL ReadByte(BYTE&); 
	virtual		BOOL WriteBytes(BYTE*, BYTE) {return TRUE;};
	virtual 	BOOL UpdateBuffer() {return TRUE;};
	
	void		SaveStatus();
	void		RestoreStatus();
	void		MarkInsStart();  
	void		GetFrame(CFramePos&); 
	void		SetFrameRange(CFramePos, CFramePos);
	
	BOOL		SetCurSite(CFramePos newPos);
	BOOL		SkipInvalidFrame();
	BOOL		SkipOneByte();   
	BOOL		FlushBytes(); // for jump instruction
	BOOL		FlushAsOddAddr(); // for first byte after jump instruction
	BOOL 		FlushBytesAsNeed(const ADDR& nextAddr); // for branch instruction
};
                   
class CDADTraceDq : public CObject
{                        
public:
	CDADTraceDq(){ m_pDadOk = &m_dad196;};
	
	enum {MAX_TRY_TIMES=7, MAX_TRY_INS=5};

protected:
	CObListExt	m_listFrame;
	CObListExt	m_listAddr;
	
	CStringList m_listInstruction;

	C196DAD		m_dad196;
	CTraceDqMem m_DADMem;
	CBaseDAD*	m_pDadOk;                 
	
public:
//	CObList&	GetFrameList() { return m_listFrame; };
//	CObList&	GetAddrList() { return m_listAddr; };
//	CStringList& GetResultList() { return m_listResult; };
	
	BOOL		DasTraceIns(CFramePos SiteFrom, CFramePos SiteEnd);
	BOOL		TryInsBegin(CFramePos& InsStart, CFramePos SiteEnd);
	
	void		DumpDadIns(DWORD& dwInsNum, IntroInsData* pInsData, 
					CInsFrame* pInsFrame); 
};
	   
#endif
	   
/***********************************end of file*********************************/
