#include "stdafx.h"

#include "trcobj.h"  
#include "trcserve.h"

extern CTraceManage traceMan;

CFramePos::CFramePos(DWORD dwExtSite, BYTE byIntSite)
{
	m_dwExtSite = dwExtSite;
	m_byIntSite = byIntSite;
}

CFramePos::CFramePos(const CFramePos& frame)
{
	m_dwExtSite = frame.m_dwExtSite;
	m_byIntSite = frame.m_byIntSite;
}	

void CFramePos::Set(DWORD dwExtSite, BYTE byIntSite)
{
	m_dwExtSite = dwExtSite;
	m_byIntSite = byIntSite;
}

const CFramePos& CFramePos::operator++()
{       
	ASSERT(m_dwExtSite >= 0 && 
		   m_dwExtSite <= traceMan.m_dwFrameNum-1);
		   
	if (traceMan.IsTraceCycleByte(m_dwExtSite))
	{
		m_byIntSite = 0;
	}		
	else m_byIntSite = m_byIntSite == 0 ? 
							(BYTE)1 : (BYTE)0;
    
    if (m_byIntSite == 0)   
    	if (m_dwExtSite < traceMan.m_dwFrameNum-1)
    		m_dwExtSite ++;
    	
	return *this;    	
}

const CFramePos& CFramePos::operator--()
{
	ASSERT(m_dwExtSite >= 0 && 
		   m_dwExtSite <= traceMan.m_dwFrameNum-1);

	if (m_byIntSite == 1)
		m_byIntSite = 0;
	else if (m_dwExtSite > 0)
	{
		m_dwExtSite--;
		
		if (traceMan.IsTraceCycleByte(m_dwExtSite))
			m_byIntSite = 0;
		else m_byIntSite = 1;
	}
    	
	return *this;    	
}

const CFramePos& CFramePos::operator++(int /*nInc*/)
{       
	ASSERT(m_dwExtSite >= 0 && 
		   m_dwExtSite <= traceMan.m_dwFrameNum-1);
		   
	if (traceMan.IsTraceCycleByte(m_dwExtSite))
	{
		m_byIntSite = 0;
	}		
	else m_byIntSite = m_byIntSite == 0 ?
						(BYTE)1 : (BYTE)0;
    
    if (m_byIntSite == 0)   
    	if (m_dwExtSite < traceMan.m_dwFrameNum-1)
    		m_dwExtSite ++;
    	
	return *this;    	
}

const CFramePos& CFramePos::operator--(int /*nInc*/)
{
	ASSERT(m_dwExtSite >= 0 && 
		   m_dwExtSite <= traceMan.m_dwFrameNum-1);

	if (m_byIntSite == 1)
		m_byIntSite = 0;
	else if (m_dwExtSite > 0)
	{
		m_dwExtSite--;
		
		if (traceMan.IsTraceCycleByte(m_dwExtSite))
			m_byIntSite = 0;
		else m_byIntSite = 1;
	}
    	
	return *this;    	
}
	
BOOL CFramePos::operator<(const CFramePos& frame)
{
	if (m_dwExtSite < frame.m_dwExtSite) return TRUE;
	
	if (m_dwExtSite == frame.m_dwExtSite &&
		m_byIntSite < frame.m_byIntSite)
		return TRUE;
		
	return FALSE;
}

BOOL CFramePos::operator<=(const CFramePos& frame)
{
	if (m_dwExtSite < frame.m_dwExtSite) return TRUE;
	
	if (m_dwExtSite == frame.m_dwExtSite &&
		m_byIntSite <= frame.m_byIntSite)
		return TRUE;
		
	return FALSE;
}	

BOOL CFramePos::operator>(const CFramePos& frame)
{
	if (m_dwExtSite > frame.m_dwExtSite) return TRUE;
	
	if (m_dwExtSite == frame.m_dwExtSite &&
		m_byIntSite > frame.m_byIntSite)
		return TRUE;
		
	return FALSE;
}	

BOOL CFramePos::operator>=(const CFramePos& frame)
{
	if (m_dwExtSite > frame.m_dwExtSite) return TRUE;
	
	if (m_dwExtSite == frame.m_dwExtSite &&
		m_byIntSite >= frame.m_byIntSite)
		return TRUE;
		
	return FALSE;
}	                 

const CFramePos& CFramePos::operator=(const CFramePos& frame)
{
	m_dwExtSite = frame.m_dwExtSite;
	m_byIntSite = frame.m_byIntSite;
	
	return *this;
}

BOOL CFramePos::operator<(DWORD dwFrame)
{
	return m_dwExtSite < dwFrame;
}	                             

BOOL CFramePos::operator<=(DWORD dwFrame)
{
	return m_dwExtSite <= dwFrame;
}	                             

BOOL CFramePos::operator>(DWORD dwFrame)
{
	return m_dwExtSite > dwFrame;
}	                             

BOOL CFramePos::operator>=(DWORD dwFrame)
{
	return m_dwExtSite >= dwFrame;
}	                             
	
			
IMPLEMENT_DYNAMIC(CObListExt, CObList)

CObListExt::CObListExt() : CObList()
{
}

CObListExt::~CObListExt()
{
	RemoveFreeAll();
}        

void CObListExt::RemoveFreeAll()
{
	ASSERT_VALID(this);
	
	if (m_nCount==0) return;
	
	CNode* pNode = m_pNodeHead;  
	CNode* pNextNode;
	
	while(pNode){
		pNextNode = pNode->pNext;
		delete (CObject*)pNode->data;
		pNode = pNextNode;
	}       
	
	RemoveAll();
}

IMPLEMENT_DYNAMIC(CInsFrame, CObject)

		
void CInsFrame::SetFrameInfo(CFramePos frameCur, CFramePos frameNext)
{
	memcpy(&m_frameCur, &frameCur, sizeof(CFramePos));
	memcpy(&m_frameNext, &frameNext, sizeof(CFramePos));
}

void CInsFrame::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
		ar << m_frameCur.m_dwExtSite << m_frameCur.m_byIntSite
		   << m_frameNext.m_dwExtSite << m_frameNext.m_byIntSite;
	else
		ar >> m_frameCur.m_dwExtSite >> m_frameCur.m_byIntSite
		   >> m_frameNext.m_dwExtSite >> m_frameNext.m_byIntSite;
};

const CInsFrame& CInsFrame::operator=(const CInsFrame& frame)
{
	m_frameCur = frame.m_frameCur;
	m_frameNext = frame.m_frameNext;
		
	return *this;
}
