#ifndef _trcobj_h
#define _trcobj_h

#include <afxcoll.h>

class CFramePos{
public:    
	CFramePos() {};
	CFramePos(DWORD dwExtSite, BYTE byIntSite);
	CFramePos(const CFramePos& frame);

	DWORD m_dwExtSite; // frame site
	BYTE  m_byIntSite; // whether it is the first byte of this frame
	
	void  Set(DWORD dwExtSite, BYTE byIntSite);

	const CFramePos& operator++();
	const CFramePos& operator--(); 
	const CFramePos& operator++(int nInc);
	const CFramePos& operator--(int nInc);
			
	BOOL operator<(const CFramePos& frame);
	BOOL operator<=(const CFramePos& frame);
	BOOL operator>(const CFramePos& frame);
	BOOL operator>=(const CFramePos& frame);
	
	BOOL operator<(DWORD dwFrame);
	BOOL operator<=(DWORD dwFrame);
	BOOL operator>(DWORD dwFrame);
	BOOL operator>=(DWORD CFrame);
	const CFramePos& operator=(const CFramePos& frame);
};

class CObListExt : public CObList
{ 
	DECLARE_SERIAL(CObListExt)

public:
	CObListExt();                      
	virtual ~CObListExt();
	void RemoveFreeAll();
};

class CInsFrame : public CObject
{ 
	DECLARE_SERIAL(CInsFrame)
	
public:          
	CInsFrame() {};
	
	void SetFrameInfo(CFramePos frameCur, CFramePos frameNext);
	    
public:
	const CInsFrame& operator=(const CInsFrame& frame);

	CFramePos m_frameCur;
	CFramePos m_frameNext; 
	
	void Serialize(CArchive& ar);
};
                


#endif

/*******************************end of file*****************************/
