/***************************************************************************
**
**    $Header: 
**
**    $Log: 
****************************************************************************/

/***************************************************************************
**
** File name : TRCSERVE.H
** Author:Richard
** Description:
**
**
**    Finished date: 
**
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _trcserve_h
#define _trcserve_h

#include "abiextfn.h"              
#include "trcpub.h"   
#include "trcobj.h"

//Trcae server functions as an interface between ABI and shell or trace
// window.
#define MAX_TRC_LINE       128
#define MAX_INST_LINE      200   //max number of m_pTraceInfo
#define MAX_TRCWIN_LINE    50


// base class for event, level, trigger and trace                  
class CTraceBase
{
public:
	CTraceBase();
	virtual ~CTraceBase();       
	                         
	enum CardType{ SINGLE_CARD, ALL_CARD, MASK_CARD}; 
	enum {ADDR_TYPE, DATA_TYPE};
	enum {STATUS_S=1, STATUS_R=4, STATUS_W=2, STATUS_AK=8, STATUS_NONE = 16};
	enum {OP_CLEAR, OP_SET};
	enum {SHOWINSHELL, SHOWMESSAGEBOX};  
	enum {TRACE_ICE_RUNNING = 1};                                                                           
                                                                             
protected:
    char		*m_pArgPoint[35];
    int			m_nArgMax;   
    
    CString		m_strDisplay; // for display on shell
    int			m_nClearFlag; // 1=clear
    
protected:    
    BOOL	IsKeyword(const char* ob, const char* key);
    BOOL	IsContainKeyword(const char* ob, const char* key);
    
    BOOL	IsPAddr(char* p, DWORD& dwAddr);
    BOOL	IsEventData(char* p, WORD& wData);   
    BOOL	IsCount(char* p, WORD& wData);
    BOOL	IsListFrame(char* p, DWORD& wData);
    BOOL	isNum(char * p);
    BOOL	IsWildCard(char * p);
    int		IsStatus(char *str);
    
    int 	StrChrNum(const char *szStr, char ch);
    int		StrChrNumNoCase(const char *szStr, char ch);   
    
    int		GetAddrBank(DWORD dwValue);

	void 	StrFromValue(char* szStr, DWORD dwValue, int nLen);
	
    
    void	PreStoreArg(int nArgc, char** pszArgv);
    CardType WildCard(const char* pszArgv, DWORD& dwValue, 
    			DWORD& dwMask, int nAddrType);

	void	ShowToShell();
	void	SetByShell();
	void	Clear();

	virtual void	SimplifySet(); // simplify user setting
	
	virtual void	ResetTmpData();
	virtual void	ResetContents(void* pData);
	virtual BOOL	SetFW();
	
public:
    BOOL	IsBinary(const char* szBuf, int nAddrType);
	void 	StrFromValueMask(char* szStr, DWORD dwValue, DWORD dwMask, 
    		int nLen, int nType);
    void 	ValueMaskFromStr(const char* szStr, DWORD& dwValue, 
    		DWORD& dwMask, int nBase, int nType);

    void 	DisplayErrorMessage(unsigned long nErrorID, int nFlag=SHOWINSHELL);
	BOOL	Init();
	void 	ShellCmd(int nArgc, char** pszArgv);
	BOOL	RestoreSet();   
	
	void Serialize(CArchive& ar);
};

class CBusEvent : public CTraceBase
{
public:
	CBusEvent();
	CBusEvent(WORD wEventID);
	~CBusEvent();

    enum {ADDR_NOT_SET=0, ADDR_GROUP, ADDR_WILD_CARD, ADDR_RANGE, ADDR_EXCLUDE_RANGE};
    enum {DATA_NOT_SET=0, DATA_SINGLE, DATA_WILD_CARD, DATA_RANGE, DATA_EXCLUDE_RANGE};
    
// member
protected:
	WORD		m_wID; // event ID only be 1 or 2
	BUS_EVENT   m_busEv;
	BUS_EVENT	m_tmpBusEv;
	

//function          
private:                   
    void WildCardAddr(char *Input);
    void WildCardData(char *Input);    
    
    void SetAddrType(int nType);
    int  GetAddrType();
    
    void SetDataWidth(int nByteNum);
    int  GetDataWidth();  
    
    void SetDataType(int nType);
    int  GetDataType();
    
    
    void SetAddr(int& nIndexHere);//analysis input for addr 
    void GetAddrStr(char* szBuf); // for display in shell window
    
    void SetData(int& nIndexHere);//analysis input for data   
    void GetDataStr(char* szBuf);
    
    void SetStatus(int& nIndexHere);//analysis input for status
    void GetStatusStr(char* szBuf);     
    
    void SetCount(int& nIndexHere); //analysis input for count
    void GetCountStr(char* szBuf);

protected:
	void ShowToShell();
	void SetByShell();
	void Clear();

	virtual void	ResetTmpData();            
	virtual void	ResetContents(void* pData);
	virtual BOOL	SetFW();       
	virtual BOOL	ClearFW();
	virtual void	SimplifySet(); // simplify user setting
	virtual BOOL	IsEqualNotSet(BUS_EVENT&);
		
public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL RestoreSet();

// for trace group dialog	
	int  SetByWin(BOOL bClearFlag, BUS_EVENT evData);
	BOOL DumpEvent(BOOL& bClearFlag, BUS_EVENT& evData);
	
	void Serialize(CArchive& ar);
};

class CExtEvent : public CTraceBase // event 3
{
public:
	CExtEvent();  
	CExtEvent(WORD);
	~CExtEvent();
	
	enum { EV_LOW=0, EV_HIGH=1 };
	
protected:    
	WORD	m_wID;
	int		m_nStatus; // High or low
	int		m_nTmpStatus;

protected:
	void ShowToShell();
	void SetByShell();
//	void Clear();

	virtual void	ResetTmpData(); 
	virtual void	ResetContents(void* pData);
	virtual BOOL	SetFW();
	
public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL RestoreSet();
	
// for trace group dialog	
	int  SetByWin(WORD evData);
	BOOL DumpEvent(WORD& evData);      
	
	void Serialize(CArchive& ar);
};

class CLevel : public CTraceBase
{
// constructor
public:         
	CLevel();
	CLevel(WORD wLevelID);
	~CLevel();
	
	enum {TRACE_NOT_SET=0, TRACE_ON, TRACE_OFF};
	enum {TIMER_NOT_SET=0, TIMER_ON, TIMER_OFF};
	enum {ALL_EVENT=10};
		
protected:
	WORD			m_wID; // level ID	only 1 or 2
	TRIGGER_LEVEL	m_level;
	TRIGGER_LEVEL   m_tmpLevel;
	
protected:
    BOOL IsEventID(const char* szBuf, WORD& wID);

    void SetEventLogic(int &nIndexHere);
    void GetEventLogicStr(char* szBuf);
    
    void SetTraceStatus(int &nIndexHere);
    void GetTraceStatusStr(char* szBuf);
    
    void SetTimerStatus(int &nIndexHere);
    void GetTimerStatusStr(char* szBuf);

	virtual void	ResetContents(void* pData);
	virtual void	ResetTmpData(); 
	virtual BOOL	SetFW();

protected:
	void ShowToShell();
	void SetByShell();

public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL RestoreSet();
	
	int	   SetByWin(TRIGGER_LEVEL lvData);
	BOOL   DumpLevel(TRIGGER_LEVEL& lvData);

	void Serialize(CArchive& ar);
};

class CTrigger : public CTraceBase
{
// constructor   
public:
	CTrigger();
	~CTrigger();
	
	enum { TRIGGER_OFF=0, TRIGGER_ON};  
	enum { NOT_RUN=0, RUN=1};
	enum { LV1=1, LV2};   
	enum { DELAY=0, FORWARD, BACKWARD, CENTER};
	
protected:
	WORD			m_nStatus; // trigger on or off
	WORD			m_nTmpStatus;
	
	TRIGGER_LOGIC   m_trig;
	TRIGGER_LOGIC	m_tmpTrig;

private:
	BOOL IsLevelID(const char* szBuf, WORD& wID);
	void GetRunFlagStr(char* szBuf);
	void SetLevel(int &nIndexHere);
    void GetLevelStr(char* szBuf);
    void SetDelay(int &nIndexHere);
    void GetPropertyStr(char* szBuf);

protected:
	void ShowToShell();
	void SetByShell(); 
	void SetTrigStatusByShell();
	void Clear();

	virtual void	ResetTmpData();            
	virtual void	ResetContents(void* pData);
	virtual BOOL	SetFW();
	virtual BOOL	SetFWStatus();
	
public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL RestoreSet();
	
	int    SetByWin(TRIGGER_LOGIC trigData);
	int    SetStatusByWin(BOOL trigStatus);
	BOOL   DumpTrig(TRIGGER_LOGIC& trigData);
	BOOL   DumpTrigStatus(BOOL& trigStatus);

	void Serialize(CArchive& ar);
};

class CQualify : public CTraceBase
{
// constructor
public:
	CQualify();
	~CQualify(); 

    enum {ADDR_NOT_SET=0, ADDR_GROUP, ADDR_WILD_CARD, ADDR_RANGE, ADDR_EXCLUDE_RANGE};
    enum {DATA_NOT_SET=0, DATA_SINGLE, DATA_WILD_CARD, DATA_RANGE, DATA_EXCLUDE_RANGE};
    enum {FILTER_OFF=0, FILTER_ON};  
    enum {STATUS_NOT_SET = 0};
	
protected:
	QUALIFY_INFO		m_qualify;
	QUALIFY_INFO		m_tmpQualify;
	
//function          
protected:                   
    void WildCardAddr(char *Input);
    void WildCardData(char *Input);    
    
    void SetAddrType(int nType);
    int  GetAddrType();
    
    void SetDataWidth(int nByteNum);
    int  GetDataWidth();  
    
    void SetDataType(int nType);
    int  GetDataType();
    
    
    void SetAddr(int& nIndexHere);//analysis input for addr 
    void GetAddrStr(char* szBuf); // for display in shell window
    
    void SetData(int& nIndexHere);//analysis input for data   
    void GetDataStr(char* szBuf);
    
    void SetStatus(int& nIndexHere);//analysis input for status
    void GetStatusStr(char* szBuf);     
    
protected:
	void ShowToShell();
	void SetByShell();
	void Clear();
    
    virtual void	ResetTmpData();            
	virtual void	ResetContents(void* pData);
	virtual BOOL	SetFW();
	virtual void	SimplifySet(); // simplify user setting
	virtual BOOL	IsEqualNotSet(QUALIFY_INFO&);

public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL RestoreSet();

	int    SetByWin(QUALIFY_INFO trigData);
	BOOL   DumpQualify(QUALIFY_INFO& trigData);

	void Serialize(CArchive& ar);
};
		
class CControl : public CTraceBase // control
{
public:
	CControl();
	~CControl();
	
	enum { DISABLE=0, ENABLE=1 };
	enum { RESET=0, NMI=1};
	
protected:    
	WORD 	m_nStatus; // Disable and Enable
	WORD	m_nTmpStatus;

private:
	void	SetReset(int& nIndexHere);
	void	GetResetStr(char* szBuf);
	
	void	SetNmi(int& nIndexHere);
	void 	GetNmiStr(char* szBuf);
	
	void	UniSetStatus(const char* szStr, int nStatusSite);
	int		UniGetStatus(int nStatusSite);
	
protected:
	void ShowToShell();
	void SetByShell();
//	void Clear();

	virtual void	ResetTmpData(); 
	virtual void	ResetContents(void* pData);
	
public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL GetCurStatus();
	BOOL RestoreSet();
};

class CInPort : public CTraceBase // inport
{
public:
	CInPort();
	~CInPort();
	
public:
	void ShellCmd(int nArgc, char** pszArgv);
};

class COutPort : public CTraceBase // inport
{
public:
	COutPort();
	virtual ~COutPort();
	
public:
	void ShellCmd(int nArgc, char** pszArgv);
};

class CCtlTrace : public CTraceBase // trace
{
public:
	CCtlTrace();
	~CCtlTrace();
	
	enum { TRACE_OFF=0, TRACE_ON=1 };
	
protected:    
	int		m_nStatus; // High or low
	int		m_nTmpStatus;

protected:
	void ShowToShell();
	void SetByShell();
	void Clear();

	virtual void	ResetTmpData(); 
	virtual void	ResetContents(void* pData);
	virtual BOOL	SetFW();
	
public:
	BOOL Init();
	void ShellCmd(int nArgc, char** pszArgv);
	BOOL GetCurStatus();
	BOOL RestoreSet();
	
	void SetClearFlag();
	BOOL IsClear(); 
	void ValidBuffer(); // set trace buffer valid again

	int    SetByWin(BOOL trcData);
	BOOL   DumpStatus(BOOL& trcData);
};

class CTraceShow : public CQualify
{
public:
	CTraceShow();
	~CTraceShow();

protected:
	WORD			m_wID; // not used, reserved
	char			m_pSpareBit[10]; // strange, temp used

protected:                   
	int				GetStatus(BYTE status);
	
	const char*		GetStatusStr(BYTE status);
	const char*		GetSpareStr(BYTE status);   

	
	BOOL GetTraceDepth(BUFFER_DEPTH& bufferDep);
	
	void DumpTraceBuf(char* szBuf, const TRACE_INFO* pTraceInfo);
};
	
class CCtlList : public CTraceShow // list
{
public:
	CCtlList();
	~CCtlList();

protected:
	BUFFER_DEPTH	m_depth;
	DWORD			m_dwStartList;
	TRACE_INFO		*m_pTraceInfo;
	
private:
	void	ListTrcDataToShell();
	int 	GetAbiFrame(DWORD& dwStart, DWORD dwEnd);
			
protected:
	
	virtual void	ResetTmpData();   
	
public:
	void 	ShellCmd(int nArgc, char** pszArgv);
	BOOL	GetElapseTimeStr(char *szBuf);
	
};

class CTraceManage : public CCtlList // list
{
public:
	CTraceManage();
	~CTraceManage();           
	
	friend class CTraceDqMem;
	friend class CFramePos;
	
	enum {LINE_FRAME=1, QUALIFY_LINE_FRAME = 10,
		  MAX_HEAD_FRAME_GAP = 20};   
		   
	enum {SETTLE_ERROR=-3, SMALLER=-2, LARGER=-1, ALL_EXIST=0, NEED_MORE, PART_EXIST};
	
	enum CDirection{PAGE_UP=-2, LINE_UP, CURLINE,
		LINE_DOWN, PAGE_DOWN, UP, CUR, DOWN}; 
		
	enum {FRAME_HEAD=1, FRAME_TAIL=2, INS_HEAD = 4,
		INS_TAIL = 8};
	
    typedef struct{
    	CDirection  nDirect;
    	CFramePos	start;
    	DWORD		dwNum;
    }CReadInfo;

protected:    
	BOOL			m_bValid; // whether cache buffer is valid
	DWORD 			m_dwFrameNum; // how many frames exist in trace buffer


protected:
	// used in HitTest and 
	DWORD			m_dwValidFrom;
	DWORD			m_dwValidTo;
	
    int		    	m_nEncounter; // represent whether it encounter tail, head
	DWORD			m_dwFromSite; // first valid frame site in trace buffer
	DWORD			m_dwValidNum; // valid frame number
	CReadInfo		m_readInfo; // more frame need read information

private:  
	int   MustReadAndMerge(int nFlag, DWORD dwBoundary, DWORD dwNeed);
	
	void  ConvertBusForWin(DWORD& dwCurFrame, DWORD& dwFrameNum, 
				FrameData* pReturnBuf);
	BOOL  MergeTraceBuf(int nFlag, DWORD dwValid, DWORD dwNeed,
				TRACE_INFO* pTraceInfo);
	int   ResetTraceBuf(DWORD dwStart, DWORD dwNum);
	int   GetTraceBuffer(DWORD dwStart, DWORD& dwNeed, 
				TRACE_INFO* pTraceBuf);
	int   MustReadTraceUp(DWORD dwEnd, DWORD& dwNeed,
				TRACE_INFO* pTraceInfo);
	int   MustReadTrace(int nFlag, DWORD dwBoundary, DWORD& dwNeed,
				TRACE_INFO* pTraceBuf);
	
	void  SetEncounter(int nFlag);
	void  ClearEncounter(int nFlag);
	BOOL  IsEncounter(int nFlag);
	
	DWORD SetRedundantBegin(int nFlag, DWORD dwNeedNum, 
				DWORD dwCurFrame);
	void  GetScrollInfo(int nFlag, DWORD dwNeedNum,
				int& nDirect, DWORD& dwLineNum);
	int   HitTest(int nFlag, DWORD dwCurFrame, DWORD dwNeedNum);
	int   SettleSite(DWORD dwCurFrame);
	int   FindMatch(DWORD wFrom, DWORD wEnd, DWORD dwCurFrame);

	BOOL  SaveTraceBusToFile(const char* szFileName, DWORD dwStart,
			DWORD dwEnd, BOOL bOverWirte);				
	BOOL  SaveTraceInsToFile(const char* szFileName, DWORD dwStart,
			DWORD dwEnd, BOOL bOverWirte);				

public:  
	void  SetFilter(QUALIFY_INFO& qulify);
	
	void  ClearCache();
	DWORD TS_GetLastFrame();		
	int   TS_GetBusRecord(int nFlag, DWORD& dwCurFrame, DWORD& dwFrameNum, 
				FrameData* pReturnBuf);   
    			
	BOOL  SaveTraceToFile(int nTraceMode, const char* szFileName, DWORD dwStart,
			DWORD dwEnd, BOOL bOverWirte);				


// below for instruction mode
protected:     
	CInsFrame     	*m_pInsFrame;
	IntroInsData	*m_pInsInfo;
			
	BOOL			m_bInsValid; // whether instruction cache buffer is valid
	DWORD			m_dwInsNum; // how many instructions exist in instruction buffer 

private:      
	void 	ConvertInsForWin(DWORD& dwCurFrame, BYTE& byIntNo,
					DWORD& dwInsNum, InsData* pReturnBuf);
			
	BOOL 	IsConnected(DWORD dwFirst, DWORD dwSecond);

	BOOL  	ResetInsBuf(DWORD dwStartSite, DWORD dwNum);

	DWORD 	SetInsRedundantBegin(int nFlag, DWORD dwCurFrame, 
				DWORD dwNeedNum);
	
	int   	InsHitTest(int nFlag, DWORD dwCurFrame, BYTE byIntNo, DWORD dwNeedNum);
	int	  	InsSettleSite(DWORD dwCurFrame, BYTE byIntNo);

	BOOL 	FindFlush(DWORD dwFrom, DWORD dwTo, DWORD& dwGap);
	BOOL 	SetDisasmStart(CFramePos& frameStart);

protected:
// only used in class CTraceDqMem
	BOOL	IsTraceCycleByte(DWORD dwFrameNum);
	int		TraceCycleStatus(DWORD dwFrameNum);
	DWORD	TraceCycleAddr(DWORD dwFrameNum);
	BYTE 	TraceCycleData(const CFramePos& frame);

public: 

    int  	TS_GetInsRecord(int nFlag, DWORD& dwCurFrame, BYTE& byIntNo,
    			DWORD& dwInsNum, InsData* pReturnBuf);

};

#endif	

/**********************************end of file**************************************/

	
	
	