 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/TSTID.CPP   1.14   09 Jan 1997 14:26:32   ZJRD  $
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTID.CPP
//
//  Description: The implementation file for the class: CIdentify.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CIdentify.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
#include "abiextfn.h"
#include "tstid.h"
#include "hosterrs.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void IdentifyCmd(int nArgc, char* pszArgv[]);
extern void ShowLine(char* pszBuffer);
void DisplayErrorMessage(U32 errId, BOOL isUI) {
	char tmp[100];
	
	ErrGetErrorText(errId,tmp);
	
	if(isUI) {
		AfxMessageBox(tmp);
	} else {
		ShowLine(tmp);
	}		
}


void TstIdentify(CString& strCPU, CString& strFW, CString& strSW, 
                 CString& strDOS, CString& strWin);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


void GetCpuName(CString& strName);

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Supply identify information to About dialog.
void TstIdentify(CString& strCPU, CString& strFW, CString& strSW, 
                 CString& strDOS, CString& strWin)
{
    // Execute Identify command.
    CIdentify* pEmulationIdentify = new CIdentify;
    if ( !pEmulationIdentify ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationIdentify->GetIdentifyInformation(strCPU, strFW, strSW, 
                                                   strDOS, strWin);
        delete pEmulationIdentify;
    }

}   // End of TstIdentify().
//TESTINIT
void TstInit(BOOL& isTraceBoardOn)
{
    // Execute Identify command.
    CIdentify* pEmulationIdentify = new CIdentify;
    if ( !pEmulationIdentify ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationIdentify->IdentifyKernel(FALSE);
        isTraceBoardOn = pEmulationIdentify->m_isTraceBoard;
        delete pEmulationIdentify;
      }

}   // End of TstIdentify().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   IdentifyCmd().
//
//  Description: The main control routine of Identify command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void IdentifyCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Identify command.
    CIdentify* pEmulationIdentify = new CIdentify;
    if ( !pEmulationIdentify ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationIdentify->IdentifyAction(nArgc, pszArgv);
        delete pEmulationIdentify;
    }
    
//    CIdentify objIdentify;
//    objIdentify.IdentifyAction(nArgc, pszArgv);

}   // End of IdentifyCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CIdentify.

// Construction.
CIdentify::CIdentify()
{
    // Default intial setting.
    m_uCpuID = 0;
    m_uchMajor = 1;
    m_uchMinor = 0;     
    m_isServer = FALSE;
    m_strSW = "1.0(1.4.1021)";
    
}   // End of CIdentify::CIdentify().


// Destruction.
CIdentify::~CIdentify()
{

}   // End of CIdentify::~CIdentify().


// Emulation Identify command.
void CIdentify::IdentifyAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    m_isServer = FALSE;
    // Call the Identify kernel.
    IdentifyKernel();

}   // End of CIdentify::IdentifyAction().


// Identify kernel routine.
void CIdentify::IdentifyKernel(BOOL isShow)
{
    // Assertion of the input parameters.
    //ASSERT( ICE_OK == m_nErrorID );
    
    // Call ABI function to get CPU ID.
/*
    m_nErrorID = AbiGetCpuId(&m_uCpuID);
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }
*/
    m_isShow = isShow;
    // Call ABI function to get FW ID.
    BYTE bTmp[20];
    m_nErrorID = emuGetID(bTmp);
    if ( 0 != m_nErrorID ) {
		DisplayErrorMessage(ER_ICE_OK+m_nErrorID,m_isServer);
		if ( !m_isServer ) return;
    } else {
    	m_uchMajor = bTmp[2];
    	m_uchMinor = bTmp[3];
    	m_isTraceBoard = (BOOL)bTmp[4];
    }
    
    // Get DOS & Windows version.
    DWORD dwVersion = GetVersion();
    m_wDOS = HIWORD(dwVersion);
    m_wWin = LOWORD(dwVersion);

    // Display the ID information.             
    DisplayIdentifyInfo();

}   // End of CIdentify::IdentifyKernel().


// Display the ID information.
void CIdentify::DisplayIdentifyInfo(void)
{
    // Assertion of the input parameters.
    //if(m_isServer) return;
    // Display CPU type.
    ShowCPU();
    
    // Display FW version.
    ShowFW();
    
    // Display SW version.
    ShowSW();
    
    // Display DOS version.
    ShowDOS();
    
    // Display Windows version.
    ShowWin();
    
}   // End of CIdentify::DisplayIdentifyInfo().


// Display CPU type.
void CIdentify::ShowCPU(void)
{
    // Get the CPU type.
    ::GetCpuName(m_strCPU);
    
    // Format CPU type.
    strcpy(m_pszResult, "Emulation CPU: ");
    strcat(m_pszResult, m_strCPU);

    // Show the information.
    if(m_isShow) ShowLine(m_pszResult);

}   // End of CIdentify::ShowCPU().


// Display FW version.
void CIdentify::ShowFW(void)
{
    // Assertion of the input parameters.
    
    // Format FW version.
    strcpy(m_pszResult, "FW version: ");
    
    char pszVersion[6];
    sprintf(pszVersion, "%02X.%02X", m_uchMajor, m_uchMinor);

    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    if(m_isShow)
    	ShowLine(m_pszResult);
    m_strFW = pszVersion;
    
}   // End of CIdentify::ShowFW().


// Display SW version.
void CIdentify::ShowSW(void)
{
    // Assertion of the input parameters.

    // Format SW version.
    strcpy(m_pszResult, "SW version: ");

    char pszVersion[20];
    strcpy(pszVersion, m_strSW.GetBuffer(m_strSW.GetLength()+5)); 
    m_strSW.ReleaseBuffer();

    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    if(m_isShow)
    	ShowLine(m_pszResult);
    m_strSW = pszVersion;
    
}   // End of CIdentify::ShowSW().


// Display DOS version.
void CIdentify::ShowDOS(void)
{
    // Assertion of the input parameters.

    // Format DOS version.
    strcpy(m_pszResult, "MS-DOS version: ");

    char pszVersion[6];
    sprintf(pszVersion, "%d.%d", HIBYTE(m_wDOS), LOBYTE(m_wDOS));

    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    if(m_isShow)
    	ShowLine(m_pszResult);
    m_strDOS = pszVersion;
    
}   // End of CIdentify::ShowDOS().


// Display Windows version.
void CIdentify::ShowWin(void)
{
    // Assertion of the input parameters.

    // Format Win version.
    strcpy(m_pszResult, "Windows version: ");

    char pszVersion[20];
    if(0x5f03 != m_wWin)
    	sprintf(pszVersion, "%d.%d", LOBYTE(m_wWin), HIBYTE(m_wWin));
    else sprintf(pszVersion, "%s", "Windows 95");
    
    strcat(m_pszResult, pszVersion);
    
    // Show the information.
    if(m_isShow)
    	ShowLine(m_pszResult);
    m_strWin = pszVersion;
    
}   // End of CIdentify::ShowWin().


// Display Target Clock .
void CIdentify::ShowClock(void)
{
    // Assertion of the input parameters.

    // Format Win version.
    char *ScaleMsg[] = {
       "Ghz",
       "Mhz",
       "Khz",
       "hz"
    };
     
    strcpy(m_pszResult, "Target Clock: ");

    char pszTemp[100];
    if ( m_chScale > 3 || m_chScale < 0 ) m_chScale = 3;
    sprintf(pszTemp, "%f %s", m_fClock, ScaleMsg[m_chScale]);

    strcat(m_pszResult, pszTemp);
    
    // Show the information.
    if(m_isShow)
    	ShowLine(m_pszResult);
    m_strClock = pszTemp;
    
}   // End of CIdentify::ShowWin().


// Supply identify information to About dialog.
void CIdentify::GetIdentifyInformation(CString& strCPU, CString& strFW, 
                    CString& strSW, CString& strDOS, 
                    CString& strWin)
{
    // Set the server flag.
    m_isServer = TRUE;

    // Call the Identify kernel.
    IdentifyKernel(FALSE);
    
    // Get the parameters.
    strCPU = m_strCPU;
    strFW = m_strFW;
    strSW = m_strSW;
    strDOS = m_strDOS;
    strWin = m_strWin;         

}   // End of CIdentify::GetIdentifyInformation().
                    
//////////////////////////////// End of File ////////////////////////////////
