
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/TSTID.H__   1.14   09 Jan 1997 14:26:34   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/TSTID.H__  $
** 
**    Rev 1.0   13 Aug 1996 09:19:16   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTID.H
//
//  Description: The header file for the class: CIdentify.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CIdentify.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TSTID_
#define _TSTID_                                    

extern void TstIdentify(CString& strCPU, CString& strFW, CString& strSW, 
                 CString& strDOS, CString& strWin);

/////////////////////////////////////////////////////////////////////////////
// CIdentify class.
class CIdentify 
{
// Construction & Destruction.
public:
    CIdentify();
    ~CIdentify();
   BOOL m_isServer;
   int m_nErrorID;
   char m_pszResult[100];
   BOOL m_isShow;
// Member variables.
public:
	
private:
    enum { MIN_CPU = 0, MAX_CPU = 200 };
    UINT m_uCpuID;
    UCHAR m_uchMajor, m_uchMinor;
    WORD m_wDOS;
    WORD m_wWin;
    float m_fClock;
    BYTE m_chScale;   
public:    
    BOOL m_isTraceBoard;
    
private:
    CString m_strCPU;
    CString m_strFW;
    CString m_strSW;
    CString m_strDOS;
    CString m_strWin;
    CString m_strClock;
    
// Implementations.
public:
    void IdentifyKernel(BOOL isShow=TRUE);
private:    
    void DisplayIdentifyInfo(void);
    
    void ShowCPU(void);
    void ShowFW(void);
    void ShowSW(void);
    void ShowDOS(void);
    void ShowWin(void);
    void ShowClock(void);
    
public:
    void IdentifyAction(int nArgc, char* pszArgv[]);
    
    void GetIdentifyInformation(CString& strCPU, CString& strFW, 
                    CString& strSW, CString& strDOS, 
                    CString& strWin);

};  // End of class: CIdentify.

#endif
//////////////////////////////// End of File ////////////////////////////////
