#define  __cplusplus
#include "stdafx.h"
#include "tutorial.h"
#include "MAINFRM.h" 
#include "SRCWND.h"
//#include "dialog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern void Delay(int nDelay,BOOL bShow=0);
extern BOOL g_mbCanDoNext;
extern BOOL g_bAuto;
extern UINT g_uTick;
/////////////////////////////////////////////////////////////////////////////
// CArrowMsgDlg dialog


CArrowMsgDlg::CArrowMsgDlg(CRect rect,UINT ID,BOOL bUp,CWnd* pParent /*=NULL*/)
	: CDialog(CArrowMsgDlg::IDD, pParent),rectMsg(rect),stringID(ID),m_bUpper(bUp)
{
	//{{AFX_DATA_INIT(CArrowMsgDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	Create(IDD,pParent); 
}

void CArrowMsgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CArrowMsgDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}
          
BEGIN_MESSAGE_MAP(CArrowMsgDlg, CDialog)
	//{{AFX_MSG_MAP(CArrowMsgDlg)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CArrowMsgDlg message handlers
BOOL CArrowMsgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetAMsgDlg(this);
    MoveWindow(rectMsg.left,rectMsg.top,rectMsg.Width(),rectMsg.Height());
	if(m_bUpper)              
	  {
	   CRect r;
	   MoveWindow(rectMsg.left,rectMsg.top,rectMsg.Width(),rectMsg.Height());
	   GetDlgItem(IDCANCEL)->GetWindowRect(&r);
	   GetDlgItem(IDCANCEL)->MoveWindow(rectMsg.Width()-60,rectMsg.Height()-19,
	                                     r.Width(),r.Height());
	  }   
	else
	  {
	   CRect r;  
	   int x=rectMsg.Height();
	   rectMsg.top-=x;
	   rectMsg.bottom-=x;
	   MoveWindow(rectMsg.left,rectMsg.top,rectMsg.Width(),rectMsg.Height());
	   GetDlgItem(IDCANCEL)->GetWindowRect(&r);
	   GetDlgItem(IDCANCEL)->MoveWindow(rectMsg.Width()-60,
	                                    rectMsg.Height()-int(rectMsg.Height()-2)/6-19,
	                                    r.Width(),r.Height());
	  }

	// TODO: Add extra initialization here
	GetParent()->SetFocus();
	return TRUE;  // return TRUE  unless you set the focus to a control
} 

void CArrowMsgDlg::OnSetFocus(CWnd* pOldWnd)
{
	CDialog::OnSetFocus(pOldWnd);
	
	// TODO: Add your message handler code here
	GetParent()->SetFocus();
}

void CArrowMsgDlg::OnKillFocus(CWnd* pNewWnd)
{
	CDialog::OnKillFocus(pNewWnd);
	
	// TODO: Add your message handler code here
	GetParent()->SetFocus();
}

BOOL CArrowMsgDlg::OnEraseBkgnd(CDC *pDC)
{          
 return 1;
}               

void CArrowMsgDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	dc.SaveDC();
	const int nXPos=50;
	int nYPos;
	
	CString *pString=new CString;
	CRect   rectWin;          
	CRect   rectRgn;
	CBitmap *pBMsgBit   = new CBitmap;
	GetClientRect(&rectWin);  
	
	nYPos=int((rectWin.Height()-2)/6);
	
	if(m_bUpper)
	  rectRgn.SetRect(nXPos+6,nYPos+6,rectWin.right-4,rectWin.bottom-20);
	else
	  rectRgn.SetRect(nXPos+6,6,rectWin.right-4,rectWin.bottom-nYPos-20);
	
	
	POINT point[]={0,0, 
	               nXPos,nYPos,
	               rectWin.Width()-1,nYPos, 
	               rectWin.Width()-1,rectWin.Height()-2, 
	               nXPos,rectWin.Height()-2, 
	               nXPos,int(long(nXPos*480)/640)};
	
	
	pBMsgBit->LoadBitmap(IDB_BRUSH);
	CBrush brush(pBMsgBit);
    dc.SelectObject(&brush);
    if(!m_bUpper)                           
      {               
       dc.SetMapMode(MM_ISOTROPIC);
       dc.SetWindowOrg(0,rectWin.Height());
       dc.SetWindowExt(rectWin.Width(),-rectWin.Height());
       dc.SetViewportOrg(rectWin.left,rectWin.top);
       dc.SetViewportExt(rectWin.right,rectWin.bottom);
      } 
    dc.Polygon(point,sizeof(point)/sizeof(POINT));
    
    dc.RestoreDC(-1);
    dc.SaveDC();
    
    if(stringID)
      {      
         ShowBitmap(&dc, rectRgn, stringID, 0);          
//       ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->DrawMsgText(&dc,&rectRgn,stringID,1);
      }  
     
    pBMsgBit->DeleteObject();
    delete pBMsgBit; 
    delete pString;
	dc.RestoreDC(-1);
	// Do not call CDialog::OnPaint() for painting messages
}
void CArrowMsgDlg::OnCancel()
{
	// TODO: Add extra cleanup here          
	((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetAMsgDlg(0);
    DestroyWindow();
}

/////////////////////////////////////////////////////////////////////////////
// CMsgDlg dialog


CMsgDlg::CMsgDlg(BOOL bOk,int &nExitID,UINT StringID,int nCount/*=NULL*/,CWnd* pParent /*=NULL*/)
	: CDialog(CMsgDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMsgDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT   
	g_mbCanDoNext=0;
	m_bOk      = bOk;
	m_pExitID  = &nExitID;
	m_StringID = StringID;
	m_nCount   = nCount;
}

void CMsgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMsgDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMsgDlg, CDialog)
	//{{AFX_MSG_MAP(CMsgDlg)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDNO, OnNo)
	ON_BN_CLICKED(IDYES, OnYes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMsgDlg message handlers

BOOL CMsgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	GetDlgItem(IDOK)->ShowWindow(SW_HIDE);
	GetDlgItem(IDYES)->ShowWindow(SW_HIDE);
    GetDlgItem(IDNO)->ShowWindow(SW_HIDE);

	if(m_bOk) 
	  {
	   GetDlgItem(IDOK)->ShowWindow(SW_SHOW);
	  }
	else
	  {
		GetDlgItem(IDYES)->ShowWindow(SW_SHOW);
	    GetDlgItem(IDNO)->ShowWindow(SW_SHOW);
	  }        
	g_mbCanDoNext=1;  
	return TRUE;  // return TRUE  unless you set the focus to a control
} 

void CMsgDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CRect   rectWin;
	CBitmap *pBitmap = new CBitmap;
	pBitmap->LoadBitmap(IDB_BRUSH);
	CBrush  brush(pBitmap);
	GetClientRect(&rectWin);
	dc.FillRect(rectWin,&brush);
	pBitmap->DeleteObject();
	delete pBitmap;            
	dc.SaveDC();
	// Do not call CDialog::OnPaint() for painting messages

	CString string;         
	CFont   font;
	LOGFONT logFont;

  	_fmemset(&logFont,0,sizeof(LOGFONT));
	logFont.lfHeight=30;
	logFont.lfWidth=15;
	logFont.lfWeight=600;
	lstrcpy(logFont.lfFaceName,"Arial");
	font.CreateFontIndirect(&logFont);
	dc.SelectObject(&font);
	
	string.LoadString(IDS_TUTORIAL_MSG_TITLE);
	int  xChar=int(dc.GetTextExtent(string.GetBuffer(string.GetLength()),string.GetLength()).cx);   
	CRect rect(int((rectWin.Width()-xChar)/2),10,rectWin.right,rectWin.bottom);
	((CMainFrame *)GetParent())->DrawMsgText(&dc,rect,IDS_TUTORIAL_MSG_TITLE,1,
	                                         30,15,600,RGB(0,0,0));
    rect.SetRect(int((rectWin.Width()-xChar)/2)-1,10-1,rectWin.right,rectWin.bottom);
	
	((CMainFrame *)GetParent())->DrawMsgText(&dc,rect,IDS_TUTORIAL_MSG_TITLE,1,
	                                         30,15,600,RGB(128,0,128));

    rect.SetRect(30,60,rectWin.right,rectWin.bottom);
	((CMainFrame *)GetParent())->DrawMsgText(&dc,rect,m_StringID,1,
	                                         14,7,300);
    dc.RestoreDC(-1);
}

void CMsgDlg::OnNo()
{
	// TODO: Add your control notification handler code here
	*m_pExitID=IDNO;
	CDialog::OnOK();
}

void CMsgDlg::OnOK()
{
	// TODO: Add extra validation here
    *m_pExitID=IDOK;
	CDialog::OnOK();
	
}

void CMsgDlg::OnYes()
{
	// TODO: Add your control notification handler code here
	*m_pExitID=IDYES;
	CDialog::OnOK();
}


/////////////////////////////////////////////////////////////////////////////
// CTDialog dialog


CTDialog::CTDialog(UINT IDD ,CWnd* pParent /*=NULL*/,
                   BOOL bModal /*=1*/,BOOL bChild/*=0*/,
                   BOOL bSetByUse/*=TRUE*/)
         : CDialog(IDD, pParent)
         ,m_bModal(bModal)
         ,m_bChild(bChild)
         ,m_bSetByUse(bSetByUse)//Step message box
{                   
     g_mbCanDoNext=0;
     ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetAMsgDlg(0);
	//{{AFX_DATA_INIT(CTDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    if(g_bAuto)
      {
       AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);
      }
}

void CTDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTDialog, CDialog)
	//{{AFX_MSG_MAP(CTDialog)
	ON_WM_NCMOUSEMOVE()
	ON_WM_NCLBUTTONDOWN()
	ON_WM_NCLBUTTONDBLCLK()
	ON_WM_NCLBUTTONUP()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTDialog message handlers

BOOL CTDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	CButton *pHelpBtn=(CButton *)GetDlgItem(ID_HELP);
	if(pHelpBtn)
	  pHelpBtn->ShowWindow(SW_SHOW);
	// Set Dialog Pos;
	m_uFocus=SETSUCCESS;

	CRect  rectDlg;
	CPoint point(0,0);
	GetWindowRect(&rectDlg);
	GetParent()->ClientToScreen(&point);
	MoveWindow(point.x,point.y,rectDlg.Width(),rectDlg.Height());

    if(!m_bModal)	
     {
		  FilterLMClk(1,GetSafeHwnd());
		  if(!m_bChild)
		    {
			  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetByUser(0);	
		      ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDlgWnd((CDialog *)this);
		    }  
     }
    else 
     ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetByUser(TRUE);
	// TODO: Add extra initialization here
	g_mbCanDoNext=1;           
    if(g_bAuto)
    {
       AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO,5000,NULL);
    }

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTDialog::OnNcMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
//	CDialog::OnMouseMove(nFlags, point);
}

void CTDialog::OnNcLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	//CDialog::OnNcLButtonDown(nFlags, point);
}

void CTDialog::OnNcLButtonDblClk(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	//CDialog::OnNcLButtonDblClk(nFlags, point);
}

void CTDialog::OnNcLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	//CDialog::OnNcLButtonUp(nFlags, point);
}

void CTDialog::OnOK()
{
	 
	 if(m_bSetByUse)
	   ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetByUser(0);
	  
	 if(!m_bChild)               
	     {       
	       FilterLMClk(0,0);
		   ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDlgWnd(0);
		   //if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetStepMsgBox())
		   //  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->RestoreBk(MS_STEP);
		   if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetOverMsgBox())
		     ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->RestoreBk(MS_OVERMSG );
		 }   
/*	
	 if(m_bModal)                             
	  {     
	    CDialog::OnOK();            
	  } 
	 else
*/
	  {            
	  	 if(!m_bChild) 
 	       ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDlgWnd(0);
	     else
	       FilterLMClk(1,(HWND)(GetParent()->GetSafeHwnd()));
	  // ((CMainFrame *)GetParent())->SetByUser(1);
	      m_uFocus = CLOSEFOCUS;
	      DestroyWindow();
	  } 

}
void CTDialog::OnCancel()
{                        

	 if(m_bSetByUse)
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetByUser(0);
	  
	 if(!m_bChild)               
	    {          
	       FilterLMClk(0,0);
		   if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetStepMsgBox())
		     ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->RestoreBk(1);
		   if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetOverMsgBox())
		     ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->RestoreBk(0);
		 }   

/*
	 if(m_bModal)                             
	  { 
	    CDialog::OnCancel();            
	  } 
	 else
*/
	  {
		 if(!m_bChild) 
		   ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDlgWnd(0);
		 else
		   FilterLMClk(1,(HWND)(GetParent()->GetSafeHwnd()));

		 m_uFocus = CLOSEFOCUS;
		 DestroyWindow();
	  } 
}



/////////////////////////////////////////////////////////////////////////////
// CMapDlg dialog


CMapDlg::CMapDlg(CWnd* pParent /*=NULL*/,BOOL bModal /*=1*/)
	: CTDialog(CMapDlg::IDD, pParent,bModal)
{
           
    if(!bModal)	
	  Create(IDD,pParent);
	//{{AFX_DATA_INIT(CMapDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	

}

void CMapDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMapDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMapDlg, CTDialog)
	//{{AFX_MSG_MAP(CMapDlg)
	ON_BN_CLICKED(IDC_MAP_CLOSE, OnMapClose)
	ON_BN_CLICKED(ID_HELP, OnHelp)
	ON_BN_CLICKED(IDC_MAP_ADD, OnMapAdd)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapDlg message handlers

BOOL CMapDlg::OnInitDialog()
{
	CTDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_bClkSet=0;
	//Inital Controlers  
    pEdit1      =new CTEdit(&m_uFocus,m_bModal,"0x0",IDS_SET_MAP_EDIT1);
    pEdit1->SubclassDlgItem(IDC_MAP_EDIT1,this);
    pEdit2      =new CTEdit(&m_uFocus,m_bModal,"0xffff",IDS_SET_MAP_EDIT2);
    pEdit2->SubclassDlgItem(IDC_MAP_EDIT2,this);
    pCombo1     =new CTComboBox(&m_uFocus,m_bModal,"End Address",IDS_SET_MAP_COMBO1);
    pCombo1->SubclassDlgItem(IDC_MAP_COMBO1,this);
    pCombo2     =new CTComboBox(&m_uFocus,m_bModal,"Internal Read/Write",IDS_SET_MAP_COMBO2);
    pCombo2->SubclassDlgItem(IDC_MAP_COMBO2,this);
    pListBox    =new CTListBox();
    pListBox->SubclassDlgItem(IDC_MAP_LIST1,this);
    pRadio1     =new CTButton(IDS_SET_MAP_RADIO1,1,FALSE);
    pRadio1->SubclassDlgItem(IDC_MAP_RADIO1,this);    
    pRadio2     =new CTButton(0,0,0);
    pRadio2->SubclassDlgItem(IDC_MAP_RADIO2,this);    
    pSetBtn     =new CTButton(IDS_SET_MAP_SET,1);
    pSetBtn->SubclassDlgItem(IDC_MAP_ADD,this);    
    pSaveBtn    =new CTButton(IDS_SET_MAP_SAVE,1);
    pSaveBtn->SubclassDlgItem(IDC_MAP_SAVE,this);    
    pRestoreBtn =new CTButton();
    pRestoreBtn->SubclassDlgItem(IDC_MAP_RESTORE,this);    
    pCloseBtn   =new CTButton(IDS_SET_MAP_CLOSE,1);
    pCloseBtn->SubclassDlgItem(IDC_MAP_CLOSE,this);    
    pHelpBtn     =new CTButton();
    pHelpBtn->SubclassDlgItem(ID_HELP,this);    

    pRadio2->SetCheck(1);
    if(m_bModal)
      {
       pEdit1->SetFocus();
      } 
	return FALSE;//TRUE;  // return TRUE  unless you set the focus to a control
}                                                          

void CTDialog::OnKillFocus(CWnd* pNewWnd)
{
  if(m_bModal)
	CDialog::OnKillFocus(pNewWnd);
	
	// TODO: Add your message handler code here
	
}

/*-------------------------------------------------------*/
/*            Control Function Group                     */
/*-------------------------------------------------------*/ 
void CMapDlg::SetEditText1()
{
 pEdit1->SetEditText("0x0",IDS_SET_MAP_EDIT1,1);
}              

void CMapDlg::SetEditText2()
{
 pEdit2->SetEditText("0xffff",IDS_SET_MAP_EDIT2,1);
}

void CMapDlg::SetCombo1()
{
 pCombo1->SetCombo(0,IDS_SET_MAP_COMBO1,1);
}

void CMapDlg::SetCombo2()
{
 pCombo2->SetCombo(0,IDS_SET_MAP_COMBO2,1);
}
 
void CMapDlg::SetRadioButton()
{
 pRadio1->SetRadioButton(1);
}; 

void CMapDlg::SetSetBtn(BOOL bDown)
{
 pSetBtn->SetButtonDown(bDown);
}                         

void CMapDlg::SetListBox()
{                     

 pListBox->SetListBox(IDS_SET_MAP_LIST1,2,0);
}
                                                           
void CMapDlg::SetSaveBtn(BOOL bDown)
{
 pSaveBtn->SetButtonDown(bDown);
}                                

void CMapDlg::SetCloseBtn(BOOL bDown)
{
 pCloseBtn->SetButtonDown(bDown);
}
                                                           
/*-------------------------------------------------------*/
/*             quit SetMap Dialog                        */
/*-------------------------------------------------------*/
BOOL CMapDlg::Check()
{
 BOOL bSuccess=1;
 char szText[50];
 pEdit1->GetWindowText(szText,48);
 if(lstrcmpi(szText,"0x0")!=0)
   bSuccess=0;

 pEdit2->GetWindowText(szText,48);
 if(lstrcmpi(szText,"0xffff")!=0)
   bSuccess=0;
  
 pCombo1->GetWindowText(szText,48);
 if(lstrcmpi(szText,"End Address")!=0)
   bSuccess=0;

 pCombo2->GetWindowText(szText,48);
 if(lstrcmpi(szText,"Internal Read/Write")!=0)
   bSuccess=0;

 if(((CButton *)GetDlgItem(IDC_MAP_RADIO1))->GetCheck()!=1) 
   bSuccess=0;   
   
 return bSuccess;  
}

void CMapDlg::OnCancel()
{       
 OnDelete();
 CTDialog::OnCancel();
}

void CMapDlg::OnDelete()
{
   delete pEdit1;
   delete pEdit2;
   delete pCombo1;
   delete pCombo2;
   delete pListBox;
   delete pRadio1;
   delete pRadio2;
   delete pSetBtn;
   delete pSaveBtn;
   delete pRestoreBtn;
   delete pCloseBtn;
   delete pHelpBtn;

}


void CMapDlg::OnMapClose()
{
	// TODO: Add your control notification handler code here 
	int nExitID;


	if(((CButton *)GetDlgItem(IDC_MAP_RADIO1))->GetCheck()!=1)
	  {                                       
	   CMsgDlg *pDlg = new CMsgDlg(1,nExitID,IDS_SET_MAP_RAD,1,this); 
       pDlg->DoModal(); 
       return;
	  }

	if(m_bClkSet==0)
	  {
	   CMsgDlg *pDlg = new CMsgDlg(1,nExitID,IDS_SET_MAP_SETC,1,this); 
       pDlg->DoModal(); 
	   return;
	  }            
	((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetByUser(0);
	OnCancel();
}

void CMapDlg::OnHelp()
{
	// TODO: Add your control notification handler code here
	
}

void CMapDlg::OnMapAdd()
{
	// TODO: Add your control notification handler code here
	if(((CButton *)GetDlgItem(IDC_MAP_RADIO1))->GetCheck()!=1)
	  {   
	   MessageBeep(-1);
	   return;
	  }
	if(m_bClkSet==0) 
	  {  
	   pCloseBtn->EnableWindow();
	   m_bClkSet=1;
	   SetListBox();
	  } 

};



//CSrcGroupDlg::CSrcGroupDlg(int nTab,BOOL bChild,CWnd* pParent /*=NULL*/,
//                           BOOL bModal/*=1*/,BOOL bSetByUse/*=TRUE*/)
//	: CTDialog(CSrcGroupDlg::IDD, pParent,bModal,bChild,bSetByUse),m_nTab(nTab)
/*
{
	m_pvbxTab=0;
	bPageShow=0;
	g_mbCanDoNext=0;
	if(!m_bModal)
	  Create(IDD,pParent);
}
*/
/*
void CSrcGroupDlg::DoDataExchange(CDataExchange* pDX)
{
	CTDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrcGroupDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_VBControl(pDX, IDC_SRCTAB, m_pvbxTab);
	//}}AFX_DATA_MAP
}

void CSrcGroupDlg::InitTabCtrl(int nTab)    
{
 switch(nTab)
   {
     case 0:
          ((CButton *)GetDlgItem(IDC_SRCGRP1_CODE))->SetCheck(TRUE);
          ((CButton *)GetDlgItem(IDC_SRCGRP1_SYMBOL))->SetCheck(TRUE);
          //((CButton *)GetDlgItem(IDC_SRCGRP1_DEMAND))->SetCheck(TRUE);
          ((CButton *)GetDlgItem(IDC_SRCGRP1_STATUS))->SetCheck(TRUE);
          ((CButton *)GetDlgItem(IDC_SRCGRP1_WARN))->SetCheck(TRUE);
          ((CButton *)GetDlgItem(IDC_SRCGRP1_STC1))->SetCheck(TRUE);
          break;
      default :
          m_pBkFunction->AddString("main");
          for(int i=0;i<16;i++)
            {
             CString string;
             string.LoadString(IDS_SCRGRP_MDL+i);
             m_pBkModule->AddString(string);
            } 
          break;  
   }
}

void CSrcGroupDlg::GetTabCtrl()
{        
 switch(m_nTab)
   {
    case 0:
		 m_pRCode   = new CTButton(IDS_SRCGRP1_CODE,1,FALSE); 
		 m_pRCode->SubclassDlgItem(IDC_SRCGRP1_CODE,this);
		
		 m_pRSymbol = new CTButton(IDS_SRCGRP1_SYMBOL,1,FALSE);
		 m_pRSymbol->SubclassDlgItem(IDC_SRCGRP1_SYMBOL,this); 
		   
		 m_pRDemand = new CTButton(IDS_SRCGRP1_DEMAND,1,FALSE);
		 m_pRDemand->SubclassDlgItem(IDC_SRCGRP1_DEMAND,this);
		
		 m_pRStatus = new CTButton(IDS_SRCGRP1_STATUS,1,FALSE);
		 m_pRStatus->SubclassDlgItem(IDC_SRCGRP1_STATUS,this);
		
		 m_pRWarn   = new CTButton(IDS_SRCGRP1_WARN,1,FALSE);
		 m_pRWarn->SubclassDlgItem(IDC_SRCGRP1_WARN,this);
		
		 m_pOkBtn   = new CTButton();
		 m_pOkBtn->SubclassDlgItem(IDOK,this);
		 break;
	default:     
		m_pBkFunction  = new CTComboBox(&m_uFocus,m_bModal,"main",IDS_SRCGRP6_ADDR);
		m_pBkFunction->SubclassDlgItem(IDC_SRCGRP6_ADDR,this);
		
		m_pBkModule    = new CTComboBox(&m_uFocus,m_bModal,"PRIME1",IDS_SRCGRP6_MDL);
		m_pBkModule->SubclassDlgItem(IDC_SRCGRP6_MDL,this);
		
		m_pBkSymbol    = new CTListBox(); 
		m_pBkSymbol->SubclassDlgItem(IDC_SRCGRP6_LIST,this);
		
		m_pBkAddress   = new CTEdit(&m_uFocus,m_bModal,NULL,IDS_SRCGRP6_ADDR1);
		m_pBkAddress->SubclassDlgItem(IDC_SRCGRP6_ADDR1,this);
		
		m_pBkAdd       = new CTButton(IDS_SRCGRP6_ADD,1,FALSE);
		m_pBkAdd->SubclassDlgItem(IDC_SRCGRP6_ADD,this);
		
		m_pBkEnable    = new CTButton(IDS_SRCGRP6_ENABLE,1,FALSE);
		m_pBkEnable->SubclassDlgItem(IDC_SRCGRP6_ENABLE,this);
		
		m_pBkDisable   = new CTButton(IDS_SRCGRP6_DISABLE,1,FALSE);
		m_pBkDisable->SubclassDlgItem(IDC_SRCGRP6_DISABLE,this);
		
		m_pBkDelete    = new CTButton(IDS_SRCGRP6_DELETE,1,FALSE);
		m_pBkDelete->SubclassDlgItem(IDC_SRCGRP6_DEL,this);
		
		m_pBkDelAll    = new CTButton(IDS_SRCGRP6_DELALL,1,FALSE);
		m_pBkDelAll->SubclassDlgItem(IDC_SRCGRP6_DELALL,this);
		
		m_pRestoreBtn  = new CTButton(IDS_SRCGRP6_RESTORE,1,FALSE);
		m_pRestoreBtn->SubclassDlgItem(IDC_SRCGRP6_RESTORE,this);
		
		m_pSaveBtn     = new CTButton(IDS_SRCGRP6_SAVE,1,FALSE);
		m_pSaveBtn->SubclassDlgItem(IDC_SRCGRP6_SAVE,this);
        
        m_pCloseBtn    =new CTButton();
        m_pCloseBtn->SubclassDlgItem(IDOK,this);
   }
}

void CSrcGroupDlg::ShowTabCtrl(int nTab,BOOL bShow)
{
    int nCmdShow = bShow ? SW_SHOW : SW_HIDE;
    switch(nTab) {
        case    0:
//            if(isShow)  m_nIDHelp = IDD_SRCGRP_LOADOPTION;
            GetDlgItem(IDC_SRCGRP1_CODE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_SYMBOL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_DEMAND)->ShowWindow(nCmdShow);
            //GetDlgItem(IDC_SRCGRP1_CPP)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_STATUS)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_WARN)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP1_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
//            GetDlgItem(IDC_SRCGRP1_DEMAND)->EnableWindow(m_isSymbol_1);
//            GetDlgItem(IDC_SRCGRP1_CPP)->EnableWindow(m_isSymbol_1);
            break;
        case    1:
//            if(isShow)  m_nIDHelp = IDD_SRCGRP_BROWSEMODULE;
            GetDlgItem(IDC_SRCGRP2_MDL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_INFO)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC3)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC5)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC6)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP2_STC7)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            break;
        case    2:
//            if(isShow)  m_nIDHelp = IDD_SRCGRP_SOURCEPATH;
            GetDlgItem(IDC_SRCGRP3_DIR)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_DRV)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_ADD)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_REMOVE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_LIST)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_STC3)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP3_PATH)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");                      
//            m_strOldDrv_3 = m_vbxDrv_3->GetStrProperty("Drive");
//            m_strPath_3 = m_vbxDir_3->GetStrProperty("Path");
            break;
        case    3:
//            if(isShow)  m_nIDHelp = IDD_SRCGRP_SOURCEOPTION;
            GetDlgItem(IDC_SRCGRP4_CR)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_LF)->ShowWindow(nCmdShow);
////            GetDlgItem(IDC_SRCGRP4_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_STC3)->ShowWindow(nCmdShow);
////            GetDlgItem(IDC_SRCGRP4_TAB)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP4_HIST)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            break;
        case    4:
//            if(isShow)  m_nIDHelp = IDD_SRCGRP_EXTENSION;
            GetDlgItem(IDC_SRCGRP5_LIST)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_ADD)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_REMOVE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_EDIT)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP5_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDCANCEL)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "OK");
            break;
        case    5:
//            if(isShow)  m_nIDHelp = IDD_SRCGRP_BREAKPOINT;
            GetDlgItem(IDC_SRCGRP6_ADD)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC4)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_ENABLE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_DISABLE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_DEL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_DELALL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_SAVE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_RESTORE)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC2)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC3)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC5)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC6)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_STC7)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_ADDR)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_ADDR1)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_MDL)->ShowWindow(nCmdShow);
            GetDlgItem(IDC_SRCGRP6_LIST)->ShowWindow(nCmdShow);
            SetDlgItemText(IDOK, "&Close");
            break;
    }

}

void CSrcGroupDlg::SetRCodeMsg()
{
  m_pRCode->SetRadioMsg(UPPER,this);
}        

void CSrcGroupDlg::SetRSymbol()
{
 m_pRSymbol->SetRadioMsg(UPPER,this);
}

void CSrcGroupDlg::SetRDemand()
{
 m_pRDemand->SetRadioMsg(UPPER,this);
}

void CSrcGroupDlg::SetRStatus()
{
 m_pRStatus->SetRadioMsg(UPPER,this);
}

void CSrcGroupDlg::SetRWarn()
{
 m_pRWarn->SetRadioMsg(DOWN,this);
}
                           
void CSrcGroupDlg::SetOkBtn()
{
  m_pOkBtn->SetButtonDown(0);
  m_pOkBtn->SetState(0);
}

void CSrcGroupDlg::IntroduceBk(int nStep)
{
  switch(nStep)
   {
    case 1:    
         m_pBkModule->SetCombo(0,IDS_SRCGRP6_MDL,1);
         break;
    case 2:   
         m_pBkFunction->SetCombo(0,IDS_SRCGRP6_ADDR,1);
         break;
    case 3: 
         m_pBkAddress->SetEditText("#PRIME1#main",IDS_SRCGRP6_ADDR1,1);
         break;
    case 4:   
         m_pBkAdd->SetButtonDown(TRUE); 
         m_pBkSymbol->SetListBox(IDS_SRCGRP6_LIST,1);
         break;
    case 5:    
         Delay(100);
         m_pBkEnable->SetRadioMsg(UPPER,this);
         break;
    case 6:
         Delay(100); 
         m_pBkDisable->SetRadioMsg(UPPER,this);
         break;
    case 7:         
         Delay(100);
         m_pBkDelete->SetRadioMsg(UPPER,this);
         break;
    case 8:         
         Delay(100);
         m_pBkDelAll->SetRadioMsg(UPPER,this);
         break;
    case 9:         
         Delay(100);
         m_pSaveBtn->SetRadioMsg(DOWN,this);
         break;
    case 10:        
         Delay(100);
         m_pRestoreBtn->SetRadioMsg(DOWN,this);
         break;
    case 11:      
         m_pCloseBtn->SetButtonDown(FALSE);
         PostMessage(WM_COMMAND,IDOK);
         Delay(1000);
         break;  
    default:
         break;
   }
}
                           
BEGIN_MESSAGE_MAP(CSrcGroupDlg, CTDialog)
	//{{AFX_MSG_MAP(CSrcGroupDlg)
	ON_VBXEVENT(VBN_TABPAGESHOWN, IDC_SRCTAB, OnTabpageshownSrctab)
	ON_BN_CLICKED(IDC_SRCGRP6_ADD, OnSrcgrp6Add)
	ON_BN_CLICKED(IDC_SRCGRP6_DEL, OnSrcgrp6Del)
	ON_BN_CLICKED(IDC_SRCGRP6_DELALL, OnSrcgrp6Delall)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSrcGroupDlg message handlers

void CSrcGroupDlg::OnTabpageshownSrctab(UINT, int, CWnd*, LPVOID)
{
	// TODO: Add your VBX event notification handler code here
	
	if(bPageShow)
	  {
		//m_pvbxTab=(CVBControl *)GetDlgItem(IDC_SRCTAB);
		if(m_pvbxTab)
		  m_pvbxTab->SetNumProperty("ActiveTab", m_nTab);   
	  } 

}

BOOL CSrcGroupDlg::OnInitDialog()
{
	CTDialog::OnInitDialog();  
    if(g_bAuto)
      AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);

	CSrcWnd *pWnd;
    GetTabCtrl();         

    
    if(!m_bModal && m_bChild)
      ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDlgWnd((CDialog *)(GetParent()));


    GetDlgItem(IDC_SRCGRP1_STC1)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP2_STC2)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP3_DIR)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP3_DRV)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP4_STC3)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP6_STC1)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_SRCGRP6_STC4)->ShowWindow(SW_HIDE);
    
    m_pvbxTab->SetNumProperty("ActiveTab", m_nTab);    
	
	// TODO: Add extra initialization here
	ShowTabCtrl(m_nTab,SHOW);
	InitTabCtrl(m_nTab);   
	
    switch(m_nTab)
     {
      case 0:
           m_uFocus = SHOWFOCUSMSG;
           break;
      case 5:    
           pWnd=
           ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
           if(pWnd && m_bModal)
             {
              pWnd->GetLineBpInfo(m_pBkSymbol,m_pBkAddress);
              pWnd->ShowWindow(SW_HIDE);
              m_pBkModule->SetCurSel(0); 
              m_pBkFunction->SetCurSel(0);
              m_pBkEnable->EnableWindow(0);
              m_pBkDisable->EnableWindow(0);
             }
           break;
      default:
           break;
     }
	
	bPageShow=1;    
	g_mbCanDoNext=1;
	if(g_bAuto) 
	{         
	  KillTimer(IDAUTO);
      g_uTick=10000;
      AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO,10000,NULL);
    }  
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSrcGroupDlg::DeleteCtrl(int nPage)
{   
  switch(nPage)
   {
    case 0:
	 	delete m_pRCode;
		delete m_pRSymbol;
		delete m_pRStatus;
		delete m_pRDemand;
		delete m_pRWarn;
		break;
	case 5:
		delete m_pBkFunction;
		delete m_pBkModule;
		delete m_pBkAddress;
		delete m_pBkSymbol;
		delete m_pBkAdd;
		delete m_pBkEnable;
		delete m_pBkDisable;
		delete m_pBkDelete;
		delete m_pBkDelAll;
		delete m_pRestoreBtn;
		delete m_pSaveBtn;
		delete m_pCloseBtn;
		break;
	default:
		break;
   }
}

void CSrcGroupDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	m_uFocus=CLOSEFOCUS;
	DeleteCtrl(m_nTab);
	if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg())  
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg()->DestroyWindow();

    if(m_nTab==5)
      {
	    CSrcWnd *pWnd=
	    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
	    CTDialog::OnCancel();  
	    if(pWnd)
	       pWnd->ShowWindow(SW_SHOW);
     }
    else
      CTDialog::OnCancel();
}

void CSrcGroupDlg::OnOK()
{
	// TODO: Add extra validation here 
	m_uFocus=CLOSEFOCUS;
	DeleteCtrl(m_nTab);
	if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg())          
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg()->DestroyWindow();

    if(m_nTab==5)
      {
	    CSrcWnd *pWnd=
	    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
	    CTDialog::OnOK();  
	    if(pWnd)
	       pWnd->ShowWindow(SW_SHOW);
     }
    else
	CTDialog::OnOK();  
}

void CSrcGroupDlg::OnSrcgrp6Add()
{
	// TODO: Add your control notification handler code here
	char    szText[20];
	long    lLine;    
	m_pBkAddress->GetWindowText(szText,18);
    lLine=atol(szText);
    
    CSrcWnd *pWnd=
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
    if(pWnd) 
       pWnd->AddBp(lLine,m_pBkSymbol);
}

void CSrcGroupDlg::OnSrcgrp6Del()
{
	// TODO: Add your control notification handler code here
    CSrcWnd *pWnd=
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
    if(pWnd)                        
      {
       if(pWnd->DeleteBp(m_pBkSymbol))
          m_pBkAddress->SetWindowText("");
      } 
}

void CSrcGroupDlg::OnSrcgrp6Delall()
{
	// TODO: Add your control notification handler code here
    CSrcWnd *pWnd=
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
    m_pBkSymbol->ResetContent();
    m_pBkAddress->SetWindowText("");
    if(pWnd) 
       pWnd->DeleteBp(NULL);
}

*/
/////////////////////////////////////////////////////////////////////////////
// CLODialog dialog
CLODialog::CLODialog(CWnd* pParent /*=NULL*/)
	: CTDialog(CLODialog::IDD, pParent,0,1,0)
{
	//{{AFX_DATA_INIT(CLODialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	Create(IDD,pParent);
}

void CLODialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLODialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLODialog, CTDialog)
	//{{AFX_MSG_MAP(CLODialog)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLODialog message handlers

void CLODialog::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CRect rect;
	GetClientRect(&rect);
	CDC dcMap;
	dcMap.CreateCompatibleDC(&dc);
	dcMap.SelectObject(&m_Bitmap); 
	dc.BitBlt(0,0,rect.Width(),rect.Height(),&dcMap,0,0,SRCCOPY);
	dcMap.DeleteDC();
	// Do not call CDialog::OnPaint() for painting messages
}

BOOL CLODialog::OnInitDialog()
{
	CTDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
  	m_Bitmap.LoadBitmap(IDB_LOAD);

    m_pRCode   = new CTButton(IDS_SRCGRP1_CODE,1,FALSE); 
    m_pRCode->SubclassDlgItem(IDC_SRCGRP1_CODE,this);
	m_pRCode->SetCheck(1);	
	
    m_pRSymbol = new CTButton(IDS_SRCGRP1_SYMBOL,1,FALSE);
    m_pRSymbol->SubclassDlgItem(IDC_SRCGRP1_SYMBOL,this); 
	m_pRSymbol->SetCheck(1);	
		   
    m_pRDemand = new CTButton(IDS_SRCGRP1_DEMAND,1,FALSE);
    m_pRDemand->SubclassDlgItem(IDC_SRCGRP1_DEMAND,this);
		
    m_pRStatus = new CTButton(IDS_SRCGRP1_STATUS,1,FALSE);
    m_pRStatus->SubclassDlgItem(IDC_SRCGRP1_STATUS,this);
	m_pRStatus->SetCheck(1);	
		
    m_pRWarn   = new CTButton(IDS_SRCGRP1_WARN,1,FALSE);
    m_pRWarn->SubclassDlgItem(IDC_SRCGRP1_WARN,this);
	m_pRWarn->SetCheck(1);	
		
    m_pOkBtn   = new CTButton();
    m_pOkBtn->SubclassDlgItem(IDOK,this);
	
	g_mbCanDoNext=1;           
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CLODialog::OnOK()
{
	// TODO: Add extra validation here
	
	DeleteCtrl();
	if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg())          
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg()->DestroyWindow();

	CTDialog::OnOK();
}

void CLODialog::OnCancel()
{
	// TODO: Add extra cleanup here
	DeleteCtrl();
	if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg())  
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg()->DestroyWindow();

	
	CTDialog::OnCancel();
}

void CLODialog::DeleteCtrl()
{   
  delete m_pRCode;
  delete m_pRSymbol;
  delete m_pRStatus;
  delete m_pRDemand;
  delete m_pRWarn;
  m_Bitmap.DeleteObject();
}
void CLODialog::SetRCodeMsg()
{
  m_pRCode->SetRadioMsg(UPPER,this);
}        

void CLODialog::SetRSymbol()
{
 m_pRSymbol->SetRadioMsg(UPPER,this);
}

void CLODialog::SetRDemand()
{
 m_pRDemand->SetRadioMsg(UPPER,this);
}

void CLODialog::SetRStatus()
{
 m_pRStatus->SetRadioMsg(UPPER,this);
}

void CLODialog::SetRWarn()
{
 m_pRWarn->SetRadioMsg(DOWN,this);
}
                           
void CLODialog::SetOkBtn()
{
  m_pOkBtn->SetButtonDown(0);
  m_pOkBtn->SetState(0);
}
/////////////////////////////////////////////////////////////////////////////
// CBPDialog dialog


CBPDialog::CBPDialog(CWnd* pParent /*=NULL*/)
	: CTDialog(CLODialog::IDD, pParent,0,0,0)
{
	//{{AFX_DATA_INIT(CBPDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	  Create(IDD,pParent);
}

void CBPDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBPDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBPDialog, CTDialog)
//{{AFX_MSG_MAP(CBPDialog)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBPDialog message handlers

void CBPDialog::OnCancel()
{
	// TODO: Add extra cleanup here
	DeleteCtrl();
	if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg())  
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg()->DestroyWindow();

    CSrcWnd *pWnd=
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
    CTDialog::OnCancel();  
    if(pWnd)
       pWnd->ShowWindow(SW_SHOW);
       
}

void CBPDialog::OnOK()
{
	// TODO: Add extra validation here
	DeleteCtrl();
	if(((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg())          
	  ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetAMsgDlg()->DestroyWindow();

	    CSrcWnd *pWnd=
	    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetSrcWnd();
	    CTDialog::OnOK();  
	    if(pWnd)
	       pWnd->ShowWindow(SW_SHOW);
}

BOOL CBPDialog::OnInitDialog()
{
	CTDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
    m_Bitmap.LoadBitmap(IDB_BK);

	m_pBkFunction  = new CTComboBox(&m_uFocus,m_bModal,"main",IDS_SRCGRP6_ADDR);
	m_pBkFunction->SubclassDlgItem(IDC_SRCGRP6_ADDR,this);
		
	m_pBkModule    = new CTComboBox(&m_uFocus,m_bModal,"PRIME1",IDS_SRCGRP6_MDL);
	m_pBkModule->SubclassDlgItem(IDC_SRCGRP6_MDL,this);
		
	m_pBkSymbol    = new CTListBox(); 
	m_pBkSymbol->SubclassDlgItem(IDC_SRCGRP6_LIST,this);
		
	m_pBkAddress   = new CTEdit(&m_uFocus,m_bModal,NULL,IDS_SRCGRP6_ADDR1);
	m_pBkAddress->SubclassDlgItem(IDC_SRCGRP6_ADDR1,this);
		
	m_pBkAdd       = new CTButton(IDS_SRCGRP6_ADD,1,FALSE);
	m_pBkAdd->SubclassDlgItem(IDC_SRCGRP6_ADD,this);
		
	m_pBkEnable    = new CTButton(IDS_SRCGRP6_ENABLE,1,FALSE);
	m_pBkEnable->SubclassDlgItem(IDC_SRCGRP6_ENABLE,this);
		
	m_pBkDisable   = new CTButton(IDS_SRCGRP6_DISABLE,1,FALSE);
	m_pBkDisable->SubclassDlgItem(IDC_SRCGRP6_DISABLE,this);
		
	m_pBkDelete    = new CTButton(IDS_SRCGRP6_DELETE,1,FALSE);
	m_pBkDelete->SubclassDlgItem(IDC_SRCGRP6_DEL,this);
		
	m_pBkDelAll    = new CTButton(IDS_SRCGRP6_DELALL,1,FALSE);
	m_pBkDelAll->SubclassDlgItem(IDC_SRCGRP6_DELALL,this);
		
	m_pRestoreBtn  = new CTButton(IDS_SRCGRP6_RESTORE,1,FALSE);
	m_pRestoreBtn->SubclassDlgItem(IDC_SRCGRP6_RESTORE,this);
		
	m_pSaveBtn     = new CTButton(IDS_SRCGRP6_SAVE,1,FALSE);
	m_pSaveBtn->SubclassDlgItem(IDC_SRCGRP6_SAVE,this);
    
    m_pCloseBtn    =new CTButton();
    m_pCloseBtn->SubclassDlgItem(IDOK,this);
	
    m_pBkFunction->AddString("main");
    CString string;
    for(int i=0;i<16;i++)
    {
       string.LoadString(IDS_SCRGRP_MDL+i);
       m_pBkModule->AddString(string);
   } 
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBPDialog::DeleteCtrl()
{   

 delete m_pBkFunction;
 delete m_pBkModule;
 delete m_pBkAddress;
 delete m_pBkSymbol;
 delete m_pBkAdd;
 delete m_pBkEnable;
 delete m_pBkDisable;
 delete m_pBkDelete;
 delete m_pBkDelAll;
 delete m_pRestoreBtn;
 delete m_pSaveBtn;
 delete m_pCloseBtn;
 m_Bitmap.DeleteObject();

}

void CBPDialog::IntroduceBk(int nStep)
{
  switch(nStep)
   {
    case 1:    
         m_pBkModule->SetCombo(0,IDS_SRCGRP6_MDL,1);
         break;
    case 2:   
         m_pBkFunction->SetCombo(0,IDS_SRCGRP6_ADDR,1);
         break;
    case 3: 
         m_pBkAddress->SetEditText("#PRIME1#main",IDS_SRCGRP6_ADDR1,1);
         break;
    case 4:   
         m_pBkAdd->SetButtonDown(TRUE); 
         m_pBkSymbol->SetListBox(IDS_SRCGRP6_LIST,1);
         break;
    case 5:    
         Delay(100);
         m_pBkEnable->SetRadioMsg(UPPER,this);
         break;
    case 6:
         Delay(100); 
         m_pBkDisable->SetRadioMsg(UPPER,this);
         break;
    case 7:         
         Delay(100);
         m_pBkDelete->SetRadioMsg(UPPER,this);
         break;
    case 8:         
         Delay(100);
         m_pBkDelAll->SetRadioMsg(UPPER,this);
         break;
    case 9:         
         Delay(100);
         m_pSaveBtn->SetRadioMsg(DOWN,this);
         break;
    case 10:        
         Delay(100);
         m_pRestoreBtn->SetRadioMsg(DOWN,this);
         break;
    case 11:      
         m_pCloseBtn->SetButtonDown(FALSE);
         PostMessage(WM_COMMAND,IDOK);
         Delay(1000);
         break;  
    default:
         break;
   }
}

void CBPDialog::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CRect rect;
	GetClientRect(&rect);
	CDC dcMap;
	dcMap.CreateCompatibleDC(&dc);
	dcMap.SelectObject(&m_Bitmap); 
	dc.BitBlt(0,0,rect.Width(),rect.Height(),&dcMap,0,0,SRCCOPY);
	dcMap.DeleteDC();
	
	// Do not call CTDialog::OnPaint() for painting messages
}
