// mainfrm.h : interface of the CMainFrame class
//
#ifndef _tutorial_struct
#define _tutorial_struct
struct OVERMSGBOX
       {
        int     charPos;
        int     lfWidth;
        int     lfHeight;
        int     lfWeight;
        UINT    stringID; 
        CRect   rectDes; 
        CRect   rectOld; 
        CBitmap *pStoreBit;
        BOOL    bOverMsg;
        void    SetFont(int x,int y,int z)
                {lfWidth=y;lfHeight=x;lfWeight=z;};
        void    SetPaintRect(CRect r,BOOL bNewCase = 1);        
       };
#endif     

#ifndef _FIRLOOK_H 
#define _FIRLOOK_H 
#include "firlook.h"
#endif

#ifndef _MSGWND_H
#define _MSGWND_H
#include "msgwnd.h"
#endif         

#ifndef _ADV_OTHER_H
#define _ADV_OTHER_H
#include "advother.h"
#endif

//#include "speaker.h"
class CSrcWnd;
/////////////////////////////////////////////////////////////////////////////
class CMainFrame : public CMDIFrameWnd
{

DECLARE_DYNCREATE(CMainFrame)
public: // create from serialization only
	CMainFrame();

private:
    CBitmap * m_pBitmap;
    CBitmap * m_pTBitmap;
    CBitmap * m_pBitText;
    CBitmap * m_pBit;
    CBitmap * m_pMonoBit;
    CBitmap * m_pStoreBit;
// Attributes

public:      
    
// system manager
public:
   WORD  m_nSourceWnd;
   WORD  m_nVariableWnd;
   BOOL  MouseButtonDown(WORD Message,WORD wParam,LONG lParam,BOOL bCan=0);
   void  InitItem();
private:   
   BOOL  ClickBtn(WORD Message,WORD wParam,DWORD lParam,CRect rect,POINT p,CButton *pBtn);

protected:
   char  m_szLoadFilePath[50];  
   void  SetNextAction(UINT x){m_uNextAction=x;};
public:                   
   CMenu *GetMainMenu(){return m_pMainMenu;};
   void  SetSrcWnd(CSrcWnd *p){m_pSrcWnd = p;};
   CSrcWnd *GetSrcWnd(){return m_pSrcWnd;};
   UINT  GetCase(){return m_uCase;};
   void  SetCase(UINT x){m_uCase=x;};
   void  SetByUser(BOOL x){bByUser = x;};
   BOOL  GetByUser(){return bByUser;};
   void  SetBusy(BOOL x){bBusy=x;};
   BOOL  GetBusy(){return bBusy;};
   void  SetDlgWnd(CDialog *x){m_pDlg=x;};
   void  SetWnd(CMDIChildWnd *x){m_pWnd=x;};
   CMDIChildWnd *GetWnd(){return m_pWnd;};
   void  InitMenuItem(CMenu *pAppMenu);
   POINT GetWindowPos(){return WinCxy;};
   void  ClearDlg(){m_pDlg=0;};
   void  CloseDlg(CDialog *pDlg); 
   void  CloseWnd(CMDIChildWnd *pWnd);
   CDialog *GetAMsgDlg(){return m_pAMsgDlg;};    
   CDialog *GetDlg(){return m_pDlg;};
   void  SetAMsgDlg(CDialog *p){m_pAMsgDlg=p;};
   BOOL  CheckOperation(LPSTR lpDesString,LPSTR lpSrcString,
                        UINT  ID,UINT  nCount);
   LPSTR GetLoadFilePath(){return m_szLoadFilePath;};                     
   void  SetCaseTitle(LPSTR lpTitle){lstrcpy(szCaseTitle,lpTitle);};
   POINT GetWinCxy(){return WinCxy;};
   UINT  GetMenuAct(){return m_uMenuAct;};
   BOOL  GetTipActive(){return m_bTipActive;};
   void  SetTipActive(BOOL x){m_bTipActive=x;};
   UINT  GetCaseID(){return m_uNextCaseID;};
   CButtonBar *GetToolBar(){return &m_wndToolBar;};
   void  SetPaintDO(BOOL x){bCase2Paint=x;};
   HCURSOR  GetHandCursor(){return hCursor1;};
   HCURSOR  GetArrowCursor(){return hArrow;};
private:  
   OVERMSGBOX OverMsg;
   OVERMSGBOX StepMsg;
   HCURSOR    hCursor2;
   HCURSOR    hCursor1;
   HCURSOR    hArrow;
   UINT       m_uOldMsgMapID;
   UINT       m_uMsgID;      //for message box string id
   UINT       m_uColorID;
   UINT       m_uMonoID;
   UINT       m_uCase;
   UINT       m_uMenuPos;
   int        m_nMenuCount;
   int        m_nSeparator;
   UINT       m_uMenuAct; // the symbol for specified tutorial action 
                          // default is 0, else set current menu item id
   UINT       m_uNextAction;
   int        m_uNextCaseID;                       
   char       szCaseTitle[40];                       
   BOOL       bBusy;  // if not timer control
   BOOL       bByUser;// if the time by user
   POINT      WinCxy; // org position
   BOOL       bPaint; // for OnPaint & NcOnPaint 
   BOOL       bClose;
   BOOL       bFirst; // for Timer case 0;
   BOOL       m_bSetMap_Action;
   CDialog    * m_pDlg; 
   CDialog    * m_pAMsgDlg;//the arrow dialog msg box 
 CMDIChildWnd * m_pWnd;   
   CSrcWnd    * m_pSrcWnd;
   CMenu      * m_pMainMenu;
   BOOL       m_bTipActive;
   BOOL       m_bPostToMain;
   
// Operations
public:
 BOOL PaintBitmap(CDC &dc,CRect DestRect,CRect SrcRect,
                  CBitmap *pBitmap,BOOL bDelete=0,
                  DWORD dwFlag=SRCCOPY);
// BOOL ShowBitmap(CDC *dc, CRect DestRect, UINT ID, BOOL bInternal=1);               
 BOOL PaintWall(CDC &dc,CRect DestRect,CBitmap *pBitmap);
 BOOL TransparentBitmap(CDC &dc,CRect DestRect,CBitmap *pBitmap,LPSTR lpResName);
 BOOL MovingBitmap(CDC &dc,CRect DestRect,CBitmap *pBitmap,CBitmap *pMonoBitmap);
 void DrawTPmap(CDC &dc,CRect &rectMap,LPSTR colorID,LPSTR monoID);
 void DrawTPmap(CDC &dc,CRect &rectMap,UINT colorID,UINT monoID)
      {
       DrawTPmap(dc,rectMap,(LPSTR)MAKEINTRESOURCE(colorID),
                             (LPSTR)MAKEINTRESOURCE(monoID));
      }
 void DrawTPmap(CDC &dc, CRect rectMap,
                LPSTR colorID, LPSTR monoID,
                HINSTANCE hInst, CBitmap *restoreBit=NULL);
                
 BOOL MakeMonBitmap(LPSTR lpBmpName,MONBITMAP & monDIB);
 void DrawTitle(CDC &dc,LPSTR lpszText,COLORREF lineColor);
 void DisplayMessage(CDC &DC,CRect rect,UINT msgID,int   nCount,BOOL bDIP=1);
 void MoveCursor(CPoint pointDes,CPoint pointSrc,
                 BOOL bBack=1,int nDelay=55,int nStep=12,BOOL bFilter=0);
 void DrapMenu(UINT uSubID,UINT uMenuID,UINT uMenuItemCount,int  nSeparator=0);
 void WndMouse(int x,int y,UINT nFlags,BOOL bNotMove=0);
 void WndBPMouse(int x,int y,UINT nFlags,BOOL bNotMove/*=0*/); 
 void MenuTimer(UINT nIDEvent); 
 void PopupNoteMsg(CDC &dc,UINT ID,int nCount,CRect rectDes,CBitmap * restoreBitmap=NULL,
                   int nFontHeight=16,int nFontWidth=6,int nFontWeight=200); 
 void SetNoteMsg(UINT ID,int nCount,BOOL bClear=1);
 void SetStepMsg(UINT ID,int nCount,BOOL bClear=1);
 void PaintUpArrow(CDC &dc,CPoint Org,int nLength,LPSTR lpszText=NULL,
                   COLORREF rgbFill=RGB(128,0,128),COLORREF rgbFrame=RGB(255,0,255));  
 void PaintVArrow( CDC &dc,CPoint Org,int nWidth,LPSTR lpszText=NULL,
                   COLORREF rgbFill=RGB(210,210,0),COLORREF rgbFrame=RGB(128,128,0));

 void DrawMsgText(CDC *dc,LPRECT lpRect,UINT textID,int nCount,
                  int nFontHeight=16,int nFontWidth=6,int nFontWeight=200,COLORREF TextColor=RGB(0,0,0)); 
 void RestoreBk(BOOL bStep=0,int nCY=0); 
 void RestoreBk(CDC &dc,BOOL bStep=0,int nCY=0);  
 void WriteMsg(UINT ID,BOOL bDoorOpen=0,LPSTR lpTitle=NULL);
 void ClearFrame();
public:
 void DrawLine(CDC &dc,CPen &pen,int nXCurrent,int nYHeight);
// case 0            
private: 
 BOOL    bDrawBkg; 
 BOOL    bDrawBtn;
 POINT   posLine;
 CRect   rectMenu;
 CButton *m_pExitBtn;
 void PaintCase0(CDC &dc);
 void Timer(UINT nIDEvent);
 void Case0MouseMove(UINT nFlags,CPoint point);
 void Case0MLD(UINT nFlags,CPoint point);
public: 
 void DrawControl(CDC &dc,int nXCurrent,int nYHeight);
 
//////////////////////////////////////////////////////////////////////
//case 2                          ////////////////////////////////////
public:
void PaintCase2(CDC &dc);
private:       
 BOOL       bPaintMsg;
 BOOL       bCase2Paint; 
 CMDIChildWnd  *m_pVarWnd;
 
 CRect   rectMsgBlock; 
 CRect   m_AutoBtn;
 CButton *m_pCancelBtn;
 CButton *m_pNextBtn;
 BOOL Case2NcMLD(UINT nFlags);

//setmap
 void SetMapNext();
 void SetMapCancel();
 void PaintSetMapMsg(CDC &dc);
 void HowToUseSetmapDlg(UINT *nID);//csae2.cpp
 BOOL EndCase(BOOL *ByUser,UINT ID,UINT *pCaseID);
public:
 void SetOverMsgBox(BOOL x){OverMsg.bOverMsg=x;};
 BOOL GetOverMsgBox(){return OverMsg.bOverMsg;};
 void SetStepMsgBox(BOOL x){StepMsg.bOverMsg=x;};
 BOOL GetStepMsgBox(){return StepMsg.bOverMsg;};

//Down Load File
private:
 void HowToUseDownLoadFile(UINT *nCase);//download.cpp
//set bresk point 
private:
 void HowToSetBreakPoint(UINT *nCase);//setbp.cpp
//go
private:
 void HowToGo(UINT *nCase); //setbp.cpp  
//sel mode 
private:
 void HowToSelMode(UINT *nCase); 
//step Over
private:
 void HowToStep(UINT *nCase);
//variable 
private: 
void HowToUseVarWnd(UINT *nCase); 
///////////////////////////////////////////////////////////////////////// 
///////first look    
public:
void SetPlaySpeed(int x){m_nPlaySpeed=x;};
void SetPlayCount(int x){m_nPlayCount=x;};
int  GetCanDoNext(){return m_nCanDoNext;};
void ProcessNextPlay(BOOL bInit=0);
void InitFirstLook(int nShowBtn=0); 
CPlayMeter * GetMeter(){return m_pMeter;};    

public:
HINSTANCE m_hFlookInst;

private:             

int      m_nPlayCount;     
int      m_nPlaySpeed;
int      m_nCanDoNext;
BOOL     m_IconsClk;
BOOL     m_bPlayStop;
//CEdit    *m_pExplainEdit;
HINSTANCE m_hPlayInst;
//CChildIconWnd *m_pSource;
CMenuDlg *m_pMenu95;
CBitmapButton *m_pStart;
CBitmapButton m_StopDome;
CBitmapButton m_NextBtn;
CBitmap *m_pBkGroundS;
CBitmap *m_pBkGroundM;
CPlayMeter *m_pMeter;
HBITMAP m_hBitmap;
CRect   m_Rect95;
CRect   m_Message;
BOOL m_bSet;      
BOOL m_bDCan;
BOOL m_bTimeActive;
BOOL m_bCanPaste;                   
BOOL m_bCanPal;                     
void StartFirstLook();
void PaintFirstLook(CDC &dc,BOOL bNotPaint=1); 
void SetBottomToolBar(CDC &dc);                
void SetSysTime(CDC &dc,UINT nIDEvent=SYSTIME);
void PastePicutre(BOOL bOpen=FALSE,int orgX=10,int orgY=20);
void WalkPicture(HBITMAP hBitmap);
void StartScreen(int orgX,int orgY,int nCX,int nCY,BOOL bBlack=0);
void BitmapProcess(CDC &dc,CBitmap *pBitmap);
BOOL BitmapToDIB (int orgX,int orgY,HBITMAP hBitmap,BOOL bBlack);
WORD PaletteSize (LPSTR lpbi);         
HPALETTE SetPalette(HDC &hDC,HPALETTE &hPal,BOOL bRestore=FALSE);
HPALETTE CreateLogPalette(LPSTR lpDIB);
void DrawFirstLookTitle();
BOOL InitLibrary(LPSTR lpLibrary);
void OnManTimer() ;
void OnAutoTimer(BOOL bInit=0);
void OnBtnTimer();
void DefragRestore(CRect rect);
void StopPlay();
void StepDraw(UINT nNum,CDC &dc,CDC &SrcDC,
              POINT &point,CRect rect,BITMAP bm);
void IniOrg(UINT nNum,POINT &point,CRect rect);
BOOL WndIconAction(LONG lParam);
void InitBitmapInfoHeader (LPBITMAPINFOHEADER lpBmInfoHdr,
                                        DWORD dwWidth,
                                        DWORD dwHeight,
                                          int nBPP);

public:
CBitmapButton *GetStartBtn(){return m_pStart;};
void SetBSet(BOOL x){m_bSet=x;};
void SetDCan(BOOL x){m_bDCan=x;};
void OnExitProcess();
void AdvanceRestoreBk();

// Advance tutorial
private:
CWnd *m_pAdvanceWnd;       
CBitmapButton m_Trace;
CBitmapButton m_Memory;
CBitmapButton m_Stack;

//CArrowWnd m_pArrow;
BOOL      m_bDC;
BOOL      m_bUpArrow;
BOOL      m_bTrace;
BOOL      m_bMemory;
CRect     m_rectDes;
CMsgWnd   *m_pMsgWnd;
POINT     m_pointS;
POINT     m_pointD;       
int       m_Move_Count_Delay;
int       m_nCursorStep;

void PaintAdvance(CDC &dc);
void StartAdvance();
void AdvanceNext();
void PaintUpBitmap(int orgx,int orgy,LPSTR lpBitmap,BOOL bMove=1);
void MoveArrow( CDC &dc,CRect rect,int nCy=1,BOOL  bUP=1,int nDelay=100);
void MenuAction();
void SetCursorPoint(int x,int y,int nDelay=55,int nCursorStep=8)
{
 m_pointD.x=WinCxy.x+x;
 m_pointD.y=WinCxy.y+y;     
 GetCursorPos(&m_pointS); 
 m_pointS.x+=WinCxy.x;
 m_pointS.y+=WinCxy.y;                   
 m_Move_Count_Delay=nDelay; 
 m_nCursorStep = nCursorStep;
};

public:
void InitButton(int x);
void MemGoto();
void MemSearch();
void MemModifyCode();

private:
void SetArrow(int ncy, int bup, int top, int left=210, int width=200, 
              int height=50, int delay=100);
              
void AdvanceEvent();
void AdvanceTrace();
void AdvanceTrigger();
void AdvanceFilter();
void AdvanceMemEdit();
void AdvanceMemDlg();

void Trace_Advance();
void Trace_Bus();
void Trace_Option(int nCase);                 
void Trace_Event();
void Trace_Address_Range();
void Trace_Address_Mult();                            
void Trace_Address_Status();
void Trace_Event3();
void Trace_Control();
void Trace_Switch();
void Trace_Timer();
void Trace_Pre(int nIdx);
void Trigger_Sel();         
void Trigger_Level();
void Trigger_Level_Content();
void Trigger_Introduce();
void Trigger_Content();
void Filter_Set();
void Filter_Trace();
void Filter_Item();
void Filter_State();
void ToMemCase();
void Mem_Advance();
void Mem_Goto();
void Mem_Menu_Goto();
void Mem_Menu_Search();
void Mem_Search();
void Mem_Modify();
void Mem_Mode();
void Mem_Modify_Code();
void Mem_Dlg_CheckSum();
void Mem_Dlg_Change(int n);
// Implementation      

public:
	virtual ~CMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CButtonBar  m_wndToolBar;
// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg LONG OnTMTIPActive(UINT wParm, LONG );
	afx_msg LONG OnWinChange(UINT wParam, LONG );
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnNcPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();
	afx_msg void OnNcLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnNcLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnNcLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg BOOL OnNcActivate(BOOL bActive);
	afx_msg void OnClose();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnNcMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnCase0Basic();
	afx_msg void OnCase0FirstLook();
	afx_msg void OnCase0Advance();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg int  OnMouseActivate(CWnd * pDesktopWnd,UINT nHitTest,UINT Msg);
	afx_msg void OnCase2Exit();
	afx_msg void OnCancel();
	afx_msg void OnNext();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	afx_msg void OnGroupMap();
	afx_msg void OnFileLoad(); 
	afx_msg void OnShowSrcWnd();
	afx_msg void OnLoadStatus();
	afx_msg void OnWindowVariable();
	afx_msg void OnFirstLookExit();
	afx_msg void OnStartBtn();  
	afx_msg void OnStartCmd();
	afx_msg void OnFirLookExt();
	afx_msg BOOL OnShowFLook(UINT nID);
	afx_msg void OnStopDome();
	afx_msg void OnNextPlay();
	afx_msg void OnAutoPlay();
	afx_msg HBRUSH OnCtlColor(CDC *,CWnd *,UINT);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnExitAdvance();
	afx_msg void OnCaseExit();  
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnTrace();
	afx_msg void OnMemory();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

extern HINSTANCE g_hExpInst;

BOOL ShowBitmap(CDC *pDC, CRect DestRect, UINT ID, BOOL bInternal=1);               
BOOL ShowBitmap(CDC *pDC, CRect DestRect, LPCSTR strID, BOOL bInternal=1);               

/////////////////////////////////////////////////////////////////////////////
