// msgwnd.cpp : implementation file
//

#include "stdafx.h"
#include "io.h"
#include "tutorial.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define CHINESE
const int g_nTextHeight=40;
const int g_nTextExternal=10;
/////////////////////////////////////////////////////////////////////////////
//global function
void FilterString(LPSTR lpChar,UINT uLen)
{     
 HGLOBAL hMem =GlobalAlloc(GPTR,uLen+1);
 LPSTR lpTemp =(LPSTR)GlobalLock(hMem); 
 BOOL  bFilter=1;      
 BOOL  bNext=0;
 UINT  j=0;
 for(UINT i=0;i<uLen;i++)
  {
   if(lpChar[i]==0x0d && bFilter==1)
     {
      if(lpChar[i+1]==0x0a)
        i++;
      bFilter=0;
      bNext=1;  
      continue;
     } 
   if(lpChar[i]!=' ')                                 
      bNext=0;
                                      
   if(lpChar[i]!=0x0d && lpChar[i]!=0x0a && !bNext)  
      bFilter=1;
      
   lpTemp[j]=lpChar[i];   
   j++;
 }             
 lstrcpy(lpChar,lpTemp);
 GlobalUnlock(hMem);      
 GlobalFree(hMem);  
}
/////////////////////////////////////////////////////////////////////////////
// CMsgWnd

CMsgWnd::CMsgWnd(BOOL bAdvance/*=1*/)
{              
  DWORD Style=0;                   
  m_bAdvance = bAdvance;
  POINT WinCxy=((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetWinCxy(); 
  SetTitleFont();
  _fmemset(m_szTitle,0,sizeof(m_szTitle));
  CRect rect;
  if(m_bAdvance)
    {
	  rect.left=WinCxy.x+100;//+430;
	  rect.top=WinCxy.y+100;//50;//+(480-33)/2-20;//+50;
	  rect.right=rect.left+400;
	  rect.bottom=rect.top+200;//;//+40;//350;
	  Style=(WS_POPUP|WS_VISIBLE);
	}
  else
   	{
   	  rect.left   = WinCxy.x+490;
      rect.top    = WinCxy.y+20;
      rect.right  = rect.left+140;
      rect.bottom = rect.top+420;
      Style=WS_POPUP;
   	}               
   	
  CreateEx(WS_EX_TOPMOST,AfxRegisterWndClass(0),
           NULL,Style,
           rect.left,rect.top,rect.Width(),rect.Height(),
           NULL,NULL,NULL);
    
}

CMsgWnd::~CMsgWnd()
{
}
/*-------------------------------------------------------*/
/*               Set msg content                         */
/*-------------------------------------------------------*/
BOOL CMsgWnd::SetContent(LPSTR lpFileName)
{            

 strName=lpFileName;  
 strName.MakeUpper();
 int nIndex=strName.Find(".TXT");
 if(nIndex>0)
    strName=strName.Mid(0,nIndex);
 Invalidate();
 UpdateWindow(); 
  
/* 
 if(!IsWindowVisible())
     ShowWindow(SW_SHOW);
*/ 
// UpdateWindow();   
//            
/*
 HGLOBAL hGlobal;
 LPSTR   lpContent;  
 UINT    cbBuffer;
 HFILE hFile=_lopen(lpFileName,READ);
 if(hFile==HFILE_ERROR)
   return 0;
 cbBuffer=(UINT)_filelength(hFile);  
 if(cbBuffer==0)
    return 0;
 hGlobal=GlobalAlloc(GPTR,cbBuffer+1);
 if(hGlobal==NULL)
   {
    AfxMessageBox("Tutorial can not alloc more memory! \n   Exit some application!");
    return 0;
   }
 lpContent=(LPSTR)GlobalLock(hGlobal);  
 if(lpContent==NULL)
   {
    AfxMessageBox("Tutorial can not alloc more memory! \n   Exit some application!");
    return 0;
   }
 
 if((_lread(hFile,lpContent,cbBuffer))==HFILE_ERROR)
    return 0;
 else   
 _lclose(hFile);
 FilterString(lpContent,cbBuffer);
 m_pExplainEdit.SetFont(&m_font);
 m_pExplainEdit.SetWindowText(NULL);
 m_pExplainEdit.SetWindowText(lpContent);
 
 GlobalUnlock(hGlobal);
 GlobalFree(hGlobal);   
*/ 
 return 1;
}

BEGIN_MESSAGE_MAP(CMsgWnd, CWnd)
	//{{AFX_MSG_MAP(CMsgWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_CTLCOLOR()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMsgWnd message handlers
void CMsgWnd::SetTitleFont(int nHeight/*=36*/,
                         int nWidth/*=18*/,
                         int nWeight/*=1600*/)
{
  _fmemset(&logFont,0,sizeof(LOGFONT));
 logFont.lfHeight=nHeight;
 logFont.lfWidth=nWidth;
 logFont.lfWeight=nWeight;          
 if(m_bAdvance)     
    lstrcpy(logFont.lfFaceName,"Helv");
 else   
    lstrcpy(logFont.lfFaceName,"System_FIXED");
}
            
void CMsgWnd::SetTextFont(int nHeight,//=18,
                          int nWidth,//=9,
                          int nWeight)//=0);
{                                  
 m_font.DeleteObject();
 LOGFONT logFont;
  _fmemset(&logFont,0,sizeof(LOGFONT));
 logFont.lfHeight=nHeight;
 logFont.lfWidth=nWidth;
 logFont.lfWeight=nWeight; 
 lstrcpy(logFont.lfFaceName,"System");
 m_font.CreateFontIndirect(&logFont);              
}                          
                                 
void CMsgWnd::SetTitle(LPSTR lp)
{ 
   lstrcpy(m_szTitle,lp);
   CWindowDC dc(this);
   PaintTitle(dc);
   if(!IsWindowVisible())
     ShowWindow(SW_SHOW);
}
                                 
void CMsgWnd::PaintTitle(CDC &dc)
{                         
 if(m_szTitle[0]==0)
    return;
    
 CFont    font;
 CRect    rect;              
 COLORREF colorref;
 
 if(m_bAdvance)
   colorref=RGB(0,0,128);
 else                   
   colorref=RGB(0,128,128);    
   
 CBrush brush(colorref);
   
 GetClientRect(&rect);
 dc.SetBkMode(TRANSPARENT);
 if(m_bAdvance)
   dc.SetTextColor(RGB(192,129,129)); 
 else
   dc.SetTextColor(RGB(255,255,0)); 
 font.CreateFontIndirect(&logFont);
 dc.SelectObject(&font);
 int xChar=dc.GetTextExtent(m_szTitle,lstrlen(m_szTitle)).cx;
 int nWidth=rect.Width();  
 if(m_bAdvance)
   {
	 rect.left+=8;
	 rect.top =8;    
	 rect.right-=8;
	 rect.bottom=rect.top+g_nTextHeight;
   } 	                
 else
  {  
	 rect.bottom=rect.top+g_nTextHeight;
  }           
  
 dc.FillRect(&rect,&brush);        
 if(m_bAdvance)
    rect.left=(nWidth-xChar)/2>=0?(nWidth-xChar)/2:0; 

 rect.right=(rect.left+(nWidth>xChar?xChar:nWidth));
 dc.DrawText(m_szTitle,lstrlen(m_szTitle),&rect,DT_CENTER|DT_VCENTER);
 font.DeleteObject();

}
void CMsgWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	PaintContent(dc);
}	            

void CMsgWnd::PaintContent(CDC &dc)
{
	if(m_bAdvance)
	  {
		CBrush   brush(RGB(0,0,128));             
		CBrush   brushBlue(RGB(0,0,128));
		CPen     penWhite(PS_SOLID,1,RGB(255,255,255));
		CPen     penGray(PS_SOLID,1,RGB(128,128,128));      
		CPen     PenLGray(PS_SOLID,10,RGB(192,192,192));
		// TODO: Add your message handler code here
		CRect rect;
		GetClientRect(&rect);                                   
		dc.SelectObject(&brush);
		dc.SelectObject(&PenLGray);  
		dc.Rectangle(rect.left,rect.top,rect.right,rect.bottom);
		dc.SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(HOLLOW_BRUSH)));
		dc.SelectObject(&penWhite);
		dc.Rectangle(rect.left+1,rect.top+1,rect.right-1,rect.bottom-1);
		dc.SelectObject(&brushBlue);
		dc.SelectObject(&penGray);
		dc.Rectangle(rect.left+4,rect.top+4,rect.right-4,rect.bottom-4);
                
	  }         
	else
	  { 
	    CBrush brush(RGB(0,128,128));     
	    CRect  rect;
	    GetClientRect(&rect);
	    dc.FillRect(&rect,&brush);
	  }	

#ifndef CHINESE	
	PaintTitle(dc);
	// Do not call CWnd::OnPaint() for painting messages
#endif	

#ifdef CHINESE	
     ShowBitmap(&dc,rectRange,strName , 0);               
#endif	

}

int CMsgWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	CRect rect;
	GetClientRect(&rect);      
	if(m_bAdvance)
	 {
		rect.left   += g_nTextExternal; 
		rect.right  -= g_nTextExternal;
		rect.top    += 8+g_nTextHeight;
		rect.bottom -= g_nTextExternal;               
	  } 
	else
	  {
	   rect.top += g_nTextHeight;
	  }            
	  

#ifndef CHINESE	
    m_pExplainEdit.Create(WS_CHILD|WS_DISABLED|
                           ES_READONLY|ES_LEFT|
                           ES_MULTILINE|
                           WS_VISIBLE,rect,this,-1);
    m_font.CreateFontIndirect(&logFont);              
    SetTextFont();
    if(!m_bAdvance)
       SetTitleFont(34,15,4000);
#endif

	return 0;
}

HBRUSH CMsgWnd::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	// TODO: Add your message handler code here and/or call default

#ifndef CHINESE	
 HBRUSH brush;	
 if(pWnd->GetSafeHwnd()==m_pExplainEdit.GetSafeHwnd() && 
    (nCtlColor==CTLCOLOR_EDIT ||nCtlColor==CTLCOLOR_MSGBOX))
   {                          
    if(nCtlColor==CTLCOLOR_EDIT)
      {
       if(m_bAdvance)         
	     {
	       pDC->SetTextColor(RGB(192,192,192));
	       pDC->SetBkColor(RGB(0,0,128));
	     }
	    else
	     {
	       pDC->SetTextColor(RGB(192,192,192));
           pDC->SetBkColor(RGB(0,128,128));
         }  
      }                                  
    if(m_bAdvance)  
       brush=CreateSolidBrush(RGB(0,0,128));
    else
       brush=CreateSolidBrush(RGB(0,128,128));
    return brush;  
   }  
   
#endif	
 return CWnd::OnCtlColor(pDC, pWnd, nCtlColor);
}

void CMsgWnd::OnDestroy()
{
	CWnd::OnDestroy();
	
	// TODO: Add your message handler code here
#ifndef CHINESE	
	m_pExplainEdit.DestroyWindow(); 
	m_font.DeleteObject();
#endif	
	
}

void CMsgWnd::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);
	
	// TODO: Add your message handler code here
	
#ifdef CHINESE	
	if(m_bAdvance)
	{     
	
	   rectRange.left=0;//g_nTextExternal;
	   rectRange.top=0;//8+g_nTextHeight;
	   rectRange.right=cx;//rectRange.left+cx-2*g_nTextExternal;
	   rectRange.bottom=cy;//rectRange.top+cy-8-g_nTextHeight-g_nTextExternal;
	}                             
	else{
	   rectRange.left=0;
	   rectRange.top=0;//g_nTextHeight;
	   rectRange.right=rectRange.left+cx;
	   rectRange.bottom=rectRange.top+cy;
   }
#endif
   
#ifndef CHINESE	
	if(m_bAdvance)
	   m_pExplainEdit.MoveWindow(g_nTextExternal,8+g_nTextHeight,
	                             cx-2*g_nTextExternal,
	                             cy-8-g_nTextHeight-g_nTextExternal);
	else
	   m_pExplainEdit.MoveWindow(0,g_nTextHeight,
	                             cx,
	                             cy);
#endif	                             
}

void CMsgWnd::ClearMsg()
{
 CClientDC dc(this);
 CRect     rect;
 GetClientRect(&rect);
 CBrush brush(RGB(0,128,128));
 dc.FillRect(&rect,&brush);

#ifndef CHINESE	
 m_pExplainEdit.SetWindowText("");
 if(IsWindowVisible())
   ShowWindow(SW_HIDE);
#endif   
}