// trcdlg.h : header file
//
struct eventInfo{
	int nActiveEvent;	// 1/2/3

	int nEv1AddrMode;	// 1/2/3
	char Ev1StartAddrTxt[129];
	char Ev1EndAddrTxt[129];
	int  nEv1AddrType;  // 0/1
	
	int nEv1DataMode; 	// 1/2/3
	char Ev1StartDataTxt[129];
	char Ev1EndDataTxt[129];
	int  nEv1DataType; 	// 0
	
	BOOL bEv1S;
	BOOL bEv1F;
	BOOL bEv1R;
	BOOL bEv1W;
	BOOL bEv1AK;
	
	char Ev1CountTxt[10];

	int nEv2AddrMode; 	// 1/2/3
	char Ev2StartAddrTxt[129];
	char Ev2EndAddrTxt[129];
	int  nEv2AddrType;	// 0/1
	
	int nEv2DataMode;	// 1/2/3
	char Ev2StartDataTxt[129];
	char Ev2EndDataTxt[129];
	int  nEv2DataType;	// 0
	
	BOOL bEv2S;
	BOOL bEv2F;
	BOOL bEv2R;
	BOOL bEv2W;
	BOOL bEv2AK;

	int nEv3HL;	// 1/2
};             
struct filterInfo{
	int nActiveChoice;	// 1/2

	int nDisplayAddrMode;	// 1/2/3
	char DisplayStartAddrTxt[129];
	char DisplayEndAddrTxt[129];
	int  nDisplayAddrType;	// 0/1
	
	int nDisplayDataMode;	// 1/2/3
	char DisplayStartDataTxt[129];
	char DisplayEndDataTxt[129];
	int  nDisplayDataType;	// 0
	
	BOOL bDisplayS;
	BOOL bDisplayF;
	BOOL bDisplayR;
	BOOL bDisplayW;
	BOOL bDisplayAK;
	
	int nTraceAddrMode;	// 1/2/3
	char TraceStartAddrTxt[129];
	char TraceEndAddrTxt[129];
	int  nTraceAddrType;	// 0/1
	
	int nTraceDataMode;	// 1/2/3
	char TraceStartDataTxt[129];
	char TraceEndDataTxt[129];
	int  nTraceDataType;	// 0
	
	BOOL bTraceS;
	BOOL bTraceF;
	BOOL bTraceR;
	BOOL bTraceW;
	BOOL bTraceAK;
}; 

struct traceControlInfo {
	BOOL bStartTrace;
	BOOL bStartTimer;
	
	int nDelay; 	// 1/2/3/4
	char delayTxt[129];
};            

struct level {
	int nSet; // 0-14
	BOOL bTraceOn;
	BOOL bTimerOn;
};                

struct triggerInfo {    
	int nActiveLevel;	// 1/2
	struct level level1;
	struct level level2;
	BOOL bTriggerEnable;
	BOOL bRun;
	int nTriggerSet;	// 0-4
};


/////////////////////////////////////////////////////////////////////////////
// CTrcDlg dialog

class CTrcDlg : public CDialog
{
// Construction
public:
	CTrcDlg(CWnd* pParent = NULL);	// standard constructor
    void AdrRang();        
    void AdrRang(BOOL x);
    void AdrMult();  
    void AdrMult(BOOL x);  
    void AdrWide();  
    void AdrWide(BOOL x);  
    void event3();
    void SelTrace();
    void SelTrigger();
    void SetLevel();
    void SelLogic(BOOL bLevel=1);
    void SelFilter();
    void SetTrace();  
// Dialog Data
	//{{AFX_DATA(CTrcDlg)
	enum { IDD = IDD_GROUP_TRACE };
	CVBControl*	m_Tab;
	//}}AFX_DATA
private:
	struct eventInfo m_event;
	struct filterInfo m_filter;   
	struct traceControlInfo m_traceControl;
	struct triggerInfo m_trigger;
	
    int m_activeTab;
// Implementation
private:
CTButton   *m_pRangBtn;
CTButton   *m_pMultBtn;
CTButton   *m_pWidBtn;
CTButton   *m_pEvt3Btn;
CTButton   *m_pLevel;
CTButton   *m_pTrace;
CTComboBox *m_pLevelComb; 
CTComboBox *m_pTriggerComb; 

/*
CTButton *m_p
*/
private:
void ShowEventDlg(int nCmdShow);
void ShowTraceControlDlg(int nCmdShow);
void ShowTriggerDlg(int);
void ShowFilterDlg(int);
void EnableEventCtrl(BOOL);
void EventInit();      
void Ev1Init();
void Ev2Init();
void Ev3Init();
void FilterInit();
void DisplayInit();
void TriggerInit();
void TraceInit();
void TraceControlInit(); 
void SetTab(int nTabToActivate);
void InitItem();
void DeleteItem();

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
    virtual BOOL PreTranslateMessage(MSG *pMsg);
	// Generated message map functions
	//{{AFX_MSG(CTrcDlg)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOk();
	afx_msg void OnTabactivateTabTrace(UINT, int, CWnd*, LPVOID);
	afx_msg void OnNcLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnGrptrcEvtEv1();
	afx_msg void OnGrptrcEvtEv2();
	afx_msg void OnGrptrcEvtEv3();
	afx_msg void OnGrptrcFltDisplay();
	afx_msg void OnGrptrcFltTrace();
	afx_msg void OnTabpageshownTabTrace(UINT, int, CWnd*, LPVOID);
	afx_msg void OnGrptrcEvtMulti1();
	afx_msg void OnGrptrcEvtMulti2();
	afx_msg void OnGrptrcEvtWild1();
	afx_msg void OnGrptrcEvtWild2();
	afx_msg void OnGrptrcFltMulti1();
	afx_msg void OnGrptrcFltMulti2();
	afx_msg void OnGrptrcFltRange1();
	afx_msg void OnGrptrcFltRange2();
	afx_msg void OnGrptrcFltWild1();
	afx_msg void OnGrptrcFltWild2();
	afx_msg void OnGrptrcEvtRange1();
	afx_msg void OnGrptrcEvtRange2();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
