// firstlook.cpp : implementation of the CMainFrame class
//
#include "stdafx.h"
#include "tutorial.h"
#include "tmouse.h"
#include "mainfrm.h"
#include "time.h"
                    
#ifndef _SPEAKER_H
#define _SPEAKER_H
#include "speaker.h"
#endif _SPEAKER_H
                    
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                       
extern void Delay(int nDelay,BOOL bShow=0);
extern BOOL g_bAuto;
extern BOOL g_bAutoBtn;
extern BOOL g_mbCanDoNext;
BOOL   g_bStop=1;
/*-------------------------------------------------------*/
/*           WndIconAction                               */
/*-------------------------------------------------------*/
BOOL CMainFrame::WndIconAction(LONG lParam)
{             
 if(m_IconsClk==0)
    return 0;
 POINT point;
 point.x=LOWORD(lParam);
 point.y=HIWORD(lParam);                  
 ClientToScreen(&point);
 CRect rect[10];
 rect[0].SetRect(14,49,67,104); 
 rect[1].SetRect(12,125,69,181);
 rect[2].SetRect(12,204,68,260);
 rect[3].SetRect(7,270,72,336);
 rect[4].SetRect(9,350,71,404); 
 rect[5].SetRect(91,50,146,103);
 rect[6].SetRect(84,129,141,183); 
 rect[7].SetRect(82,204,140,258); 
 rect[8].SetRect(81,266,136,321); 
// rect[9].SetRect(81,350,136,404);
 for(int i=0;i<9;i++)
    {
     if(rect[i].PtInRect(point))
        break;
    } 
 if(i<9)
   {
    CWindowDC dc(this);  
    CBrush brush(RGB(0,128,128));
    dc.PatBlt(rect[i].left,rect[i].top,rect[i].Width(),rect[i].Height(),DSTINVERT);
    dc.SelectObject(&brush);
    COLORREF colorRef=dc.GetPixel(rect[i].left+4,rect[i].top+4);
    dc.ExtFloodFill(rect[i].left+4,rect[i].top+4,
                    colorRef,
                    FLOODFILLSURFACE);
    UINT wParam;
     switch(i)
	  {
	     case 0: 
	          wParam=ID_FIRST_VAR;
	          break;
	     case 1:
	          wParam=ID_FIRST_SOURCE;
	          break;        
	     case 2:
	          wParam=ID_FIRST_TRACE;
	          break;
	     case 3:                    
	          wParam=ID_FIRST_BITMEMORY;
	          break;
	     case 4: 
	          wParam=ID_FIRST_PER;
	          break;
	     case 5://5:
	          wParam=ID_FIRST_CPU;
	          
	          break;
	     case 6://6:
	          wParam=ID_FIRST_MEMORY;
	          break;
	     case 7://7:
	          wParam=ID_FIRST_SHELL;
	          break;
	     case 8://8:
	          wParam=ID_FIRST_STACK;
	          break;
	    // case 9:
	      //    wParam=ID_FIRST_INTRC;
	       //   break;
	     default:     
	          return 0;
	   } 
    m_IconsClk=0;
    PostMessage(WM_COMMAND,wParam);
    return 1;
   }                 
  return 0; 
}

/*-------------------------------------------------------*/
/*           OnNextPlay                                  */
/*-------------------------------------------------------*/
void CMainFrame::OnNextPlay()
{                
 ProcessNextPlay();
}
void CMainFrame::ProcessNextPlay(BOOL bInit/*=0*/)         
{
 static int nCase=0;                  
 if(bInit)
   {nCase=0;
    return;}
    
 nCase++;
 UINT nID=(UINT)GetProp(m_hWnd,"NextPlaySeg");
 switch(nID){                         
   case ID_FIRST_SOURCE:    
        switch(nCase){
          case 1:     
             OnShowFLook(ID_SRC_WORD);//ASM); //"source"
             break;
          case 2:
             OnShowFLook(ID_SRC_ASM);//MIX);
             break;
          case 3:
             OnShowFLook(ID_SRC_MIX);
             break;
          case 4:
             OnShowFLook(ID_PROJECT);
             break;                     
          case 5:
             OnShowFLook(ID_FMAP);
             break; 
          case 6:
             OnShowFLook(ID_SET_MAP);   
             break;
          case 7:
             OnShowFLook(ID_SPA_SPA);
             break;   
          case 8:
             OnShowFLook(ID_SPA_MODULE);
             break;                    
          case 9:
             OnShowFLook(ID_SPA_TIMEA);
             break;                 
          case 10:
             OnShowFLook(ID_SPA_CODE);
             break;      
          default: 
             nCase=0;       
             StopPlay();
             break;  
         }    
        break; 
   case ID_FIRST_MEMORY:
        switch(nCase){
          case 1:     
             OnShowFLook(ID_MEM_3);
             break;
          case 2:
             OnShowFLook(ID_MEM_HEX);
             break;                  
          case 3:
             OnShowFLook(ID_MEM_DEC);
             break;                  
          case 4:
             OnShowFLook(ID_MEM_WORD);
             break;                  
          case 5:
             OnShowFLook(ID_MEM_DISASM);
             break;   
          case 6:
             OnShowFLook(ID_MEM_MEMORY);
             break;
          case 7:
             OnShowFLook(ID_MEM_CHECK);
             break;
          case 8:
             OnShowFLook(ID_MEM_COMPARE);
             break;                    
          case 9:
             OnShowFLook(ID_MEM_COPY);
             break;                 
          case 10:
             OnShowFLook(ID_MEM_FILL);
             break;                 
          case 11:
             OnShowFLook(ID_MEM_SEARCH);
             break;                   
          case 12:
             OnShowFLook(ID_MEM_TEST);
             break;   
          default: 
             nCase=0;       
             StopPlay();
             break;  
         }    
        break; 
   case ID_FIRST_STACK:
        switch(nCase){
          case 1:     
             OnShowFLook(ID_STK_EXTV);
             break;
          case 2:
             OnShowFLook(ID_STK_FFL);
             break;                  
          case 3:
             OnShowFLook(ID_STK_LAF);
             break;                  
          //case 4:
            // OnShowFLook(ID_STK_FULL);
            // break;                
          case 4:
             OnShowFLook(ID_STK_VARSEL);
             break;                
          case 5:
             OnShowFLook(ID_STK_VARMODIFY);
             break;                
          case 6:
             OnShowFLook(ID_STK_VAR);
             break;                
          default: 
             nCase=0;       
             StopPlay();
             break;  
         }    
        break;
   case ID_FIRST_TRACE:
        switch(nCase){
          case 1:     
             OnShowFLook(ID_TRACE_INSTRUCTION);
             break;
          case 2:
             OnShowFLook(ID_FTRACE_SOURCE);
             break;                     
          case 3:
             OnShowFLook(ID_FTRACE_TRACE);
             break; 
          case 4:
             OnShowFLook(ID_FTRACE_EVENT);
             break;
          case 5:
             OnShowFLook(ID_FTRACE_CONTROL);
             break;   
          case 6:
             OnShowFLook(ID_FTRACE_TRIGGER);
             break;                    
          case 7:
             OnShowFLook(ID_FTRACE_FILTER);
             break;  
          default: 
             nCase=0;       
             StopPlay();
             break;  
         }    
        break;
   case ID_FIRST_CPU:      
        switch(nCase){
          case 1:     
             OnShowFLook(ID_CPU_DEC);
             break;                
     //     case 2:     
       //      OnShowFLook(ID_CPU_HEX);
        //     break;                
          default: 
             nCase=0;       
             StopPlay();
             break;  
         }    
        break;
  /* case ID_FIRST_INTRC:
        switch(nCase){
          case 1:
             OnShowFLook(ID_NEW_FEATURE);
             break;
          default: 
             nCase=0;       
             StopPlay();
             break;  
         }                  
         break;*/
   default:        
        nCase=0;       
        break;
  }         
 
}
/*-------------------------------------------------------*/
/*           Stop Dome                                   */
/*-------------------------------------------------------*/
void CMainFrame::OnStopDome()
{       
 if(g_mbCanDoNext==0 && m_StopDome.IsWindowEnabled())
    return;
 PlaySound((LPSTR)NULL);
 StopPlay();   
/*   	 
 if(g_bAuto)
    SetTimer(AUTOPLAY, 1000, NULL);
*/    
}                                          

void CMainFrame::StopPlay()
{
 bCase2Paint=0;
 m_IconsClk=1;
 g_bStop=0;
 g_bAuto=0;
 ProcessNextPlay(1);
 if(m_pMsgWnd)
    m_pMsgWnd->ClearMsg();  
    
 if(int(m_hPlayInst)>=32)
   { FreeLibrary(m_hPlayInst);
     m_hPlayInst=0;}
         
 if(m_bPlayStop)                     
   { 
     if(m_StopDome.m_hWnd)
       if(m_StopDome.IsWindowVisible());
          m_StopDome.ShowWindow(SW_HIDE);
           
     if(m_NextBtn.m_hWnd)
       if(m_NextBtn.IsWindowVisible())
          m_NextBtn.ShowWindow(SW_HIDE);
    
     
     RemoveProp(m_hWnd,"NextPlaySeg");
   }
     
 if( m_bPlayStop && m_nCanDoNext!=-1)
   {      
    KillTimer(AUTOTIMER);
    OnAutoTimer(1);
    if(m_pMeter)
      {m_pMeter->DestroyWindow(); 
       delete  m_pMeter ;
       m_pMeter=0;}
    RemoveProp(m_hWnd,"ClearScreen");   
   }
    
 m_bCanPal=1;
 m_bCanPaste=0;
 
 if(m_bPlayStop)
   { 
//     DefragRestore(m_Message);
     m_pStart->EnableWindow(1);    
     bCase2Paint=1; 
	 CWindowDC dc(this);
	 PaintFirstLook(dc);
     bCase2Paint=0;         
   } 	         
   
 m_nCanDoNext=-1;  
 m_bPlayStop=0;
 
}     

/*-------------------------------------------------------*/
/*            DefragRestore                              */
/*-------------------------------------------------------*/              
void CMainFrame::DefragRestore(CRect rect)
{                           
 if(rect.Width()==0 || rect.Height()==0)
    return;
    
 LONG lLen;
 BOOL *pbUse=new BOOL[128*96];
 _fmemset(pbUse,0,128*96*sizeof(BOOL)); 
                         
 int cx=rect.Width()/5+1;
 int cy=rect.Height()/5+1;                        
 lLen=LONG(cx*cy);
///////////////////////////////////////////////////////////      
 CWindowDC dc(this);
 CBrush brush(RGB(0,128,128));
 dc.SaveDC();
 dc.SelectObject(&brush);
 UINT nNum;     
 LONG lCount=0;
 for(;;)
  {               
   nNum=UINT(long(long(rand())*lLen)/RAND_MAX);
   if(pbUse[nNum])
      continue;
   pbUse[nNum]=1;
   dc.PatBlt(rect.left+(nNum%cx)*5,rect.top+(nNum/cx)*5,5,5,PATCOPY);
   lCount++;
   if(lCount>(lLen*8/10))
    { dc.PatBlt(rect.left,rect.top,rect.Width()+4,rect.Height()+4,PATCOPY);
      break;}
  }                  
 delete pbUse; 
 dc.RestoreDC(-1);  
 m_Message.SetRect(0,0,0,0);
}         
/*-------------------------------------------------------*/
/*           Init Library                                */
/*-------------------------------------------------------*/
BOOL CMainFrame::InitLibrary(LPSTR lpLibrary)
{
 if(int(m_hPlayInst)>=32)
    FreeLibrary(m_hPlayInst);
    
 if(*lpLibrary==0)
    return TRUE;          
    
 if(int(m_hPlayInst = ::LoadLibrary(lpLibrary))<32)
   {                                   
     char szMsg[100];
     wsprintf(szMsg,"Can not find %s library",lpLibrary);
     AfxMessageBox(szMsg,MB_OK | MB_ICONEXCLAMATION);
     return FALSE;
   } 
 return TRUE;  
}
/*-------------------------------------------------------*/
/*           show  first Look                            */
/*-------------------------------------------------------*/
BOOL CMainFrame::OnShowFLook(UINT nID)
{                               
 
 char szTitle[50];
 char szText[100];
 szTitle[0]=0;
 szText[0]=0; 

 HINSTANCE hInst=m_hFlookInst;
 m_bCanPaste=1;  
 m_bPlayStop=1;
  
 if(m_hBitmap)
   { DeleteObject(m_hBitmap);
     m_hBitmap=0;}

 if(m_pStart->IsWindowEnabled())
    m_pStart->EnableWindow(FALSE);

 if(m_bCanPal)    
    StartScreen(0,40,146,380);

 switch(nID)
   {                         
     case ID_FIRST_AUTO:
          m_IconsClk=0;
          //SetSysMouse(1);
          PlaySound("tutorial.WAV");
          m_nPlayCount=0;
          SetProp(m_hWnd,"ClearScreen",(HANDLE)0);
          DrawFirstLookTitle();
          bCase2Paint=0;
          Delay(100);                                                      
          m_pMeter=0;
//          m_pMeter = new  CPlayMeter (CWnd::FromHandle(m_hWndMDIClient));
/*
	      if(m_StopDome.m_hWnd)
	        if(!m_StopDome.IsWindowVisible());
	           m_StopDome.ShowWindow(SW_SHOW);
         */
          return 1;
          
     case ID_FIRST_SOURCE:       
          InitLibrary("other.dll");
          m_hBitmap = LoadBitmap(hInst,"LOAD");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;} 
          lstrcpy(szTitle,"LOAD");
          lstrcpy(szText,"load.txt");
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(30,15,2000);    
          break;
              
     case ID_SRC_WORD:  //"SOURCE"      
          m_hBitmap = LoadBitmap(hInst,"IDB_SOURCE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}  
          WalkPicture(m_hBitmap);   
          //lstrcpy(szTitle,"SOURCE");
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("SOURCE");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("srcvm.txt");
          return 1;
          //lstrcpy(szText,"srcsrc.txt");
          //if(m_pMsgWnd)
           //  m_pMsgWnd->SetTitleFont(30,15,2000); 
          //break;
     case ID_SRC_ASM:                      
          m_hBitmap = LoadBitmap(m_hPlayInst,"SRC_ASM");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("srcvm.txt");
          return 1;
     case ID_SRC_MIX:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"SRC_MIX");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("srcbk.txt");             
          return 1;
     case ID_PROJECT:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"PROJECT");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("PROJECT");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("project.txt");             
          return 1;
     case ID_FMAP:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"IDB_MAP");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("MAP");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("map.txt");             
          return 1;                    
     case ID_SET_MAP:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"SET_MAP");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          return 1;     
     case ID_SPA_SPA:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"SPA");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          //lstrcpy(szTitle,"SPA");
          //lstrcpy(szText,"spa.txt");
         // if(m_pMsgWnd)
           //  m_pMsgWnd->SetTitleFont(30,15,2000); 
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("SPA");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("spa.txt");             
          return 1;

     case ID_SPA_MODULE:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"SPA_MODULE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("spam.txt");             
          return 1;                                     
     case ID_SPA_TIMEA:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"SPA_TIME");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("spat.txt");             
          return 1;                                   
     case ID_SPA_CODE:                  
          m_hBitmap = LoadBitmap(m_hPlayInst,"SPA_CODE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("spac.txt");             
          return 1;     
     case ID_FIRST_MEMORY:          
          InitLibrary("mem.dll");
          m_hBitmap = LoadBitmap(hInst,"IDB_MEMORY");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          lstrcpy(szTitle,"MEMORY");
          lstrcpy(szText,"MEM1.txt");          
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(30,15,2000); 
          break;        
     case ID_MEM_DEC:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_UDEC");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);      
                     
          return 1;
     case ID_MEM_HEX:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_HEX");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("mem.txt");  
          return 1;
     case ID_MEM_WORD:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_SDEC");//"MEM_WORD");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);       
          
          return 1; 
     case ID_MEM_DISASM:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_DISASM");//"MEM_WORD");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);       
          
          return 1;     
     case ID_MEM_3:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_3");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          return 1;                                      
     case ID_MEM_MEMORY:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_MEMORY");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);      
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memdlg.txt");             
          return 1;                       
     case ID_MEM_CHECK:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_CHECK");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);      
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(24,12,1600);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memck.txt");             
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("CHECKSUM");
          return 1;                      
     case ID_MEM_COMPARE:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_COMPARE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);      
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("COMPARE");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memcp.txt");             
          return 1;                      
     case ID_MEM_COPY:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_COPY");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);        
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("COPY");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memcopy.txt");             
          return 1;                        
     case ID_MEM_FILL:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_FILL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);     
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("FILL"); 
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memfill.txt");             
          return 1;                        
     case ID_MEM_SEARCH:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_SEARCH");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);     
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("SEARCH"); 
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memsh.txt");             
          return 1;                      
     case ID_MEM_TEST:
          m_hBitmap = LoadBitmap(m_hPlayInst,"MEM_TEST");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);       
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitle("TEST");
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("memtest.txt");             
          return 1;     
     case ID_FIRST_BITMEMORY:        
          m_hBitmap = LoadBitmap(hInst,"IDB_BITMEM");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          lstrcpy(szTitle,"BIT MEMORY");
          lstrcpy(szText,"bitmem.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(20,10,2000);
          break;
     case ID_FIRST_STACK:
          InitLibrary("stk.dll");
          m_hBitmap = LoadBitmap(hInst,"IDB_STACK");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          lstrcpy(szTitle,"STACK");
          lstrcpy(szText,"STACK.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(32,16,2000);
          break;
     case ID_STK_EXTV:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_EXTV");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);   
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("STACK2.txt");             
          return 1;
     case ID_STK_FFL:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_FFL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);         
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("stackffl.txt");             
          return 1;
     case ID_STK_FULL:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_FULL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);  
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("stackful.txt");             
          return 1;                        
     case ID_STK_LAF:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_LAF");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);          
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("stacklaf.txt");             
          return 1;
     case ID_STK_VAR:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_VAR");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          return 1;
     case ID_STK_VARMODIFY:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_VARMODIFY");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);           
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("stackmdf.txt");             
          return 1;
     case ID_STK_VARSEL:
          m_hBitmap = LoadBitmap(m_hPlayInst,"STK_VARSEL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("stackvar.txt");             
          return 1;
     case ID_FIRST_VAR:
          m_hBitmap = LoadBitmap(hInst,"IDB_VARIABLE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}         
          lstrcpy(szTitle,"VARIABLE");
          lstrcpy(szText,"VARWIN.txt");   
          m_pMsgWnd->SetTitleFont(26,12,2000);
          break;
     case ID_FIRST_TRACE:
          InitLibrary("other.dll");
          m_hBitmap = LoadBitmap(hInst,"IDB_TRACE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}                   
          lstrcpy(szTitle,"TRACE");
          lstrcpy(szText,"trace.txt");   
          m_pMsgWnd->SetTitleFont(32,16,2000);
          break;
          
     case ID_TRACE_INSTRUCTION:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_INSTRUCTION");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          return 1;
     case ID_FTRACE_SOURCE:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_SRC");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
         // if(m_pMsgWnd)
           //  m_pMsgWnd->SetContent("trcsrc.txt");             
          return 1;
     case ID_FTRACE_TRACE:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_TRACE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("trct.txt");             
          return 1;                               
     case ID_FTRACE_CONTROL:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_CONTROL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("trctrci.txt");             
          return 1; 
     case ID_FTRACE_EVENT:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_EVENT");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("trcevt.txt");             
          return 1;      
     case ID_FTRACE_TRIGGER:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_TRIGGER");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("trctrg.txt");             
          return 1; 
     case ID_FTRACE_FILTER:
          m_hBitmap = LoadBitmap(m_hPlayInst,"TRACE_FILTER");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("trcf1.txt");             
          return 1; 
     case ID_FIRST_CPU:      
          InitLibrary("other.dll");
          m_hBitmap = LoadBitmap(hInst,"IDB_CPU");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
         
          lstrcpy(szTitle,"CPU");
          lstrcpy(szText,"CPU.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(36,18,2000); 
             
          break;  
     case ID_CPU_DEC:
          m_hBitmap = LoadBitmap(m_hPlayInst,"CPU_RESET");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("cpu2.txt");             
          return 1;
     case ID_CPU_HEX:
          m_hBitmap = LoadBitmap(m_hPlayInst,"CPU_REGISTER");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          WalkPicture(m_hBitmap);
          if(m_pMsgWnd)
             m_pMsgWnd->SetContent("cpu3.txt");
          return 1;
     case ID_FIRST_PER:
          m_hBitmap = LoadBitmap(hInst,"IDB_PERIPHERAL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}
          lstrcpy(szTitle,"PERIPHERAL");
          lstrcpy(szText,"PER.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(20,10,2000); 
          break;
     case ID_FIRST_SHELL:
          m_hBitmap = LoadBitmap(hInst,"IDB_SHELL");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}                   
          lstrcpy(szTitle,"SHELL");
          lstrcpy(szText,"SHELL.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(36,18,2000); 
          break;
     case ID_NEW_FEATURE:
         m_hBitmap = LoadBitmap(m_hPlayInst,"NEW_FEATURE");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}                   
          WalkPicture(m_hBitmap);
          lstrcpy(szTitle,"New Feature");
          lstrcpy(szText,"SHELL.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(24,12,1500); 
          return 1;
     case ID_FIRST_INTRC:     
          InitLibrary("other.dll");
          m_hBitmap = LoadBitmap(hInst,"INTRODUCTION");
          if(m_hBitmap==0)
            {AfxMessageBox("Can not find first look resource!");
             return 0;}               
          lstrcpy(szTitle,"Introduction");
          lstrcpy(szText,"intrc.txt");   
          if(m_pMsgWnd)
             m_pMsgWnd->SetTitleFont(24,12,1500);    
         break;    
     default:        
           return 0;
          // break;
  }         
                  
 PastePicutre(1);
 
 if(m_pMsgWnd)
   {
	 m_pMsgWnd->SetTitle(szTitle);
	 m_pMsgWnd->SetContent(szText);
   }
    
 if(m_nCanDoNext==-1)
   {
     bCase2Paint=0;
     if(m_StopDome.m_hWnd)
        if(!m_StopDome.IsWindowVisible());
           m_StopDome.ShowWindow(SW_SHOW);

     if(nID==ID_FIRST_CPU    ||
        nID==ID_FIRST_SOURCE ||
        nID==ID_FIRST_MEMORY ||
        nID==ID_FIRST_STACK  ||
        nID==ID_FIRST_TRACE)//  ||
       // nID==ID_FIRST_INTRC)
     {
       if(m_NextBtn.m_hWnd)
         if(!m_NextBtn.IsWindowVisible())
           m_NextBtn.ShowWindow(SW_SHOW);
       SetProp(m_hWnd,"NextPlaySeg",(HANDLE)nID);
     }
   }  
 else           
   m_nCanDoNext=1;

 return 1;         
} 
/*-------------------------------------------------------*/
/*               GDI Action                              */
/*-------------------------------------------------------*/ 
void CMainFrame::IniOrg(UINT nNum,POINT &point,CRect rect)
{
   switch(UINT(nNum%8)){
     case 1:
         point.x=rect.left;
         point.y=rect.bottom;
         break;
     case 2:
         point.x=rect.left;
         point.y=rect.top;
         break;
     case 3:
         point.x=rect.right;
         point.y=rect.top;
         break;
     case 4:
         point.x=rect.left;
         point.y=rect.bottom;
         break;    
     case 6:
         point.x=rect.left;
         point.y=rect.top;
         break;    
     case 5:    
         point.x=rect.left;
         point.y=rect.top;
         break;    
     case 7:    
         point.x=rect.right;
         point.y=rect.top;
         break;    
     default:    
         point.x=rect.right;
         point.y=rect.bottom;
         break;
     }
}
     
void CMainFrame::StepDraw(UINT nNum,
                          CDC &dc,
                          CDC &SrcDC,
                          POINT &point,
                          CRect rect,
                          BITMAP bm)
{               
  UINT  uNum=nNum%8;
  BOOL  bBreak=0;
  CRect rPicture; 
  POINT pointSrc;
  for(int i=0;i<500;i++){ 
    switch(uNum){
      case 2:
      case 3:
        point.y+=i;
	    if(point.y>=rect.bottom)  
	       bBreak=1;
	    break;     
	  case 4:
	    point.y-=i;
	    if(point.y<=rect.top)  
	       bBreak=1;            
	    break;   
	  case 6:
	    point.y+=i;
	    if(point.y>=rect.bottom)  
	       bBreak=1;            
	    break;
	  case 5:
	    point.x+=i;
	    if(point.x>=rect.right)  
	       bBreak=1;            
	    break;
	  case 7:  
	    point.x-=i;
	    if(point.x<=rect.left)  
	       bBreak=1;            
	    break;
      default:
	    point.y-=i;                                                      
	    if(point.y<=rect.top)  
	       bBreak=1;            
	    break;
	 }//switch(uNum)
    if(bBreak) break;
//---------------------------------------------------------    	   
    Delay(50);
	if(uNum<=3) 
	  point.x=int((LONG(point.y)*LONG(rect.Width()))/rect.Height());
//---------------------------------------------------------	 
    switch(uNum){
      case 1:
        rPicture.left  = rect.left;
        rPicture.top   = point.y;
        rPicture.right = rect.left+rect.Width()-point.x;
        rPicture.bottom= rect.bottom;
        pointSrc.x=bm.bmWidth-rPicture.Width();
        pointSrc.y=0;
        break;
      case 2: 
        rPicture.left  = rect.left;
        rPicture.top   = rect.top;
        rPicture.right = point.x;
        rPicture.bottom= point.y;
        pointSrc.x=bm.bmWidth-rPicture.Width();
        pointSrc.y=bm.bmHeight-rPicture.Height();
        break;
      case 3:
        rPicture.left  = rect.right-(point.x-rect.left);
        rPicture.top   = rect.top;
        rPicture.right = rect.right;
        rPicture.bottom= point.y;
        pointSrc.x=0;
        pointSrc.y=bm.bmHeight-rPicture.Height();
        break;
      case 4:
        rPicture.left  = rect.left;
        rPicture.top   = point.y;
        rPicture.right = rect.right;
        rPicture.bottom= rect.bottom;
        pointSrc.x=0;
        pointSrc.y=0;
        break;
      case 6:
        rPicture.left  = rect.left;
        rPicture.top   = rect.top;
        rPicture.right = rect.right;
        rPicture.bottom= point.y;
        pointSrc.x=0;
        pointSrc.y=bm.bmHeight-rPicture.Height();
        break;
      case 5:
        rPicture.left  = rect.left;
        rPicture.top   = rect.top;
        rPicture.right = point.x;
        rPicture.bottom= rect.bottom;
        pointSrc.x=bm.bmWidth-rPicture.Width();
        pointSrc.y=0;
        break;
      case 7:
        rPicture.left  = point.x;
        rPicture.top   = rect.top;
        rPicture.right = rect.right;
        rPicture.bottom= rect.bottom;
        pointSrc.x=0;
        pointSrc.y=0;
        break;
      default:
        rPicture.left  = point.x;
        rPicture.top   = point.y;
        rPicture.right = rect.right;
        rPicture.bottom= rect.bottom;
        pointSrc.x=0;
        pointSrc.y=0;
        break;
	 }//switch(uNum)
	if(rPicture.left<(WinCxy.x+500)) 
	   dc.BitBlt(rPicture.left,rPicture.top,rPicture.Width(),rPicture.Height(),
	          &SrcDC,pointSrc.x,pointSrc.y,SRCCOPY);
	          
  }  
}
void CMainFrame::WalkPicture(HBITMAP hBitmap)
{           
 static UINT nNum=0;
 g_mbCanDoNext=0;
 m_StopDome.EnableWindow(FALSE);
 CRect rect=m_Message;
 POINT point;
 rect.left+=4;
 rect.right-=4;
 rect.top+=4;
 rect.bottom-=4;
 CBitmap *pBitmap=CBitmap::FromHandle(hBitmap);            
 CWindowDC dc(this);
 CDC       SrcDC;
 SrcDC.CreateCompatibleDC(&dc);
 SrcDC.SelectObject(pBitmap);
 IniOrg(nNum,point,rect); 
/////////////////////////////////////////////////////////// 
 BITMAP bm;
 ::GetObject(hBitmap,sizeof(BITMAP),&bm);
 StepDraw(nNum,dc,SrcDC,point,rect,bm);
///////////////////////////////////////////////////////////	
 nNum++;
 SrcDC.DeleteDC(); 	  
 PastePicutre(); 
 Delay(500);
 if(m_nCanDoNext!=-1)
   m_nCanDoNext=1;
 m_StopDome.EnableWindow(TRUE);  
 g_mbCanDoNext=1;
}

void CMainFrame::PastePicutre(BOOL bOpen/*=0*/,
                               int orgX/*=10*/,
                               int orgY/*=20*/)
{                   
 CWindowDC dc(this);
 CBitmap *pLoadBit = CBitmap::FromHandle(m_hBitmap);
 CBitmap Bitmap;
 BITMAP bm;
 int nHead[9];
 
 CDC SrcDC;
 CDC DesDC;
 SrcDC.CreateCompatibleDC(&dc);
 DesDC.CreateCompatibleDC(&dc);
 SrcDC.SaveDC();
 DesDC.SaveDC();
 dc.SaveDC();   
 
 pLoadBit->GetObject(sizeof(BITMAP),&bm);
 Bitmap.CreateCompatibleBitmap(&dc,bm.bmWidth+8,bm.bmHeight+8);
 SrcDC.SelectObject(pLoadBit);
 DesDC.SelectObject(&Bitmap);            
 CBrush brush(RGB(0,128,128));
 CBrush brushG(RGB(0,128,255));
 CRect rect(4,4,bm.bmWidth,bm.bmHeight);
 //MSG msg;
 DesDC.SelectObject(&brushG);                         
 DesDC.Rectangle(0,0,bm.bmWidth+8,bm.bmHeight+8);     
 DesDC.BitBlt(4,4,bm.bmWidth,bm.bmHeight,&SrcDC,0,0,SRCCOPY);
 DesDC.SelectObject(&brush);                         
//////////////////////////////////////////////////////////////////////
 if(bOpen) 
   { 
    int nWidth=(bm.bmWidth)/8;
    for(int y=0;y<8;nHead[y]=(y+1)*nWidth,y++);
    nHead[7]=bm.bmWidth+4;
       
    for(int i=0;i<nWidth;i+=16)
       {          
         if(m_nCanDoNext!=-1)
            m_nCanDoNext=0;
         
         if(i==0)
            DesDC.Rectangle(&rect);//FillRect(&rect,&brush);
         else
           {          
            for(int j=0;j<8;j++)
              {
               rect.right=nHead[j];
               rect.left=rect.right-nWidth+i;
               DesDC.Rectangle(&rect);//FillRect(&rect,&brush);
              }//for 
           }//else       
	    dc.BitBlt(orgX,orgY,bm.bmWidth+8,bm.bmHeight+8,
	              &DesDC,0,0,SRCCOPY);  
        DesDC.SelectObject(&brushG);                         
        DesDC.Rectangle(0,0,bm.bmWidth+8,bm.bmHeight+8);     
        DesDC.BitBlt(4,4,bm.bmWidth,bm.bmHeight,&SrcDC,0,0,SRCCOPY);
        DesDC.SelectObject(&brush);                         
       }          

   }        
////////////////////////////////////////////////////////////////////// 
 dc.BitBlt(orgX,orgY,bm.bmWidth+8,bm.bmHeight+8,&DesDC,0,0,SRCCOPY);
 m_Message.SetRect(orgX,orgY,orgX+bm.bmWidth+8,orgY+bm.bmHeight+8);
 DesDC.RestoreDC(-1);
 SrcDC.RestoreDC(-1);
 dc.RestoreDC(-1); 
 SrcDC.DeleteDC(); 
 DesDC.DeleteDC();
 Bitmap.DeleteObject();
}

/*-------------------------------------------------------*/
/*           Start first Look                            */
/*-------------------------------------------------------*/
void CMainFrame::InitFirstLook(int nShowBtn/*=0*/)
{  
 CRect rectBtn;                                      
 rectBtn.SetRect(100,410,205,434);               
 if(nShowBtn==0)
   {    
	    m_StopDome.DestroyWindow();
	    m_StopDome.m_hWnd=0;
        
        m_NextBtn.DestroyWindow();
        m_NextBtn.m_hWnd=0;
        return;
   }

  if(!m_StopDome.Create(NULL,WS_CHILD|WS_TABSTOP|//|WS_VISIBLE
                        BS_OWNERDRAW|BS_LEFTTEXT,
                        rectBtn,this,ID_STOP_DOME))
      { AfxMessageBox("Can not create stop dome button!"); 
        return;}     
       
  if(!m_StopDome.LoadBitmaps("DS_DOWN","DS_UP","DS_DOWN"))
       { AfxMessageBox("Can not Load stop dome button!"); 
         AfxThrowResourceException();
         return;}                    

///////////////////////////////////////////////////////////

 rectBtn.SetRect(300+50,410,350+105,434);
 
  if(!m_NextBtn.Create(NULL,WS_CHILD|WS_TABSTOP|//WS_VISIBLE|
                        BS_OWNERDRAW|BS_LEFTTEXT,
                        rectBtn,this,ID_NEXT_PLAY))
       { AfxMessageBox("Can not create Next button!"); 
         return;}     
       
  if(!m_NextBtn.LoadBitmaps("NEXT_DOWN","NEXT_UP","NEXT_DOWN"))
       { AfxMessageBox("Can not Load Next button!"); 
         AfxThrowResourceException();
         return;}            

}

void CMainFrame::StartFirstLook()
{ 
//  SetKey(0);
  SetSysKey(1);

  g_bAutoBtn=0;
  FilterTaskChange(0);
  BOOL bSet=SetProp(m_hWnd,"CanBk",0);
  ASSERT(bSet);
  m_pMeter=0;
  m_bSet=1;
  m_bDCan=1;
  m_bTimeActive=0;
  m_bCanPaste=0;  
  m_bCanPal=1;
  m_hBitmap=0; 
  g_bStop=1;
  m_nCanDoNext=-1;//for auto play
  g_mbCanDoNext=1;
  bCase2Paint=1;            
  m_IconsClk=1;
  m_bPlayStop=0;
  m_StopDome.m_hWnd= 0;
  m_NextBtn.m_hWnd= 0;
  m_Message.SetRect(0,0,0,0);
  SetCase(ID_CASE_FIRST_LOOK);  
  m_pExitBtn->ShowWindow(SW_HIDE);
  m_pExitBtn->DestroyWindow();  
  if(int(m_hFlookInst = ::LoadLibrary("first.dll"))<32)
   {
     AfxMessageBox("Can not find firstres.dll library",MB_OK | MB_ICONEXCLAMATION);
     return ;
   }             

///////////////////////////////////////////////////////////  
  CWindowDC dc(this);    
  CDC       DC;    
  int       x,y; 
  const int nLine=int(64*48);
  LONG      z; 
  CRect    rectWin;          
  BOOL     *pCheck = new BOOL[nLine];
  CBitmap  *pSrcMap = new CBitmap;
  
  pSrcMap->CreateCompatibleBitmap(&dc,640,480); 
  DC.CreateCompatibleDC(&dc);
  DC.SelectObject(pSrcMap); 
  
  m_pBkGroundS->LoadBitmap(IDB_ICONS);
  m_pBkGroundM->LoadBitmap(IDB_ICONM);
  
  PaintFirstLook(DC,FALSE);
  _fmemset(pCheck,0,nLine*sizeof(BOOL));
  int nCount=0;
  for(;;)
     {         
	  z=rand();
	  if(z<=64*48)
		 if(pCheck[z]==0)
		    pCheck[z]=1;
		 else
		     continue;
	   else
		  continue;
	     
	  y=int(z/64*10);
	  x=int((z%64)*10);
	  dc.BitBlt(x,y,10,10,&DC,x,y,SRCCOPY);
	  nCount++;
	  if(nCount>64*48*9/10)   
	    break;    
	     
	 }            
  dc.BitBlt(0,0,640,480,&DC,0,0,SRCCOPY);	         
  DC.DeleteDC();	 
  pSrcMap->DeleteObject();	 
  delete pSrcMap;
  delete pCheck;	  
  SetKey(1);    
///////////////////////////////////////////////////////////
                                         
  CRect rectBtn(2,410,60,434); 
     
  if(!m_pStart->Create("Start",WS_CHILD|WS_VISIBLE|WS_TABSTOP|
                               BS_OWNERDRAW|BS_CHECKBOX|BS_LEFTTEXT,
                       rectBtn,this,ID_START))
     { AfxMessageBox("Can not create start button!"); 
       return;}     
       
  if(!m_pStart->LoadBitmaps("StartDown","StartUp",
                            "StartFocus","StartDisable"))
     { AfxMessageBox("Can not Load start button!"); 
       AfxThrowResourceException();
       return;}  
//////////////////////////////////////////////////////////      
InitFirstLook(1);
///////////////////////////////////////////////////////////
//  m_pStart->SizeToContent();  
//  m_pStart->ShowWindow(SW_SHOW);                      
  m_pMenu95=0;
  m_pMeter =0; //new  CPlayMeter (CWnd::FromHandle(m_hWndMDIClient));
  m_hPlayInst=0;
  m_pMsgWnd = new CMsgWnd(FALSE);
  SetTimer(SYSTIME,1000,NULL);
  if(g_bAuto)                     
    {
     Delay(1000);
     PostMessage(WM_COMMAND,ID_FIRST_AUTO);
     SetSysKey(1);
    } 
}                

/*-------------------------------------------------------*/
/*          return to Start                              */
/*-------------------------------------------------------*/
void CMainFrame::OnFirstLookExit()
{
// TODO: Add your command handler code here
  if(g_mbCanDoNext==0)
     return;
  PlaySound((LPSTR)NULL);
  RemoveProp(m_hWnd,"CanBk");
  ProcessNextPlay(TRUE);
//  m_pSource->MDIDestroy();
  
  if( m_pMsgWnd )                               
    {delete m_pMsgWnd;
     m_pMsgWnd=0;}
     
  if(m_pMeter)
    {m_pMeter->DestroyWindow(); 
     delete  m_pMeter ;
     m_pMeter=0;}
  
  if(int(m_hPlayInst)>=32)
    { FreeLibrary(m_hPlayInst);
      m_hPlayInst=0;}

  if(int(m_hFlookInst)>=32)
    { FreeLibrary(m_hFlookInst);
      m_hPlayInst=0;}
       
  KillTimer(SYSTIME);
  KillTimer(TIMER2);   
  KillTimer(AUTOTIMER);
  OnAutoTimer(1);
  RemoveProp(m_hWnd,"ClearScreen");   
  RemoveProp(m_hWnd,"NextPlaySeg");
  
  if(m_pMenu95)
    { m_pMenu95->DestroyWindow();
      m_pMenu95=0;}  
      
  m_bCanPal=1;     
  m_bCanPaste=0;

 if(int(m_hPlayInst)>=32)
   { FreeLibrary(m_hPlayInst);
     m_hPlayInst=0;}

/////////////////////////////  
  if(m_hBitmap)//////////////
    { DeleteObject(m_hBitmap);
      m_hBitmap=0;}

  m_pStart->DestroyWindow();
  InitFirstLook(0);    
  
  m_pBkGroundS->DeleteObject();
  m_pBkGroundM->DeleteObject();

///////////////////////////////////////////////////////////
  SetCase(ID_CASE_START);
  CRect rectWin;
  GetWindowRect(&rectWin);
  CRect rectBtn(
                int(rectWin.Width()*3/4),
                int(posLine.y-6),
                int(rectWin.Width()*3/4)+100,
                int(posLine.y-6+20) );
  ScreenToClient(&rectBtn);              
  
  m_pExitBtn->Create("&Exit Tutorial",
                     WS_CHILD|WS_VISIBLE|WS_TABSTOP,
                     rectBtn,this,ID_APP_EXIT);
                     
  FilterTaskChange(1);
  g_mbCanDoNext=1;  
  
  if(g_bAuto){
     KillTimer(AUTOPLAY);
     SetTimer(AUTOPLAY, 2000, NULL);}
  else
     g_bAutoBtn=0;//1;   

  SetSysMouse(0);
  SetSysKey(0);
     
}
 
/*-------------------------------------------------------*/
/*           Paint first look wall paper                 */
/*-------------------------------------------------------*/
void CMainFrame::PaintFirstLook(CDC &dc,BOOL bNotPaint/*=1*/)
{
  if(!bCase2Paint && bNotPaint)
    {bCase2Paint=1;
     if(!m_StopDome.IsWindowVisible())
        {
        /*
         CRect rect;     
         CBrush brush(RGB(192,192,192)); 
         m_StopDome.GetWindowRect(&rect);
         dc.FillRect(&rect,&brush);
        */ 
        }
     return;}
     
  dc.SaveDC();
  CBrush brush(RGB(0,128,128));
  CRect  rectWin;    
  CRect  rectDes;
///////////////////////////////////////////////////////////
//paint background  
  GetWindowRect(&rectWin);
  dc.FillRect(rectWin,&brush);
  rectDes=rectWin;       
  rectDes.top=50;
  rectDes.right=rectDes.left+146;
  rectDes.bottom=rectDes.top+350;
///////////////////////////////////////////////////////////  
  SetBottomToolBar(dc);
  if(m_bCanPal || !bNotPaint)
     MovingBitmap(dc,rectDes,m_pBkGroundS,m_pBkGroundM);
  dc.RestoreDC(-1);
  if(!bNotPaint)
     return;
     
  if(m_bCanPaste)
    {PastePicutre();}

  if(m_StopDome.IsWindowVisible())
     {m_StopDome.Invalidate(FALSE);
      m_StopDome.UpdateWindow();}

  if(m_NextBtn.IsWindowVisible())
     {m_NextBtn.Invalidate(FALSE);
      m_NextBtn.UpdateWindow();}
      
  if(m_pStart)    
    {m_pStart->Invalidate(FALSE);
     m_pStart->UpdateWindow();}
     
  if(m_pMeter)    
  if(m_pMeter->IsWindowVisible())
    {m_pMeter->Invalidate(FALSE);
     m_pMeter->UpdateWindow();}
} 
/*-------------------------------------------------------*/
/*                 Set System Time                       */
/*-------------------------------------------------------*/
void CMainFrame::SetSysTime(CDC &dc,UINT nIDEvent)
{         
 dc.SaveDC();
 CPen  penBlack(PS_SOLID,1,RGB(0,0,0));
 CPen  penWhite(PS_SOLID,1,RGB(255,255,255));  
 CFont font;
 CRect rectWin(570,452,635,477);
//////////////////////////////////////////////////////////
 dc.SelectObject(&penBlack);
 dc.MoveTo(570,477);
 dc.LineTo(570,452);
 dc.LineTo(635,452);
 dc.SelectObject(&penWhite);
 dc.LineTo(635,477);
 dc.LineTo(570,477);
//////////////////////////////////////////////////////////
 LOGFONT logFont;
 CRect   rectTime;     
 char    szTime[15];
 _fmemset(&logFont,0,sizeof(LOGFONT));
 logFont.lfHeight=18;
 logFont.lfWidth =6; 
 logFont.lfWeight=200;
 lstrcpy(logFont.lfFaceName,"Arial"); 
 font.CreateFontIndirect(&logFont);
 dc.SelectObject(&font);
 _strtime(szTime);
 rectTime.SetRect(571+1,459-4,634,474);
 dc.SetBkColor(RGB(192,192,192));
 dc.DrawText(szTime,lstrlen(szTime),&rectTime,DT_CENTER);
 
////////////////////////////////////////////////////////// 
 font.DeleteObject();
 dc.RestoreDC(-1);
}
/*-------------------------------------------------------*/
/*                 Set Buttom Tool Bar                   */
/*-------------------------------------------------------*/
void CMainFrame::SetBottomToolBar(CDC &dc)
{
  CBrush brush(RGB(192,192,192));
  CPen   pen(PS_SOLID,1,RGB(255,255,255));
  CRect  rectWin;
  CRect  rect;
////////////////////////////////////////////////////////////
  dc.SaveDC();   
  GetWindowRect(&rectWin);
  rect=rectWin;
  rect.top=rect.bottom-33;
  dc.FillRect(rect,&brush);   
  dc.SelectObject(&pen);
  dc.MoveTo(rect.left,rect.top+1);
  dc.LineTo(rect.right,rect.top+1);
  dc.RestoreDC(-1); 
  SetSysTime(dc);
}
void CMainFrame::OnStartBtn()
{            
  if(m_bDCan==0)
    {m_bDCan=1;
     return;}
  
  if(m_bTimeActive || g_bAuto)
     return;
     
  if(m_bSet)
	{ m_bSet=0;
	  m_bTimeActive=1;
	  m_pStart->SetState(1);
      PostMessage(WM_COMMAND,ID_BTN_START);
	  SetTimer(TIMER2,55,NULL);
	}
  else
  	{ m_bSet=1;      
  	  m_bTimeActive=1;
  	  m_pStart->SetState(0);
  	  PostMessage(WM_COMMAND,ID_BTN_START);
	  SetTimer(TIMER2,55,NULL);}
  
}                       
void CMainFrame::OnBtnTimer()
{
    if(m_pStart)
       m_pStart->SetState(!m_bSet);
    KillTimer(TIMER2);   
    m_bTimeActive=0;
}   

void CMainFrame::OnStartCmd()
{
  if(!m_bSet)      
    {m_bDCan=0;
     m_pMenu95 = new CMenuDlg(this);
     m_pMenu95->SetFocus();}
  else
  	{ if(m_pMenu95)
  	     m_pMenu95->DestroyWindow();
  	  m_pMenu95=0;} 	  
}
/////////////////////////////////////////////////////////////////////////////
// CMenuDlg dialog
CMenuDlg::CMenuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMenuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMenuDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
  m_hWnd=0;	
  Create(IDD,pParent);	
}

void CMenuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMenuDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMenuDlg, CDialog)
	//{{AFX_MSG_MAP(CMenuDlg)
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMenuDlg message handlers

BOOL CMenuDlg::OnInitDialog()
{
	m_pBitMenu = new CBitmap;
	m_pBitMenu->LoadBitmap(IDB_MENU95);
	m_pBitSel = new CBitmap;
	m_pBitSel->LoadBitmap(IDB_MENU96);

	CDialog::OnInitDialog();
	m_nLine=11;
	m_bInit=0;
	// TODO: Add extra initialization here
	MoveWindow(10,149,154,300);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMenuDlg::OnDestroy()
{                                      
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	if(m_pBitMenu)
	  {m_pBitMenu->DeleteObject();
       delete m_pBitMenu;
       m_pBitMenu=0;}
    if(m_pBitSel)
      {m_pBitSel->DeleteObject();
       delete m_pBitSel;
       m_pBitSel=0;}

}
void CMenuDlg::OnCancel()
{
 if((((CMainFrame *)(AfxGetApp()->m_pMainWnd))->
       GetStartBtn()->GetState()&0x0004)!=0)
    {((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetStartBtn()->SetState(0);
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDCan(1);
    ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetBSet(1);}

 if(m_pBitMenu)
   {m_pBitMenu->DeleteObject();
    delete m_pBitMenu;
    m_pBitMenu=0;}
 if(m_pBitSel)
   {m_pBitSel->DeleteObject();
    delete m_pBitSel;
    m_pBitSel=0;}
    
 //((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetMenu95();
 DestroyWindow();
   m_hWnd=0;
}
void CMenuDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
    
    dc.SaveDC();                
	// TODO: Add your message handler code here
	CDC SrcDC;
	SrcDC.CreateCompatibleDC(&dc);
	SrcDC.SaveDC();
	SrcDC.SelectObject(m_pBitMenu);
	dc.BitBlt(0,0,154,300,&SrcDC,0,0,SRCCOPY);
	SrcDC.RestoreDC(-1);
	SrcDC.DeleteDC();
	
	CFont   font;
	LOGFONT logFont;                
	_fmemset(&logFont,0,sizeof(LOGFONT));
	logFont.lfHeight=20;
	logFont.lfWidth=10;
	logFont.lfWeight=800;               
	lstrcpy(logFont.lfFaceName,"Roman");
	logFont.lfEscapement=-900;
	font.CreateFontIndirect(&logFont);
	dc.SelectObject(&font);
	dc.SetBkMode(TRANSPARENT);
	dc.SetTextColor(RGB(192,192,192));
	dc.SetMapMode(MM_ISOTROPIC);
	dc.SetWindowExt(22,300);
	dc.SetViewportExt(22,-300);
	dc.SetViewportOrg(22,300);
	dc.TextOut(-19,8,"EasyPack/SLD Tutorial",21);
    font.DeleteObject();
	// Do not call CDialog::OnPaint() for painting messages
    if(!m_bInit)                
      {
		CPoint point(-2000,-2000);
		CRect rect=GetSelRect(point);
		DrawSel(rect);
		m_bInit=1;
	  }         
    dc.RestoreDC(-1);	  
}
CRect CMenuDlg::GetSelRect(CPoint point)
{
 int nPos[]={0,23,24,48,49,72,73,97,98,121,122,
             145,146,170,171,194,195,220,221,
             257,258,300};
 CRect rect;
 rect.left=24;
 rect.right=150;  

 if(point.x<=-1000 && point.y<=-1000)          
   {
	  rect.top=nPos[m_nLine*2];
	  rect.bottom=nPos[2*m_nLine+1];
      return rect;
   }  
   
 for(int i=0;i<=10;i++)
 {  
  rect.top=nPos[2*i];
  rect.bottom=nPos[2*i+1];
  if(rect.PtInRect(point))
    {if(m_nLine==i)
        break;
     else   
     {m_nLine=i;
      return rect;}}
 }          
  rect.top=0;
  rect.bottom=0;
  return rect;         
}                     

void CMenuDlg::SetCurSel(CPoint point)
{          
  CRect rect;
  int nLine;
  int nLineOld = m_nLine;
  
  rect=GetSelRect(point);
  if(rect.Height()==0)
     return;
  nLine   = m_nLine;  
  m_nLine = nLineOld;
  DrawSel(rect);
  m_nLine = nLine;
}
void CMenuDlg::DrawSel(CRect rect)
{
  CClientDC dc(this);
  CDC SrcDC;
  CPen  pen(PS_SOLID,1,RGB(0,0,128));
  rect.top += 2;
  rect.bottom -=2;
  dc.SaveDC();
  SrcDC.CreateCompatibleDC(&dc);
  SrcDC.SaveDC();   

  if(m_nLine>=0 && m_nLine<=10 ) 
    {    
     POINT p;
     p.x=-2000;
     p.y=-2000;   
     CRect rectOld=GetSelRect(p);
     SrcDC.SelectObject(m_pBitMenu);
     dc.BitBlt(rectOld.left,rectOld.top,rectOld.Width(),rectOld.Height(),
            &SrcDC,rectOld.left,rectOld.top,SRCCOPY);
     
    }                     
  SrcDC.SelectObject(m_pBitSel);
  dc.BitBlt(rect.left,rect.top,rect.Width(),rect.Height(),
            &SrcDC,rect.left,rect.top,SRCCOPY);
  SrcDC.RestoreDC(-1); 
  SrcDC.DeleteDC();  
  dc.RestoreDC(-1); 

}                     
void CMenuDlg::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	SetCurSel(point);
	CDialog::OnMouseMove(nFlags, point);
}         

BOOL CMenuDlg::PreTranslateMessage(MSG *pMsg)
{                          

 if(pMsg->message==WM_KEYUP)
   if(pMsg->wParam==VK_LEFT || pMsg->wParam==VK_RIGHT)
      return 1;
              
 if(pMsg->message==WM_KEYDOWN)
   {           
     if(pMsg->wParam==VK_LEFT || pMsg->wParam==VK_RIGHT)
        return 1;
     if(pMsg->wParam==VK_RETURN)
       { MessageProcess();
         return 1;}
         
     if(m_nLine<0)
        m_nLine=10;
     if(m_nLine>10)
        m_nLine=0;
     if(pMsg->wParam==VK_UP)
       {MenuBar(1);
        return 1;}
     if(pMsg->wParam==VK_DOWN)
       {MenuBar(0);               
        return 1;}
   }  
 return CDialog::PreTranslateMessage(pMsg);   
}    

void CMenuDlg::MenuBar(BOOL bUp)
{
     int nLine = m_nLine;
     int nNew;
	 POINT p;
     p.x=-2000;
     p.y=-2000;         
     if(bUp)
       m_nLine --;
     else
       m_nLine ++;
       
     if(m_nLine>10)
        m_nLine=0;
     else
     if(m_nLine<0)
        m_nLine=10;
        
     nNew = m_nLine;   
     CRect rect=GetSelRect(p);
     m_nLine = nLine;
	 DrawSel(rect);
     m_nLine = nNew;
}

void CMenuDlg::MessageProcess()
{                  
 UINT wParam;
 switch(m_nLine)
   {     
     
    // case 0:
      //    wParam=ID_FIRST_INTRC;
       //   break;
     case 0:
          wParam=ID_FIRST_SOURCE;
          break;
     case 1:
          wParam=ID_FIRST_MEMORY;
          break;        
     case 2:
          wParam=ID_FIRST_BITMEMORY;
          break;
     case 3:
          wParam=ID_FIRST_STACK;
          break;
     case 4:
          wParam=ID_FIRST_VAR;
          break;
     case 5:
          wParam=ID_FIRST_TRACE;
          break;
     case 6:
          wParam=ID_FIRST_CPU;
          break;
     case 7:
          wParam=ID_FIRST_PER;
          break;
     case 8:
          wParam=ID_FIRST_SHELL;
          break;
     case 9:
          wParam=ID_FIRST_AUTO;
          break;
     case 10: 
          wParam=ID_FIRLOOK_EXIT;
          break;
     default:
          return;
   }        
 SendMessage(WM_COMMAND,IDCANCEL);
 Delay(200);
 AfxGetApp()->m_pMainWnd->PostMessage(WM_COMMAND,wParam);
}
void CMenuDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	CDialog::OnLButtonDown(nFlags, point);
	MessageProcess();
}
/*-------------------------------------------------------*/
/*                 first look exit                       */
/*-------------------------------------------------------*/
void CMainFrame::OnFirLookExt()
{
 OnFirstLookExit();
}  
/*   
/////////////////////////////////////////////////////////////////////////////
// CChildIconWnd

IMPLEMENT_DYNCREATE(CChildIconWnd, CMDIChildWnd)

CChildIconWnd::CChildIconWnd()
{ 

  Create(AfxRegisterWndClass(0,0,0,
                             LoadIcon(AfxGetApp()->m_hInstance,
                             MAKEINTRESOURCE(IDI_CPU))) ,"Source", WS_OVERLAPPEDWINDOW|WS_CHILD|WS_VISIBLE);
}

CChildIconWnd::~CChildIconWnd()
{
}


BEGIN_MESSAGE_MAP(CChildIconWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildIconWnd)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildIconWnd message handlers
*/
