// trcdlg.cpp : implementation file
//

#include "stdafx.h"
#include "tutorial.h"
#include "trcdlg.h"
#include "mainFrm.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define AFX_NUM_EVENTPARAMINDEX(type, lpParams, index) \
    (type FAR&)(**((type FAR* FAR*)(lpParams) + index))

extern void Delay(int nDelay,BOOL bShow=0);
extern BOOL g_bAuto;
extern BOOL g_mbCanDoNext;
extern UINT g_uTick;
/////////////////////////////////////////////////////////////////////////////
// CTrcDlg dialog


CTrcDlg::CTrcDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTrcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTrcDlg)
    g_mbCanDoNext=0;   
	m_Tab = NULL;
	//}}AFX_DATA_INIT  
   if(g_bAuto)
      AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);
	    
	m_activeTab=0;
	m_event.nActiveEvent = 1;                 
	m_event.nEv1AddrMode = 1;
	m_event.Ev1StartAddrTxt[0]='\0';
	m_event.Ev1EndAddrTxt[0]='\0';
	m_event.nEv1AddrType = 0;
	m_event.nEv1DataMode = 1;
	m_event.Ev1StartDataTxt[0]='\0';
	m_event.Ev1EndDataTxt[0]='\0';
	m_event.nEv1DataType=0;
	
	m_event.bEv1S = FALSE;
	m_event.bEv1F = FALSE;
	m_event.bEv1R = FALSE;
	m_event.bEv1W = FALSE;
	m_event.bEv1AK = FALSE;
	
	m_event.Ev1CountTxt[0]='\0';

	m_event.nEv2AddrMode = 1;
	m_event.Ev2StartAddrTxt[0]='\0';
	m_event.Ev2EndAddrTxt[0]='\0';
	m_event.nEv2AddrType = 0;
	m_event.nEv2DataMode = 1;
	m_event.Ev2StartDataTxt[0]='\0';
	m_event.Ev2EndDataTxt[0]='\0';
	m_event.nEv2DataType=0;
	
	m_event.bEv2S = FALSE;
	m_event.bEv2F = FALSE;
	m_event.bEv2R = FALSE;
	m_event.bEv2W = FALSE;
	m_event.bEv2AK = FALSE; 
	
	m_event.nEv3HL = 1;

	m_filter.nActiveChoice = 1;                 
	m_filter.nDisplayAddrMode = 1;
	m_filter.DisplayStartAddrTxt[0]='\0';
	m_filter.DisplayEndAddrTxt[0]='\0';
	m_filter.nDisplayAddrType = 0;
	m_filter.nDisplayDataMode = 1;
	m_filter.DisplayStartDataTxt[0]='\0';
	m_filter.DisplayEndDataTxt[0]='\0';
	m_filter.nDisplayDataType=0;
	
	m_filter.bDisplayS = FALSE;
	m_filter.bDisplayF = FALSE;
	m_filter.bDisplayR = FALSE;
	m_filter.bDisplayW = FALSE;
	m_filter.bDisplayAK = FALSE;
	
	m_filter.nTraceAddrMode = 2;
	m_filter.TraceStartAddrTxt[0]='\0';
	m_filter.TraceEndAddrTxt[0]='\0';
	m_filter.nTraceAddrType = 0;
	m_filter.nTraceDataMode = 2;
	m_filter.TraceStartDataTxt[0]='\0';
	m_filter.TraceEndDataTxt[0]='\0';
	m_filter.nTraceDataType=0;
	
	m_filter.bTraceS = FALSE;
	m_filter.bTraceF = FALSE;
	m_filter.bTraceR = FALSE;
	m_filter.bTraceW = FALSE;
	m_filter.bTraceAK = FALSE;                   
	
	m_traceControl.bStartTrace = TRUE;
	m_traceControl.bStartTimer = TRUE;
	m_traceControl.nDelay = 2;
	m_traceControl.delayTxt[0]='\0';        
	
	m_trigger.nActiveLevel = 1;
	m_trigger.level1.nSet = 11;
	m_trigger.level1.bTraceOn = TRUE;
	m_trigger.level1.bTimerOn = TRUE;
	m_trigger.level2.nSet = 0;
	m_trigger.level2.bTraceOn = TRUE;
	m_trigger.level2.bTimerOn = TRUE;
	m_trigger.bTriggerEnable = TRUE;
	m_trigger.bRun = TRUE;
	m_trigger.nTriggerSet = 1;
    Create(IDD,pParent);
}

void CTrcDlg::InitItem()
{                                            

 m_pRangBtn = new CTButton(IDS_ADV_EVT_RANG,1,0);
 m_pRangBtn->SubclassDlgItem(IDC_GRPTRC_EVT_RANGE1,this);
 m_pMultBtn = new CTButton(IDS_ADV_EVT_MULT,1,0);    
 m_pMultBtn->SubclassDlgItem(IDC_GRPTRC_EVT_MULTI1,this);
 m_pWidBtn  = new CTButton(IDS_ADV_EVT_WIDE,1,0);
 m_pWidBtn->SubclassDlgItem(IDC_GRPTRC_EVT_WILD1,this);
 m_pEvt3Btn = new CTButton(IDS_ADV_EVT_WIDE,0,0);
 m_pEvt3Btn->SubclassDlgItem(IDC_GRPTRC_EVT_EV3,this);
 m_pLevel = new CTButton(IDS_ADV_EVT_WIDE,0,0);
 m_pLevel->SubclassDlgItem(IDC_GRPTRC_TRG_LV2,this); 
 m_pTrace = new CTButton(IDS_ADV_EVT_WIDE,0,0);
 m_pTrace->SubclassDlgItem(IDC_GRPTRC_FLT_TRACE,this); 
 m_pLevelComb = new CTComboBox(NULL,NULL,NULL,NULL);
 m_pLevelComb->SubclassDlgItem(IDC_GRPTRC_TRG_EVTYPE,this);
 m_pTriggerComb = new CTComboBox(NULL,NULL,NULL,NULL);
 m_pTriggerComb->SubclassDlgItem(IDC_GRPTRC_TRG_COMBO,this);

}
                            
void CTrcDlg::DeleteItem()
{
 delete m_pRangBtn;
 delete m_pMultBtn;
 delete m_pWidBtn;                                 
 delete m_pEvt3Btn;
 delete m_pLevel;
 delete m_pLevelComb;
 delete m_pTriggerComb;
 delete m_pTrace;
}

void CTrcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTrcDlg)
	DDX_VBControl(pDX, IDC_TAB_TRACE, m_Tab);
	//}}AFX_DATA_MAP
}
                                        
void CTrcDlg::ShowEventDlg(int nCmdShow)     
{                           
        GetDlgItem(IDC_GRPTRC_EVT_EV1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_EV2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_EV3)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_WILD1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_WILD2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STATUS)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_S)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_F)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_R)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_W)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_AK)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_HIGH)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_LOW)->ShowWindow(nCmdShow);
}

void CTrcDlg::ShowTraceControlDlg(int nCmdShow)
{
        GetDlgItem(IDC_GRPTRC_TRC_STARTTRACE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_STARTTIMER)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_TRIGGER1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_PRETRG)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_CENTRG)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_POSTTRG)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_DELAY)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_COMBO)->ShowWindow(nCmdShow);
}

void CTrcDlg::ShowTriggerDlg(int nCmdShow)
{  
        GetDlgItem(IDC_GRPTRC_TRG_LEVEL)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_LV1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_LV2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_EVTYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRACE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRCON)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRCOFF)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC3)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TIMER)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TIMERON)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TIMEROFF)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRIGGER1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_ENABLE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_DISABLE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC4)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_RUN)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRIGGER2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_COMBO)->ShowWindow(nCmdShow);
}

void CTrcDlg::ShowFilterDlg(int nCmdShow)
{
        GetDlgItem(IDC_GRPTRC_FLT_DISPLAY)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_TRACE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_ADDRMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_RANGE1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_MULTI1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_WILD1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_ADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_DATAMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_RANGE2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_MULTI2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_WILD2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_DATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STATUS)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_S)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_F)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_R)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_W)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_AK)->ShowWindow(nCmdShow);
}

void CTrcDlg::EnableEventCtrl(BOOL bEnable)
{
        GetDlgItem(IDC_GRPTRC_EVT_EV1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_EV2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_EV3)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_WILD1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_WILD2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STATUS)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_S)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_F)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_R)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_W)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_AK)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(bEnable);
}                                                   
              
void CTrcDlg::EventInit()
{   
	switch (m_event.nActiveEvent)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV1);	
			Ev1Init();
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV2);	
			Ev2Init();
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV3);	
			Ev3Init();
			break;
		default:
			break;
	}
}
void CTrcDlg::Ev1Init()
{                       
	EnableEventCtrl(TRUE);                
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(FALSE);

	if (m_event.nEv1AddrMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Address");
	}                       
	else
	{
	    GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Address");
	}
	if (m_event.nEv1DataMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Data");
	}
	else
	{
	    GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Data");
	}

	switch (m_event.nEv1AddrMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
		default:
			break;
	}

	switch (m_event.nEv1DataMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
		default:
			break;
	}

	SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt);
	SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt);

	CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
	CComboBox* a=(CComboBox *)t;
	a->SetCurSel(m_event.nEv1AddrType);

	t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
	a=(CComboBox *)t;
	a->SetCurSel(m_event.nEv1DataType);
	
	SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt);
	SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt);

	SetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt);
	
	if (m_event.bEv1S) CheckDlgButton(IDC_GRPTRC_EVT_S, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_S, FALSE);

	if (m_event.bEv1F) CheckDlgButton(IDC_GRPTRC_EVT_F, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_F, FALSE);

	if (m_event.bEv1R) CheckDlgButton(IDC_GRPTRC_EVT_R, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_R, FALSE);

	if (m_event.bEv1W) CheckDlgButton(IDC_GRPTRC_EVT_W, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_W, FALSE);

	if (m_event.bEv1AK) CheckDlgButton(IDC_GRPTRC_EVT_AK, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_AK, FALSE);
	
}

void CTrcDlg::Ev2Init()
{
	EnableEventCtrl(TRUE);                
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
	GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);

	if (m_event.nEv2AddrMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Address");
	}
	else
	{
	    GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Address");
	}
	if (m_event.nEv2DataMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Data");
	}
	else
	{
	    GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Data");
	}

	switch (m_event.nEv2AddrMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
		default:
			break;
	}

	switch (m_event.nEv2DataMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
		default:
			break;
	}

	SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt);
	SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt);

	CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
	CComboBox* a=(CComboBox *)t;
	a->SetCurSel(m_event.nEv2AddrType);

	t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
	a=(CComboBox *)t;
	a->SetCurSel(m_event.nEv2DataType);
	
	SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt);
	SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt);

	if (m_event.bEv2S) CheckDlgButton(IDC_GRPTRC_EVT_S, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_S, FALSE);

	if (m_event.bEv2F) CheckDlgButton(IDC_GRPTRC_EVT_F, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_F, FALSE);

	if (m_event.bEv2R) CheckDlgButton(IDC_GRPTRC_EVT_R, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_R, FALSE);

	if (m_event.bEv2W) CheckDlgButton(IDC_GRPTRC_EVT_W, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_W, FALSE);

	if (m_event.bEv2AK) CheckDlgButton(IDC_GRPTRC_EVT_AK, TRUE);
	else CheckDlgButton(IDC_GRPTRC_EVT_AK, FALSE);
}

void CTrcDlg::Ev3Init()
{
	EnableEventCtrl(FALSE);                
	GetDlgItem(IDC_GRPTRC_EVT_EV1)->EnableWindow(TRUE);
	GetDlgItem(IDC_GRPTRC_EVT_EV2)->EnableWindow(TRUE);
	GetDlgItem(IDC_GRPTRC_EVT_EV3)->EnableWindow(TRUE);  
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(TRUE);
    GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(TRUE);
    GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(TRUE);

	switch (m_event.nEv3HL)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_HIGH);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_LOW);
			break;
		default:
			break;
	}
}                                     

void CTrcDlg::FilterInit()
{   
	switch (m_filter.nActiveChoice)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_DISPLAY);	
			m_filter.nDisplayAddrMode=3;
            m_filter.nDisplayDataMode=3;
			DisplayInit();
			//TraceInit();
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_TRACE);	
			//DisplayInit();
			m_filter.nTraceAddrMode=1;
            m_filter.nTraceDataMode=1;
			TraceInit();
			break;
		default:
			break;
	}
}                   

void CTrcDlg::DisplayInit()
{
	if (m_filter.nDisplayAddrMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(SW_HIDE);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(SW_HIDE);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Address");
	}                       
	else
	{
	    GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(SW_SHOW);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(SW_SHOW);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Address");
	}
	if (m_filter.nDisplayDataMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(SW_HIDE);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(SW_HIDE);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Data");
	}
	else
	{
	    GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(SW_SHOW);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(SW_SHOW);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Data");
	}

	switch (m_filter.nDisplayAddrMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
		default:
			break;
	}

	switch (m_filter.nDisplayDataMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
		default:
			break;
	}

	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt);
	SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.DisplayEndAddrTxt);

	CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
	CComboBox* a=(CComboBox *)t;
	a->SetCurSel(m_filter.nDisplayAddrType);

	t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
	a=(CComboBox *)t;
	a->SetCurSel(m_filter.nDisplayDataType);
	
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt);
	SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.DisplayEndDataTxt);

	if (m_filter.bDisplayS) CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);

	if (m_filter.bDisplayF) CheckDlgButton(IDC_GRPTRC_FLT_F, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_F, FALSE);

	if (m_filter.bDisplayR) CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);

	if (m_filter.bDisplayW) CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);

	if (m_filter.bDisplayAK) CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);
}

void CTrcDlg::TraceInit()
{
	if (m_filter.nTraceAddrMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Address");
	}                       
	else
	{
	    GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Address");
	}
	if (m_filter.nTraceDataMode!=1)
	{
	    GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(FALSE);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Data");
	}
	else
	{
	    GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(TRUE);
    	GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Data");
	}

	switch (m_filter.nTraceAddrMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
		default:
			break;
	}

	switch (m_filter.nTraceDataMode)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
		default:
			break;
	}

	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt);
	SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.TraceEndAddrTxt);

	CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
	CComboBox* a=(CComboBox *)t;
	a->SetCurSel(m_filter.nTraceAddrType);

	t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
	a=(CComboBox *)t;
	a->SetCurSel(m_filter.nTraceDataType);
	
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt);
	SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.TraceEndDataTxt);

	if (m_filter.bTraceS) CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);

	if (m_filter.bTraceF) CheckDlgButton(IDC_GRPTRC_FLT_F, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_F, FALSE);

	if (m_filter.bTraceR) CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);

	if (m_filter.bTraceW) CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);

	if (m_filter.bTraceAK) CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
	else CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);
}
                                                  
void CTrcDlg::TraceControlInit()
{                                             
	if (m_traceControl.bStartTrace) CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, TRUE);
	else CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, FALSE);
	
	if (m_traceControl.bStartTimer) CheckDlgButton(IDC_GRPTRC_TRC_STARTTIMER, TRUE);
	else CheckDlgButton(IDC_GRPTRC_TRC_STARTTIMER, FALSE);
	
	switch (m_traceControl.nDelay)
	{
		case 1:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_PRETRG);
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_CENTRG);
			break;
		case 3:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_POSTTRG);
			break;
		case 4:
			CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_DELAY);
			break;
		default:
			break;
	}
	
	if (m_traceControl.nDelay==4) 
	{
		GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(TRUE);
		//GetDlgItem(IDC_GRPTRC_TRC_COMBO)->SetFocus();
		SetDlgItemText(IDC_GRPTRC_TRC_COMBO,m_traceControl.delayTxt);
	}
	else GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
}                          

void CTrcDlg::TriggerInit()
{           
	CComboBox* a;
	switch (m_trigger.nActiveLevel)
	{
		case 1:               
			CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV1);
			
			a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
			a->SetCurSel(m_trigger.level1.nSet);
			
			if (m_trigger.level1.bTraceOn)
				CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
			else
				CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
			
			if (m_trigger.level1.bTimerOn)
				CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
			else
				CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
			
			break;
		case 2:
			CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV2);
			
			a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
			a->SetCurSel(m_trigger.level2.nSet);
			
			if (m_trigger.level2.bTraceOn)
				CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
			else
				CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
			
			if (m_trigger.level2.bTimerOn)
				CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
			else
				CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
			
			break;
		default:
			break;
	}                           
	
	if (m_trigger.bTriggerEnable)
		CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_ENABLE);
	else
		CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_DISABLE);
	
	CheckDlgButton(IDC_GRPTRC_TRG_RUN, m_trigger.bRun);

	a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
	a->SetCurSel(m_trigger.nTriggerSet);
}
                                                  
                                        
BEGIN_MESSAGE_MAP(CTrcDlg, CDialog)
	//{{AFX_MSG_MAP(CTrcDlg)
	ON_WM_NCLBUTTONDOWN()
	ON_BN_CLICKED(IDC_GRPTRC_EVT_EV1, OnGrptrcEvtEv1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_EV2, OnGrptrcEvtEv2)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_EV3, OnGrptrcEvtEv3)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_DISPLAY, OnGrptrcFltDisplay)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_TRACE, OnGrptrcFltTrace)
//	ON_VBXEVENT(VBN_TABPAGESHOWN, IDC_TAB_TRACE, OnTabpageshownTabTrace)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI1, OnGrptrcEvtMulti1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI2, OnGrptrcEvtMulti2)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD1, OnGrptrcEvtWild1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD2, OnGrptrcEvtWild2)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI1, OnGrptrcFltMulti1)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI2, OnGrptrcFltMulti2)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE1, OnGrptrcFltRange1)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE2, OnGrptrcFltRange2)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD1, OnGrptrcFltWild1)
	ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD2, OnGrptrcFltWild2)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE1, OnGrptrcEvtRange1)
	ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE2, OnGrptrcEvtRange2)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcDlg message handlers

BOOL CTrcDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	InitItem();
	// TODO: Add extra initialization here

    FilterLMClk(1,GetSafeHwnd());
	switch (m_activeTab)
	{
		case 0:                   
			m_Tab->SetNumProperty("ActiveTab", 0);
			ShowEventDlg(SW_SHOW);                
			EventInit();
			break;
			
		case 1:
			m_Tab->SetNumProperty("ActiveTab", 1);
			ShowTraceControlDlg(SW_SHOW);
			TraceControlInit();
			break;
		case 2:
			m_Tab->SetNumProperty("ActiveTab", 2);
			ShowTriggerDlg(SW_SHOW);
			TriggerInit();
			break;
		case 3:
			m_Tab->SetNumProperty("ActiveTab", 3);
			ShowFilterDlg(SW_SHOW);
			FilterInit();
			break;

		default:
			break;
	}
   if(g_bAuto)
     {
       AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO, 10000,NULL);
       g_uTick=10000;
     }  
	
   g_mbCanDoNext=1;   

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcDlg::OnTabpageshownTabTrace(UINT, int, CWnd*, LPVOID)
{
	// TODO: Add your VBX event notification handler code here 
	//m_Tab =(CVBControl *)GetDlgItem(IDC_SRCTAB);
    
	if(m_Tab)	
	   m_Tab->SetNumProperty("ActiveTab",m_activeTab);   
	   
}                          

void CTrcDlg::SetTab(int nTabToActivate)
{           
    if(m_Tab)	
	   m_Tab->SetNumProperty("ActiveTab",nTabToActivate);   

    switch (m_activeTab)
    {
    	case 0:
    		ShowEventDlg(SW_HIDE);
    		break;
    	case 1:
    		ShowTraceControlDlg(SW_HIDE);
    		break;
    	case 2:
    		ShowTriggerDlg(SW_HIDE);
    		break;
    	case 3:
    		ShowFilterDlg(SW_HIDE);
    		break;
    	default:
    		break;
    } 

    switch (nTabToActivate)
    {
    	case 0:
    		ShowEventDlg(SW_SHOW);
    		EventInit();
    		break;
    	case 1:
    		ShowTraceControlDlg(SW_SHOW);
    		TraceControlInit();
    		break;
    	case 2:
    		ShowTriggerDlg(SW_SHOW);
    		TriggerInit();
    		break;
    	case 3:
    		ShowFilterDlg(SW_SHOW);  
    		    
    		FilterInit();
    		break;
    	default:
    		break;
    }                            
    
    m_activeTab = int(nTabToActivate);
	
}



void CTrcDlg::OnNcLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
//	CDialog::OnLButtonDown(nFlags, point);
}

void CTrcDlg::OnGrptrcEvtEv1()
{
	// TODO: Add your control notification handler code here
	m_event.nActiveEvent = 1;                            
	
	Ev1Init();

}

void CTrcDlg::OnGrptrcEvtEv2()
{
	// TODO: Add your control notification handler code here
	m_event.nActiveEvent = 2;
	
	Ev2Init();
	
}

void CTrcDlg::OnGrptrcEvtEv3()
{
	// TODO: Add your control notification handler code here
	m_event.nActiveEvent = 3;
	
	Ev3Init();
	                          }

void CTrcDlg::OnGrptrcFltDisplay()
{
	// TODO: Add your control notification handler code here
	m_filter.nActiveChoice = 1;
	
	FilterInit();

}

void CTrcDlg::OnGrptrcFltTrace()
{
	// TODO: Add your control notification handler code here
	m_filter.nActiveChoice = 2;
	
	FilterInit();

}


void CTrcDlg::OnGrptrcEvtMulti1()
{
	// TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
    	case 1:   
    		m_event.nEv1AddrMode = 2;
    		Ev1Init();
    		break;
    	case 2:
    		m_event.nEv2AddrMode = 2;
    		Ev2Init();
    		break;
    	default:
    		break;
    }
	SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,"");
	SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,"");
	
}

void CTrcDlg::OnGrptrcEvtMulti2()
{
	// TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
    	case 1:   
    		m_event.nEv1DataMode = 2;
    		Ev1Init();
    		break;
    	case 2:
    		m_event.nEv2DataMode = 2;
    		Ev2Init();
    		break;
    	default:
    		break;
    }
	SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,"");
	SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,"");
	
}

void CTrcDlg::OnGrptrcEvtWild1()
{
	// TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
    	case 1:   
    		m_event.nEv1AddrMode = 3;
    		Ev1Init();
    		break;
    	case 2:
    		m_event.nEv2AddrMode = 3;
    		Ev2Init();
    		break;
    	default:
    		break;
    }
	SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,"");
	SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,"");
	
}

void CTrcDlg::OnGrptrcEvtWild2()
{
	// TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
    	case 1:   
    		m_event.nEv1DataMode = 3;
    		Ev1Init();
    		break;
    	case 2:
    		m_event.nEv2DataMode = 3;
    		Ev2Init();
    		break;
    	default:
    		break;
    }
	SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,"");
	SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,"");
	
}

void CTrcDlg::OnCancel()
{
	// TODO: Add your control notification handler code here
	DeleteItem();
	DestroyWindow();
}                        

void CTrcDlg::OnOk()
{
	// TODO: Add your control notification handler code here
	DeleteItem();
	DestroyWindow();
}                        

/*-------------------------------------------------------*/
/*                Address range                          */
/*-------------------------------------------------------*/
void CTrcDlg::AdrRang(BOOL x)
{
 m_pRangBtn->SetRadioButton(x);
// m_pRangBtn->SetRadioMsg();
}
void CTrcDlg::AdrRang()
{
 m_pRangBtn->SetRadioMsg(1,this,250,130);  
 SetFocus();
}
/*-------------------------------------------------------*/
/*                Address Multiple                       */
/*-------------------------------------------------------*/
void CTrcDlg::AdrMult(BOOL x)
{
 m_pMultBtn->SetRadioButton(x);
// m_pRangBtn->SetRadioMsg();
}
void CTrcDlg::AdrMult()
{
 m_pMultBtn->SetRadioMsg(1,this,250,130);  
 SetFocus();
}
/*-------------------------------------------------------*/
/*                Address WideCard                       */
/*-------------------------------------------------------*/
void CTrcDlg::AdrWide(BOOL x)
{
 m_pWidBtn->SetRadioButton(x);
// m_pRangBtn->SetRadioMsg();
}
void CTrcDlg::AdrWide()
{
 m_pWidBtn->SetRadioMsg(1,this,250,130);  
 SetFocus();
}             
/*-------------------------------------------------------*/
/*                Event 1 -3                             */
/*-------------------------------------------------------*/
void CTrcDlg::event3()
{
  m_pEvt3Btn->SetRadioButton(0,0,55,8);
}
/*-------------------------------------------------------*/
/*                Select tab trace control               */
/*-------------------------------------------------------*/
void CTrcDlg::SelTrace()
{
 CPoint pointDes;
 CPoint pointSrc;
 
 pointDes.x=150;
 pointDes.y=5; 
 ClientToScreen(&pointDes);
 GetCursorPos(&pointSrc);

 ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->
 MoveCursor(pointDes,pointSrc,1,30,4);
 
 SetTab(1);
}
 
/*-------------------------------------------------------*/
/*                Select tab trace control               */
/*-------------------------------------------------------*/
void CTrcDlg::SelTrigger()
{
 CPoint pointDes;
 CPoint pointSrc;
 
 pointDes.x=250;
 pointDes.y=5; 
 ClientToScreen(&pointDes);
 GetCursorPos(&pointSrc);

 ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->
 MoveCursor(pointDes,pointSrc,1,50,8);
 
 SetTab(2);

}

/*-------------------------------------------------------*/
/*            Trigger - level                            */
/*-------------------------------------------------------*/
void CTrcDlg::SetLevel()
{
 m_pLevel->SetRadioButton(0,0,55,8);
}

/*-------------------------------------------------------*/
/*            Trigger - level - combo                    */
/*-------------------------------------------------------*/
void CTrcDlg::SelLogic(BOOL bLevel/*=1*/)
{
 CRect rect;
 CTComboBox *pCombo;
                     
 if(bLevel)
   pCombo=m_pLevelComb;
 else
   pCombo=m_pTriggerComb;                  
   
 pCombo->GetWindowRect(&rect);

 CPoint pointDes;
 CPoint pointSrc;
 
 pointDes.x=rect.right-5;
 pointDes.y=rect.top+5; 
// ClientToScreen(&pointDes);
 GetCursorPos(&pointSrc);

 ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->
 MoveCursor(pointDes,pointSrc,1,55,8);
 
 Delay(60);    
 
 pCombo->ShowDropDown(TRUE); 
 
 for(int i=0;pCombo->SetCurSel(i)!=CB_ERR;i++)
    { 
     Delay(1000,TRUE);
    }
 Delay(1000,TRUE);
 pCombo->ShowDropDown(FALSE); 
    
}

/*-------------------------------------------------------*/
/*             Select Filter                             */
/*-------------------------------------------------------*/
void CTrcDlg::SelFilter()  
{
 CPoint pointDes;
 CPoint pointSrc;
 
 pointDes.x=350;
 pointDes.y=5; 
 ClientToScreen(&pointDes);
 GetCursorPos(&pointSrc);

 ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->
 MoveCursor(pointDes,pointSrc,1,55,8);
 
 SetTab(3);
}

void CTrcDlg::OnGrptrcFltMulti1()
{
	// TODO: Add your control notification handler code here
	switch (m_filter.nActiveChoice)
	{
		case 1:
			m_filter.nDisplayAddrMode = 2;
			break;
		case 2:
			m_filter.nTraceAddrMode = 2;
			break;
		default:
			break;
	}
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,"");
	SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,"");
	
}

void CTrcDlg::OnGrptrcFltMulti2()
{
	// TODO: Add your control notification handler code here
	switch (m_filter.nActiveChoice)
	{
		case 1:
			m_filter.nDisplayDataMode = 2;
			break;
		case 2:
			m_filter.nTraceDataMode = 2;
			break;
		default:
			break;
	}
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,"");
	SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,"");
	
	
}

void CTrcDlg::OnGrptrcFltRange1()
{
	// TODO: Add your control notification handler code here
	switch (m_filter.nActiveChoice)
	{
		case 1:
			m_filter.nDisplayAddrMode = 1;
			break;
		case 2:
			m_filter.nTraceAddrMode = 1;
			break;
		default:
			break;
	}
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,"");
	SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,"");
	
	
}

void CTrcDlg::OnGrptrcFltRange2()
{
	// TODO: Add your control notification handler code here
	switch (m_filter.nActiveChoice)
	{
		case 1:
			m_filter.nDisplayDataMode = 1;
			break;
		case 2:
			m_filter.nTraceDataMode = 1;
			break;
		default:
			break;
	}
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,"");
	SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,"");
	
}

void CTrcDlg::OnGrptrcFltWild1()
{
	// TODO: Add your control notification handler code here
	switch (m_filter.nActiveChoice)
	{
		case 1:
			m_filter.nDisplayAddrMode = 3;
			break;
		case 2:
			m_filter.nTraceAddrMode = 3;
			break;
		default:
			break;
	}
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,"");
	SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,"");
	
}

void CTrcDlg::OnGrptrcFltWild2()
{
	// TODO: Add your control notification handler code here
	switch (m_filter.nActiveChoice)
	{
		case 1:
			m_filter.nDisplayDataMode = 3;
			break;
		case 2:
			m_filter.nTraceDataMode = 3;
			break;
		default:
			break;
	}
	FilterInit();
	SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,"");
	SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,"");
}

void CTrcDlg::OnGrptrcEvtRange1()
{
	// TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
    	case 1:   
    		m_event.nEv1AddrMode = 1;
    		Ev1Init();
    		break;
    	case 2:
    		m_event.nEv2AddrMode = 1;
    		Ev2Init();
    		break;
    	default:
    		break;
    }
	SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,"");
	SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,"");
}

void CTrcDlg::OnGrptrcEvtRange2()
{
	// TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
    	case 1:   
    		m_event.nEv1DataMode = 1;
    		Ev1Init();
    		break;
    	case 2:
    		m_event.nEv2DataMode = 1;
    		Ev2Init();
    		break;
    	default:
    		break;
    }
	SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,"");
	SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,"");
}

/*-------------------------------------------------------*/
/*              Filter Action                            */
/*-------------------------------------------------------*/
void CTrcDlg::SetTrace()
{
  m_pTrace->SetRadioButton(0,0);
}                                   

BOOL CTrcDlg::PreTranslateMessage(MSG *pMsg)
{    
 CMainFrame *pWnd=(CMainFrame *)(AfxGetApp()->m_pMainWnd);
 if((pWnd->GetCase()==ID_CASE_ADVANCE)&&
    (pMsg->message==WM_LBUTTONDOWN||
     pMsg->message==WM_LBUTTONDBLCLK))
   {
    pWnd->AdvanceRestoreBk();
   }      
 return CDialog::PreTranslateMessage(pMsg);  
}
void CTrcDlg::OnDestroy()
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	FilterLMClk(0,0);
	
}
