// HWTIP.H : Contains HWTIP.DLL implementation and initialization
//             code.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1995 HW FOX WORKSHOP
// All rights reserved.
//
/////////////////////////////////////////////////////////////////////
#ifndef _HW_TIP_TOOLBAR
#define _HW_TIP_TOOLBAR
#include "resource.h"
class CTipStatic : public CButton
{
// Construction
public:
	CTipStatic(CWnd *pParent);

// Attributes   
public:   
   void GetContent(LPSTR lp){lstrcpy(szText,lp);};
private:
   char szText[256];
   CBitmap *m_pBkmap;
   CFont   m_Font;
   CBrush  m_Brush;
// Operations
public:

// Implementation
public:
	virtual ~CTipStatic();

protected:
	// Generated message map functions
	//{{AFX_MSG(CTStstic)  
	virtual void OnCancel(){};
	afx_msg void OnPaint();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CTipToolBar window

class CTipToolBar : public CToolBar
{
// Construction
public:
	CTipToolBar();

// Attributes
private:
   CTipStatic *m_pTip; 
   CStatusBar *m_pStatusBar;
   UINT far   *m_pBtnID;
   UINT far   *m_pBtnEx;
   int        m_nCount; 
   BOOL       bCapture; 
   BOOL       m_bActive; 
   BOOL       m_bKey;
   BOOL       m_bOpenWnd;   
   BOOL       m_bTipShow;
   int        m_nTimeCount;  
   UINT       m_uMessage;
   HGLOBAL    hMem;      
   POINT      m_Point;
   UINT       m_nIdx;
   UINT       m_BtnID;
   UINT       m_OldID;  
   enum { m_TimerID = 10 };
     
public:

virtual BOOL Create(      CWnd *pParent,          //set with mainframe point
                    CStatusBar *pStatusBar=NULL,  //set, if use status bar
                           int nTotalToolID=0,
                          UINT uReserve=NULL); 

virtual BOOL SetButtons(UINT far * lpArrayID,      //every button id include
                                                   //separator.
                        int        nIDCount,       //how many buttons
                        UINT far * lpArrayEx=NULL);//each button 
                                                   //tip contents id
virtual void SetButtonInfo(int nIndex,
                           UINT nID,
                           UINT nStyle,
                           int  iImage,
                           UINT nExID=0);            // for tip card explaination
                                                   
void UpdateBtnInfo(UINT far * lpArrayID,           //every button id include
                                                   //separator.
                   int        nIDCount,            //how many buttons
                   UINT far * lpArrayEx);          //each button 
                                                   //tip content id

// Operations
private:                  
void ShowTipCard(UINT ID,POINT point);
void ShowTipCard(POINT point,UINT ID);
void DrawContent(LPSTR lpText,POINT point);
void ReleaseTip();
// Implementation
public:
	virtual ~CTipToolBar();

protected:
	// Generated message map functions
	//{{AFX_MSG(CTipToolBar)
    virtual BOOL PreTranslateMessage(MSG *PMsg);
	afx_msg void OnKeyDown(UINT nC,UINT nR,UINT nF);
	afx_msg void OnKeyUp(UINT nC,UINT nR,UINT nF);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg int  OnMouseActivate(CWnd * pWnd,UINT nH, UINT nM);
	afx_msg void OnTimer(UINT);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif
/////////////////////////////////////////////////////////////////////////////
