// trcwnd.cpp : implementation file
//

#include "stdafx.h"
#include "tutorial.h"
#include "trcwnd.h"
#include "mainFrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAdvanceWnd

CAdvanceWnd::CAdvanceWnd(LPSTR lpLIB,LPSTR lpBit)
{       
 m_hBit=0;              
 if(int(m_hInst = ::LoadLibrary(lpLIB))<32)
    {
     AfxMessageBox("Can not find resource.dll library",MB_OK | MB_ICONEXCLAMATION);
     return ;
    }        
 if(!LoadMsg(lpBit, 4, 23, FALSE))
    return;
}

CAdvanceWnd::CAdvanceWnd(HINSTANCE hInst,LPSTR lpBit)
{       
 m_hBit=0;              
 if(int(m_hInst = hInst)<32)
    {
     AfxMessageBox("Can not find resource.dll library",MB_OK | MB_ICONEXCLAMATION);
     return ;
    }        
 if(!LoadMsg(lpBit, 3, 23, FALSE))
    return;
}

CAdvanceWnd::~CAdvanceWnd()
{
}

void CAdvanceWnd::CreateTrace(CRect &rect)
{
  //((CMainFrame *)(AfxGetApp()->m_pMainWnd))->ClientToScreen(&rect);
  CreateEx(NULL,
           AfxRegisterWndClass(0),
           "Trace",
           /*WS_POPUPWINDOW*/WS_CHILDWINDOW|WS_CAPTION|WS_THICKFRAME|
           WS_SYSMENU|WS_MAXIMIZEBOX|WS_MINIMIZEBOX|
           WS_VISIBLE|WS_HSCROLL|WS_VSCROLL,
           rect.left,rect.top,rect.Width(),rect.Height(),
           (AfxGetApp()->m_pMainWnd->GetSafeHwnd()),NULL,NULL);

}
BOOL CAdvanceWnd::LoadMsg(LPSTR lpMsg,
                      int   orgx/*=3*/, 
                      int   orgy/*=23*/,
                      BOOL  bPaint/*=1*/)
{ 
  m_nOrgx=orgx;
  m_nOrgy=orgy; 
   
  if(int(m_hInst)<32)
     return 0;
  if(m_hBit)
     ::DeleteObject(m_hBit);
  m_hBit=::LoadBitmap(m_hInst,lpMsg);
  if(m_hBit==NULL)
     return 0;
     
  if(bPaint)
    {
     Invalidate();
     UpdateWindow();
    }
  return 1;  
}

BOOL CAdvanceWnd::PreTranslateMessage(MSG *pMsg)
{
 if(pMsg->message==WM_NCLBUTTONDOWN ||
    pMsg->message==WM_NCLBUTTONUP   ||
    pMsg->message==WM_NCLBUTTONDBLCLK||
    pMsg->message==WM_NCRBUTTONDOWN ||
    pMsg->message==WM_NCRBUTTONUP   ||
    pMsg->message==WM_NCRBUTTONDBLCLK)
    
 return 1;
 
 return CWnd::PreTranslateMessage(pMsg);
} 

void CAdvanceWnd::SetArrow(int orgx,int orgy)
{
 POINT  pArrow[]={0,0, 15,15, 15,9, 30,9, 30,-9, 15,-9, 15,-15};                 
 CPen   pen(PS_SOLID,1,RGB(128,0,0));
 CBrush brush(RGB(128,0,0)); 
 CRect  rect;
 GetClientRect(&rect);
 CClientDC dc(this);
 dc.SetMapMode(MM_ISOTROPIC);
 dc.SetWindowOrg(0,orgy);
 dc.SetWindowExt(rect.Width(),orgy);
 dc.SetViewportExt(rect.Width(),-orgy);
 dc.SetViewportOrg(orgx,orgy);
 dc.SetBkMode(TRANSPARENT);
 dc.SelectObject(&pen);
 dc.SelectObject(&brush);
 dc.Polygon(pArrow,sizeof(pArrow)/sizeof(POINT));
 
}

BEGIN_MESSAGE_MAP(CAdvanceWnd, CWnd)
	//{{AFX_MSG_MAP(CAdvanceWnd)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CAdvanceWnd message handlers


void CAdvanceWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	CDC  SrcDC;
	// TODO: Add your message handler code here
	CRect rect;
	BITMAP bm;
	GetClientRect(&rect);
	CBitmap *pBitmap=CBitmap::FromHandle(m_hBit);
	if(!pBitmap) 
	    return;
	pBitmap->GetObject(sizeof(BITMAP),&bm);
	SrcDC.CreateCompatibleDC(&dc);
	SrcDC.SelectObject(pBitmap);
	dc.BitBlt(0,0,bm.bmWidth-m_nOrgx,bm.bmHeight-m_nOrgy,
	          &SrcDC,m_nOrgx,m_nOrgy,SRCCOPY);
	SrcDC.DeleteDC();
}


void CAdvanceWnd::OnDestroy()
{
	CWnd::OnDestroy();
	
	// TODO: Add your message handler code here
  if(m_hBit)
    {::DeleteObject(m_hBit);
     m_hBit=0;}
  
  if(m_hInst!=(((CMainFrame *)AfxGetApp()->m_pMainWnd)->m_hFlookInst))   
  if(int(m_hInst)>=32) 
    {FreeLibrary(m_hInst);
     m_hInst=0;}
}

