/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/AC.CPP   1.5.1.0.1.0   11 Nov 1996 12:59:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/AC.CPP  $
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 12:59:52   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:19:30   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:31:00   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 09:58:04   ZJRD
** No change.
** 
**    Rev 1.5.1.1   28 Aug 1996 15:48:04   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.5.1.0   12 Aug 1996 10:52:38   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:37:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// ac.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "ac.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void ACTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nRegBank = " << m_nRegBank << "\n";
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_nOptimize = " << m_nOptimize << "\n";
    dc << "m_fStrInRom = " << m_fStrInRom << "\n";
    dc << "m_fUChar = " << m_fUChar << "\n";
    dc << "m_fNoWarn = " << m_fNoWarn << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void ACTool::SetDefault(void)
{
    m_nRegBank = 0;     // 0-3
    m_nMemoryModel = 1; // 0 - 1 = s,l
    m_nOptimize = 0;    // 0 - 3
    m_fStrInRom = TRUE;
    m_fUChar = FALSE;
    m_fNoWarn = FALSE;
    m_strMore = "-err -t -g -s -C51";
    m_strPath = "c:\\cc51\\bin";
    m_incPath = "c:\\cc51\\include";
}

BOOL ACTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 6;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nRegBank = ach[0];
    m_nMemoryModel = ach[1];
    m_nOptimize = ach[2];
    m_fStrInRom = ach[3];
    m_fUChar = ach[4];
    m_fNoWarn = ach[5];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  

    return TRUE;
}                 

BOOL ACTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 6;

    char ach[nCnt];
    
    ach[0] = m_nRegBank;
    ach[1] = m_nMemoryModel;
    ach[2] = m_nOptimize;
    ach[3] = m_fStrInRom;
    ach[4] = m_fUChar;
    ach[5] = m_fNoWarn;
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
     
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    wLen = m_incPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen); 
    

    return TRUE;
}   
                            
static char * ar1[4] = { "-b0 ", "-b1 ", "-b2 ", "-b3 " };
static char * ar2[4] = { "-Ms ", "-Ml " };
static char * ar3[4] = { "-O0 ", "-O1 ", "-O2 ", "-O3 " };

CString ACTool::GetOption(void) const
{
    CString str = "";
    
    str = ar1[m_nRegBank];
    str += ar2[m_nMemoryModel];
    str += ar3[m_nOptimize];
    
    if(m_fStrInRom)
        str += "-S ";
        
    if(m_fUChar)
        str += "-u ";
        
    if(m_fNoWarn)
        str += "-w ";
        
    str += m_strMore;
    str += " ";
    
    return str;     
}

