/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/AL.CPP   1.5.1.0.1.0   11 Nov 1996 13:00:36   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/AL.CPP  $
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 13:00:36   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:21:28   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:32:56   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 09:59:58   ZJRD
** No change.
** 
**    Rev 1.5.1.1   28 Aug 1996 15:49:46   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.5.1.0   12 Aug 1996 10:53:58   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:37:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// al.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "al.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void ALTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_fCase = " << m_fCase << "\n";
    dc << "m_fLineDebug = " << m_fLineDebug << "\n";
    dc << "m_fSymbolDebug = " << m_fSymbolDebug << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void ALTool::SetDefault(void)
{                                                    
    m_fCase = TRUE;
    m_fLineDebug = TRUE;
    m_fSymbolDebug = TRUE;
    m_strMore = " ";
    m_strPath = "c:\\cc51\\bin";
}

BOOL ALTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fCase = ach[0];
    m_fLineDebug = ach[1];
    m_fSymbolDebug = ach[2];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen); 
     
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}                 

BOOL ALTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char ach[nCnt];
    
    ach[0] = m_fCase;
    ach[1] = m_fLineDebug;
    ach[2] = m_fSymbolDebug;
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}

CString ALTool::GetOption(void)
{
    CString str = " ";

    if(!m_fCase)    
        str += "NOCA ";
        
    if(!m_fLineDebug)
        str += "NODL ";
        
    if(!m_fSymbolDebug)
        str += "NODS ";

    str += m_strMore;
    str += " ";
    
    return str;
}

