/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ALIAS.H__   1.6.1.0.1.0   11 Nov 1996 12:58:18   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ALIAS.H__  $
** 
**    Rev 1.6.1.0.1.0   11 Nov 1996 12:58:18   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.6.1.4   09 Sep 1996 13:15:38   ZJRD
** No change.
** 
**    Rev 1.6.1.3   05 Sep 1996 11:27:10   ZJRD
** No change.
** 
**    Rev 1.6.1.2   02 Sep 1996 09:54:16   ZJRD
** No change.
** 
**    Rev 1.6.1.1   28 Aug 1996 15:48:30   ZJRD
** No change.
** 
**    Rev 1.6.1.0   12 Aug 1996 10:53:00   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.6   11 Jun 1996 10:27:36   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.4   05 Jun 1996 14:56:14   ZJRD
** No change.
** 
**    Rev 1.3   29 May 1996 09:36:18   ZJRD
** No change.
** 
**    Rev 1.2   16 May 1996 09:08:58   ZJRD
** No change.
** 
**    Rev 1.1   10 May 1996 09:08:36   ZJRD
** No change.
** 
**    Rev 1.0   02 May 1996 10:26:12   ZJRD
** Initial revision.
** 
****************************************************************************/

#ifndef _alias_h_
#define _alias_h_

// base class of CCommand class and CAlias class         
class CCommandRoot : public CObject
{
	DECLARE_SERIAL(CCommandRoot)
public:	
	CString strCommandName; // command name
	BYTE	bMinKeyword;  // minimize number of characters in abbreviate name                          
	enum {
		NOT_EXIST = -1,
		EXIST = -2
	};
public:
	CCommandRoot();
	CCommandRoot(const char* pszName, BYTE bNum);
	CCommandRoot(const CCommandRoot& commandroot);
	virtual ~CCommandRoot();
	const CCommandRoot& operator=(const CCommandRoot& commandroot);
	BOOL operator==(const CCommandRoot& c2) const;
	int  InCommand(const char* pszAbbr);
	
	virtual void ShowCommand();
	      
	void Serialize(CArchive& ar);                        

};
    
// items in the array are sorted by strCommandName.       
// array to store command, alias or parameter
class CCommandArray : public CObArray
{      
	DECLARE_SERIAL(CCommandArray)	
private:
	int nCurIndex; // store current index
	int LastLess(int nFrom, int nTo, const char* pszCommand);
	int FirstMatch(int nFrom, int nTo, const char* pszAbbr);
	int LastMatch(int nFrom, int nTo, const char* pszAbbr);

public:	                 
	CCommandArray();
	virtual ~CCommandArray();
	
	int  Expand(const char* pszAbbr);
	int  InsertIndex(const char* pszCommand); 
	int  CommandExist(const char* pszCommand);   
	int  AbbrCommandExist(const char* pszAbbr); 
	BOOL MatchNum(int& nFrom, int& nTo,const char* pszAbbr);
	void ShowCommand();
		
	int  Add(CCommandRoot* newElement); 
	
	CCommandRoot* operator[](int nIndex) const; 
};	                
	                
// class to support command 
class CCommand : public CCommandRoot
{                                                                
	DECLARE_SERIAL(CCommand)
private:
	void Init(){ arrArgv.SetSize(0); };
public:
	CString  strHints; 
	CCommandArray arrArgv; // record the parameters data in this command.
public:
	CCommand();
	CCommand(const char* pszName, BYTE bNum,const char* pszHints);
	CCommand(const CCommand& command);
	virtual ~CCommand();
	const CCommand& operator=(const CCommand& command);
	virtual void ShowCommand();
	void CompleteHints(char* pszHints);
	      
	void Serialize(CArchive& ar);                        	
};	
	
// class to support alias.
class CAlias : public CCommandRoot
{                               
	DECLARE_SERIAL(CAlias)
public:              
	WORD wCommandIndex; // index of command in ComArray of CCommandSet.
public:
	CAlias();
	CAlias(const char* pszName, BYTE bNum,WORD wIndex);
	CAlias(const CAlias& alias);
	virtual ~CAlias();
	const CAlias& operator=(const CAlias& alias);
	virtual void ShowCommand();
	      
	void Serialize(CArchive& ar);                        	
};	                             

// class containing command array and alias array.
class CCommandSet { 
private:
	BOOL	GetEventName(CString& EventName,const char* pszCommand);
	
protected:
	CCommandArray  ComArray; // old command array.
	CCommandArray  HiddenComArray; // hiden command array.
	CCommandArray  AliasArray; // alias array added by user.   
	
public:                            
	CCommandSet();
	~CCommandSet();

	enum { 
		COMMAND,
		ALIAS,
		NO_COMMAND = -1
	};
	
	void AliasCmd(int m_nArgc, char* m_pszArgv[]);  
	void HelpCmd(int m_nArgc, char* m_pszArgv[]);
	int  GetCommandId(const char* pszCommand);   
	int  GetTotalCommandId(const char* pszCommand);
	BOOL SearchCommand(const char* pszCommand, int &nArgc, char* pszArgv[]);
	BOOL ExpandCommand(const char* pszCommand, char* pszExpand, char* pszHints);
	BOOL ExpandCommandSub(const char* pszCommand, char* pszExpand, char* pszHints);
	BOOL ExpandParameter(const char* pszCommand, const char* pszParameter, char* pszExpand);
	
	// special for Event 1|2|3
	BOOL GetEventHints(const char* pszCommand, char* pszHints);
	BOOL ExpandEventPara(const char* pszCommand, const char* pszParameter, char* pszExpand);
};
	

inline BOOL CCommandRoot::operator==(const CCommandRoot& c2) const
{
	return (strCommandName.CompareNoCase(c2.strCommandName) == 0 );
}

	
#endif

/*----------------------------end of file-------------------------*/
	