/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BC.CPP   1.4.1.0.1.0   11 Nov 1996 12:58:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BC.CPP  $
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 12:58:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:16:00   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:27:32   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 09:54:38   ZJRD
** No change.
** 
**    Rev 1.4.1.1   28 Aug 1996 15:48:52   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.4.1.0   12 Aug 1996 10:53:12   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.1   29 May 1996 09:36:32   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// bc.cpp
//
// Michael Long
//                                                                           
// 5/13/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "bc.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BCTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_nOptimize = " << m_nOptimize << "\n";
    dc << "m_fStrInVariable = " << m_fStrInVariable << "\n";
    dc << "m_fSChar = " << m_fSChar << "\n";
    dc << "m_fNoWarn = " << m_fNoWarn << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n"; 
     dc << "m_incPath = " << m_incPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BCTool::SetDefault(void)
{
    m_nMemoryModel = 4; 
    m_nOptimize = 0;    
    m_fStrInVariable = TRUE;
    m_fSChar = FALSE;
    m_fNoWarn = FALSE;
    m_strMore = " -r2 -b ";
    m_strPath = "c:\\icc8051\\exe"; 
    m_incPath = "c:\\icc8051\\inc";
    
}

BOOL BCTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    
    char bch[nCnt];
    
    if(fread(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nMemoryModel = bch[0];
    m_nOptimize = bch[1];   
    m_fNoWarn = bch[2];
    m_fStrInVariable = bch[3];
    m_fSChar = bch[4];
        
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
   
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

     m_strPath.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

     m_incPath.ReleaseBuffer(wLen);  

    return TRUE;
}                 

BOOL BCTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char bch[nCnt];
    
    bch[0] = m_nMemoryModel;
    bch[1] = m_nOptimize;
    bch[2] = m_fNoWarn;
    bch[3] = m_fStrInVariable;
    bch[4] = m_fSChar;
      
    if(fwrite(bch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
      wLen = m_incPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  

    return TRUE;
}   
                            
static char * br1[6] = { "-mt ", "-ms ", "-mc ", "-mm ","-ml ","-mb " };
static char * br2[4] = { " " ,"-s0 ", "-z0 " };

CString BCTool::GetOption(void) const
{
    CString str = " ";
    
    str += br1[m_nMemoryModel];
    str += br2[m_nOptimize];
    
    if(m_fStrInVariable)
        str += "-y ";
        
    if(m_fSChar)
        str += "-c ";
        
    if(m_fNoWarn)
        str += "-w ";
        
    str += m_strMore;
    str += " ";
    
    return str;     
}

