
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BMEMWND.CPP   1.7.1.0.1.0   11 Nov 1996 12:58:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BMEMWND.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:56   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:00   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:32   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:36   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:22   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:53:38   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.6.1.0   19 Jul 1996 09:52:00   ZJRD
** EasyPack/SLD Version 1.20b
** 
**    Rev 1.8   20 Jun 1996 09:25:54   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:20:32   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:30:14   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:07:30   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:10:28   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:04   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:46   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:37:50   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:52   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:36   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:20   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:00   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:08   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:24   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:46   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:54   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:31:46   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:36   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:48   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:10   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:24   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:18   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:08   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:24   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:54   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BMEMWND.CPP
//
//  Description:The implement file for the class: CBMemoryWindow
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// bmemwnd.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"    
#include "uicom.h"
#include "bmemview.h"
#include "bmemwnd.h"

#include "btnbar.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/*
    Output : uchStatus = the current cpu status
             STATUS_HALT  == 0
             STATUS_GO    == 1
             STATUS_GORUN == 2
    returN : TRUE ==> GET OK
             FALSE ==> GET FAIL
*/
extern BOOL GetCpuStatus(unsigned char & uchStatus);
extern BOOL GetSFRBYTEName(BYTE bAddr,CString &strName );
extern BOOL GetSFRBitName(BYTE bAddr,CString &strName );

                  
void BMemOpenWindow(CMDIFrameWnd * /*pParentWnd*/)
{
    if (isBMemOn) return;
    pBMemDocTemplate->OpenDocumentFile(NULL);
}                  

/////////////////////////////////////////////////////////////////////////////
// CBMemoryWindow
//
IMPLEMENT_DYNCREATE(CBMemoryWindow, CMDIChildWnd)

CBMemoryWindow::CBMemoryWindow()
{                    
    isBMemOn = TRUE;
    pBMemWnd = this;
    m_pView = NULL;
    strcpy( m_strRegName, "" );
    m_strRegName[0] = '\0';    
    m_pointCaret.y = 0;
    m_pointCaret.x = 0;
}

CBMemoryWindow::~CBMemoryWindow()
{  
    isBMemOn = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CBMemoryWindow message handlers

BOOL 
CBMemoryWindow :: PreCreateWindow( CREATESTRUCT& cs )
{
   cs.cy = 300;
   cs.cx = 350;
   return CMDIChildWnd::PreCreateWindow(cs);   
}


int CBMemoryWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here
    return 0;
}

void CBMemoryWindow::OnSize(UINT nType, int cx, int cy)
{
    CMDIChildWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here
    if (m_pView!=NULL) {
        m_pView->SetWindowPos(NULL, 0, 20, cx, cy-20, SWP_NOZORDER);
    }        
}

void CBMemoryWindow::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    RECT rect;    
    int lpDxWidths[8];
    int i;
    
    GetClientRect(&rect);
    rect.bottom = 20;                     
    
    for ( i=0; i<8; i++ )
       lpDxWidths[i]=/*((CBMemoryView *)m_pView)->m_nDxWidth*/15;
    
    dc.SelectStockObject(ANSI_FIXED_FONT);
    
    int x = 0;
    x = /*((CBMemoryView *)m_pView)->m_nTextBegin*/30+1;   
    dc.ExtTextOut(x, 5, 
                  ETO_CLIPPED | ETO_OPAQUE, 
                  &rect, 
                  "76543210",        // Modify on 5.17.96(FAX)
                  8,                 // Modify on 5.17.96(FAX)   
                  lpDxWidths);
    
    char str[128];
    memset(str, 0, sizeof(str));
    wsprintf( str, "Byte  Bit : ");
    int len = strlen( str );              
    rect.left += 8*15+25;
    dc.ExtTextOut( x+8*15+25, 5,
                   ETO_CLIPPED | ETO_OPAQUE, 
                   &rect, 
                   str, // Modify on 5.17.96(FAX)
                   len,
                   NULL);
                   
    char *regName = NULL;
    CString strName;
         
    BYTE bAddr = BYTE(m_pointCaret.y*8+(7-m_pointCaret.x));
    BOOL bGetOk = FALSE;
         
    bGetOk = GetSFRBitName(bAddr, strName );   
    if ( bGetOk ) {
       regName = new char[strName.GetLength() + 2];   
       strcpy( regName, strName.GetBuffer( strName.GetLength() ) );
    }
    else {
       regName = new char[5];      
       strcpy( regName, " " );
    }
    
    WriteRegName( regName );

    if ( NULL != regName )   delete []regName;
                                               
/*
    if (NULL != m_pView)
      (CBMemoryView *)m_pView->SendMessage(WM_COMMAND,ID_VIEW_REFRESH,0);  
*/      
    // Do not call CMDIChildWnd::OnPaint() for painting messages
}

void CBMemoryWindow::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
   // TODO: Add your message handler code here and/or call default
   /*
   unsigned char uchCpuStatus;
   
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
      lpMMI->ptMaxSize.x = 15;
      lpMMI->ptMaxSize.y = 15;
      lpMMI->ptMaxTrackSize.x = 15;   
      lpMMI->ptMaxTrackSize.y = 15;   
 
      return;      
     }
     else {   
      
     }
   }     
   */
   lpMMI->ptMinTrackSize.x = 15*12;          
   CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}


void CBMemoryWindow::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    CMenu * pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );

    pLocalMenu->CreatePopupMenu();
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_BIT, "&Switch Bit");

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
    delete pLocalMenu;
    
    CMDIChildWnd::OnRButtonDown(nFlags, point);
}

BOOL CBMemoryWindow::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    if(message == WM_RBUTTONDOWN)   
        return FALSE;
    return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}


void CBMemoryWindow::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
    CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
    
    // TODO: Add your message handler code here
    if(bActivate && pActivateWnd == this)
//        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
//            LONG(WID_BMEM));
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate),
            LONG(WID_MEMORY));
            
    else if(!bActivate && !pActivateWnd)
//        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate),
            LONG(WID_MEMORY));
}

/*
void CBMemoryWindow::OnViewRefresh()
{
   // TODO: Add your command handler code here
   if (m_pView != NULL)
     m_pView->SendMessage(WM_COMMAND, ID_VIEW_REFRESH, 0); 
}
*/

void CBMemoryWindow::OnSysCommand(UINT nID, LPARAM lParam)
{
   // TODO: Add your message handler code here and/or call default
   unsigned char uchCpuStatus;
   
   if (GetCpuStatus(uchCpuStatus)) {
     if ( 1 == uchCpuStatus ) {       // Is on GO status (STATUS_GO)
      if ( SC_ZOOM == nID ) return;          // Zoomed
      if ( SC_MAXIMIZE == nID ) return;      // Zoomed
      if ( SC_RESTORE == nID ) return;       // Restore
      if ( SC_SIZE == nID ) return;       // Size      
     }
   }        
      
   CMDIChildWnd::OnSysCommand(nID, lParam);
}

//
// Add on 5.17.96 only for the FAX
// Write the register name related to the bit
//
void  
CBMemoryWindow::WriteRegName(char* regName)
{   
    //ASSERT(regName != NULL );
    //if (NULL == regName)
    //  return;
      
    CDC *dc = GetDC(); // device context for painting
    dc->SelectStockObject(ANSI_FIXED_FONT);
    
    int x = 0;
    x = 30+1;   
    
    char str[256];// = NULL;
    memset(str, 0, sizeof(str));
    int len = strlen( regName );
    //str = new char[len+10];
    wsprintf( str, "Byte  Bit : %s", 
              regName );
    len = strlen(str);
    
    RECT rect;    
    GetClientRect(&rect);
    rect.bottom = 20;
    rect.left += 8*15+25;
    dc->ExtTextOut( x+8*15+20, 5,
                    ETO_CLIPPED | ETO_OPAQUE, 
                    &rect, 
                    str, 
                    len, 
                    NULL);
    //if (str != NULL) delete []str;                    
    ReleaseDC(dc);
}

void  
CBMemoryWindow::RepaintBitWnd()
{
   Invalidate();
   if (m_pView != NULL)
     m_pView->SendMessage(WM_COMMAND, ID_VIEW_REFRESH, 0); 
}

BEGIN_MESSAGE_MAP(CBMemoryWindow, CMDIChildWnd)
   //{{AFX_MSG_MAP(CBMemoryWindow)
   ON_WM_CREATE()
   ON_WM_SIZE()
   ON_WM_PAINT()
   ON_WM_GETMINMAXINFO()
   ON_WM_RBUTTONDOWN()
   ON_WM_SETCURSOR()
   ON_WM_MDIACTIVATE()
   ON_WM_SYSCOMMAND()
   ON_WM_NCHITTEST()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()
                               
UINT 
CBMemoryWindow::OnNcHitTest(CPoint point)
{
   // TODO: Add your message handler code here and/or call default
   unsigned char uchCpuStatus;
   
   if (GetCpuStatus(uchCpuStatus)) {
      if ( 1 != uchCpuStatus ) {       // Is on GO status (STATUS_GO)
         return CMDIChildWnd::OnNcHitTest(point);
      }
      else {
         ShowStatusGo();
         return HTERROR;
      }         
   }
   else
      return HTERROR;
}

void   
CBMemoryWindow::ShowStatusGo()
{
   CString str = "Running. Halt CPU first.";
   ((CMainFrame*)((CXviewApp *)AfxGetApp()->m_pMainWnd))->m_wndStatusBar.UpdateStatusBar(0, str);
   MessageBeep( -1 );
}


///////////////////////////(EOF of the BMEMWND.CPP)////////////////////

