
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BYADRTBL.H__   1.7.1.0.1.0   11 Nov 1996 12:59:28   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BYADRTBL.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:28   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:22   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:52   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:58   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:28   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:06   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:10   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:48   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:02   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:10:32   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:28:10   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:59:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:39:10   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:46   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:34   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:42   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:06   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:02   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:48   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:38   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:08   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:32   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:16   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:56   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:32   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:14   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:22   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:00   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:00   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:10   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:04   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:56   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:02   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:56   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: byadrtbl.h
**
** Title: By-address Sorted Table
**
** Purpose:
**  Class and methods for managing the by-address sorted table.  Each base
**  structure points to one by-address sorted table.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/BYADRTBL.H__   1.7.1.0.1.0   11 Nov 1996 12:59:28   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _BYADRTBL_

                       /****************************
                        *                          *
                        *        INCLUDE FILES     *
                        *                          *
                        ****************************/
#include "mempool.h"
#include "symmgr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct {
   TABLE_OFFSET symbolOffset;
   U32          delta;      // requested addr minus start addr of matching sym
} SYMBOL_INFO_TYPE;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class ByAddressTable : public MemPool {

public:
//---------------------------------------------------------------------------
// ByAddressTable()  constructor
//
// Purpose:
//    Initialize by-address table variables for memory management.
//---------------------------------------------------------------------------
   ByAddressTable();    // constructor


//-----------------------------------------------------------------------
// GetOffset
//
// Purpose: returns the offset to the symbol stored in the by-address table
//-----------------------------------------------------------------------
TABLE_OFFSET ByAddressTable::GetOffset(U32 index) {
   return *(HP_TABLE_OFFSET)GetHugeDataPtr(index * sizeof(TABLE_OFFSET));
   } 


//-----------------------------------------------------------------------
// GetSymbolCount
// 
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
   U32 GetSymbolCount(VOID) { return (GetAvailMemOffset()
                              / sizeof(TABLE_OFFSET)); };


//-----------------------------------------------------------------------
// SearchForAddr
//
// Purpose:
//    Searches for a symbol which has a range that contains the requested
//    address and has the smallest end address that still contains addr.
//-----------------------------------------------------------------------
   RETCODE
   ByAddressTable::SearchForAddr(OFFSET_ADDR_TYPE requestedAddr,
                                 BOOLEAN          NoPublics,
                                 SYMBOL_INFO_TYPE& symbolInfo);


//-----------------------------------------------------------------------
// SortTable
//
// Purpose: Sorts the offsets to symbols by the start address of each symbol
//
// Input parameter: NONE
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE SortTable(VOID);

//-----------------------------------------------------------------------
// CreateAddrRanges
//
// Purpose: Create address range of the specified label type.
//
// Input parameter: label type
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE CreateAddrRanges(SYM_TYPE_TYPE labelType);

   
};  // end of class ByAddressTable

#endif


#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------
// AddressCompare
//
// Purpose:
//    Provides the compare function for the QSort sort
//------------------------------------------------------------------------
int AddressCompare(const VOID FAR * first,
                   const VOID FAR * second);



//------------------------------------------------------------------------
// SortAllByAddressTables
//
// Purpose:
//    Sorts all by-address tables with addrTableDirty TRUE
//------------------------------------------------------------------------
RETCODE EXPORT
SortAllByAddressTables(VOID);


//-----------------------------------------------------------------------
// ByAddressTableGetNext
//
// Purpose:
//   Iterator to walk the bases and return the name and symbol count
//
// Input parameters:
//    startLoop: TRUE ==> starts the interation
//              FALSE ==> must be set after first access
//
// Output parameters:
//    loopPtr: call by reference; must be returned when startLoop FALSE
//    baseName: string of base name
//    entryCount: reference var returning number of symbols in this base
//    tableSize: allocated size of by-address table
//-----------------------------------------------------------------------
RETCODE
ByAddressTableGetNext(BOOLEAN       startLoop,
                      TABLE_OFFSET& loopPtr,
                      LPSTR         baseName,
                      U32&          entryCount,
                      U32&          tableSize);

//------------------------------------------------------------------------
// CreateAllAddrRanges
//
// Purpose:
//    Create address range for all public labels.
//
//------------------------------------------------------------------------
RETCODE CreateAllAddrRanges(SYM_TYPE_TYPE type);

#ifdef __cplusplus
}
#endif

#define _BYADRTBL_
#endif
/******************************** E O F *************************************/
