/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/CL.CPP   1.3.1.0.1.0   11 Nov 1996 12:57:24   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/CL.CPP  $
** 
**    Rev 1.3.1.0.1.0   11 Nov 1996 12:57:24   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3.1.4   09 Sep 1996 13:13:22   ZJRD
** No change.
** 
**    Rev 1.3.1.3   05 Sep 1996 11:24:54   ZJRD
** No change.
** 
**    Rev 1.3.1.2   02 Sep 1996 09:52:02   ZJRD
** No change.
** 
**    Rev 1.3.1.1   28 Aug 1996 15:43:42   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.3.1.0   12 Aug 1996 10:49:08   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.0   29 May 1996 09:35:34   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// cl.cpp
//
// Michael long
//                                                                           
// 5/15/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "cl.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void CLTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";  
    dc << "m_libPath = " << m_libPath << "\n";
 
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void CLTool::SetDefault(void)
{                                                    
   m_strMore = "map ,Extended Microtek,Intel Hex"; 
   m_strPath = "c:\\2500ad\\bin";
   m_libPath = "c:\\2500ad\\lib";
}

BOOL CLTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_libPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_libPath.ReleaseBuffer(wLen);  

    return TRUE;
}                 

BOOL CLTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
      
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    wLen = m_libPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_libPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_libPath.ReleaseBuffer(wLen);  

    return TRUE;
}

CString CLTool::GetOption(void)
{
    CString str = " ";

    str += m_strMore;
    str += " ";
    
    return str;
}

