
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/COMMUNIC.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:02   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/COMMUNIC.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:02   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:48   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:54   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:38   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:53:52   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:00   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:30:32   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:07:48   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:22   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:25:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.27   18 Apr 1996 13:00:00   Shirley
** No change.
** 
**    Rev 1.26   12 Apr 1996 10:35:20   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.24   15 Feb 1996 08:50:34   Shirley
** No change.
** 
**    Rev 1.23   12 Feb 1996 14:05:14   Shirley
** No change.
** 
**    Rev 1.22   06 Feb 1996 15:31:48   Shirley
** No change.
** 
**    Rev 1.21   06 Feb 1996 13:45:00   Shirley
** No change.
** 
**    Rev 1.20   01 Feb 1996 10:17:48   Shirley
** No change.
** 
**    Rev 1.19   26 Jan 1996 09:15:56   Shirley
** No change.
** 
**    Rev 1.18   25 Jan 1996 13:15:48   Shirley
** No change.
** 
**    Rev 1.17   24 Jan 1996 10:35:34   Shirley
** No change.
** 
**    Rev 1.16   23 Jan 1996 11:26:22   Shirley
** No change.
** 
**    Rev 1.15   18 Jan 1996 10:15:00   Shirley
** No change.
** 
**    Rev 1.14   15 Jan 1996 16:17:06   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.13   04 Jan 1996 11:14:12   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.12   30 Nov 1995 09:14:28   Shirley
** No change.
** 
**    Rev 1.11   28 Nov 1995 15:33:20   Shirley
** No change.
** 
**    Rev 1.10   21 Nov 1995 11:20:36   Shirley
** No change.
** 
**    Rev 1.9   13 Nov 1995 09:27:02   Shirley
** No change.
** 
**    Rev 1.8   12 Nov 1995 11:31:38   Shirley
** No change.
** 
**    Rev 1.7   08 Nov 1995 16:33:06   Shirley
** No change.
** 
**    Rev 1.6   08 Nov 1995 12:45:04   Shirley
** No change.
** 
**    Rev 1.5   02 Nov 1995 10:03:36   Shirley
** No change.
** 
**    Rev 1.4   27 Oct 1995 16:46:46   Shirley
** No change.
** 
**    Rev 1.3   27 Oct 1995 13:44:20   Shirley
** No change.
** 
**    Rev 1.2   25 Oct 1995 14:26:08   Shirley
** No change.
** 
**    Rev 1.1   18 Oct 1995 14:48:50   Shirley
** No change.
** 
**    Rev 1.0   13 Oct 1995 13:24:10   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  COMMUNIC.CPP
//
//  Description:The implement file of the class CCommunicationDialog
//
//  Author:     Roger Zhang
//  Date:       10/06/95
//
//  Updated by: Frank
//  Date:       12/27/95
//
//  Modification:
//
//      1. 10/06/95, Ver 0.1d
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "communic.h"
#include "uicom.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
extern int nPortAddr;
extern int nPortType;
                   
char * PortAddr[8] = {
    "0x300",  //PCE
    "0x378",  //LPT1
    "0x278",  //LPT2
    "0x3BC",  //LPT3
    "0x3F8",  //COM1
    "0x2F8",  //COM2
    "0",    //COM3
    "0"     //COM4
};                                       

/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog dialog

extern int OpenAbiComDlg(int);

CCommunicationDialog::CCommunicationDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CCommunicationDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CCommunicationDialog)
    m_nType = nPortType;
    //}}AFX_DATA_INIT
          
	char * pEnd;
	for(int i = 0; i < 8; i ++) {          
    	m_nPortAddr[i] = (int)strtol(PortAddr[i], &pEnd, 16);
    }                                               
    m_nPortAddr[nPortType] = nPortAddr;
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", nPortAddr);
    m_strAddr.ReleaseBuffer();
}

void CCommunicationDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CCommunicationDialog)
    DDX_Radio(pDX, IDC_COMM_PCE, m_nType);
    DDX_Text(pDX, IDC_COMM_EDIT, m_strAddr);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCommunicationDialog, CDialog)
    //{{AFX_MSG_MAP(CCommunicationDialog)
    ON_BN_CLICKED(IDC_COMM_LPT1, OnCommLpt1)
    ON_BN_CLICKED(IDC_COMM_LPT2, OnCommLpt2)
    ON_BN_CLICKED(IDC_COMM_LPT3, OnCommLpt3)
	ON_BN_CLICKED(IDC_COMM_PCE, OnCommPce)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog message handlers

void CCommunicationDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData();                    
    
    DWORD dw;
    BOOL is = Str2Num(m_strAddr.GetBuffer(10), dw);
    m_strAddr.ReleaseBuffer();
    
    if(!is || dw > 0xFFF) {
        AfxMessageBox("Address Error!");
        return;
    }                                
                
                
    nPortType = m_nType;
    nPortAddr = int(dw);
    
    CDialog::OnOK();
}

void CCommunicationDialog::OnCommLpt1()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = PortAddr[m_nType];              
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt2()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt3()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

BOOL CCommunicationDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCommunicationDialog::OnCommPce()
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}
