
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/CPUCFG.CPP   1.7.1.0.1.0   11 Nov 1996 12:57:10   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/CPUCFG.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:12:18   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:24:06   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:51:26   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:43:08   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:48:40   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:50:58   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:27:36   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:16   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:07:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:52:42   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:32   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:46:30   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:01:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:26:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:14   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:11:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:06   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:31:56   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:21:50   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:16   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:00   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:28   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:00   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:28:52   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:48   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:00   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:27:32   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:12   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:44:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:08   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:38   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:34   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:47:58   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:30   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:58   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  CPUCFG.CPP
//
//  Description:The implement file for the class: CRegcfgDialog
//
//  Author:     Roger Zhang
//
//  Date:       04/25/95
//
//  Modification:
//
//      1. 04/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "cpucom.h"
#include "cpucfg.h"
#include "hosterrs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRegcfgDialog dialog

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CRegcfgDialog::CRegcfgDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CRegcfgDialog::IDD, pParent)
{
    ASSERT(nCurRegs <= nMaxReg);

    for(int i = 0; i < nMaxReg; i ++)   m_Reg[i] = FALSE;
    for(i = 0; i < nCurRegs; i ++)  m_Reg[RegSelect[i]] = TRUE; 
    //{{AFX_DATA_INIT(CRegcfgDialog)

    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CRegcfgDialog)              
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRegcfgDialog, CDialog)
    //{{AFX_MSG_MAP(CRegcfgDialog)
    ON_BN_CLICKED(IDC_REGCONFIG_UNSELECT, OnUnselectAll)
    ON_BN_CLICKED(IDC_REGCONFIG_SELECTALL, OnSelectAll)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CRegcfgDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::OnUnselectAll()
{
    // TODO: Add your control notification handler code here
    for(int i = 1; i < nMaxReg; i ++)                             
        m_btnReg[i].SetCheck(0);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::OnSelectAll()
{
    // TODO: Add your control notification handler code here
    for(int i = 0; i < nMaxReg; i ++)   
        m_btnReg[i].SetCheck(1);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CRegcfgDialog::OnOK()
{
    // TODO: Add extra validation here
    for(int i = 0; i < nMaxReg; i ++) {  
        if(m_btnReg[i].GetCheck())  break;
    }
    if(i == nMaxReg)    ErrDisplayError(ER_PRE_SEL_REG);
    else {   
        for(i = 0; i < nMaxReg; i ++) {
            if(m_btnReg[i].GetCheck())  m_Reg[i] = TRUE;
            else m_Reg[i] = FALSE;
        }
        CDialog::OnOK();
    } 
}   

#define _COLWD   80
#define _ROWHT   18

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CRegcfgDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    CRect rect;
    GetWindowRect(rect);
    int nRows = (nMaxReg + 5)/6; 
    int nOfs = _ROWHT * nRows;
    
    VERIFY(SetWindowPos(NULL, 40, 40, rect.Width(), rect.Height() + nOfs, 
    	SWP_NOZORDER|SWP_NOREDRAW|SWP_NOACTIVATE));

    CenterWindow();

    CButton * btn = (CButton *)GetDlgItem(IDOK);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    btn = (CButton *)GetDlgItem(IDCANCEL);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    btn = (CButton *)GetDlgItem(IDC_REGCONFIG_SELECTALL);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    btn = (CButton *)GetDlgItem(IDC_REGCONFIG_UNSELECT);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
//    btn->EnableWindow(0);
    
    btn = (CButton *)GetDlgItem(ID_HELP);
    btn->GetWindowRect(rect);
    ScreenToClient(rect);
    rect.OffsetRect(0, nOfs);
    btn->MoveWindow(rect);
    
    for(int i = 0, j = 0; j < nRows && i < nMaxReg; j ++) {
        for(int k = 0; k < 6 && i < nMaxReg; k ++, i++) {  
            rect.SetRect(10 + k * _COLWD, 10 + j * _ROWHT, 
                10 + k * _COLWD + 75, 10 + j * _ROWHT + 16);
            m_btnReg[i].Create("O&verwrite",WS_VISIBLE|WS_CHILD|WS_TABSTOP
                |BS_AUTOCHECKBOX, rect, this, IDC_REGCONFIG_FIRSTREG + i);
            m_btnReg[i].SetFont(GetFont(), TRUE);   
            m_btnReg[i].SetWindowText(RegName[i]);
            if(m_Reg[i])    m_btnReg[i].SetCheck(1);
            else    m_btnReg[i].SetCheck(0);
        }
    }                  
    m_btnReg[0].EnableWindow(0);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////(EOF)///////////////////////////////////////
