
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DAD.H__   1.7.1.0.1.0   11 Nov 1996 13:00:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DAD.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:21:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:44   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:44   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:36   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:46   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:32:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:54   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:40   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:22   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:22   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:34   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:06   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:16:56   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:50   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:56   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:02   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:12:24   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:10:06   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:00   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:20   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:16   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:40   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:16   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:36   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:50   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:42   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:23:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:42   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:34   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:42   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:22   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : dad.h
** Author:John Zhou
** Description:
**    definition of data struct and prototype of interface function.
**
**
**    Finished date: 1995.4.21
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
              
#ifndef _DAD_H
#define _DAD_H

#define NOTTEST  //this must be close when testing because of the bi-meanings
                 //of asm eg: "mov r7,a" and "mov r7,0e0h"
#include "abibase.h"

#define SHELL
#define ABI
#define BRIGHT
#define SOURCE
#define MEMORY
#define SYMBOL
#define ESC_KEY
 //define if want to stop during dad ,AND IT CAN NOT BE DEFINED ONLY THE "STDAFX.H" IS DEFINED

    #define GATESLEN 45  //GATES' Symbol length

  //constant symbols
    #define     None         0
    #define     Accum        1
    #define     cFlag        2
    #define     symbolAB     3
    #define     contentADptr 4
    #define     contentAPc   5
    #define     symbolDptr   6
    #define     contentR0    7
    #define     contentR1    8
    #define     symbolR0     9
    #define     symbolR1    10
    #define     symbolR2    11
    #define     symbolR3    12
    #define     symbolR4    13
    #define     symbolR5    14
    #define     symbolR6    15
    #define     symbolR7    16

    #define     contentDptr  27  //repaired by john 95.4.12

  //following constant symbols have none corresponding in constant symbol string table

    #define     codeAddrH   17  //64k code address high
    #define     codeAddrL   0   //64k code address low
                                //but it is no use because it's always following codeAddrH
    #define     codeAddrPg  19  //orient code address
    #define     dataAddr    20  //0-0xff data address
    #define     dataByte    21  //one byte data
    #define     dataWord    22  //one word data
    #define     bitAddr     23  //0xff bit address
    #define     NbitAddr    24
    #define     codeAddr11  25  //2kbytes jump (deferent from SEP)

    #define BITABLE 1;
    #define UNBITABE 0;

    typedef struct {
                unsigned char *Intruction;
                unsigned char ByteNum;  // 1;2;3;
                unsigned char opcode1;
                unsigned char opcode2;
                unsigned char opcode3;
                } CMDLINE;

    typedef struct
       {
        unsigned char *Name;
        unsigned char DirAddr;
        unsigned char SfrAttr;  // BITABLE: bitable  UNBITABE:unbitable.
        unsigned long int AvailableCPU_H;
        unsigned long int AvailableCPU_L;
        }SFRNAME;

    typedef struct
               {
                unsigned short InstrStartAddr;
                unsigned char InstrString[128];
                }OneInstruction;

/**********    InstrString structure *******************
        InstrString[0..3]:  instruction start address. example: 0000,0001,ffff.
        InstrString[4..5]: blank.
        InstrString[6..11]: instruction hex code.
        InstrString[12..13]: blank.
        InstrString[14..19]: executable instruction. example: MOV,ACALL.
        InstrString[19..20]: blank.
        InstrString[21..127]: none or dest opcode or (dest opcode + source opcode).

        remark: " " represent a blank.
*********************************************************/

/****       The Source stream could be made up with:   **************
            1. Operation code. (example: MOV,LJMP...)
            2. SFR name. (example: R0.4,SP,PSW...)
            3. absoluted code address. (example: 20h.3,340h...)
            4. direct data address. (example: 10h...)
            5. data. (example: #30h,#1234h)
            6. blank
            7. ","
            8. "$"  // represent current PC
        The assembly function will analyze the grammar of the input stream. And
        compare the input stream format to CMd_51 table . If it is standard, the
        assembly function will compile it and the result is several bytes.
        Otherwise the assembly function will return an error code.
        Remark: 1. The input stream grammar is following the standard 51 instruction.
              2. Input stream length maxium is 100 characters.
              3. Input characters case is ignored.
              4. blank number between opcode is ignored.

********************************************************************/

    typedef struct  //defined for DAOne using
             {
              unsigned short InstrStartAddr;
              unsigned char InstrString[128*2];//only deffernt from OneInstruction
              }OneInstructionPlus ;

    //defined for address convertion
    struct AddrStruct
       {
         unsigned char addrl;
         unsigned char addrh;
         };
    union AddrTemp
       {
        unsigned short addrShort;
        struct AddrStruct addrStruct;
        };

#define MAXASCII 99
#define BITLENGTH 8
#define BITABLELOW 0X20//  the range IDATA area which can be addressed in bit
#define BITABLEHIGH 0X2F//
#define DisassemblyDefaultLength 50//used in shell command
#define MAXHEXCODELEN 512
#define MAXINSTRUCTION 512
#define MAXMEMINSTRUCTION 60
#define MAXINSTRUCTIONSTRING 5
#define STARTOPCODEINDEX 21
#define ENDOPCODEINDEX 127

//defined for accessing the ABI funtion

#define ABI_CODE_ADDR_JOHN  1 //defined for get data from 51's addr with ABI
#define ABI_XDATA_ADDR 2 //
#define ABI_IDATA_ADDR 3 //
#define ABI_SFR_ADDR   4 //
#define ABI_BIT_ADDR   5 //

#define ABI_CODE_ADDR_JOHN_MIN  0x0000 //defined the range of address
#define ABI_CODE_ADDR_JOHN_MAX  0xffff//
#define ABI_XDATA_ADDR_MIN 0x0000 //
#define ABI_XDATA_ADDR_MAX 0xffff//
#define ABI_IDATA_ADDR_MIN 0x00//
#define ABI_IDATA_ADDR_MAX 0xff//
#define ABI_SFR_ADDR_MIN   0x80//
#define ABI_SFR_ADDR_MAX   0xff//
#define ABI_BIT_ADDR_MIN   0x00//
#define ABI_BIT_ADDR_MAX   0xff//

//typedef unsigned int  WORD;
//typedef unsigned int  UINT;
typedef int           STATUS;
typedef unsigned char FLAG;
//typedef unsigned char U8;
//typedef unsigned long U32;
/*
typedef struct
       {
        FLAG addrType;//1 code addr
                      //2 extern data addr
                      //3 intern data addr
                      //4 SFR addr
                      //5 bit addr
        WORD addr;
        }ADDR;*/

//define of daddll  ***********************************************
extern "C"
{
int WINAPI _export GetByteSFRSymbolIndex(unsigned char Addr,
                                         SFRNAME *SFRbitRet,
                                         unsigned long Module_H,
                                         unsigned long Module_L);
int WINAPI _export GetBitSFRSymbolIndex(unsigned char Addr,
                                        SFRNAME *SFRbitRet,
                                        unsigned long Module_H,
                                        unsigned long Module_L);
int WINAPI _export GetByteSFRAddrIndex(unsigned char *SFRNameBuf,
                                       SFRNAME *SFRbitRet,
                                       unsigned long Module_H,
                                       unsigned long Module_L);
int WINAPI _export GetBitSFRAddrIndex(unsigned char *SFRNameBuf,
 									  SFRNAME *SFRbitRet,
 									  unsigned long Module_H,
 									  unsigned long Module_L);                                       
}
/*****************************************************************/        
        
#ifdef ABI
//ABI FUNCTION

//this function get 51's memory data from addr1 to addr2 to the pchBuff
//return 0 refer to ok!
//return !=0 refer to wrong
extern STATUS AbiGetMemN(ADDR addr1,ADDR addr2,char *pchBuff);

//this function set 51's memory data from addr lasting len by the pchBuff
//return 0 refer to ok!
//return !=0 refer to wrong
extern STATUS AbiSetMemN(ADDR addr,char *pchBuff,UINT len);
#endif

#ifdef SYMBOL
#include "symblsvr.h"
int SymToAddr( char *lpStr , U8* lpType , U32* lpAddr );
int AddrToSym( U8 type , U32 addr , char* str );
#endif

#ifdef MEMORY
typedef struct  
 {             
  long address;
  char code[10];
  char instruction[256];
  } DADMEMSTRU;     
      
#endif


#endif

/****************         APENDIX A     95/6/9   ***************************
     Today I define some new principles about DAD,because the bi-meanings of
 some registers name as 'A' ,'C'. One is constant symbol,the other is SFR
 name.
     If Asm meets this problem it will give higher priority to Constant Sym
 bol.
     For example: "push a"
                  firstly asm translate a to constant symbol,but could not
                  found instruction like push a.There is only instruction
                  like "push dadeaddr".  So it translate it to SFR and found
                  the address 0E0H.Thus it is converted to "push e0h"
     When disasm run, it will convert internal address to SFR Name,whether
     the instruction is avaible. So such instruction like "Push a" will appear.

     So if we test DAD as from disassemble to assemble and list to disassemble,
     the result will be wrong.
     Because:(for example)
     disassemble will firstly translate "mov r7,e0" as "mov r7,a",
     them assemble translate "mov r7,a" and found it could not be
     campitable to "mov r7,e0h".
*****************************************************************************/




