/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DIAGNOST.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:54   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DIAGNOST.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:54   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:38   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:08   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:12   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:12   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:44   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:02   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:37:22   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:01:58   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:16:50   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:12   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:38   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:36:00   Shirley
** Initial revision.
** 
****************************************************************************/
// diagnost.cpp : implementation file
//
//john chow 96.3
#include "stdafx.h"
//#include "ep-sld.h"
#include "diagnost.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox dialog


CDiagnosticBox::CDiagnosticBox(CWnd* pParent /*=NULL*/)
	: CDialog(CDiagnosticBox::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDiagnosticBox)
	m_POIResult = "";
	m_MAPRAMResult = "";
	m_EVENTADDRResult = "";
	m_EVENTDATARAMResult = "";
	m_SPOONRAMResult = "";
	m_EMULATIONRAMResult = "";
	m_TRACERAMResult = "";
	m_BHasSaved = FALSE;
	//}}AFX_DATA_INIT
}

void CDiagnosticBox::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiagnosticBox)
	DDX_Control(pDX, IDC_EMULATIONRAM, m_buttonEmulationRam);
	DDX_Control(pDX, IDC_CHECK_TRACERAM, m_buttonCheckTraceRam);
	DDX_Control(pDX, IDC_CHECK_SPOONRAM, m_buttonCheckSpoonRam);
	DDX_Control(pDX, IDC_CHECK_PIOCTC, m_buttonCheckPIOCTC);
	DDX_Control(pDX, IDC_CHECK_MAPRAM, m_buttonCheckMapRam);
	DDX_Control(pDX, IDC_CHECK_EVENTDATARAM, m_buttonCheckEventDataRam);
	DDX_Control(pDX, IDC_CHECK_EVENTADDRRAM, m_buttonCheckEventAddrRam);
	DDX_Control(pDX, IDOK, m_buttonDetail);
	DDX_Control(pDX, ID_BUTTON_DIAGNOSTIC, m_buttonDiagnostic);
	DDX_Control(pDX, IDC_CHECK_ALL, m_buttonCheckAll);
	DDX_Text(pDX, IDC_STATIC_PIO, m_POIResult);
	DDX_Text(pDX, IDC_STATIC_MAPRAM, m_MAPRAMResult);
	DDX_Text(pDX, IDC_STATIC_EVENTADDRRAM, m_EVENTADDRResult);
	DDX_Text(pDX, IDC_STATIC_EVENTDATARAM, m_EVENTDATARAMResult);
	DDX_Text(pDX, IDC_STATIC_SPOONRAM, m_SPOONRAMResult);
	DDX_Text(pDX, IDC_STATIC_EMULATIONRAM, m_EMULATIONRAMResult);
	DDX_Text(pDX, IDC_STATIC_TRACERAM, m_TRACERAMResult);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDiagnosticBox, CDialog)
	//{{AFX_MSG_MAP(CDiagnosticBox)
	ON_BN_CLICKED(ID_BUTTON_DIAGNOSTIC, OnButtonDiagnostic)
	ON_BN_CLICKED(IDC_CHECK_ALL, OnCheckAll)
	ON_BN_CLICKED(IDC_CHECK_PIOCTC, OnCheckPioctc)
	ON_BN_CLICKED(IDC_CHECK_EVENTADDRRAM, OnCheckEventaddrram)
	ON_BN_CLICKED(IDC_CHECK_EVENTDATARAM, OnCheckEventdataram)
	ON_BN_CLICKED(IDC_CHECK_MAPRAM, OnCheckMapram)
	ON_BN_CLICKED(IDC_CHECK_SPOONRAM, OnCheckSpoonram)
	ON_BN_CLICKED(IDC_CHECK_TRACERAM, OnCheckTraceram)
	ON_BN_CLICKED(IDC_EMULATIONRAM, OnEmulationram)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox message handlers

void CDiagnosticBox::OnButtonDiagnostic()
{
	// TODO: Add your control notification handler code here 
	UpdateData(TRUE);  
	m_POIResult = "";
	m_MAPRAMResult = "";
	m_EVENTADDRResult = "";
	m_EVENTDATARAMResult = "";
	m_SPOONRAMResult = "";
	m_EMULATIONRAMResult = "";
	m_TRACERAMResult = "";
	UpdateData(FALSE);   
	
	
	//SAVE HW SETTINGS
	if(!m_BHasSaved) {
	    BeginWaitCursor();
	    m_BHasSaved = TRUE;
	    ::SaveAllConfig();
	    EndWaitCursor();
	}
	
	unsigned char bResult;
	if(m_buttonCheckAll.GetCheck() || m_buttonCheckPIOCTC.GetCheck()) {              
	    BeginWaitCursor();
	    if(AbiDiagnostic(1,bResult) == ICE_OK && bResult ==0) m_POIResult = "OK";
	        else m_POIResult = "FAIL";  
	    EndWaitCursor();    
	} else m_POIResult = "";  
	UpdateData(FALSE);  
	if(TestKey(VK_ESCAPE)) { 
	    DecideDetailButtonStatus();
	    return;
	}    
	  
	if(m_buttonCheckAll.GetCheck() || m_buttonCheckMapRam.GetCheck()) {                             
	    BeginWaitCursor();
	    if(AbiDiagnostic(2,bResult) == ICE_OK && bResult ==0) m_MAPRAMResult = "OK";
	        else m_MAPRAMResult = "FAIL";  
	    EndWaitCursor();    
	} else m_MAPRAMResult = "";   
	UpdateData(FALSE);  
	if(TestKey(VK_ESCAPE)) { 
	    DecideDetailButtonStatus();
	    return;
	}    
	  
	if(m_buttonCheckAll.GetCheck() || m_buttonCheckEventAddrRam.GetCheck()) {                            
	    BeginWaitCursor();
	    if(AbiDiagnostic(3,bResult) == ICE_OK && bResult ==0) m_EVENTADDRResult = "OK";
	        else m_EVENTADDRResult = "FAIL"; 
	    EndWaitCursor();    
	} else m_EVENTADDRResult = "";
	UpdateData(FALSE);  
	if(TestKey(VK_ESCAPE)) { 
	    DecideDetailButtonStatus();
	    return;
	}    
	  
	if(m_buttonCheckAll.GetCheck() || m_buttonCheckEventDataRam.GetCheck()) {                   
	    BeginWaitCursor();
	    if(AbiDiagnostic(4,bResult) == ICE_OK && bResult ==0) m_EVENTDATARAMResult = "OK";
	        else m_EVENTDATARAMResult = "FAIL";
	    EndWaitCursor();    
	} else m_EVENTDATARAMResult = "";      
	UpdateData(FALSE);  
	if(TestKey(VK_ESCAPE)) { 
	    DecideDetailButtonStatus();
	    return;
	}    
	  
	if(m_buttonCheckAll.GetCheck() || m_buttonCheckSpoonRam.GetCheck()) {                       
	    BeginWaitCursor();
	    if(AbiDiagnostic(5,bResult) == ICE_OK && bResult ==0) m_SPOONRAMResult = "OK";
	        else m_SPOONRAMResult = "FAIL";
	    EndWaitCursor();    
	} else m_SPOONRAMResult = ""; 
	UpdateData(FALSE);  
	if(TestKey(VK_ESCAPE)) { 
	    DecideDetailButtonStatus();
	    return;
	}    
	
	if(m_buttonCheckAll.GetCheck() || m_buttonEmulationRam.GetCheck()) {                              
	    BeginWaitCursor();
	    if(AbiDiagnostic(6,bResult) == ICE_OK && bResult ==0) m_EMULATIONRAMResult = "OK";
	        else m_EMULATIONRAMResult = "FAIL";
	    EndWaitCursor();    
	} else m_EMULATIONRAMResult = "";
	UpdateData(FALSE);  
	if(TestKey(VK_ESCAPE)) { 
	    DecideDetailButtonStatus();
	    return;
	}    
	
	if(m_buttonCheckAll.GetCheck() || m_buttonCheckTraceRam.GetCheck()) {                          
	    BeginWaitCursor();
	    if(AbiDiagnostic(7,bResult) == ICE_OK && bResult ==0) m_TRACERAMResult = "OK";
	        else m_TRACERAMResult = "FAIL";
	    EndWaitCursor();    
	} else m_TRACERAMResult = "";  
	UpdateData(FALSE);  
	
	DecideDetailButtonStatus();
	  
	
}

void CDiagnosticBox::OnCheckAll()
{
	// TODO: Add your control notification handler code here
	if(m_buttonCheckAll.GetCheck()) {
	    m_buttonCheckPIOCTC.EnableWindow(FALSE);
	    m_buttonCheckMapRam.EnableWindow(FALSE);
	    m_buttonCheckEventAddrRam.EnableWindow(FALSE);
	    m_buttonCheckEventDataRam.EnableWindow(FALSE);
	    m_buttonCheckSpoonRam.EnableWindow(FALSE);
	    m_buttonEmulationRam.EnableWindow(FALSE);
	    m_buttonCheckTraceRam.EnableWindow(FALSE);
	} else { 
	    m_buttonCheckPIOCTC.EnableWindow(TRUE);
	    m_buttonCheckMapRam.EnableWindow(TRUE);
	    m_buttonCheckEventAddrRam.EnableWindow(TRUE);
	    m_buttonCheckEventDataRam.EnableWindow(TRUE);
	    m_buttonCheckSpoonRam.EnableWindow(TRUE);
	    m_buttonEmulationRam.EnableWindow(TRUE);
	    m_buttonCheckTraceRam.EnableWindow(TRUE);
	}                            
	    
	DecideDiagnosticButtonStatus();
}

void CDiagnosticBox::OnCheckPioctc()
{
	// TODO: Add your control notification handler code here 
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheckEventaddrram()
{
	// TODO: Add your control notification handler code here  
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheckEventdataram()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	                  
}

void CDiagnosticBox::OnCheckMapram()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheckSpoonram()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnCheckTraceram()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

void CDiagnosticBox::OnEmulationram()
{
	// TODO: Add your control notification handler code here
	DecideDiagnosticButtonStatus();
	
}

BOOL CDiagnosticBox::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here   
	CenterWindow();
	m_buttonDetail.EnableWindow(FALSE);
	m_buttonDiagnostic.EnableWindow(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDiagnosticBox::DecideDiagnosticButtonStatus()
{      
      BOOL bResult = FALSE;
      if(m_buttonCheckAll.GetCheck()) bResult = TRUE;
      if(m_buttonCheckPIOCTC.GetCheck()) bResult = TRUE;
	  if(m_buttonCheckMapRam.GetCheck()) bResult = TRUE;
	  if(m_buttonCheckEventAddrRam.GetCheck()) bResult = TRUE;
	  if(m_buttonCheckEventDataRam.GetCheck()) bResult = TRUE;
	  if(m_buttonCheckSpoonRam.GetCheck()) bResult = TRUE;
	  if(m_buttonEmulationRam.GetCheck()) bResult = TRUE;
	  if(m_buttonCheckTraceRam.GetCheck()) bResult = TRUE;
	  
	  m_buttonDiagnostic.EnableWindow(bResult);
 }

void CDiagnosticBox::DecideDetailButtonStatus()
{ 
      BOOL bResult = FALSE; 
      if(m_MAPRAMResult == "FAIL") bResult = TRUE;
      if(m_EVENTADDRResult == "FAIL") bResult = TRUE;
	  if(m_EVENTDATARAMResult == "FAIL") bResult = TRUE;
	  if(m_SPOONRAMResult == "FAIL") bResult = TRUE;
	  if(m_EMULATIONRAMResult == "FAIL") bResult = TRUE;
	  if(m_TRACERAMResult == "FAIL") bResult = TRUE;
	  if(m_POIResult == "FAIL") bResult = TRUE;
	  
	  m_buttonDetail.EnableWindow(bResult);
 } 
                                                  
//support for shell window's command
void DiagnosticCmd(int nArgc, char* pszArgv[])
{   
    unsigned char bResult;
    
    BOOL bPio = FALSE;
    BOOL bMap = FALSE;
	BOOL bEventaddr = FALSE;
	BOOL bEventdata = FALSE;
	BOOL bSpoon = FALSE;
	BOOL bEmulation = FALSE;
	BOOL bTrace = FALSE;
	BOOL bAll = FALSE;
	
	//Check FW version
	BYTE uchMajor,uchMinor;
	BOOL isOldFw(FALSE);
	BOOL isCanHWReset(FALSE);
	if (0 != AbiGetFwId(&uchMajor,&uchMinor)) {
		ShowLine("Fail in getting FW-ID");
	 	isOldFw = TRUE;
	} else {
		switch(uchMajor) {
			case 0x13:isCanHWReset = TRUE;
					break;
	        case 0x12:if(uchMinor < 0x15) isOldFw = TRUE;
	        		  if(uchMinor > 0x16) isCanHWReset = TRUE;
	 				break;
	 		case 0x22:
	 		case 0x32:if(uchMinor < 0x13) isOldFw = TRUE;  
	 				  if(uchMinor > 0x12) isCanHWReset = TRUE;
	 				break;
	 		case 0x42:if(uchMinor < 0x08) isOldFw = TRUE;     
	 				  if(uchMinor > 0x07) isCanHWReset = TRUE;
					break;
	 	}
	 	
	}	
	
	ASSERT(nArgc>=1 && nArgc<=8);
	     
    if(nArgc == 1) {
        bPio = TRUE;
        bMap = TRUE;
	    bEventaddr = TRUE;
	    bEventdata = TRUE;
	    bSpoon = TRUE;
	    bEmulation = TRUE;
	    bTrace = TRUE; 
	} else {
        for ( int i = 1; i < nArgc; i++ ) {
            CString str = strupr(pszArgv[i]);
            if ( str == "PIO") {
				bPio = TRUE;
            }
            else if (str == "MAP"){
      			bMap = TRUE;		  
            }
            else if (str == "EVENTADDR"){ 
        		bEventaddr = TRUE;        	 
            }
            else if (str == "EVENTDATA"){
        		bEventdata = TRUE;        	 
            }
            else if (str == "SPOON"){
        		bSpoon = TRUE;        	 
    		}
            else if (str == "EMULATION"){
	       		bEmulation = TRUE;        	 
            }
            else if (str == "TRACE"){
        		bTrace = TRUE;        	 
            }
            else {
            ShowLine("Syntax error???");
            }
        }//for    
    }//else  
    
    AfxGetApp()->DoWaitCursor(1);
    
    if(isOldFw) bAll = TRUE;                 
    
    char pChar[80];
    strcpy(pChar,"Please reset your EasyPack!");
    
    if(bAll) {              
    	ShowLine("You FW is too old!");               
    	ShowLine("Testing...");         
	    if(AbiDiagnostic(0,bResult) == ICE_OK && bResult ==0) 
	        ShowLine("All Tests is Ok!");
	        else {
	        	ShowLine("Find Error!");  
	            if((bResult&0x01) == 0x01) 
	    	    	ShowLine("PIO Error!");
	    		if((bResult&0x02) == 0x02)  
	    		    ShowLine("Map Ram Error!");
	    		if((bResult&0x04) == 0x04)  
	    		    ShowLine("Event Address Ram Error!");
	    		if((bResult&0x08) == 0x08)  
	    		    ShowLine("Event Data Ram Error!");
	    		if((bResult&0x10) == 0x10)  
	    		    ShowLine("Spoon Ram Error!");
	    		if((bResult&0x20) == 0x20)  
	    		    ShowLine("Emulation Ram Error!");
	    		if((bResult&0x40) == 0x40)  
	    		    ShowLine("Trace Ram Error!");
	    		    
	    	}      
	    AfxGetApp()->DoWaitCursor(-1);	      
	    ShowLine(pChar);         
	    return;
	}		    
    	
    ADDR tmpAddr;
    tmpAddr.addrType = 0x10;  
    
            
    if(bPio) {     
	    ShowLine("Testing PIO...");         
	    if(AbiDiagnostic(1,bResult) == ICE_OK && bResult ==0) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    }    
	}   
	    
	if(bMap) {     
	    ShowLine("Testing Map RAM...");         
	    if(AbiDiagnostic(2,bResult) == ICE_OK && bResult ==0) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	  
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    }    
	}   
	
	if(bEventaddr) {     
	    ShowLine("Testing Event address RAM...");         
	    if(AbiDiagnostic(3,bResult) == ICE_OK && bResult ==0) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	  
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    }    
	}  
	
	if(bEventdata) {     
	    ShowLine("Testing Event data RAM...");         
	    if(AbiDiagnostic(4,bResult) == ICE_OK && bResult ==0) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	  
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    }    
	}  
	
	if(bSpoon) {     
	    ShowLine("Testing Spoon RAM...");         
	    if(AbiDiagnostic(5,bResult) == ICE_OK && bResult ==0 ) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	  
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    	}    
	}   
	    
	if(bEmulation) {     
	    ShowLine("Testing Emulation RAM...");         
	    if(AbiDiagnostic(6,bResult) == ICE_OK && bResult ==0) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	  
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    }    
	}       
	 
	if(bTrace) {     
	    ShowLine("Testing Trace RAM...");         
	    if(AbiDiagnostic(7,bResult) == ICE_OK && bResult ==0) ShowLine("Test Ok!");
	        else ShowLine("Find Error!");  
	    if(TestKey(VK_ESCAPE)) { 
	    	AfxGetApp()->DoWaitCursor(-1);	  
	    	if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
	    	return;
	    }    
	} 
		
   AfxGetApp()->DoWaitCursor(-1);             
   if(isCanHWReset) AbiReset(tmpAddr);
	    		else ShowLine(pChar);         
 } 
 
