/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DLIB.CPP   1.3.1.0.1.0   11 Nov 1996 12:57:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DLIB.CPP  $
** 
**    Rev 1.3.1.0.1.0   11 Nov 1996 12:57:26   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3.1.4   09 Sep 1996 13:13:28   ZJRD
** No change.
** 
**    Rev 1.3.1.3   05 Sep 1996 11:25:00   ZJRD
** No change.
** 
**    Rev 1.3.1.2   02 Sep 1996 09:52:06   ZJRD
** No change.
** 
**    Rev 1.3.1.1   28 Aug 1996 15:43:46   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.3.1.0   12 Aug 1996 10:49:10   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.0   29 May 1996 09:35:38   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// dc.cpp
//
// Michael Long
//                                                                           
// 5/14/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "afx.h"
#include "toolopt.h"
#include "dlib.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void DLIBTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nSmall = " << m_nSmall << "\n";
    dc << "m_nCompact = " << m_nCompact << "\n";
    dc << "m_nLarge = " << m_nLarge << "\n";
    dc << "m_strMore = " << m_strMore << "\n";  
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void DLIBTool::SetDefault(void)
{
    m_nSmall = FALSE;     // 0-3
    m_nCompact = FALSE; // 0 - 2 = s,c,l
    m_nLarge = TRUE;    // 0 - 5
    m_strMore = ""; 
    m_strPath = "c:\\omf51\\lib";
}

BOOL DLIBTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;
    
    char dch[nCnt];
    
    if(fread(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nSmall = dch[0];
    m_nCompact = dch[1];
    m_nLarge = dch[2];
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}                 

BOOL DLIBTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 3;

    char dch[nCnt];
    
    dch[0] = m_nSmall;
    dch[1] = m_nCompact;
    dch[2] = m_nLarge;
    
    if(fwrite(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}   
                            
CString DLIBTool::GetOption(void) const
{
    CString str = "";
    CString dlibstr;
    
    dlibstr = m_strPath;
    if(dlibstr[dlibstr.GetLength()-1]!='\\')
    dlibstr = dlibstr + "\\"; 
    str += dlibstr;
    
    if(m_nSmall)
        str += "C51FPS.LIB ";
        
    if(m_nCompact)
        str += "C51FPC.LIB ";
        
    if(m_nLarge)
        str += "C51FPL.LIB ";
    
   
    if(m_strMore=="")
     return str; 

   /* if(m_strMore != "")
     {
      str += ",";
      str += m_strMore;
     } */
    char separation[2];
    LPSTR temp;
        
    separation[0]=',';
    separation[1]='\0';       
    
    
    temp =_fstrtok((LPSTR)(LPCSTR)m_strMore, separation);
    if(temp==NULL)
     return str;
    CString strtemp="";
    CString tempstr=",";
    do
    { 
      strtemp  += tempstr;
      strtemp  += dlibstr; 
      strtemp  += temp;
      temp =_fstrtok(NULL, separation);
    }while(temp!=NULL);    
    
    str += strtemp;
    return str;
}

