
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/DSMGTDLG.CPP   1.7.1.0.1.0   11 Nov 1996 12:57:48   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/DSMGTDLG.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:14:20   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:25:54   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:00   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:45:46   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:46   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:52:54   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:10   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:44   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:18   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:08   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:20   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:00   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:00   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:20   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:30   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:26   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:29:18   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:00   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:18   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:40   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:40   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:00   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:26   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:30:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:28   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.4   13 Oct 1995 13:22:34   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:08   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:34   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:38   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  DSMGTDLG.CPP
//
//  Description:The implement file for the class: CDsmGtDlg
//
//  Author:     Lane Li &  Daniel Lin
//      3. 03/11/1996 1.0 version       Daniel Lin
//         Modify for all address input field must be processed by Address 
//         server
//
//      2. 10/25/95, 0.1d version       Daniel Lin
//              modified function   OnInitDialog()
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// dsmgtdlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"
#include "dsmgtdlg.h"
#include "errno.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"

#include "address.h"
#include "addrapi.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
//extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDsmGtDlg dialog


CDsmGtDlg::CDsmGtDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CDsmGtDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CDsmGtDlg)
      // NOTE: the ClassWizard will add member initialization here
   //}}AFX_DATA_INIT
}

void CDsmGtDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CDsmGtDlg)
      // NOTE: the ClassWizard will add DDX and DDV calls here
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDsmGtDlg, CDialog)
   //{{AFX_MSG_MAP(CDsmGtDlg)
        ON_BN_CLICKED(IDC_DSM_GOTO_BUTTON1, OnDsmGotoButton1)
        ON_BN_CLICKED(IDC_DSM_GOTO_BUTTON2, OnDsmGotoButton2)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDsmGtDlg message handlers
BOOL CDsmGtDlg::OnInitDialog()
{   
   //CPUMEMORYRANGE stRange;
   char text[20];
    
   CDialog::OnInitDialog();
   
   // TODO: Add extra initialization here
   m_nSpace = 1;
   
   switch (m_nSpace) {
      case 1:
           CheckRadioButton(IDC_DSM_GOTO_RADIO1,
                            IDC_DSM_GOTO_RADIO2,
                            IDC_DSM_GOTO_RADIO1);
           break;
           
      case 2:
           CheckRadioButton(IDC_DSM_GOTO_RADIO1,
                            IDC_DSM_GOTO_RADIO2,
                            IDC_DSM_GOTO_RADIO2);
           break;
           
      default:
           break;
   }
   sprintf(text,"0x%lX",m_lAddress);
   SetDlgItemText(IDC_DSM_GOTO_EDIT1,text);
   CWnd* ctrl;
   ctrl=GetDlgItem(IDC_DSM_GOTO_EDIT1);
   ((CEdit *)ctrl)->SetFocus();
   ((CEdit *)ctrl)->SetSel(0,-1);
   if (dwpMax == 0 && dwpMin == 0) {
       GetDlgItem(IDC_DSM_GOTO_RADIO1)->EnableWindow(FALSE);
   }
   if (dwxMax == 0 && dwxMin == 0) {
       GetDlgItem(IDC_DSM_GOTO_RADIO2)->EnableWindow(FALSE);     
   }

   return FALSE;  // return TRUE  unless you set the focus to a control
}

void CDsmGtDlg::OnDsmGotoButton1()
{
   // TODO: Add your control notification handler code here
   char *buf;
   char *adrerror;
   int i;              
   char value[10];
   
   // Add by Daniel Lin on 03/11/1996
   // For Address server      
   //
   CString       text;
   ADDRESS       startAddress;
   ADDR_RETCODE  retCode;
   CString       error;                    
   CWnd          *ctrl;
            
   buf = new char[25];
   ASSERT(NULL != buf);   
   adrerror = new char[60];
   ASSERT(NULL != adrerror);
   memset(adrerror, 0, sizeof(adrerror));
   memset(buf, 0, sizeof(buf));   
   strcpy(adrerror, "Input Error! The value range is ");
   i = GetCheckedRadioButton(IDC_DSM_GOTO_RADIO1,
                             IDC_DSM_GOTO_RADIO2);
   switch (i) {
      case IDC_DSM_GOTO_RADIO1:
           m_nSpace = 1;
           break;
           
      case IDC_DSM_GOTO_RADIO2:
           m_nSpace = 2;
           break;
           
     default:
           break;
   }
   
   GetDlgItemText(IDC_DSM_GOTO_EDIT1, buf, 10);
   text = buf;
   retCode = AdrTextToAddr(text, startAddress);
   if (ADR_OK != retCode) {
     MessageBeep(-1);
     AdrErrorDeal(retCode, error);      
     MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
     ctrl = GetDlgItem(IDC_DSM_GOTO_EDIT1);
     ((CEdit *)ctrl)->SetFocus();
     ((CEdit *)ctrl)->SetSel(0, -1);
         
     return;
   }
   
   switch( m_nSpace ) {
       case 1:
            itoa( (int)dwpMin, value, 16 );
            strcat( adrerror, "0x" );
            strcat( adrerror, value );
            strcat( adrerror, "..0x" );
            itoa( (int)dwpMax, value, 16 );
            strcat( adrerror, value );
            startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                  
            if (!AdrCheckAddrRange(startAddress)) {
                MessageBeep(-1);
                MessageBox(adrerror, "Input Error", 
                           MB_OK|MB_ICONEXCLAMATION);
                ctrl = GetDlgItem(IDC_DSM_GOTO_EDIT1);
                ((CEdit *)ctrl)->SetFocus();
                ((CEdit *)ctrl)->SetSel(0, -1);
                      
                return;
            }
            
            break;
                  
       case 2:
            itoa( (int)dwxMin, value, 16 );
            strcat( adrerror, "0x" );
            strcat( adrerror, value );
            strcat( adrerror, "..0x" );
            itoa( (int)dwxMax, value, 16 );
            strcat( adrerror, value );
            startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                                    
            if (!AdrCheckAddrRange(startAddress)) {
                MessageBeep(-1);
                MessageBox(adrerror, "Input Error", 
                           MB_OK|MB_ICONEXCLAMATION);
                ctrl = GetDlgItem(IDC_DSM_GOTO_EDIT1);
                ((CEdit *)ctrl)->SetFocus();
                ((CEdit *)ctrl)->SetSel(0, -1);
                      
                return;
            }
            
            break;
   }
   
   m_lAddress = startAddress.adrAddress;

   if (NULL != buf) delete []buf;
   if (NULL != adrerror) delete []adrerror;
   
   EndDialog(1);
}

void CDsmGtDlg::OnDsmGotoButton2()
{
   // TODO: Add your control notification handler code here
   EndDialog(0);
}
