
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/EMUJUMP.CPP   1.7.1.0.1.0   11 Nov 1996 12:57:40   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/EMUJUMP.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:40   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:58   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:25:30   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:52:38   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:45:26   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:28   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:52:38   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:33:44   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:20   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:17:08   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:30   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:54:54   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:33:56   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:48:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:30:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:36   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:34   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:32   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:02   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:30   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:16   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:52   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:30   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:12   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:46   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:30:36   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:40   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:20   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:18   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:38   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:48   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:40   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:06   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:10   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:36   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUJUMP.CPP
//
//  Description: The implementation file for the class: CEmulationJump.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationJump.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
                     
#include "basictyp.h"                     
#include "emujump.h"
#include "errcodec.h"                       
#include "cpust.h" //john 96.4
extern void ErrShow(U32 errorCode,BOOL bUI);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
extern void ErrShow(U32 errorCode,BOOL bUI);
void JumpCmd(int nArgc, char* pszArgv[]);
void EmuServerJump(unsigned short uAddr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetReg(int iRegId, UINT uRegValue);
#endif  // _SERVER_NO_ABI



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   JumpCmd().
//
//  Description: The main control routine of Jump command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void JumpCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Jump command.
    CEmulationJump* pEmulationJump = new CEmulationJump;
    if ( !pEmulationJump ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationJump->JumpAction(nArgc, pszArgv);
        delete pEmulationJump;
    }

//    CEmulationJump objJump;
//    objJump.JumpAction(nArgc, pszArgv);

}   // End of JumpCmd().

// Jump server.
void EmuServerJump(unsigned short uAddr)
{
    // Assertion of the input parameters.
    
    // Execute Jump command.
    CEmulationJump* pEmulationJump = new CEmulationJump;
    if ( !pEmulationJump ) {
        ::ErrShow(ER_EMU_INSUFFICIENT_MEMORY,TRUE);
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationJump->EmuServerJump(uAddr);
        delete pEmulationJump;
    }

}   // End of EmuServerJump().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationJump.

// Construction.
CEmulationJump::CEmulationJump()
{

}   // End of CEmulationJump::CEmulationJump().


// Destruction.
CEmulationJump::~CEmulationJump()
{

}   // End of CEmulationJump::~CEmulationJump().


// Emulation Jump command.
void CEmulationJump::JumpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Set the parameters.
    switch ( nArgc ) {
        case 2:
            // Jump adr
            m_nRegID = PC;
            SetAddrVar(pszArgv[1], m_JumpAddr);
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Jump kernel.
    JumpKernel();

}   // End of CEmulationJump::JumpAction().


// Jump kernel routine.
void CEmulationJump::JumpKernel(void)
{
    // Assertion of the input parameters.
    
    // Test parameters.
    //DumpVar(m_nRegID);
    //DumpVar((unsigned long)m_JumpAddr.m_uAddr);
    //john 96.4
    if(GetXviewAppJohn()->m_nCpuStatus == STATUS_GO) {
    	if ( !m_isServer ) ::ErrShow(ER_GOFLY_ERR_MSG,FALSE);
        	else ::ErrShow(ER_GOFLY_ERR_MSG,TRUE);
        return;	
    }
    // Call the ABI function.
    m_nErrorID = AbiSetReg(m_nRegID, (unsigned int)m_JumpAddr.m_uAddr);
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }

}   // End of CEmulationJump::JumpKernel().


// Jump server.
void CEmulationJump::EmuServerJump(unsigned short uAddr)
{
    // Assertion of the input parameters.

    // Set the parameters.
    m_nRegID = PC;
    m_JumpAddr = CMemoryAddr(uAddr, MEM_PROGRAM);
    
    // Call the Jump kernel.
    m_isServer = TRUE;
    JumpKernel();

}   // End of CEmulationJump::EmuServerJump().

//////////////////////////////// End of File ////////////////////////////////
