
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/EMUSTEP.H__   1.7.1.0.1.0   11 Nov 1996 12:57:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/EMUSTEP.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:50   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:14:24   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:25:58   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:04   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:45:50   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:48   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:52:58   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:12   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:48   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:22   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:12   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:26   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:08   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:30   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:18   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:40   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:34   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:08:58   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:58   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:28   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:40   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:10   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:52   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:54   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:00   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:44   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:32   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:26   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:18   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:38   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:36   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:50:04   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:54:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:42   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:44   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUSTEP.H
//
//  Description: The header file for the class: CEmulationStep.
//               And for the STEPOption command.
//
//  Author: Chen Jun
//
//  Date: 05/10/95
//
//  Modification:
//      1. 05/10/95, Initial version of the class: CEmulationStep.
//      2. 05/10/95, Initial version of the command: STEPOption.
//      3. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _EMUSTEP_
#define _EMUSTEP_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CEmulationStep class.
class CEmulationStep : public CMemoryBase
{
// Construction & Destruction.
public:
    CEmulationStep();
    ~CEmulationStep();
    
// Member variables.
private:
    BOOL m_isStepOver;
    BOOL m_isStepForever;
    BOOL m_isStepCount;
    BOOL m_isTillCall;
    BOOL m_isTillRet;
    BOOL m_isAddr;
    BOOL m_isRegMatch;
    BOOL m_isMemMatch;
    BOOL m_isIntoCall;
    BOOL m_isOverRet;
    
    unsigned short m_uStepCount;    // Step counter.

    CMemoryAddr m_FromAddr, m_TillAddr; // Address range.

    unsigned short m_uInputCount;   // Input count.
    
    int m_nRegID;                   // Register ID.
    unsigned int m_uRegData;        // Input Register value.
    
    CMemoryAddr m_MatchAddr;        // Matched address.
    unsigned char m_uchMemData;     // Input Memory value.
    
    CMemoryAddr m_TestAddr;
    
    enum { INSTRUCTION = 0, STATEMENT, LINE };
    int m_nStepOption;
    
    unsigned short m_uBpAddr;
    
protected:

public:

// Implementations.
private:
    void StepKernel(void);
    void StepRangeKernel(void);

    void DisplayStepCount(void);
    BOOL StepMatchCount(void);
    BOOL StepMatchCall(void);
    BOOL StepMatchRet(void);
    BOOL StepMatchAddr(void);
    BOOL StepMatchReg(void);
    BOOL StepMatchMem(void);
    void GetStepRange(unsigned short& uStart, unsigned short& uEnd);
    
    void UpdateAllWindows(void);

    void StepOptionKernel(void);

protected:

public:
    void StepAction(int nArgc, char* pszArgv[]);
    void StepOptionAction(int nArgc, char* pszArgv[]);

    void EmuServerStep(long lCount);
    void EmuServerStepOver(long lCount);

};  // End of class: CEmulationStep.

#endif
//////////////////////////////// End of File ////////////////////////////////
