
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/JSYNLIB.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:14   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/JSYNLIB.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:14   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:46   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:16   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:22   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:52:10   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:42   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:44   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:31:12   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:04:28   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:20   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:56   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:03:22   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:24   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:10   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:28   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:40   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:32   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:12   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:10   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:14:30   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:11:14   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:38   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:22   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:42   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:14   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:48   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:02   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:44   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:20   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:40   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:54   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:46   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.3   29 Sep 1995 09:50:36   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:06   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:00   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:54   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.CPP
//
//  Description: The implementation file for the class: CSyntaxLibJ.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLibJ.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include <ctype.h>

#include "jsynlib.h"
#include "cpucom.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxLibJ.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLibJ::CSyntaxLibJ().
//
//  Description: The construction of the class: CSyntaxLibJ.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLibJ::CSyntaxLibJ()
{
    // Maximum of the memory type.
    m_ulMaxTypeP = 0x0FFFF;
    m_ulMaxTypeX = 0x0FFFF;
    m_ulMaxTypeI = 0x0FF;
    m_ulMaxTypeR = 0x0FF;
    m_ulMaxTypeB = 0x0FF;

}   // End of CSyntaxLibJ::CSyntaxLibJ().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLibJ::~CSyntaxLibJ().
//
//  Description: The destruction of the class: CSyntaxLibJ.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLibJ::~CSyntaxLibJ()
{

}   // End of CSyntaxLibJ::~CSyntaxLibJ().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLibJ::StrToVar().
//
//  Description: Convert the string to an unsigned long value.
//
//  Input:  pszConvStr - The string to be converted.
//
//  Output: None.
//
//  Return: An unsigned long value.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long CSyntaxLibJ::StrToVar(char* pszConvStr) const
{
    // Assertion of the input parameters.
    ASSERT( pszConvStr );
    
    // Convertion.
    char* pszStopStr;
    unsigned long ul = strtoul(pszConvStr, &pszStopStr, 16);
    
    // Return.
    return (ul);

}   // End of CSyntaxLibJ::StrToVar().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLibJ::Is***().
//
//  Description: Syntax checking lib routines.
//
//  Input:  pszArgv - Token arguments of command.
//
//  Output: None.
//
//  Return: FALSE - error; TRUE - pass.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxLibJ::IsAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "p:xxxx".
    if ( IsPAddr(pszArgv) ) {
        return (TRUE);
    }
    
    // Is "x:xxxx".
    else if ( IsXAddr(pszArgv) ) {
        return (TRUE);
    }
    
    // Is "i:xx".
    else if ( IsIAddr(pszArgv) ) {
        return (TRUE);
    }
    
    // Is "r:xx".
    else if ( IsRAddr(pszArgv) ) {
        return (TRUE);
    }
    
    // Is "b:xx".
    else if ( IsBAddr(pszArgv) ) {
        return (TRUE);
    }
    
    // Error.
    return (FALSE);
}


BOOL CSyntaxLibJ::IsPAddr(char* pszArgv) const
{
    // Is "p:xxxx".
    char* p;
    if ( 'P' != toupper(pszArgv[0]) || ':' != pszArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (pszArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(pszArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsPAddrDefault(char* pszArgv) const
{
    // Is "xxxx".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsXAddr(char* pszArgv) const
{
    // Is "x:xxxx".
    char* p;
    if ( 'X' != toupper(pszArgv[0]) || ':' != pszArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (pszArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeX ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsXAddrDefault(char* pszArgv) const
{
    // Is "xxxx".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeX ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsIAddr(char* pszArgv) const
{
    // Is "i:xxxx".
    char* p;
    if ( 'I' != toupper(pszArgv[0]) || ':' != pszArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (pszArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeI ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsRAddr(char* pszArgv) const
{
    // Is "r:xxxx".
    char* p;
    if ( 'R' != toupper(pszArgv[0]) || ':' != pszArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (pszArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeR ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsBAddr(char* pszArgv) const
{
    // Is "b:xxxx".
    char* p;
    if ( 'B' != toupper(pszArgv[0]) || ':' != pszArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (pszArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeB ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsBAddrDefault(char* pszArgv) const
{
    // Is "xxxx".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeB ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsAddrLen(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x010000ul ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsKeywordLength(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, "LENGTH") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
        
}


// Is in the range: "addr Length length".
BOOL CSyntaxLibJ::IsLengthRange(char* pszAddr, char* pszLen) const
{
    // Assertion of the input parameters.
    ASSERT( pszAddr && pszLen );
    
    // Default X: address.
    if ( ':' != *(pszAddr+1) ) {
        if ( StrToVar(pszAddr) + StrToVar(pszLen) > m_ulMaxTypeX+1 ) {
            return (FALSE);
        }
        else {
            return (TRUE);
        }
    }

    // Address with space specifier.
    switch ( toupper(*pszAddr) ) {
        case 'P':
            if ( StrToVar(pszAddr+2) + StrToVar(pszLen) > m_ulMaxTypeP+1 ) {
                return (FALSE);
            }
            break;
        case 'X':
            if ( StrToVar(pszAddr+2) + StrToVar(pszLen) > m_ulMaxTypeX+1 ) {
                return (FALSE);
            }
            break;
        case 'I':
            if ( StrToVar(pszAddr+2) + StrToVar(pszLen) > m_ulMaxTypeI+1 ) {
                return (FALSE);
            }
            break;
        case 'R':
            if ( StrToVar(pszAddr+2) + StrToVar(pszLen) > m_ulMaxTypeR+1 ) {
                return (FALSE);
            }
            break;
        case 'B':
            if ( StrToVar(pszAddr+2) + StrToVar(pszLen) > m_ulMaxTypeB+1 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsAddrRange(char* pszAddr1, char* pszAddr2) const
{
    // Assertion of the input parameters.
    ASSERT( pszAddr1 && pszAddr2 );
    
    // Is "addr2 >= addr1".
    char* p1 = (':' == pszAddr1[1]) ? pszAddr1+2 : pszAddr1;
    char* p2 = (':' == pszAddr2[1]) ? pszAddr2+2 : pszAddr2;
    
    if ( StrToVar(p1) > StrToVar(p2) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsMapStartAddr(char* pszArgv) const
{
    // Is "p:xxxx".
    if ( !IsPAddr(pszArgv) &&
         !IsXAddr(pszArgv) &&
         !IsXAddrDefault(pszArgv) ) {
        return (FALSE);
    }

    char* p1 = (':' == pszArgv[1]) ? pszArgv+2 : pszArgv;
    char* p2 = p1;
    if ( strlen(p1) < 1 ) {
        return (FALSE);
    }
    while ( *p1 ) {
        if ( !isxdigit(*(p1++)) ) {
            return (FALSE);
        }    
    }

    unsigned long ul = StrToVar(p2);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsMapEndAddr(char* pszArgv) const
{
    // Is "p:xxxx".
    if ( !IsPAddr(pszArgv) &&
         !IsXAddr(pszArgv) &&
         !IsXAddrDefault(pszArgv) ) {
        return (FALSE);
    }

    char* p1 = (':' == pszArgv[1]) ? pszArgv+2 : pszArgv;
    char* p2 = p1;
    if ( strlen(p1) < 1 ) {
        return (FALSE);
    }
    while ( *p1 ) {
        if ( !isxdigit(*(p1++)) ) {
            return (FALSE);
        }    
    }

    unsigned long ul = StrToVar(p2);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    else if ( 0 != ((ul+1) % 0x080) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsMapAddrLen(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x010000ul ) {
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsMapMemType(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "X:...".
    if ( 2 != strlen(pszArgv) ) {
        return (FALSE);
    }
    
    if ( ':' != pszArgv[1] ) {
        return (FALSE);
    }
    
    if ( 'P' != toupper(pszArgv[0]) &&
         'X' != toupper(pszArgv[0]) ) {
        return (FALSE);
    }
    
    return (TRUE);
}


BOOL CSyntaxLibJ::IsMapAttr(char chType, char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    ASSERT( 'P' == toupper(chType) || 'X' == toupper(chType) );
    
    // Is "attribute".
    if ( !stricmp(pszArgv, "I") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "IR") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "G") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "E") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "ER") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "C") ) {
        if ( 'X' == toupper(chType) ) {
            return (TRUE);
        }
        else {
            return (FALSE);
        }
    }
    else if ( !stricmp(pszArgv, "CR") ) {
        if ( 'X' == toupper(chType) ) {
            return (TRUE);
        }
        else {
            return (FALSE);
        }
    }
    else {
        return (FALSE);
    }
}


BOOL CSyntaxLibJ::IsRegName(char* pszRegName) const
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    
#ifdef _SERVER_NO_ABI
    char* RegName[28] = {
        "PC",   "DPTR", "ACC",  "B",    "SP",   "PSW",
        "R0",   "R1",   "R2",   "R3",   "R4",   "R5",
        "R6",   "R7",   "IE",   "IP",   "SCON", "TMOD", 
        "TH0",  "TL0",  "TH1",  "TL1",  "TCON", "T2CON",
        "P0",   "P1",   "P2",   "P3"
    };
    int nMaxReg = 28;
#endif  // _SERVER_NO_ABI

    // Is in "RegName[]".
    CString str = strupr(pszRegName);
    for ( int i= 0; i < nMaxReg; i++ ) {
        if ( str == RegName[i] ) {
            return (TRUE);
        }
    }
    return (FALSE);
}


BOOL CSyntaxLibJ::IsRegData(char* pszRegName, char* pszRegData) const
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    ASSERT( pszRegData );
    
    // Is "REG DATA".
    char* p = pszRegData;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    CString str = strupr(pszRegName);
    unsigned long ul = StrToVar(pszRegData);
    if ( str == "PC" || str == "DPTR" ) {
        if ( ul < 0ul || ul > 0x0FFFFul ) {
            return (FALSE);
        }
    }
    else {
        if ( ul < 0ul || ul > 0x0FFul ) {
            return (FALSE);
        }
    }
    
    return (TRUE);
}


BOOL CSyntaxLibJ::IsKeywordAll(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, "ALL") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}


BOOL CSyntaxLibJ::IsFilename(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "filename".
    if ( strlen(pszArgv) >= _MAX_PATH ) {
        return (FALSE);
    }

    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
        return (FALSE);
    }
      
    // Local driver: "..." invalid.
    // Netware driver: "..." valid.
    //if ( strstr(pszArgv, "...") ) {
    //    return (FALSE);
    //}
        
    if ( strstr(pszArgv, "\\\\") ||
         strstr(pszArgv, "//")   ||
         strstr(pszArgv, "\\/")  ||
         strstr(pszArgv, "/\\") ) {
        return (FALSE);
    }
    
    char pszDrive[_MAX_DRIVE];
    char pszDir[_MAX_DIR];
    char pszFname[_MAX_FNAME];
    char pszExt[_MAX_EXT];

    _splitpath(pszArgv, pszDrive, pszDir, pszFname, pszExt);

    //DumpText(pszDrive);
    //DumpText(pszDir);
    //DumpText(pszFname);
    //DumpText(pszExt);

    if ( strchr(pszDir, ':')   ||
         strchr(pszFname, ':') ||
         strchr(pszExt, ':') ) {
        return (FALSE);
    }
    
    if ( *pszDrive && 
         !(*pszDrive >= 'A' && *pszDrive <= 'Z') &&
         !(*pszDrive >= 'a' && *pszDrive <= 'z') ) {
        return (FALSE);
    }
    
    if ( strchr(pszFname, '.') ) {
        return (FALSE);
    }
    
    if ( !*pszFname ) {
        return (FALSE);
    }
    
    return (TRUE);
}


BOOL CSyntaxLibJ::IsLoadOption(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( nArgc > 2 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    int nSymbols = FALSE, nNoSymbols = FALSE;
    int nCode = FALSE, nNoCode = FALSE;
    // int nProgress = FALSE, nNoProgress = FALSE;
    int nDemand = FALSE, nNoDemand = FALSE;
    int nWarm = FALSE, nNoWarm = FALSE;
    // int nMangle = FALSE, nNoMangle = FALSE;
    int nModule = FALSE;
    int nType = FALSE;
    
    // Is "LOAd filename [option]".
    for ( i = 2; i < nArgc; i++ ) {
        CString str = strupr(pszArgv[i]);
        if ( str == "NOSYMBOLS" ) {
            nNoSymbols = TRUE;
        }
        else if ( str == "SYMBOLS" ) {
            nSymbols = TRUE;
        }
        else if ( str == "NOCODE" ) {
            nNoCode = TRUE;
        }
        else if ( str == "CODE" ) {
            nCode = TRUE;
        }
        /*
        else if ( str == "NOPROGRESS" ) {
            nNoProgress = TRUE;
        }
        else if ( str == "PROGRESS" ) {
            nProgress = TRUE;
        }
        */
        else if ( str == "NODEMAND" ) {
            nNoDemand = TRUE;
        }
        else if ( str == "DEMAND" ) {
            nDemand = TRUE;
        }
        else if ( str == "NOWARN" ) {
            nNoWarm = TRUE;
        }
        else if ( str == "WARN" ) {
            nWarm = TRUE;
        }
        /*
        else if ( str == "NOMANGLE" ) {
            nNoMangle = TRUE;
        }
        else if ( str == "MANGLE" ) {
            nMangle = TRUE;
        }
        */
        else if ( str == "MODULE" ) {
            if ( i < nArgc-1 && IsModuleName(pszArgv[i++]) ) {
                nModule = TRUE;
            }
            else {
                return (FALSE);
            }
        }
        else if ( IsMapMemType(pszArgv[i]) ) {
            if ( TRUE == nType ) {
                return (FALSE);
            }
            nType = TRUE;
        }
        else {
            return (FALSE);
        }
    }
    
    if ( nSymbols && nNoSymbols ) {
        return (FALSE);
    }
    if ( nCode && nNoCode ) {
        return (FALSE);
    }
/*    
    if ( nProgress && nNoProgress ) {
        return (FALSE);
    }
*/    
    if ( nDemand && nNoDemand ) {
        return (FALSE);
    }
/*    
    if ( nMangle && nNoMangle ) {
        return (FALSE);
    }
*/    
    if ( nWarm && nNoWarm ) {
        return (FALSE);
    }

/*
    if ( nModule && nNoSymbols ) {
        return (FALSE);
    }
    if ( nNoCode && nNoSymbols ) {
        return (FALSE);
    }
*/    
    
    return (TRUE);
}


BOOL CSyntaxLibJ::IsModuleName(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "module_name".
    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, ':') ||
         strchr(pszArgv, '\\')||
         strchr(pszArgv, '/') ||
         strchr(pszArgv, '.') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLibJ::IsArgument(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "argument ...".
    return (TRUE);
}


BOOL CSyntaxLibJ::IsBackLevel(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "@n".
    if ( '@' != pszArgv[0] ) {
        return (FALSE);
    }
    char* p = pszArgv+1;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+1);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLibJ::IsVariableName(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
        return (FALSE);
    }
    
    if ( !iscsymf(pszArgv[1]) ) {
        return (FALSE);
    }
    
    if ( '_' == pszArgv[1] && strlen(pszArgv) < 3 ) {
        return (FALSE);
    }
    
    BOOL isUnderscore = FALSE;
    char* p = pszArgv+1;
    if ( '_' == *p ) {
        isUnderscore = TRUE;
    }
            
    while ( *p ) {
        if ( !iscsym(*p) ) {
            return (FALSE);
        }
        else if ( '_' != *(p++) ) {
            isUnderscore = FALSE;
        }
    }

    if ( isUnderscore ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLibJ::IsDataBit(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1 0...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( '0' != *p && '1' != *p && ' ' != *p ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLibJ::IsDataBit().


BOOL CSyntaxLibJ::IsDataLong(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "12345678...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/4 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLibJ::IsDataLong().


BOOL CSyntaxLibJ::IsDataWord(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1234...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/2 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLibJ::IsDataWord().


BOOL CSyntaxLibJ::IsData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "x xx ...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLibJ::IsData().


BOOL CSyntaxLibJ::IsString(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "string".
    if ( strlen(pszArgv) > MAX_FILL_SIZE + 2 || strlen(pszArgv) < 3 ) {
        return (FALSE);
    }

    if ( '\"' != *pszArgv || '\"' != *(pszArgv+strlen(pszArgv)-1) ) {
        return (FALSE);
    }

    char* p = pszArgv;
    while ( *p ) {
        if ( !isalnum(*p) && ('\"' != *p) && (' ' != *p) ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLibJ::IsString().


BOOL CSyntaxLibJ::IsDataRange(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    
    // Check the Data field range.
    switch ( nArgc ) {
        char* p;
        int nCount;
        case 4:
            p = pszArgv[3];
            nCount = 0;
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            if ( StrToVar(pszArgv[2]+2) - StrToVar(pszArgv[1]+2) + 1 
                < (unsigned long) nCount ) {
                return (FALSE);
            }
            break;
        case 5:
            p = pszArgv[4];
            nCount = 0;
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            if ( StrToVar(pszArgv[3]) < (unsigned long) nCount ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    return (TRUE);

}   // End of CSyntaxLibJ::IsDataRange().


BOOL CSyntaxLibJ::IsStringRange(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 4 && nArgc <= 6 );
    
    // Check the Data field range.
    switch ( nArgc ) {
        case 4:
            if ( StrToVar(pszArgv[2]+2) - StrToVar(pszArgv[1]+2) + 1 < 
                 strlen(pszArgv[3]) - 2 ) {
                return (FALSE);
            }
            break;
        case 5:
            if ( IsKeywordInsensitive(pszArgv[3]) ) {
                if ( StrToVar(pszArgv[2]+2) - StrToVar(pszArgv[1]+2) + 1 < 
                     strlen(pszArgv[4]) - 2 ) {
                    return (FALSE);
                }
            }
            else {
                if ( StrToVar(pszArgv[3]) < strlen(pszArgv[4]) - 2 ) {
                    return (FALSE);
                }
            }
            break;
        case 6:
            if ( StrToVar(pszArgv[3]) < strlen(pszArgv[5]) - 2 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    return (TRUE);

}   // End of CSyntaxLibJ::IsStringRange().


BOOL CSyntaxLibJ::IsKeywordInsensitive(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "insensitive".
    if ( 0 == stricmp(pszArgv, "INSENSITIVE") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsKeywordInsensitive().


BOOL CSyntaxLibJ::IsCaseStringRange(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( 5 == nArgc || 6 == nArgc );
    
    // Check the Data field range.
    switch ( nArgc ) {
        case 5:
            if ( StrToVar(pszArgv[3]+2) - StrToVar(pszArgv[2]+2) + 1 < 
                 strlen(pszArgv[4]) - 2 ) {
                return (FALSE);
            }
            break;
        case 6:
            if ( StrToVar(pszArgv[4]) < strlen(pszArgv[5]) - 2 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    return (TRUE);

}   // End of CSyntaxLibJ::IsCaseStringRange().


BOOL CSyntaxLibJ::IsKeywordRun(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Run".
    if ( 0 == stricmp(pszArgv, "RUN") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsKeywordRun().


BOOL CSyntaxLibJ::IsKeywordFrom(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, "FROM") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsKeywordFrom().


BOOL CSyntaxLibJ::IsKeywordTill(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, "TILL") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsKeywordTill().


BOOL CSyntaxLibJ::IsKeywordOver(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "OVER") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordOver().


BOOL CSyntaxLibJ::IsKeywordForever(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "FOREVER") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordForever().


BOOL CSyntaxLibJ::IsKeywordRet(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "RET") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordRet().


BOOL CSyntaxLibJ::IsKeywordCall(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "CALL") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordCall().


BOOL CSyntaxLibJ::IsStepCount(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "FFFF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLibJ::IsStepCount().


BOOL CSyntaxLibJ::IsAddrData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "FFFF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLibJ::IsAddrData().


BOOL CSyntaxLibJ::IsKeywordInstruction(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "instruction".
    return ( 0 == stricmp(pszArgv, "INSTRUCTION") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordInstruction().


BOOL CSyntaxLibJ::IsKeywordStatement(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "statement".
    return ( 0 == stricmp(pszArgv, "STATEMENT") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordStatement().


BOOL CSyntaxLibJ::IsKeywordLine(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Line".
    return ( 0 == stricmp(pszArgv, "LINE") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordLine().


BOOL CSyntaxLibJ::IsKeywordWith(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "With".
    return ( 0 == stricmp(pszArgv, "WITH") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordWith().


BOOL CSyntaxLibJ::IsKeywordClear(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Clear".
    return ( 0 == stricmp(pszArgv, "CLEAR") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordClear().


BOOL CSyntaxLibJ::IsEventID(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "1", "2" or "3".
    if ( 0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsEventID().


BOOL CSyntaxLibJ::IsKeywordHigh(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "High".
    return ( 0 == stricmp(pszArgv, "HIGH") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordHigh().


BOOL CSyntaxLibJ::IsKeywordLow(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Low".
    return ( 0 == stricmp(pszArgv, "LOW") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordLow().


BOOL CSyntaxLibJ::IsKeywordRange(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Range".
    return ( 0 == stricmp(pszArgv, "RANGE") ? TRUE : FALSE );

}   // End of CSyntaxLibJ::IsKeywordRange().


BOOL CSyntaxLibJ::IsWildcardAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Binary or Hexadecimal wildcard code.
    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) ) {
        // Binary code.
        if ( 17 != strlen(pszArgv) ) {
            return (FALSE);
        }
        for ( int i = 0; i < 17-1; i++ ) {
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 17; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code.
        if ( 4 != strlen(pszArgv) ) {
            return (FALSE);
        }
        char* p = pszArgv;
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        }
        for ( int i = 0; i < 4; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsWildcardAddr().


BOOL CSyntaxLibJ::IsWildcardData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Binary or Hexadecimal wildcard code.
    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) ) {
        // Binary code.
        if ( 9 != strlen(pszArgv) ) {
            return (FALSE);
        }
        for ( int i = 0; i < 9-1; i++ ) {
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 9; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code.
        if ( 2 != strlen(pszArgv) ) {
            return (FALSE);
        }
        char* p = pszArgv;
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        }
        for ( int i = 0; i < 2; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }

}   // End of CSyntaxLibJ::IsWildcardData().


BOOL CSyntaxLibJ::IsEventData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "FF".
    if ( strlen(pszArgv) < 1 || strlen(pszArgv) > 2 ) {
        return (FALSE);
    }
    while ( *pszArgv ) {
        if ( !isxdigit(*(pszArgv++)) ) {
            return (FALSE);
        }
    }
    return (TRUE);

}   // End of CSyntaxLibJ::IsEventData().


BOOL CSyntaxLibJ::IsListOption(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Check "SOURCE", "ASSEMBLE", "MIXED" or "MODULE".
    if ( 0 != stricmp(pszArgv, "SOURCE") &&
         0 != stricmp(pszArgv, "ASSEMBLE") &&
         0 != stricmp(pszArgv, "MIXED") &&
         0 != stricmp(pszArgv, "MODULE") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLibJ::IsListOption().


BOOL CSyntaxLibJ::IsListFrame(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "7FFF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x07FFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLibJ::IsListFrame().


BOOL CSyntaxLibJ::IsKeywordTrace(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "TRace".
    return ( 0 == stricmp(pszArgv, "TRACE") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordTrace().


BOOL CSyntaxLibJ::IsKeywordTimer(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "TImer".
    return ( 0 == stricmp(pszArgv, "TIMER") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordTimer().


BOOL CSyntaxLibJ::IsKeywordOn(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ON".
    return ( 0 == stricmp(pszArgv, "ON") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordOn().


BOOL CSyntaxLibJ::IsKeywordOff(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "OFf".
    return ( 0 == stricmp(pszArgv, "OFF") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordOff().


BOOL CSyntaxLibJ::IsEventSequence(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ev1 and ev2...".
    const int nMaxSeq = 40;
    char* pszEventSequence[nMaxSeq] = {
        "ev1 ",
        "ev2 ",
        "ev3 ",
        "ev1 and ev2 ",
        "ev1 and ev3 ",
        "ev2 and ev1 ",
        "ev2 and ev3 ",
        "ev3 and ev1 ",
        "ev3 and ev2 ",
        "ev1 or ev2 ",
        "ev1 or ev3 ",
        "ev2 or ev1 ",
        "ev2 or ev3 ",
        "ev3 or ev1 ",
        "ev3 or ev2 ",
        "ev1 and ev2 and ev3 ",
        "ev1 and ev3 and ev2 ",
        "ev2 and ev1 and ev3 ",
        "ev2 and ev3 and ev1 ",
        "ev3 and ev1 and ev2 ",
        "ev3 and ev2 and ev1 ",
        "ev1 or ev2 or ev3 ",
        "ev1 or ev3 or ev2 ",
        "ev2 or ev1 or ev3 ",
        "ev2 or ev3 or ev1 ",
        "ev3 or ev1 or ev2 ",
        "ev3 or ev2 or ev1 ",
        "ev1 and ev2 or ev3 ",
        "ev1 and ev3 or ev2 ",
        "ev2 and ev1 or ev3 ",
        "ev2 and ev3 or ev1 ",
        "ev3 and ev1 or ev2 ",
        "ev3 and ev2 or ev1 ",
        "ev1 or ev2 and ev3 ",
        "ev1 or ev3 and ev2 ",
        "ev2 or ev1 and ev3 ",
        "ev2 or ev3 and ev1 ",
        "ev3 or ev1 and ev2 ",
        "ev3 or ev2 and ev1 ",
        ""
    };
    
    for ( int i = 0; i < nMaxSeq; i++ ) {
        if ( 0 == stricmp(pszArgv, pszEventSequence[i]) ) {
            return (TRUE);
        }
    }
    return (FALSE);

}   // End of CSyntaxLibJ::IsEventSequence().


BOOL CSyntaxLibJ::IsKeywordReset(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Reset".
    return ( 0 == stricmp(pszArgv, "RESET") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordReset().


BOOL CSyntaxLibJ::IsKeywordEa(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Ea".
    return ( 0 == stricmp(pszArgv, "EA") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordEa().


BOOL CSyntaxLibJ::IsKeywordEnable(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Enable".
    return ( 0 == stricmp(pszArgv, "ENABLE") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordEnable().


BOOL CSyntaxLibJ::IsKeywordDisable(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Disable".
    return ( 0 == stricmp(pszArgv, "DISABLE") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordDisable().


BOOL CSyntaxLibJ::IsKeywordBit(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Bit".
    return ( 0 == stricmp(pszArgv, "BIT") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordBit().


BOOL CSyntaxLibJ::IsKeywordByte(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Byte".
    return ( 0 == stricmp(pszArgv, "BYTE") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordByte().


BOOL CSyntaxLibJ::IsCpuModule(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "80C32".
    return ( 0 == stricmp(pszArgv, "80C32") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsCpuModule().


BOOL CSyntaxLibJ::IsPort(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "0123".
    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLibJ::IsPort().


BOOL CSyntaxLibJ::IsBitNo(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "01234567".
    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ||
         0 == stricmp(pszArgv, "4") ||
         0 == stricmp(pszArgv, "5") ||
         0 == stricmp(pszArgv, "6") ||
         0 == stricmp(pszArgv, "7") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLibJ::IsBitNo().


BOOL CSyntaxLibJ::IsBitData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "0|1".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x01ul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLibJ::IsBitData().


BOOL CSyntaxLibJ::IsByteData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "FF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLibJ::IsByteData().


BOOL CSyntaxLibJ::IsKeywordGlobal(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "GLOBAL".
    return ( 0 == stricmp(pszArgv, "GLOBAL") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordGlobal().


BOOL CSyntaxLibJ::IsLineNo(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
        return (FALSE);
    }

    char* p = pszArgv + 1;
    while ( *p ) {
        if ( !isdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    return (TRUE);

}   // End of CSyntaxLibJ::IsLineNo().


BOOL CSyntaxLibJ::IsKeywordClose(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Close".
    return ( 0 == stricmp(pszArgv, "CLOSE") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordClose().


BOOL CSyntaxLibJ::IsKeywordAppend(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Append".
    return ( 0 == stricmp(pszArgv, "APPEND") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordAppend().


BOOL CSyntaxLibJ::IsKeywordCommand(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Command".
    return ( 0 == stricmp(pszArgv, "COMMAND") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordCommand().


BOOL CSyntaxLibJ::IsKeywordLv1(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv1".
    return ( 0 == stricmp(pszArgv, "LV1") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordLv1().


BOOL CSyntaxLibJ::IsKeywordLv2(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv2".
    return ( 0 == stricmp(pszArgv, "LV2") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordLv2().


BOOL CSyntaxLibJ::IsKeywordForward(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Forward".
    return ( 0 == stricmp(pszArgv, "FORWARD") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordForward().


BOOL CSyntaxLibJ::IsKeywordBackward(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Backward".
    return ( 0 == stricmp(pszArgv, "BACKWARD") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordBackward().


BOOL CSyntaxLibJ::IsKeywordCenter(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Center".
    return ( 0 == stricmp(pszArgv, "CENTER") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordCenter().


BOOL CSyntaxLibJ::IsKeywordDelay(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Delay".
    return ( 0 == stricmp(pszArgv, "DELAY") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordDelay().


BOOL CSyntaxLibJ::IsKeywordThen(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Then".
    return ( 0 == stricmp(pszArgv, "THEN") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordThen().


BOOL CSyntaxLibJ::IsKeywordModule(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Module".
    return ( 0 == stricmp(pszArgv, "MODULE") ) ? TRUE : FALSE;

}   // End of CSyntaxLibJ::IsKeywordModule().


BOOL CSyntaxLibJ::IsCommand(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "command".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isalpha(*pszArgv) ) {
            return (FALSE);
        }
        else {
            p++;
        }
    }
    return (TRUE);

}   // End of CSyntaxLibJ::IsCommand().

//////////////////////////////// End of File ////////////////////////////////
