
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMBYTE.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMBYTE.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:50   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:26   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:58   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:02   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:02   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:36   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:56   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:36:48   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:01:26   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:42   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:30:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:54:56   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:34:00   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:48:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:42   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:56   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:42   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:50   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:44   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:30   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:16   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:56   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:02   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:08   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:10   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:52   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:22   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:04:02   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:42   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:04   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:02   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:20   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:16   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:42   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBYTE.CPP
//
//  Description: The implementation file for the class: CMemoryByte.
//
//  Author: Chen Jun
//
//  Date: 04/26/95
//
//  Modification:
//      1. 04/26/95, Initial version of the class: CMemoryByte.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "membyte.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void ByteCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char&);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   ByteCmd().
//
//  Description: The main control routine of Byte command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void ByteCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Byte to EMM.
    char error[128];
    CMemoryByte* pMemoryByte = new CMemoryByte;
    if ( !pMemoryByte ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryByte->ByteAction(nArgc, pszArgv);
            delete pMemoryByte;
          }           
       }   
    }

//    CMemoryByte objByte;
//    objByte.SetByte(nArgc, pszArgv);

}   // End of ByteCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryByte.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryByte::CMemoryByte().
//
//  Description: The construction of the class: CMemoryByte.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryByte::CMemoryByte()
{

}   // End of CMemoryByte::CMemoryByte().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryByte::~CMemoryByte().
//
//  Description: The destruction of the class: CMemoryByte.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryByte::~CMemoryByte()
{

}   // End of CMemoryByte::~CMemoryByte().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryByte::ByteAction().
//
//  Description: Set Byte value to EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryByte::ByteAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set address & pattern.
    if ( 3 == nArgc ) {
        // Byte adr data.
        SetAddrVar(pszArgv[1], m_Addr);
        SetPattern(pszArgv[2]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_Addr.m_uchType = MEM_EXTERNAL;
    }
    
    // Memory Byte kernel routine.
    MemoryByteKernel();
        
}   // End of CMemoryByte::ByteAction().


void CMemoryByte::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    m_uPatternLen = 0;
    while ( *pszPattern ) {
        char pszData[3];
        memset(pszData, 0, sizeof(pszData));
        for ( int i = 0; i <= 2; i++ ) {
            if ( ' ' != *pszPattern ) {
                pszData[i] = *pszPattern++;
            }
            else {
                pszPattern++;
                break;
            }
        }
        StrToVar(pszData);
        ((BYTE*) m_pchByte)[m_uPatternLen/1] = (BYTE) m_ulVar;
        m_uPatternLen += 1;
    }

}   // End of CMemoryByte::SetPattern().


void CMemoryByte::MemoryByteKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiSetMemN((ADDR&) m_Addr, m_pchByte, m_uPatternLen);

    // Update Source window.
    if ( MEM_PROGRAM == m_Addr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryByte::MemoryDumpKernel().


//////////////////////////////// End of File ////////////////////////////////
