
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMCOPY.CPP   1.7.1.0.1.0   11 Nov 1996 13:00:08   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMCOPY.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:08   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:10   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:40   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:44   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:00   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:48   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:48   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:34:38   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:04   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:38   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:30:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:56:08   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:08   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:26   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:12   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:24   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:28   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:46   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:16   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:32   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:30   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:50   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:52   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:12   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:28   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:38   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:02   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:38   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:07:50   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:45:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:26   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:42   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:40   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:30   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:42   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:45:52   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:44   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMCOPY.CPP
//
//  Description: The implementation file for the class: CMemoryCopy.
//
//  Author: Chen Jun
//
//  Date: 05/04/95
//
//  Modification:
//      1. 05/04/95, Initial version of the class: CMemoryCopy.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memcopy.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void CopyCmd(int nArgc, char* pszArgv[]);
void MemServerCopy(unsigned short uStart, unsigned short uEnd,
    unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiCopy(ADDR addr1, ADDR addr2, ADDR destAddr);
#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CopyCmd().
//
//  Description: The main control routine of Copy command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CopyCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Copy EMM contents.
    char error[128];
    CMemoryCopy* pMemoryCopy = new CMemoryCopy;
    if ( !pMemoryCopy ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryCopy->CopyAction(nArgc, pszArgv);
            delete pMemoryCopy;
          }           
       }   
    }

//    CMemoryCopy objCopy;
//    objCopy.MemoryCopy(nArgc, pszArgv);

}   // End of CopyCmd().


// Memory Copy server.
void MemServerCopy(unsigned short uStart, unsigned short uEnd,
    unsigned short uTarget, 
    unsigned char uchSourceType, unsigned char uchTargetType)
{
    // Assertion of the input parameters.

    // Copy EMM contents.
    CMemoryCopy* pMemoryCopy = new CMemoryCopy;
    if ( !pMemoryCopy ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pMemoryCopy->MemServerCopy(uStart, uEnd, uTarget, 
            uchSourceType, uchTargetType);
        delete pMemoryCopy;
    }

}   // End of MemServerCopy().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryCopy.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCopy::CMemoryCopy().
//
//  Description: The construction of the class: CMemoryCopy.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryCopy::CMemoryCopy()
{

}   // End of CMemoryCopy::CMemoryCopy().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCopy::~CMemoryCopy().
//
//  Description: The destruction of the class: CMemoryCopy.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryCopy::~CMemoryCopy()
{

}   // End of CMemoryCopy::~CMemoryCopy().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryCopy::CopyAction().
//
//  Description: Copy to EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryCopy::CopyAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 4 == nArgc ) {
        // Copy adr1 adr2 adr3.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
        SetAddrVar(pszArgv[3], m_TargetAddr);
        if ( ':' != pszArgv[3][1] ) {
            if ( ':' != pszArgv[1][1] ) {
                m_TargetAddr.m_uchType = MEM_EXTERNAL;
            }
            else {
                m_TargetAddr.m_uchType = m_StartAddr.m_uchType;
            }
        }
    }
    else if ( 5 == nArgc ) {
        // Copy adr1 Length length adr3.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
        SetAddrVar(pszArgv[4], m_TargetAddr);
        if ( ':' != pszArgv[4][1] ) {
            if ( ':' != pszArgv[1][1] ) {
                m_TargetAddr.m_uchType = MEM_EXTERNAL;
            }
            else {
                m_TargetAddr.m_uchType = m_StartAddr.m_uchType;
            }
        }
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_StartAddr.m_uchType = MEM_EXTERNAL;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;

    // Memory Copy kernel routine.
    MemoryCopyKernel();
        
}   // End of CMemoryCopy::CopyAction().


void CMemoryCopy::MemoryCopyKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = 
        AbiCopy((ADDR&)m_StartAddr, (ADDR&)m_EndAddr, (ADDR&)m_TargetAddr);
        
    // Update Source window.
    if ( MEM_PROGRAM == m_TargetAddr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryCopy::MemoryCopyKernel().


// Memory Copy server.
void CMemoryCopy::MemServerCopy(unsigned short uStart, unsigned short uEnd,
        unsigned short uTarget, 
        unsigned char uchSourceType, unsigned char uchTargetType)
{
    // Assertion of the input parameters.
    ASSERT( uchSourceType >= MEM_PROGRAM && uchSourceType <= MEM_BIT );
    ASSERT( uchTargetType >= MEM_PROGRAM && uchTargetType <= MEM_BIT );
    
    // Set the server flag.
    m_isServer = TRUE;
        
    // Set the parameters.
    m_StartAddr = CMemoryAddr(uStart, uchSourceType);
    m_EndAddr = CMemoryAddr(uEnd, uchSourceType);
    m_TargetAddr = CMemoryAddr(uTarget, uchTargetType);
    
    // Memory Copy kernel routine.
    MemoryCopyKernel();

}   // End of CMemoryCopy::MemServerCopy().

//////////////////////////////// End of File ////////////////////////////////
