
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMMAP.H__   1.7.1.0.1.0   11 Nov 1996 12:59:36   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMMAP.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:36   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:40   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:12   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:16   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:46   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:20   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:24   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:30:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:58   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:48   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:26   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:26   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:50   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:10   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:00   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:56   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:26   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:00   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:02   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:28   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:04   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:30   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:54   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:04   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:18   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:18   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:36   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:02   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:50   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMMAP.H
//
//  Description: The header file for the class: CMemoryMap.
//
//  Author: Chen Jun
//
//  Date: 04/18/95
//
//  Modification:
//      1. 04/18/95, Initial version of the class: CMemoryMap.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMMAP_
#define _MEMMAP_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryMap class.
class CMemoryMap : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryMap();
    ~CMemoryMap();
    
// Member variables.
private:
    enum { MAP_I = 0,
           MAP_IR,
           MAP_E,
           MAP_ER,
           MAP_C,
           MAP_CR,
           MAP_G
    };

    struct tagMapInfo {
        CMemoryAddr StartAddr;
        CMemoryAddr EndAddr;
        char chMapAttr;
    };
    
    tagMapInfo m_MapInfo;

    CMemoryAddr m_StartAddr, m_EndAddr;

// Implementations.
private:
    void GetMap(void);
    void SetMap(int nArgc, char* pszArgv[]);
    void DisplayMapHead(void) const;
    void FormatMapInfo(void);
    void GetMapInfo(int nMemType);
    void SetMapAttr(char* pszArgv);
    void SetMapInfo(void);

public:
    void MapAction(int nArgc, char* pszArgv[]);
    void MemServerSetMap(const unsigned short uStart, 
        const unsigned short uEnd, const unsigned char uchType, 
        const char chMapAttr);
    BOOL MemServerGetMap(unsigned short& uStart, unsigned short& uEnd,
        unsigned char& uchType, char& chMapAttr);

};  // End of class: CMemoryMap.

#endif
//////////////////////////////// End of File ////////////////////////////////
