
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ORDTBL.H__   1.7.1.0.1.0   11 Nov 1996 12:58:16   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ORDTBL.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:16   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:30   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:27:02   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:08   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:44   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:22   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:42   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:38:28   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:46   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:12   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:52   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:36:56   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:54   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:38   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:08   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:13:00   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:38   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:26   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:14   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:12   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:00   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:24   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:04   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:06   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:22   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:40   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:36   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:32   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:34   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:38   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:04   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:42   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:56   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:00   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:54   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: ordtbl.h
**
** Title: Ordinal Table
**
** Purpose:
**  Class and methods for managing the ordinal table - list of offsets to
**  symbols in the order they are loaded.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/ORDTBL.H__   1.7.1.0.1.0   11 Nov 1996 12:58:16   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _ORDTBL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "mempool.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef U32 ORDINAL_INDEX;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

class OrdinalTable : public MemPool {

public:

//------------------------------------------------------------------------
// OrdinalTable() - contructor
//
// Purpose:
//    Initialize ordinal table variables for table creation and expansion.
//---------------------------------------------------------------------------
OrdinalTable();    // constructor


//------------------------------------------------------------------------
// AddSymOffsetToOT
//
// Purpose:
//    Put the offset to the symbol into the next free space in the ordinal
//    table.  Return the index number where loaded.
//
// Input parameters:
//    symOffset:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    ordinalIndex:
//       ORDINAL_INDEX index (into ordinal table) where symbol offset placed
//
// Error:
//    Returns calling error messages
//------------------------------------------------------------------------
RETCODE
AddSymOffsetToOT(TABLE_OFFSET symOffset, ORDINAL_INDEX& ordIndex);


//------------------------------------------------------------------------
// GetOffset
//
// Purpose:
//    Retrieve offset to symbol table item given the index to the ordinal
//    table.
//
// Input parameters:
//    ordIndex:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL or
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       last item in the table or larger than the table size
//------------------------------------------------------------------------
RETCODE GetOffset(ORDINAL_INDEX ordIndex,
                  TABLE_OFFSET& itemOffset);


//------------------------------------------------------------------------
// GetOrdinalCount
//
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
U32 GetOrdinalCount(void) { return (GetAvailMemOffset()
                            / sizeof(TABLE_OFFSET)); };

//------------------------------------------------------------------------
// GetOrdinalFromPercent
//
// Purpose:
//    Given a percentage value (0 - 100), return the ordinal value
//    (location) closest to the percentage value requested.
//    e.g. 0  (%) = first location
//         100(%) = last location
//
// Input parameter:
//    percent: desired percentage of total entry count
//
// Return value:
//    ordinal index (0 to n) that is the closest to the percentage of the
//    total table size requested
//
// Errors: No errors; limits percent to 100
//------------------------------------------------------------------------
U32 GetOrdinalFromPercent(U8 percent);

//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
void ObliterateTable(void);

};  // end of class OrdinalTable

#define _ORDTBL_
#endif
/******************************** E O F *************************************/
