
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/PAREDIT.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:32   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/PAREDIT.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:34   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:06   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:10   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:40   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:16   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:20   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:29:02   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:06:18   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:10:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:28:24   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:59:20   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:39:26   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:53:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:50   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:12   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:30   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:48   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:56   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:29:40   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:30   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:54   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:18   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:32   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:14   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:48   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:42   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:12   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:04   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:24   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:18   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:02   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:50   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:00   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:42   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:54   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  PAREDIT.CPP
//
//  Description:The implement file for the class: CParsedEdit
//
//  Author:     Roger Zhang
//
//  Date:       04/07/95
//
//  Modification:
//
//      1. 04/07/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "paredit.h"

/////////////////////////////////////////////////////////////////////////////
// ParsedEdit

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CParsedEdit::CParsedEdit()
: m_wParseStyle(0), m_nMin(0), m_nMax(0)
{
}

BEGIN_MESSAGE_MAP(CParsedEdit, CEdit)
    //{{AFX_MSG_MAP(CParsedEdit)
    ON_WM_CHAR()
    ON_WM_VSCROLL()     // for associated spin controls
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Creating from C++ code

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CParsedEdit::Create(DWORD dwStyle, const RECT& rect,
        CWnd* pParentWnd, UINT nID)
{
    m_wParseStyle = LOWORD(dwStyle);
    // figure out edit control style
    DWORD dwEditStyle = MAKELONG(ES_LEFT, HIWORD(dwStyle));
    return CWnd::Create("EDIT", NULL, dwEditStyle, rect, pParentWnd, nID);
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Aliasing on top of an existing Edit control
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CParsedEdit::SubclassEdit(UINT nID, CWnd* pParent, WORD wParseStyle)
{
    m_wParseStyle = wParseStyle;

    // SubclassWindow requires an HWND so we call the Windows GetDlgItem
    // and avoid creating a tempory CWnd and then calling GetSafeHwnd
    HWND hWndEdit = ::GetDlgItem(pParent->m_hWnd, nID);
    if (hWndEdit == NULL)   return FALSE;
    else return SubclassWindow(hWndEdit);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Input character filter
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CParsedEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    WORD type;

    if(nChar < 0x20)    type = PES_ALL;     // always allow control chars
    else if(nChar >= '0' && nChar <= '9')   type = PES_NUMBERS;
    else if(nChar >= 'A' && nChar <= 'Z')   type = PES_LETTERS;
    else if(nChar >= 'a' && nChar <= 'z')   type = PES_LETTERS;
    else                                    type = PES_OTHERCHARS;

    if (m_wParseStyle & type)
        CEdit::OnChar(nChar, nRepCnt, nFlags);  // permitted
    else        // illegal character - inform parent
        OnBadInput();
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Spin controls will send scroll messages
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CParsedEdit::OnVScroll(UINT nSBCode, UINT, CScrollBar*)
{
    int nDelta = 0;
    if(nSBCode == SB_LINEDOWN)        nDelta = -1;
    else if(nSBCode == SB_LINEUP)     nDelta = +1;
    else        return; // nothing special

    // set the focus to this edit item and select it all
    SetFocus();

    //Get the number in the control.
    BOOL bOk;
    int nOld = GetParent()->GetDlgItemInt(GetDlgCtrlID(), &bOk);
    if(bOk) {
        // The MuScroll control also supports range checking
        // for this example, we just prevent overflow
        int nNew = nOld + nDelta;
        if(nNew >= m_nMin && nNew <= m_nMax)
            GetParent()->SetDlgItemInt(GetDlgCtrlID(), nNew);
        else    bOk = FALSE;
    }

    if (!bOk)   OnBadInput();
    SetSel(0, -1);
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: default bad input handler, beep (unless parent notification
//      returns -1). Most parent dialogs will return 0 or 1 for command
//      handlers (i.e. Beep is the default)
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CParsedEdit::OnBadInput()
{
    if (GetParent()->SendMessage(WM_COMMAND,
        GetDlgCtrlID(), MAKELONG(m_hWnd, PEN_ILLEGALCHAR)) != -1)
        MessageBeep(-1);
}

//////////////////////////////////(EOF)//////////////////////////////////////
