
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SHLSYNCO.H__   1.0.1.0   11 Nov 1996 12:59:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SHLSYNCO.H__  $
** 
**    Rev 1.0.1.0   11 Nov 1996 12:59:26   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4   09 Sep 1996 13:18:14   ZJRD
** No change.
** 
**    Rev 1.3   05 Sep 1996 11:29:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 09:56:48   ZJRD
** No change.
** 
**    Rev 1.1   28 Aug 1996 15:51:20   ZJRD
** No change.
** 
**    Rev 1.0   12 Aug 1996 10:55:02   ZJRD
** Initial revision.
** 
****************************************************************************/

#ifndef __SHLSYNCO__H
#define __SHLSYNCO__H             

#include "syntax.h"

typedef struct tagSynColor
{
	CString strText;
	int nColor;
}SynColor;
               
typedef struct tagHintsList
{
	CString strCommand;
	CStringList* plistHints;
	int nCount;
}HintsList;


class CSyntaxCheckSub : public CSyntaxCheck
{
// Construction & Destruction.
public:
    CSyntaxCheckSub();
    ~CSyntaxCheckSub();
    
// Member variables.
private:
    int m_nPos;   //The token number till syntax OK
    int m_nToken; //The total token number
	int m_nEvent;    
    
// Implementations.
private:
    // Syntax check kernel routine.
    BOOL SyntaxCheckRunMacroSub(void);
    BOOL SyntaxCheckVarDefineSub(void);
    BOOL SyntaxCheckAliasSub(void);
    BOOL SyntaxCheckAssembleSub(void);       
	BOOL SyntaxCheckBitSub(void);           
    BOOL SyntaxCheckBreakpointSub(void);    
    BOOL SyntaxCheckByteSub(void);           
    BOOL SyntaxCheckChecksumSub(void);
    BOOL SyntaxCheckClearSub(void);
    BOOL SyntaxCheckCopySub(void);
    BOOL SyntaxCheckCompareSub(void);
    BOOL SyntaxCheckControlSub(void);
    BOOL SyntaxCheckCycleSub(void);
    BOOL SyntaxCheckDisassembleSub(void);  
    BOOL SyntaxCheckDiagnosisSub(void);
    BOOL SyntaxCheckEventSub(void);
    BOOL SyntaxCheckEv1Sub(void);
    BOOL SyntaxCheckEv2Sub(void);
    BOOL SyntaxCheckEv3Sub(void);
    BOOL SyntaxCheckFillSub(void);
    BOOL SyntaxCheckGoSub(void);
    BOOL SyntaxCheckHaltSub(void);
    BOOL SyntaxCheckHelpSub(void);
    BOOL SyntaxCheckIdentifySub(void);
    BOOL SyntaxCheckIncludeSub(void);
    BOOL SyntaxCheckInportSub(void);
    BOOL SyntaxCheckJumpSub(void);
    BOOL SyntaxCheckLevelSub(void);
    BOOL SyntaxCheckListSub(void);
    BOOL SyntaxCheckLogSub(void);
    BOOL SyntaxCheckLongSub(void);
    BOOL SyntaxCheckLv1Sub(void);
    //BOOL SyntaxCheckLv2Sub(void);
	BOOL SyntaxCheckMacroSub(void);    
	BOOL SyntaxCheckMapSub(void);
    BOOL SyntaxCheckMdelSub(void);
    BOOL SyntaxCheckMemorySub(void);
    BOOL SyntaxCheckMendSub(void);
    BOOL SyntaxCheckMlistSub(void);
    BOOL SyntaxCheckOutportSub(void);
    BOOL SyntaxCheckPortSub(void);
    //BOOL SyntaxCheckQualifySub(void);
    BOOL SyntaxCheckRegisterSub(void);
    BOOL SyntaxCheckResetSub(void);
    BOOL SyntaxCheckSearchSub(void);
    BOOL SyntaxCheckStepSub(void);
    BOOL SyntaxCheckTestSub(void);
    BOOL SyntaxCheckTimerSub(void);
    BOOL SyntaxCheckTraceSub(void);
    BOOL SyntaxCheckTriggerSub(void);
    BOOL SyntaxCheckUploadSub(void);
    BOOL SyntaxCheckVerifySub(void);
    BOOL SyntaxCheckWordSub(void);
    BOOL SyntaxCheckCreateSub(void);
    BOOL SyntaxCheckDeleteSub(void);
    BOOL SyntaxCheckLoadSub(void);
    BOOL SyntaxCheckQuerySub(void);
    BOOL SyntaxCheckSsaveSub(void);
    BOOL SyntaxCheckSrecallSub(void);
    BOOL SyntaxCheckSymbolSub(void);
    BOOL SyntaxCheckWatchSub(void); 
                                                                           
	void SetSyntaxColorRunMacro(int nPos, int& nArgc, SynColor syncolor[]);                                                                           
	void SetSyntaxColorVarDefine(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorAlias(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorAssemble(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorBit(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorBreakpoint(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorByte(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorChecksum(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorClear(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCompare(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorControl(int nPos, int& nArgc, SynColor syncolor[]);
//    void SetSyntaxColorCopy(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCycle(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDisassemble(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDiagnosis(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEvent(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv1(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv2(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorEv3(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorFill(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorGo(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorHalt(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorHelp(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorIdentify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorInclude(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorInport(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorJump(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLevel(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorList(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLog(int nPos, int& nArgc, SynColor syncolor[]);  
	void SetSyntaxColorLong(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLv1(int nPos, int& nArgc, SynColor syncolor[]); 
	//void SetSyntaxColorLv2(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMacro(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMap(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMdel(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMemory(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMend(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorMlist(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorOutport(int nPos, int& nArgc, SynColor syncolor[]); 
	void SetSyntaxColorPort(int nPos, int& nArgc, SynColor syncolor[]);	
	//void SetSyntaxColorQualify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorRegister(int nPos, int& nArgc, SynColor syncolor[]);	
	void SetSyntaxColorReset(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSearch(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorStep(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTest(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTimer(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTrace(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorTrigger(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorUpload(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorVerify(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorWord(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorCreate(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorDelete(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorLoad(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorQuery(int nPos, int& nArgc, SynColor syncolor[]);		                                                       
	void SetSyntaxColorSsave(int nPos, int& nArgc, SynColor syncolor[]);			                                                       
	void SetSyntaxColorSrecall(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorSymbol(int nPos, int& nArgc, SynColor syncolor[]);
	void SetSyntaxColorWatch(int nPos, int& nArgc, SynColor syncolor[]);
	
	void SetSyntaxColorInit(int& nArgc, SynColor syncolor[]);		           
	void SetControlSyntaxColorInit(int& nArgc, SynColor syncolor[]);		           	
public:
    BOOL CheckCommandSyntaxSub(const char* pchEditBuf, const int nLen, int& nPos);
	BOOL SyntaxDispatchSub(const int nCommandID);	
	BOOL CommandParseSub(void);
	BOOL CheckCommandKeywordSub(void);
	void SetSyntaxColor(int nPos, int& nArgc, SynColor syncolor[]);	
	
};

#endif               
