/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPACODE.H__   1.7.1.0.1.0   11 Nov 1996 12:59:48   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPACODE.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:12   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:44   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:53:20   ZJRD
** EasyPack/SLD Version 1.9b
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPACODE.H
//
//  Description: The header file for the class: CSpaCodeCoveragePage.
//
//  Author: Chen Jun
//
//  Date: 03/21/96
//
//  Modification:
//      1. 03/21/96, Initial version of the class: CSpaCodeCoverageDlg.
//      2. 03/29/96, CSpaCodeCoveragePage with CPropertyPage.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SPACODE_H_
#define _SPACODE_H_

class CCodeList;

/////////////////////////////////////////////////////////////////////////////
// CSpaCodeCoveragePage dialog

class CSpaCodeCoveragePage : public CPropertyPage
{
// Construction
public:
	CSpaCodeCoveragePage();
	~CSpaCodeCoveragePage();

// Dialog Data
	//{{AFX_DATA(CSpaCodeCoveragePage)
	enum { IDD = IDD_SPA_CODE };
	CComboBox	m_comboModule;
	CStatic	m_staticModule;
	CButton	m_btnDetail;
	CEdit	m_editBp;
	CButton	m_btnBp;
	CStatic	m_staticProgressBar;
	CButton	m_btnMode;
	CButton	m_btnRange1;
	CButton	m_btnRange2;
	CButton	m_btnRange3;
	CButton	m_btnRange4;
	CButton	m_btnRestart;
	CListBox	m_listInst;
	CListBox	m_listBlock;
	CComboBox	m_comboRange1;
	CComboBox	m_comboRange2;
	CComboBox	m_comboRange3;
	CComboBox	m_comboRange4;
	CButton	m_btnEdit;
	CButton	m_btnStop;
	CButton	m_btnStart;
	CString	m_strRange1;
	CString	m_strRange2;
	CString	m_strRange3;
	CString	m_strRange4;
	int		m_nBlock;
	int		m_nInst;
	BOOL	m_bRange1;
	BOOL	m_bRange2;
	BOOL	m_bRange3;
	BOOL	m_bRange4;
	CString	m_strRange0;
	//}}AFX_DATA

private:
	CCodeList m_listCode;

private:
	CObList* m_pLineList;

private:
	int m_nMaxLine;
	int m_nMaxCol;

private:
	enum { executionRange = 0, entryRange };
	enum { combo0 = 0, combo1, combo2, combo3, combo4 };
	enum { defineLen = 80, startLen = 80, endLen = 80 };
	
	enum { maxMemBlock = 0xf0 };

	enum { tmEvent = 1, tmElapse = 100 };
    UINT m_uTimerID;
    
    BOOL m_bStop;
    
    enum { stop = 0, running, failure };
    
    int m_nMemory;
    
    int m_nProgress;

	enum { modeAsm = 0, modeSrc };
    int m_nMode;

    enum { btnStart = 0, btnRestart };
    int m_nWhichBtn;

private:
/*
	QUALIFY 		m_QualifyData;
*/
	COVERAGEGOINFO 	m_CodeSetData;
	COVERAGEGETINFO m_CodeGetData;
	
// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CSpaCodeCoveragePage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	//}}AFX_VIRTUAL

// Implementation
public:
    void RedrawBar(void) { UpdateBar(); };

private:
	void ClearResult(void);
	void CheckInputSyntax(void);

	BOOL SetCoverageData(void);

	void UpdateCoverage(void);

	void UpdateInst(void);
	void UpdateInstAsm(void);
	void UpdateInstSrc(void);

    void CalcMemoryPercent(int nWhichRange);

	void UpdateCombo(void);

	void GetExecuteRange(void);

    void ReadRecord(int nWhichFile, int nWhichCombo);
    void ReadRecord(int nWhichFile, const CString& strDefine);

	void StopTimerAction(void);
    void DisableControl(void);
	void DetectDisplayMode(void);

	void UpdateBar(BOOL bRedraw = TRUE);
	void IdleAction(void);
	
	void ControlToDetail();
	void WindowToDetail();
	void DialogToDetail();
	
	void ToggleToDetailStatus();
	void ToggleToNormalStatus();

	void UpdateModuleInfo();
	void UpdateCodeList(const CString& strFile);
	void ReadSourceCode(const CString& strFile);
	BOOL IsGrayedLine(int nLine) const;
	
	long CalcRange(const int nFirst, const int nSecond);

protected:
	// Generated message map functions
	//{{AFX_MSG(CSpaCodeCoveragePage)
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnButtonSpaEdit();
	afx_msg void OnHelp();
	afx_msg void OnButtonSpaStart();
	afx_msg void OnButtonSpaStop();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSelchangeListSpaCodeBlock();
	afx_msg void OnButtonSpaRestart();
	afx_msg void OnCheckSpaCodeRange1();
	afx_msg void OnCheckSpaCodeRange2();
	afx_msg void OnCheckSpaCodeRange3();
	afx_msg void OnCheckSpaCodeRange4();
	afx_msg void OnButtonSpaCodeMode();
	afx_msg void OnButtonSpaBp();
	afx_msg void OnEditchangeComboSpaCodeRange1();
	afx_msg void OnEditchangeComboSpaCodeRange2();
	afx_msg void OnEditchangeComboSpaCodeRange3();
	afx_msg void OnEditchangeComboSpaCodeRange4();
	afx_msg void OnSelchangeComboSpaCodeRange1();
	afx_msg void OnSelchangeComboSpaCodeRange2();
	afx_msg void OnSelchangeComboSpaCodeRange3();
	afx_msg void OnSelchangeComboSpaCodeRange4();
	afx_msg void OnButtonSpaCodeDetail();
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeComboSpaMessagebarModule();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
