/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPAENTRY.H__   1.7.1.0.1.0   11 Nov 1996 12:58:00   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPAENTRY.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:00   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:14:50   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:22   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:30   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:06   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:54   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:24:34   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:52:16   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:24   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:08:46   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:08:16   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:24:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 13:00:42   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:37:46   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPAENTRY.H
//
//  Description: The header file for the class: CSpaModuleEntryPage.
//
//  Author: Chen Jun
//
//  Date: 03/21/96
//
//  Modification:
//      1. 03/21/96, Initial version of the class: CSpaModuleEntryDlg.
//      2. 03/29/96, CSpaModuleEntryPage with CPropertyPage.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SPAENTRY_H_
#define _SPAENTRY_H_

/////////////////////////////////////////////////////////////////////////////
// CSpaModuleEntryPage dialog

class CSpaModuleEntryPage : public CPropertyPage
{
// Construction
public:
	CSpaModuleEntryPage();	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSpaModuleEntryPage)
	enum { IDD = IDD_SPA_ENTRY };
	CButton	m_btnBp;
	CButton	m_btnRestart;
	CStatic	m_staticTimeBar1;
	CStatic	m_staticTimeBar2;
	CStatic	m_staticTimeBar3;
	CStatic	m_staticTimeBar4;
	CStatic	m_staticCountBar1;
	CStatic	m_staticCountBar2;
	CStatic	m_staticCountBar3;
	CStatic	m_staticCountBar4;
	CButton	m_btnEdit;
	CButton	m_btnStop;
	CButton	m_btnStart;
	CListBox	m_listEntry;
	CComboBox	m_comboRange4;
	CComboBox	m_comboRange3;
	CComboBox	m_comboRange2;
	CComboBox	m_comboRange1;
	int		m_nSelect;
	CString	m_strRange1;
	CString	m_strRange2;
	CString	m_strRange3;
	CString	m_strRange4;
	DWORD	m_dwCount0;
	DWORD	m_dwCount1;
	DWORD	m_dwCount2;
	DWORD	m_dwCount3;
	DWORD	m_dwCount4;
	CEdit	m_editBp;
	CString	m_strRange0;
	CString	m_strUnit0;
	CString	m_strUnit1;
	CString	m_strUnit2;
	CString	m_strUnit3;
	CString	m_strUnit4;
	DWORD	m_dwTimePane0;
	DWORD	m_dwTimePane1;
	DWORD	m_dwTimePane2;
	DWORD	m_dwTimePane3;
	DWORD	m_dwTimePane4;
	//}}AFX_DATA

private:
	int		m_nCountPer1;
	int		m_nCountPer2;
	int		m_nCountPer3;
	int		m_nCountPer4;
	int		m_nTimePer1;
	int		m_nTimePer2;
	int		m_nTimePer3;
	int		m_nTimePer4;

	DWORD	m_dwTime0;
	DWORD	m_dwTime1;
	DWORD	m_dwTime2;
	DWORD	m_dwTime3;
	DWORD	m_dwTime4;

private:
	const DWORD m_cdwMaxTime;
	const DWORD m_cnMaxCount;

	enum { executionRange = 0, entryRange };
	enum { combo0 = 0, combo1, combo2, combo3, combo4 };
	enum { defineLen = 80, startLen = 80, endLen = 80 };
	
	enum { tmEvent = 1, tmElapse = 100 };
    UINT m_uTimerID;
    
    BOOL m_bStop;
    
    enum { stop = 0, pause, running, failure };

	BOOL m_bModule[4];
    
    ::ADDR m_Addr[8];
    
    enum { btnStart = 0, btnRestart };
    int m_nWhichBtn;
    
private:
	SPABPSETINFO m_EntryInfo;

// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CSpaModuleEntryPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnKillActive();
	virtual BOOL OnSetActive();
	//}}AFX_VIRTUAL

// Implementation
public:
    void RedrawBar(void);

private:
	void ClearResult(void);
	void CheckInputSyntax(void);

    BOOL SetEntryData(void);
    int GetEntryData(void);

	BOOL CalcResult(void);
    BOOL CalcCount(void);
    BOOL CalcTimer(void);

	void UpdateCombo(void);
	void UpdateList(void); 

    void ReadRecord(int nWhichFile);
    void ReadRecord(int nWhichFile, int nWhichCombo);
    void ReadRecord(int nWhichFile, const CString& strDefine);

	void GetExecuteRange(void);

    void UpdateBar(void);
    void UpdateCountBar(int nWhich, BOOL bRedraw = TRUE);
    void UpdateTimerBar(int nWhich, BOOL bRedraw = TRUE);

	void StopTimerAction(void);
    void DisableControl(void);
    
    void UpdateUnit();
    
#ifdef	_EPSLD_
    void UpdateTimer(const unsigned long ul, const UINT uPC, const BOOL bEnd);
#endif	// _EPSLD_

#ifdef	_PICSLD_
    void UpdateTimer(const DWORD dw, const WORD uPC, const BOOL bEnd);
#endif	// _PICSLD_

protected:
	// Generated message map functions
	//{{AFX_MSG(CSpaModuleEntryPage)
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnButtonSpaEdit();
	afx_msg void OnButtonSpaStart();
	afx_msg void OnButtonSpaStop();
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnButtonSpaRestart();
	afx_msg void OnButtonSpaBp();
	afx_msg void OnHelp();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
