/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPALIST.CPP   1.6   11 Nov 1996 12:59:46   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPALIST.CPP  $
** 
**    Rev 1.6   11 Nov 1996 12:59:46   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3   09 Sep 1996 13:19:12   ZJRD
** No change.
** 
**    Rev 1.2   05 Sep 1996 11:30:42   ZJRD
** No change.
** 
**    Rev 1.1   02 Sep 1996 09:57:46   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.0   28 Aug 1996 15:53:18   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPALIST.CPP
//
//  Description: The implementation file for the class: CCodeList.
//
//  Author: Chen Jun
//
//  Date: 08/19/96
//
//  Modification:
//      1. 08/19/96, Initial version of the class: CCodeList.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "xview.h"

#include "spaline.h"
#include "spalist.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CCodeList

CCodeList::CCodeList()
{
}

CCodeList::~CCodeList()
{
}

BEGIN_MESSAGE_MAP(CCodeList, CListBox)
	//{{AFX_MSG_MAP(CCodeList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCodeList overload function

void CCodeList::DrawItem(LPDRAWITEMSTRUCT lpDIS)
{
	// Get DC.
    CDC* pDC = CDC::FromHandle(lpDIS->hDC);
    pDC->SelectStockObject(ANSI_FIXED_FONT);
    
    TEXTMETRIC tm;
    pDC->GetTextMetrics(&tm);
    int nFontWidth(tm.tmAveCharWidth);
    int nFontHeight(tm.tmHeight + tm.tmExternalLeading);

	// Draw the text line.
    CSpaTextLine* pObj = (CSpaTextLine*)lpDIS->itemData;

    if ( lpDIS->itemAction & ODA_DRAWENTIRE ) {
		CRect rect(lpDIS->rcItem);
        CString strLine = pObj->GetText();
		if ( !pObj->GetGrayed() ) {
			pDC->SetBkColor(RGB(255,255,255));
			pDC->SetTextColor(RGB(0,0,255));
		}
		else {
			pDC->SetBkColor(RGB(255,255,255));
			pDC->SetTextColor(RGB(127,127,127));
		}
		pDC->TextOut(rect.left+nFontWidth*4, rect.top, strLine);
    }

/*
    if ((lpDIS->itemState & ODS_SELECTED) &&
        (lpDIS->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
    {
        // item has been selected - hilite frame
        COLORREF crHilite = RGB(255-GetRValue(cr),
                        255-GetGValue(cr), 255-GetBValue(cr));
        CBrush br(crHilite);
        pDC->FrameRect(&lpDIS->rcItem, &br);
    }
	
    if (!(lpDIS->itemState & ODS_SELECTED) &&
        (lpDIS->itemAction & ODA_SELECT))
    {
        // Item has been de-selected -- remove frame
        CBrush br(cr);
        pDC->FrameRect(&lpDIS->rcItem, &br);
    }
*/
}

void CCodeList::MeasureItem(LPMEASUREITEMSTRUCT lpMIS)
{
	// Get the line height.
    CDC* pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);
    
    TEXTMETRIC tm;
    pDC->GetTextMetrics(&tm);
    int nFontWidth(tm.tmAveCharWidth);
    int nFontHeight(tm.tmHeight + tm.tmExternalLeading);

    ReleaseDC(pDC);

	// Set the line height.
	lpMIS->itemHeight = nFontHeight;
}


/////////////////////////////////////////////////////////////////////////////
// CCodeList common routine

int CCodeList::AddLine(CSpaTextLine* pLine)
{
	// Add to a listbox.
	return AddString((LPCSTR)pLine);
}


/////////////////////////////////////////////////////////////////////////////
// CCodeList message handlers
