
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SRCDLG1.CPP   1.7.1.0.1.0   11 Nov 1996 13:00:04   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SRCDLG1.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:04   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:00   ZJRD
** EasyPack/SLD Version 1.9f
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:30   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:36   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:50   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.6   10 Jun 1996 10:23:16   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:34:28   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:54   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.1   02 May 1996 10:30:48   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:55:56   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:34:56   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:04:50   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:26   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:48   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:16:40   Shirley
** EasyPack/SLD Version 0.35a
** 
**    Rev 1.22   25 Jan 1996 13:16:34   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:28   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:56   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:13:50   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:40   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:09:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:20   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:38   Shirley
** EasyPack/SLD Version 0.32
** 
**    Rev 1.14   21 Nov 1995 11:23:44   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:46   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:31:36   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:10   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:38   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:00   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:58   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:30   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:00   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:26   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCDLG1.CPP
//
//  Description:The implement file for the class:
//              CSourceSearch
//              CBrowseAddrDialog
//              CJumpDialog
//              CStepOptionDialog
//              CLoadInfoDialog
//              CLoadProgDialog
//
//  Author:     Roger Zhang
//
//  Date:       05/18/95
//
//  Modification:
//
//      1. 05/18/95, Initial version 0.1
//
//      2. 09/08/95 0.1a                
//
//         2.1 Fixed bug No.19
//              Modify function: CBrowseAddrDialog::OnOK
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "meter.h"
#include "colors.h"
#include "zqueue.h"
#include "uicom.h"                   
#include "srccom.h"
#include "srcdlg1.h"
#include "uicom.h"
#include "srccom.h"
#include "btnbar.h"
#include "zlist.h"
#include "srclist.h"
#include "srcmdl.h"
#include "srcfile.h"
#include "srcdlg1.h"
#include "srcgrp.h"
#include "mainfrm.h"
#include "srcwin.h"
#include "address.h"
#include "addrapi.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSourceSearch dialog              
//
// Search string in the source window
// This is a modeless dialog
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CSourceSearch::CSourceSearch(CWnd* pParent /*=NULL*/, BOOL bBrowse)
    : CDialog(CSourceSearch::IDD, pParent), m_isSearchNext(FALSE),m_bBrowse(bBrowse)
{
    //{{AFX_DATA_INIT(CSourceSearch)
    m_isCase   = SrcSrchData.m_isCase;
    m_isMatch  = SrcSrchData.m_isMatch;
    m_nUp      = SrcSrchData.m_nUp;
    //}}AFX_DATA_INIT
    m_strCombo = SrcSrchData.m_StrList.IsEmpty() ? 
        "" : SrcSrchData.m_StrList.GetTail();
    Create(CSourceSearch::IDD, pParent);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceSearch::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CSourceSearch)
    DDX_Control(pDX, IDC_SRCHSRC_COMBO, m_cmbSrch);
    DDX_Check(pDX, IDC_SRCHSRC_CASE, m_isCase);
    DDX_Check(pDX, IDC_SRCHSRC_MATCH, m_isMatch);
    DDX_Radio(pDX, IDC_SRCHSRC_UP, m_nUp);
    DDX_CBString(pDX, IDC_SRCHSRC_COMBO, m_strCombo);
    //}}AFX_DATA_MAP
}                                      

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceSearch::PostNcDestroy(void)
{                  
    isSrcSrchDlg = FALSE;
    delete this;
}

BEGIN_MESSAGE_MAP(CSourceSearch, CDialog)
    //{{AFX_MSG_MAP(CSourceSearch)
    ON_BN_CLICKED(IDC_SRCHSRC_SEARCH, OnSrchsrcSearch)
    ON_CBN_EDITCHANGE(IDC_SRCHSRC_COMBO, OnEditchangeSrchsrcCombo)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSourceSearch message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceSearch::OnCancel()
{
    // TODO: Add extra cleanup here
    
    //CDialog::OnCancel();
    DestroyWindow();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceSearch::OnOK()
{
    // TODO: Add extra cleanup here
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceSearch::OnSrchsrcSearch()
{
    // TODO: Add your control notification handler code here
    if(!m_isSearchNext) {
        UpdateData(TRUE);
    
        SrcSrchData.m_isCase   = m_isCase;
        SrcSrchData.m_isMatch  = m_isMatch;
        SrcSrchData.m_nUp      = m_nUp;    
        SrcSrchData.m_strText  = m_strCombo;
    
        if(SrcSrchData.m_StrList.IsEmpty() ||
            m_strCombo != SrcSrchData.m_StrList.GetTail()) {
            SrcSrchData.AddNew(m_strCombo);                 
        }      
    
        m_isSearchNext = TRUE;
        SetDlgItemText(IDC_SRCHSRC_SEARCH, "Search Next");
        GetDlgItem(IDC_SRCHSRC_COMBO)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCHSRC_CASE)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCHSRC_MATCH)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCHSRC_UP)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCHSRC_DOWN)->EnableWindow(FALSE);
        GetDlgItem(IDC_SRCHSRC_ALL)->EnableWindow(FALSE);
        SrcSrchData.m_isFirst = TRUE;
    } 
    
    //pSourceWnd->PostMessage(XM_SRCSRCH);
    if(m_bBrowse && isBrowseOn)
       pBrowseWnd->PostMessage(WM_COMMAND, ID_EDIT_SEARCHNEXT);
    else if(!m_bBrowse && isSourceOn)   
       pSourceWnd->SendMessage(WM_COMMAND, ID_EDIT_SEARCHNEXT);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSourceSearch::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();
    
    // TODO: Add extra initialization here 
    m_cmbSrch.LimitText(240);
    POSITION pos = SrcSrchData.m_StrList.GetTailPosition();
    while(pos) {
        m_cmbSrch.AddString(SrcSrchData.m_StrList.GetPrev(pos));
    }
    
    GetDlgItem(IDC_SRCHSRC_SEARCH)->EnableWindow(m_strCombo != "");
        
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CSourceSearch::OnEditchangeSrchsrcCombo()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);        
    GetDlgItem(IDC_SRCHSRC_SEARCH)->EnableWindow(m_strCombo != "");
}

/////////////////////////////////////////////////////////////////////////////
// CBrowseAddrDialog dialog
//
// This dialog uses as both browse from addr/line dialog
/////////////////////////////////////////////////////////////////////////////
static CStringList BrsAddrList;
static CStringList BrsLineList;

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CBrowseAddrDialog::CBrowseAddrDialog(BOOL isAddr, CWnd* pParent /*=NULL*/)
    : CDialog(CBrowseAddrDialog::IDD, pParent), m_isAddr(isAddr)
{
    if(!isAddr) m_nIDHelp = IDD_BROWSE_LINE;
    //{{AFX_DATA_INIT(CBrowseAddrDialog)
    //}}AFX_DATA_INIT 
    char psz[20];
    if(m_isAddr) {
        m_strText = "&Address";
        wsprintf(psz, "0x%X", uBrowseAddr);
        m_strCmb  = psz;
    } else {
        m_strText = "&Number";
        wsprintf(psz, "%d", nBrowseLine);
        m_strCmb  = psz;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CBrowseAddrDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CBrowseAddrDialog)
    DDX_Control(pDX, IDC_BRSADDR_COMBO, m_cmbAddr);
    DDX_CBString(pDX, IDC_BRSADDR_COMBO, m_strCmb);
    DDX_Text(pDX, IDC_BRSADDR_TEXT, m_strText);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBrowseAddrDialog, CDialog)
    //{{AFX_MSG_MAP(CBrowseAddrDialog)
    ON_CBN_EDITCHANGE(IDC_BRSADDR_COMBO, OnEditchangeBrsaddrCombo)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBrowseAddrDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CBrowseAddrDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();
    
    // TODO: Add extra initialization here
    POSITION pos;
    if(m_isAddr) {
        pos = BrsAddrList.GetTailPosition();
        while(pos) 
            m_cmbAddr.AddString(BrsAddrList.GetPrev(pos));
        SetWindowText("Browse From Address");
    } else {
        pos = BrsLineList.GetTailPosition();
        while(pos) 
            m_cmbAddr.AddString(BrsLineList.GetPrev(pos));
        SetWindowText("Browse From Line");
    }
    
    GetDlgItem(IDOK)->EnableWindow(m_strCmb != "");
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CBrowseAddrDialog::OnEditchangeBrsaddrCombo()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);        
    GetDlgItem(IDOK)->EnableWindow(m_strCmb != "");
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CBrowseAddrDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData(TRUE);        
        
    long    lVal;       
    if(m_isAddr) {
    	// Modified by Chen Jun, 10/08/96
		// Check C-conversion.
		::ADDRESS Addr;
		if ( ::ADR_OK != ::AdrTextToAddr(m_strCmb, Addr) ) {
	        AfxMessageBox("Entered Address Error!");
			return;
		}
		
		// Check space.
		if ( ::SPACE_PROGRAME != Addr.adrSpace && ::SPACE_UNDEFINE != Addr.adrSpace ) {
	        AfxMessageBox("Entered Address Error!");
			return;
		}
		
		// Check range.
		Addr.adrSpace = ::SPACE_PROGRAME;
		if ( ::ADR_OK != ::AdrCheckAddrRange(Addr) ) {
	        AfxMessageBox("Entered Address Error!");
			return;
		}
		
		lVal = long(Addr.adrAddress);

    /*
        //lVal = strtol(m_strCmb, NULL, 0);
        //
        lVal = Str2Addr(m_strCmb);
	*/
	        
        if(lVal >= 0x10000L || lVal < 0) {
            AfxMessageBox("Entered Address Error!");
            return;
        } else {
            uBrowseAddr = unsigned(lVal);
            BrsAddrList.AddTail(m_strCmb);
        }       
    
    } else {                 
        char * p;
        lVal = strtol(m_strCmb, &p, 10);
        if(lVal <= 0 || ((*p < '0' || *p > '9') && *p != '\0')) {
            AfxMessageBox("Entered Line Number Error!");
            return;
        } else {
            nBrowseLine = int(lVal);
            BrsLineList.AddTail(m_strCmb);
        }       
    }
    
    CDialog::OnOK();
}                                                        

/////////////////////////////////////////////////////////////////////////////
// CJumpDialog dialog
/////////////////////////////////////////////////////////////////////////////
static CStringList JumpAddrList;   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CJumpDialog::CJumpDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CJumpDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CJumpDialog)
    m_isInitPC = JumpData.m_isInitPC;
    //}}AFX_DATA_INIT  
    wsprintf(m_strCmb.GetBuffer(20), "0x%X", JumpData.m_uAddr);     
    m_strCmb.ReleaseBuffer();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CJumpDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CJumpDialog)
    DDX_Control(pDX, IDC_JUMP_COMBO, m_cmbAddr);
    DDX_Check(pDX, IDC_JUMP_CHECK, m_isInitPC);
    DDX_CBString(pDX, IDC_JUMP_COMBO, m_strCmb);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CJumpDialog, CDialog)
    //{{AFX_MSG_MAP(CJumpDialog)
    ON_BN_CLICKED(IDC_JUMP_CHECK, OnJumpCheck)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CJumpDialog message handlers                                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CJumpDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();
    
    // TODO: Add extra initialization here
    POSITION pos = JumpAddrList.GetTailPosition();
    while(pos) {
        m_cmbAddr.AddString(JumpAddrList.GetPrev(pos));
    }
    
    GetDlgItem(IDC_JUMP_COMBO)->EnableWindow(!m_isInitPC);
    GetDlgItem(IDC_JUMP_TEXT)->EnableWindow(!m_isInitPC);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CJumpDialog::OnJumpCheck()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                                      
    if(m_isInitPC) {
        wsprintf(m_strCmb.GetBuffer(20), "0x%X", LoadInfo.m_lPC);     
        m_strCmb.ReleaseBuffer();
    }
    UpdateData(FALSE);        
    
    GetDlgItem(IDC_JUMP_COMBO)->EnableWindow(!m_isInitPC);
    GetDlgItem(IDC_JUMP_TEXT)->EnableWindow(!m_isInitPC);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CJumpDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData(TRUE);
    
    long    lVal;        
        
    if(!m_isInitPC) {
    /*
        lVal = Str2Addr(m_strCmb);
        if(lVal >= 0x10000L) {
            AfxMessageBox("Entered Address Error!");
            return;                                 
        }
    */
    
    	// Modified by Chen Jun, 10/08/96
		// Check C-conversion.
		::ADDRESS Addr;
		if ( ::ADR_OK != ::AdrTextToAddr(m_strCmb, Addr) ) {
	        AfxMessageBox("Entered Address Error!");
			return;
		}
		
		// Check space.
		if ( ::SPACE_PROGRAME != Addr.adrSpace && ::SPACE_UNDEFINE != Addr.adrSpace ) {
	        AfxMessageBox("Entered Address Error!");
			return;
		}
		
		// Check range.
		Addr.adrSpace = ::SPACE_PROGRAME;
		if ( ::ADR_OK != ::AdrCheckAddrRange(Addr) ) {
	        AfxMessageBox("Entered Address Error!");
			return;
		}
		
		lVal = long(Addr.adrAddress);
	}

    JumpData.m_uAddr = m_isInitPC ? unsigned(LoadInfo.m_lPC):unsigned(lVal);
    JumpData.m_isInitPC = m_isInitPC;
    JumpAddrList.AddTail(m_strCmb);
    
    CDialog::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
// CStepOptionDialog dialog
/////////////////////////////////////////////////////////////////////////////
static CStringList StepCntList;

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CStepOptionDialog::CStepOptionDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CStepOptionDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CStepOptionDialog)
    m_nOpt = SrcEmu.m_nStepOpt;
    //}}AFX_DATA_INIT                      
    char    psz[10];
    wsprintf(psz, "%d", SrcEmu.m_nStepCount);
    m_strCmb = psz;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CStepOptionDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CStepOptionDialog)
    DDX_Control(pDX, IDC_STEPOPT_COMBO, m_cmbCnt);
    DDX_CBString(pDX, IDC_STEPOPT_COMBO, m_strCmb);
    DDX_Radio(pDX, IDC_STEPOPT_INSTRUCTION, m_nOpt);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStepOptionDialog, CDialog)
    //{{AFX_MSG_MAP(CStepOptionDialog)
    ON_CBN_EDITCHANGE(IDC_STEPOPT_COMBO, OnEditchangeStepoptCombo)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStepOptionDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CStepOptionDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CenterWindow();
    
    if(!isSourceOn || 
        ((CSourceWindow *)pSourceWnd)->m_nDispMode != MODE_SOURCE) {
        GetDlgItem(IDC_STEPOPT_LINE)->EnableWindow(FALSE);                  
    }
    
    if(!isSourceOn 
        || ((CSourceWindow *)pSourceWnd)->m_nDispMode != MODE_SOURCE
        || !SrcEmu.m_isStatement) {
        GetDlgItem(IDC_STEPOPT_STATEMENT)->EnableWindow(FALSE);                  
    }
    
    // TODO: Add extra initialization here
    POSITION pos = StepCntList.GetTailPosition();
    while(pos) {
        m_cmbCnt.AddString(StepCntList.GetPrev(pos));
    }
    
    GetDlgItem(IDOK)->EnableWindow(m_strCmb != "");
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CStepOptionDialog::OnEditchangeStepoptCombo()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);        
    GetDlgItem(IDOK)->EnableWindow(m_strCmb != "");
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CStepOptionDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData(TRUE);
    if(atoi(m_strCmb) <= 0) {
        AfxMessageBox("Entered step count error");
        return;
    }    
    
    StepCntList.AddTail(m_strCmb);
    SrcEmu.m_nStepOpt = m_nOpt;
    if(m_nOpt == 1 && !SrcEmu.m_isStatement)
        SrcEmu.m_nStepOpt = 2;
    SrcEmu.m_nStepCount = atoi(m_strCmb);
    
    CDialog::OnOK();
}

/////////////////////////////////////////////////////////////////////////////
// CLoadInfoDialog dialog
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLoadInfoDialog::CLoadInfoDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CLoadInfoDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CLoadInfoDialog)
    //}}AFX_DATA_INIT

    char s[30];

    if(LoadInfo.m_strFile.GetLength() >= 28)
        m_strFile = "..." + LoadInfo.m_strFile.Right(25);
    else    
        m_strFile = LoadInfo.m_strFile;
    
    if(LoadInfo.m_lBytes < 0)   m_strByte = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lBytes);
        m_strByte = s;
    }
    if(LoadInfo.m_lModules < 0)   m_strMdl = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lModules);
        m_strMdl = s;
    }
    if(LoadInfo.m_lSymbols < 0)   m_strSym = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lSymbols);
        m_strSym = s;
    }
    if(LoadInfo.m_lTypes < 0)   m_strType = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lTypes);
        m_strType = s;
    }
    if(LoadInfo.m_lFunctions < 0)   m_strFunc = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lFunctions);
        m_strFunc = s;
    }
    if(LoadInfo.m_lLines < 0)   m_strLine = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lLines);
        m_strLine = s;
    }
    if(LoadInfo.m_lPC < 0)   m_strPC = "NULL";
    else {
        wsprintf(s, "0x%X", LoadInfo.m_lPC);
        m_strPC = s;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadInfoDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CLoadInfoDialog)
    DDX_Text(pDX, IDC_LOADINFO_BYTE, m_strByte);
    DDX_Text(pDX, IDC_LOADINFO_FILE, m_strFile);
    DDX_Text(pDX, IDC_LOADINFO_FUNC, m_strFunc);
    DDX_Text(pDX, IDC_LOADINFO_LINE, m_strLine);
    DDX_Text(pDX, IDC_LOADINFO_MDL, m_strMdl);
    DDX_Text(pDX, IDC_LOADINFO_PC, m_strPC);
    DDX_Text(pDX, IDC_LOADINFO_SYM, m_strSym);
    DDX_Text(pDX, IDC_LOADINFO_TYPE, m_strType);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLoadInfoDialog, CDialog)
    //{{AFX_MSG_MAP(CLoadInfoDialog)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLoadInfoDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLoadInfoDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// CLoadProgDialog dialog
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLoadProgDialog::CLoadProgDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CLoadProgDialog::IDD, pParent), m_nRatio(0)
{                          
    m_isLoading = FALSE;
    if(LoadInfo.m_strFile.GetLength() >= 28)
        m_strFile = "..." + LoadInfo.m_strFile.Right(25);
    else    
        m_strFile = LoadInfo.m_strFile;
    //{{AFX_DATA_INIT(CLoadProgDialog)
    m_strByte = "";
    m_strCurMdl = "";
    m_strFunc = "";
    m_strLine = "";
    m_strMdl = "";
    m_strPC = "";
    m_strSym = "";
    m_strType = "";
    //}}AFX_DATA_INIT                                  
    
    LoadInfo.m_isCancel = FALSE;
    LoadInfo.m_isLoadEnd = FALSE;

    hLib = LoadLibrary("METER.DLL");
    if(hLib < HINSTANCE_ERROR)  return;
}

CLoadProgDialog::~CLoadProgDialog()
{
    FreeLibrary(hLib);
}    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadProgDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CLoadProgDialog)
    DDX_Text(pDX, IDC_LOADPROG_BYTE, m_strByte);
    DDX_Text(pDX, IDC_LOADPROG_CURMDL, m_strCurMdl);
    DDX_Text(pDX, IDC_LOADPROG_FILE, m_strFile);
    DDX_Text(pDX, IDC_LOADPROG_FUNC, m_strFunc);
    DDX_Text(pDX, IDC_LOADPROG_LINE, m_strLine);
    DDX_Text(pDX, IDC_LOADPROG_MDL, m_strMdl);
    DDX_Text(pDX, IDC_LOADPROG_PC, m_strPC);
    DDX_Text(pDX, IDC_LOADPROG_SYM, m_strSym);
    DDX_Text(pDX, IDC_LOADPROG_TYPE, m_strType);
    //}}AFX_DATA_MAP
}                                        

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadProgDialog::SetFill(int nRatio)
{           
    if(nRatio < 0)  nRatio = 0;
    else if(nRatio > 100)   nRatio = 100;

    m_meter.SetPartsComplete(WORD(nRatio));
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadProgDialog::SetInfo(void)
{
    char s[30];

    m_strCurMdl = LoadInfo.m_strModule;
    
    if(LoadInfo.m_lBytes < 0)   m_strByte = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lBytes);
        m_strByte = s;
    }
    if(LoadInfo.m_lModules < 0)   m_strMdl = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lModules);
        m_strMdl = s;
    }
    if(LoadInfo.m_lSymbols < 0)   m_strSym = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lSymbols);
        m_strSym = s;
    }
    if(LoadInfo.m_lTypes < 0)   m_strType = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lTypes);
        m_strType = s;
    }
    if(LoadInfo.m_lFunctions < 0)   m_strFunc = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lFunctions);
        m_strFunc = s;
    }
    if(LoadInfo.m_lLines < 0)   m_strLine = "NULL";
    else {
        wsprintf(s, "%ld", LoadInfo.m_lLines);
        m_strLine = s;
    }
    if(LoadInfo.m_lPC < 0)   m_strPC = "NULL";
    else {
        wsprintf(s, "0x%X", LoadInfo.m_lPC);
        m_strPC = s;
    }
    
    UpdateData(FALSE);        
}

BEGIN_MESSAGE_MAP(CLoadProgDialog, CDialog)
    //{{AFX_MSG_MAP(CLoadProgDialog)
    ON_WM_TIMER()
    ON_WM_CTLCOLOR()
    ON_WM_DESTROY()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLoadProgDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLoadProgDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    m_br.CreateSolidBrush(PALETTEINDEX(COLOR_BLACK));
    
    CenterWindow();
    CRect rect(60, 70, 310, 90);

    m_meter.Create(WS_VISIBLE|WS_CHILD|WS_BORDER, rect,
        this, IDC_METER);
    m_meter.SetPartsInJob(100);
    m_meter.SetPartsComplete(0);

    // TODO: Add extra initialization here
    m_uTimer = SetTimer(1, 100, NULL);
    m_isTimer = TRUE;
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

static char achName[100];      
int iiii = 0;
int TTTTT(void)
{
    for(int i = 0; i < 32; i ++) {
        TestMessage();
        for(int j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        for( j = 0; j < 32000; j ++) ;
        iiii = i * 3;        
    }
    iiii = 100;
    return 0;
}
                  
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadProgDialog::OnTimer(UINT nIDEvent)
{
    // TODO: Add your message handler code here and/or call default
    
    //CDialog::OnTimer(nIDEvent); 
    char szModule[100];       
    
    if(nIDEvent != m_uTimer)   return;          
              
    if(!m_isLoading) {
        m_isLoading = TRUE;
        
        // Call load file routine
        strcpy(achName, LoadInfo.m_strFile);
        m_nRval = /*TTTTT();*/SrcLoadFile(achName);
        LoadInfo.m_isLoadEnd = TRUE;
        if(m_isTimer) {
            KillTimer(m_uTimer);
            m_isTimer = FALSE;
        }   

        if(SrcGetLdrStats(szModule, &(LoadInfo.m_lSymbols),
            &((unsigned short &)(LoadInfo.m_lModules)), &(LoadInfo.m_lTypes), 
            &(LoadInfo.m_lFunctions), &(LoadInfo.m_lLines),
            &(LoadInfo.m_lBytes), &m_nRatio) == -1) {
            return;
        }                            
        
        LoadInfo.m_strModule = szModule;
        //m_nRatio = iiii;  
          
        SetInfo();                       
        SetFill(m_nRatio);
        
        //CDialog::OnOK();
        GetDlgItem(IDOK)->SetWindowText("OK");
    } else {
        if(LoadInfo.m_isLoadEnd) {
            if(m_isTimer) {
                KillTimer(m_uTimer);
                m_isTimer = FALSE;
            }   
            //return;
        }
        
        if(SrcGetLdrStats(szModule, &(LoadInfo.m_lSymbols),
            &((unsigned short &)(LoadInfo.m_lModules)), &(LoadInfo.m_lTypes), 
            &(LoadInfo.m_lFunctions), &(LoadInfo.m_lLines),
            &(LoadInfo.m_lBytes), &m_nRatio) == -1) {
            return;
        }                            
        
        LoadInfo.m_strModule = szModule;
        //m_nRatio = iiii;  
          
        SetInfo();                       
        SetFill(m_nRatio);
    }    
}

HBRUSH CLoadProgDialog::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
    // TODO: Add your message handler code here and/or call default
    if(nCtlColor == CTLCOLOR_METER) {
        pDC->SetTextColor(PALETTEINDEX(COLOR_BLACK/*COLOR_LTBLUE*/));   
//      pDC->SetBkColor(PALETTEINDEX(COLOR_WHITE)); 
        return (HBRUSH)(m_br.m_hObject);
    } else return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
}
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadProgDialog::OnOK()
{
    // TODO: Add extra validation here
    LoadInfo.m_isCancel = TRUE;
    
    if(LoadInfo.m_isLoadEnd)
        CDialog::OnOK();                  
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL IsLoadCanceled(void)
{
    return LoadInfo.m_isCancel;
}                              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void SetLoadEnd(void)
{
    LoadInfo.m_isLoadEnd = TRUE;
}                   

//////////////////////////////////(EOF)//////////////////////////////////////



void CLoadProgDialog::OnDestroy()
{
    CDialog::OnDestroy();
    
    // TODO: Add your message handler code here
    m_br.DeleteObject();
}
