
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SRCFILE.H__   1.7.1.0.1.0   11 Nov 1996 12:58:46   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SRCFILE.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:46   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:38   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:10   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:16   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:02   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.6   10 Jun 1996 10:20:14   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:29:46   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:07:02   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:24   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:20   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:34   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:16   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:50   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:50   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:56   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:50   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:22   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:15:02   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:08   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:14   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:14:28   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:22   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:38   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:38   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:42   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:24   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:28   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:49:34   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:58   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:34   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:48   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:34   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:40   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:12   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:32   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCFILE.H
//
//  Description:The header file for the class: 
//                  SourceAssemble
//                  SourceMixed
//
//  Author:     Roger Zhang
//
//  Date:       06/20/95
//
//  Modification:
//
//      1. 06/20/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCFILE_
#define _SRCFILE_

/////////////////////////////////////////////////////////////////////////////
#define SRCMDL      (MdlInfo.m_Module[MdlInfo.m_nModuleIdx])                    
#define SRCLINES    (int(SRCMDL.m_Src.m_lCount))
#define MIXLINES    (SrcMix.m_AsmList.GetCount() + SrcMix.m_nSrcLines)
#define ASMLINES    (SrcAsm.m_AsmList.GetCount())

#define BWSSRCMDL   (bwsMdlInfo.m_Module[bwsMdlInfo.m_nModuleIdx])                    
#define BWSSRCLINES (int(BWSSRCMDL.m_Src.m_lCount))
#define BWSMIXLINES (BwsMix.m_AsmList.GetCount() + BwsMix.m_nSrcLines)
#define BWSASMLINES (BwsAsm.m_AsmList.GetCount())

/////////////////////////////////////////////////////////////////////////////
//  Assembly Line Element
/////////////////////////////////////////////////////////////////////////////
class AsmLine
{
public:                   
    char             m_chLabel;    // 1:Label, 0:Not Label
    unsigned short   m_uAddr;
    CString          m_strText;
};

/////////////////////////////////////////////////////////////////////////////
// Assembly mode class : SourceAssemble                                     
/////////////////////////////////////////////////////////////////////////////
class SourceAssemble
{
public:
    enum { MAX_CHECK = 3 };
    enum { MAX_RANGE = 256 };   // Address Range
    enum { MAX_PAGE = 128 };    // Address Page
    
    CPtrList    m_AsmList;      
    
    int         m_nOffset;		// the offset to the start address
    int         m_nIndex;       // the index to the start address
    
    long		m_lStartAddr;	// the address of the 1st element in the list
    long		m_lRange;		// the address range of the list
        
    SourceAssemble(void) 
    : m_nOffset(0), m_nIndex(0), m_lStartAddr(0), m_lRange(0)        
    {}                         
    ~SourceAssemble();
    
    void DeleteList(void);         
    BOOL Dsm(unsigned short uAddr);
    BOOL DsmPrev(void);
    BOOL DsmNext(void);                                   
    AsmLine * GetLine(int nLine) const;
    BOOL CheckAddr(unsigned short uAddr) const;
    int MatchAddr2Line(long lAddr) const;
    int Addr2Line(long lAddr) const;
    long Line2Addr(int nLine) const;
    int MatchAddr2LineL(long lAddr) const;
    int Addr2LineL(long lAddr) const;
    long Line2AddrL(int nLine) const;
    BOOL IsHome(void) const;
    BOOL IsEnd(void) const;
    BOOL IsLabelLine(int nLine);
private:
    BOOL Dsm(unsigned short uAddr, unsigned short uRange);            
    BOOL DsmAddr(unsigned short uStart, unsigned short uChk);
};

extern SourceAssemble SrcAsm;
extern SourceAssemble BwsAsm;
/////////////////////////////////////////////////////////////////////////////     
// Mixed Mode Class : SourceMixed
/////////////////////////////////////////////////////////////////////////////
class SourceMixed
{
public:                   
    enum { MAX_RANGE = 256 };   // Address Range
    enum { MAX_PAGELINE  = 32 };
    enum { MIN_LINES = 128 };      
    
    CPtrList    m_AsmList;      
    
    int         m_nAsmPos[MIN_LINES];    // source line index - offset 
                                         // as array index
    int         m_nSrcStart;	// the line number of the 1st element
    int         m_nSrcLines;    // lines in the list                
    
    int         m_nOffset;      // offset in the list
    int         m_nIndex;		// index in the list
    int         m_bBrowse;
    
    #ifdef _DEBUG
    void DumpFile(const char * pszFileName) const;
    #endif
                
    SourceMixed(BOOL bBrowse){m_bBrowse=bBrowse;};            
    ~SourceMixed();
    void DeleteList(void);
    BOOL GetLineAddr(int nLine, unsigned short &uAddr, 
        unsigned short &uRange); 
    BOOL Dsm(int nLine);
    BOOL DsmPrev(void);
    BOOL DsmNext(void);                                   
    AsmLine * GetLine(int nSrcLine, int nAsmLine) const;
    BOOL IsHome(void) const;
    BOOL IsEnd(void) const;     
    int  Line2Ofs(int nSrc, int nAsm) const;
    int  Ofs2Line(int nOfs, int &nAsm) const;      
    int  Addr2Ofs(unsigned short uAddr) const;
private:    
    BOOL Dsm(unsigned short uAddr, unsigned short uRange);            
    BOOL DsmLine(int nLine);
    int  GetNextAsmLine(int nLine) const;
    int  GetAsmLines(int nLine) const;
};

extern SourceMixed SrcMix;
extern SourceMixed BwsMix;
       

#endif
//////////////////////////(EOF)//////////////////////////////////////////////
