
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/STKFRM.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:00   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/STKFRM.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:00   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:10   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:42   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:32   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:53:46   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:56   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:30:24   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:07:42   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:16   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:10   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:59:50   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:12   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:26:04   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:26   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:06   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:40   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:52   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:38   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:48   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:26   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:14   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:14:52   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:00   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:04   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:20   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:14   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:08   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:50   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:26   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:29:56   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:02   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:56   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:58   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:10   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:40   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:56   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:48:48   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:54   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:47:50   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:08   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKFRM.CPP
//
//  Description: The implementation file for the class: CStackFrame.
//
//  Author: Chen Jun
//
//  Date: 07/29/95
//
//  Modification:
//      1. 07/29/95, Initial version of the class: CStackFrame.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"

#include "uicom.h"
#include "btnbar.h"
#include "mainfrm.h"

#include "varpane.h"

#include "varmodi.h"
#include "varsrch.h"
#include "varcast.h"

#include "stksele.h"
#include "stkfmt.h"

#include "stkfrm.h"
#include "stkview.h"
#include "stkdoc.h"
#include "stklocal.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CMultiDocTemplate* pStkDocTemplate;

BOOL isStkSortByHistory = TRUE;
BOOL isStkDisplayVertically = TRUE;

BOOL isStkLocalActive = FALSE;

BOOL bStkFunctionsOnly = FALSE;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void StkOpenWindow(CMDIFrameWnd* pParent);
void StkCloseWindow(void);

BOOL StkAllocateSpace(void);
void StkReleaseSpace(void);


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void StkUpdateStackWindow(BOOL bUpdateStackOnly = FALSE);
BOOL StkIsEmpty(void);
int StkGetActiveLevel(void);

void StkSearchNextToken(void);

void StkInspectSource(void);
void StkRunUntil(void);
void StkSetBreakpoint(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern CMDIChildWnd* pStackWnd; // Defined in UICOM.H
extern BOOL isStackOn;          // Defined in UICOM.H

extern CStringList* pStkSearchPatternList;  // Defined in VARSRCH.CPP
extern CStringList* pStkTypeCastList;       // Defined in VARCAST.CPP
extern CPtrList* pStkAddLocalList;          // Defined in STKSELE.CPP
extern CPtrList* pStkRemoveLocalList;       // Defined in STKSELE.CPP

extern BOOL isVarWindowActive;

extern BOOL bStkLocalGetFocus;

extern BOOL bStkShowAddress;
extern BOOL bStkShowEntryPoint;
extern BOOL bStkShowModule;
extern BOOL bStkShowParameters;

extern HHOOK hookStkKeyFilter;

extern class VarServer stkObject;

extern BOOL GetCpuStatus(unsigned char & uchStatus);

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Open the Stack window if it's now closed.
void StkOpenWindow(CMDIFrameWnd* /* pParent */)
{
    // Assertion of the input parameters.

    // Only one Variable window.
    if ( ::isStackOn ) {
        return;
    }

    ::pStkDocTemplate->OpenDocumentFile(NULL);
    
    ::StkUpdateStackWindow();

}   // End of StkOpenWindow().


// Close the Stack window if it's now opened.
void StkCloseWindow(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pStackWnd );
    ASSERT( TRUE == ::isStackOn );

    // Send message to Stack window.
    ::pStackWnd->SendMessage(WM_CLOSE);

}   // End of StkCloseWindow().


// Allocate the space for the stack local variable list.
BOOL StkAllocateSpace(void)
{
    // Assertion of the input parameters.

    // Allocate ::pSearchPatternList.
    ::pStkSearchPatternList = new CStringList;
    ASSERT( ::pStkSearchPatternList );
    if ( !::pStkSearchPatternList ) {
        return (FALSE);
    }
    
    // Allocate ::pTypeCastList.
    ::pStkTypeCastList = new CStringList;
    ASSERT( ::pStkTypeCastList );
    if ( !::pStkTypeCastList ) {
        return (FALSE);
    }
    
    // Allocate ::pAddLocalList.
    ::pStkAddLocalList = new CPtrList;
    ASSERT( ::pStkAddLocalList );
    if ( !::pStkAddLocalList ) {
        return (FALSE);
    }

    // Allocate ::pRemoveLocalList.
    ::pStkRemoveLocalList = new CPtrList;
    ASSERT( ::pStkRemoveLocalList );
    if ( !::pStkRemoveLocalList ) {
        return (FALSE);
    }

    return (TRUE);
}

// Release the space.
void StkReleaseSpace(void)
{
    // Assertion of the input parameters.

    // Release the allocated space.
    if ( ::pStkSearchPatternList ) {
        delete ::pStkSearchPatternList;
    }
    
    if ( ::pStkTypeCastList ) {
        delete ::pStkTypeCastList;
    }

    if ( ::pStkAddLocalList ) {
        delete ::pStkAddLocalList;
    }

    if ( ::pStkRemoveLocalList ) {
        delete ::pStkRemoveLocalList;
    }
}


/////////////////////////////////////////////////////////////////////////////
// CStackFrame

IMPLEMENT_DYNCREATE(CStackFrame, CMDIChildWnd)

BOOL CStackFrame::OnCreateClient(LPCREATESTRUCT, CCreateContext* pContext)
{
    // Create a splitter with 2 rows, 1 column.
    if ( !m_wndSplitter.CreateStatic(this, 2, 1) ) {
        m_nErrorID = failSplitter;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return FALSE;
    }
    
    // Add the first splitter pane - the CStackView view in row 0.
    if ( !m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(CStackView),
            CSize(100, 100), pContext) ) {
        m_nErrorID = splitterPane;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return FALSE;
    }

    // Add the second splitter pane - the CVarView view in row 1.
    if ( !m_wndSplitter.CreateView(1, 0, RUNTIME_CLASS(CStackLocalView),
            CSize(0, 0), pContext) ) {
        m_nErrorID = splitterPane;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return FALSE;
    }

    // Activate the CStackView.
    SetActiveView((CView* )(m_wndSplitter.GetPane(0,0)));

    return TRUE;
}

CStackFrame::CStackFrame()
{
    // Set the Flag.
    ::isStackOn = TRUE;
    ::pStackWnd = this;
    
    // Initial.
    m_nErrorID = noError;
}

CStackFrame::~CStackFrame()
{
    // Reset the flag.
    ::isStackOn = FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// Common function.

// Display the error message.
void CStackFrame::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > noError && m_nErrorID < maxError );
    
    // Create the error message table.
    char* pszErrorMessage[] = {
        "",
        "Insufficient memory.",
        "Cannot create bottom pane in Stack window.",
        "Cannot create the splitter window.",
        "Cannot create the pane in the splitter window."
    };
    
    // Show the error message.
    AfxMessageBox(pszErrorMessage[m_nErrorID]);
}


/////////////////////////////////////////////////////////////////////////////
// Message map

/*
    ON_COMMAND(ID_VIEW_DISPLAYHORIZONTALLY, OnViewDisplayHorizontally)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DISPLAYHORIZONTALLY, OnUpdateViewDisplayHorizontally)
    ON_COMMAND(ID_VIEW_DISPLAYVERTICALLY, OnViewDisplayVertically)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DISPLAYVERTICALLY, OnUpdateViewDisplayVertically)
    ON_COMMAND(ID_VIEW_SORTBYHISTORY, OnViewSortbyHistory)
    ON_UPDATE_COMMAND_UI(ID_VIEW_SORTBYHISTORY, OnUpdateViewSortbyHistory)
    ON_COMMAND(ID_VIEW_SORTBYNAME, OnViewSortbyName)
    ON_UPDATE_COMMAND_UI(ID_VIEW_SORTBYNAME, OnUpdateViewSortbyName)
    ON_COMMAND(ID_VIEW_TYPECAST, OnViewTypecast)
    ON_UPDATE_COMMAND_UI(ID_VIEW_TYPECAST, OnUpdateViewTypecast)
*/
BEGIN_MESSAGE_MAP(CStackFrame, CMDIChildWnd)
    //{{AFX_MSG_MAP(CStackFrame)
    ON_CBN_KILLFOCUS(IDC_SRCHCOMBO, OnSrchComboKillFocus)
    ON_UPDATE_COMMAND_UI(IDC_SRCHCOMBO, OnUpdateSearchCombo)
    ON_WM_MENUSELECT()
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_MDIACTIVATE()
    ON_WM_GETMINMAXINFO()
    ON_COMMAND(ID_EDIT_INSPECTSOURCE, OnEditInspectsource)
    ON_COMMAND(ID_EDIT_SELECTLOCALVARIABLES, OnEditSelectLocalVariables)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SELECTLOCALVARIABLES, OnUpdateEditSelectLocalVariables)
    ON_COMMAND(ID_EDIT_MODIFYVALUES, OnEditModifyValues)
    ON_UPDATE_COMMAND_UI(ID_EDIT_MODIFYVALUES, OnUpdateEditModifyValues)
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCH, OnUpdateEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchNext)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCHNEXT, OnUpdateEditSearchNext)
    ON_WM_SETCURSOR()
    ON_UPDATE_COMMAND_UI(ID_EDIT_INSPECTSOURCE, OnUpdateEditInspectsource)
    ON_COMMAND(ID_VIEW_FORMATFUNCTIONLIST, OnViewFormatfunctionlist)
    ON_UPDATE_COMMAND_UI(ID_VIEW_FORMATFUNCTIONLIST, OnUpdateViewFormatfunctionlist)
    ON_COMMAND(ID_VIEW_FUNCTIONSANDLOCALS, OnViewFunctionsandlocals)
    ON_UPDATE_COMMAND_UI(ID_VIEW_FUNCTIONSANDLOCALS, OnUpdateViewFunctionsandlocals)
    ON_COMMAND(ID_VIEW_FUNCTIONSONLY, OnViewFunctionsonly)
    ON_UPDATE_COMMAND_UI(ID_VIEW_FUNCTIONSONLY, OnUpdateViewFunctionsonly)
    ON_COMMAND(ID_SHIFTRETURN, OnShiftreturn)
    ON_COMMAND(ID_STK_TAB, OnStkTab)
    ON_COMMAND(ID_VIEW_RUNUNTIL, OnViewRununtil)
    ON_UPDATE_COMMAND_UI(ID_VIEW_RUNUNTIL, OnUpdateViewRununtil)
    ON_COMMAND(ID_VIEW_SETBREAKPOINT, OnViewSetbreakpoint)
    ON_UPDATE_COMMAND_UI(ID_VIEW_SETBREAKPOINT, OnUpdateViewSetbreakpoint)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStackFrame message handlers

void CStackFrame::OnSrchComboKillFocus(void)
{   
    CMainFrame * pMain = (CMainFrame *)AfxGetApp()->m_pMainWnd;
    CString str = pMain->m_wndToolBar.GetSrchEditText();
    if(str != "") { 
        pMain->m_wndToolBar.AddSrchText(str);
        ::pStkSearchPatternList->AddTail(str);
    }
}

void CStackFrame::OnUpdateSearchCombo(CCmdUI* pCmdUI)
{
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;
    
    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::StkIsEmpty());
}


void CStackFrame::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu)
{
    // TODO: Add your message handler code here and/or call default
    
    // Set the global flag.
    int i = 0;
    
    CMDIChildWnd::OnMenuSelect(nItemID, nFlags, hSysMenu);
}

int CStackFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here
    
    // Create the bottom pane.
    if ( !m_wndBottomPane.Create(this) ) {
        m_nErrorID = bottomPane;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return -1;
    }

    return 0;
}

void CStackFrame::OnSize(UINT nType, int cx, int cy)
{
    CMDIChildWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here

    // Adjust the splitter window position.
    CRect rect(0, 0, cx, cy-bottomHeight);
    m_wndSplitter.MoveWindow(rect);
        
    // Adjust the Bottom pane position.
    rect = CRect(0, cy-bottomHeight, cx, cy);
    m_wndBottomPane.MoveWindow(rect);
}

void CStackFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
    // TODO: Add your message handler code here and/or call default
    
    // Set the minimum range.
    lpMMI->ptMinTrackSize = CPoint(bottomHeight*10, bottomHeight*4);

    CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}

void CStackFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
    CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
    
    // TODO: Add your message handler code here
    
    // Update both of the panes.
//    if( bActivate && this == pActivateWnd ) {
//        ::StkUpdateStackWindow();
//    }

    // Remove the hook function from the hook chain.
    if ( !bActivate && this == pDeactivateWnd ) {
        if ( ::hookStkKeyFilter ) {
            UnhookWindowsHookEx(::hookStkKeyFilter);
            ::hookStkKeyFilter = 0;
        }
    }


    if(bActivate && pActivateWnd == this)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
            LONG(WID_STACK));
    else if(!bActivate && !pActivateWnd)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 
}

BOOL CStackFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    
    // Disable parent window from pre-handling the WM_RBUTTONDOWN message.
    // MAINFRM latch WM_RBUTTONDOWN to implement local menu.
    if( message == WM_RBUTTONDOWN ) {
        return FALSE;
    }

    return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}


/////////////////////////////////////////////////////////////////////////////
// Local pane.

void CStackFrame::OnEditSelectLocalVariables()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;
    
    // Open Select Local Variables dialog.
    CStackSelectLocalDialog dlg;
    dlg.DoModal();
    
    // Activate the Local window.
    SetActiveView((CView* )(m_wndSplitter.GetPane(1,0)));
}

void CStackFrame::OnUpdateEditSelectLocalVariables(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;
    
    // Enable or disable according to if the Stack local window is empty.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else if ( ::pStkAddLocalList->IsEmpty() &&  
              ::pStkRemoveLocalList->IsEmpty() ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable(TRUE);
    }
}

void CStackFrame::OnEditModifyValues()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;
    
    // Open the Modify Variable dialog.
    CVarModifyVariableDialog dlg;
    dlg.DoModal();

    // Update upper pane.
    ::StkUpdateStackWindow(TRUE);
}

void CStackFrame::OnUpdateEditModifyValues(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;
    
    // Enable or disable according to if the Stack local window is empty.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        BOOL bEnable = TRUE;
	    unsigned char    uch;
	
		GetCpuStatus(uch);
		if ( uch ) {
	        bEnable = FALSE;
	    }
        else if ( ::StkIsEmpty() ) {
            bEnable = FALSE;
        }
        else {
    	::stkObject.VarLineToNode(((CStackLocalView*)GetActiveView())->m_nCurRow, 
						 ((CStackLocalView*)GetActiveView())->m_pVarNode);

            ((CStackLocalView*)GetActiveView())->DetectVarFormat();
            if ( ((CStackLocalView*)GetActiveView())->simpleSign != 
                 ((CStackLocalView*)GetActiveView())->m_nBmpStatus ) {
                bEnable = FALSE;
            }
        }
        pCmdUI->Enable(bEnable);
    }
}

void CStackFrame::OnEditSearch()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Open the Search Dialog.
    CVarSearchDialog dlg;
    dlg.DoModal();
}

void CStackFrame::OnUpdateEditSearch(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;
    
    // Enable or disable according to if the Variable window is empty.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable(!::StkIsEmpty());
    }
}

void CStackFrame::OnEditSearchNext()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Search the token from the next line.
    ::StkSearchNextToken();
}

void CStackFrame::OnUpdateEditSearchNext(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Enable or disable the menu item.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else if ( ::StkIsEmpty() ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable(!::pStkSearchPatternList->IsEmpty());
    }
}

/*
void CStackFrame::OnViewDisplayHorizontally()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Check the global flag.
    if ( !::isStkDisplayVertically ) {
        return;
    }
    
    // Display horizontally.
    ::isStkDisplayVertically = FALSE;

    // TODO:

}

void CStackFrame::OnUpdateViewDisplayHorizontally(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Set the radio dot or not.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->SetRadio(!::isStkDisplayVertically);
    }
}

void CStackFrame::OnViewDisplayVertically()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Check the global flag.
    if ( ::isStkDisplayVertically ) {
        return;
    }
    
    // Display vertically.
    ::isStkDisplayVertically = TRUE;

    // TODO:

}

void CStackFrame::OnUpdateViewDisplayVertically(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Set the radio dot or not.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->SetRadio(::isStkDisplayVertically);
    }
}

void CStackFrame::OnViewSortbyHistory()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Check the global flag.
    if ( ::isStkSortByHistory ) {
        return;
    }
    
    // Sort by history.
    ::isStkSortByHistory = TRUE;

    // TODO:
    
}

void CStackFrame::OnUpdateViewSortbyHistory(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Set the radio dot or not.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->SetRadio(::isStkSortByHistory);
    }
}

void CStackFrame::OnViewSortbyName()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Check the global flag.
    if ( !::isStkSortByHistory ) {
        return;
    }
    
    // Sort by name.
    ::isStkSortByHistory = FALSE;

    // TODO:
    
}

void CStackFrame::OnUpdateViewSortbyName(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Set the radio dot or not.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->SetRadio(!::isStkSortByHistory);
    }
}

void CStackFrame::OnViewTypecast()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Open Type Cast dialog.
    CVarTypeCastDialog dlg;
    dlg.DoModal();
}

void CStackFrame::OnUpdateViewTypecast(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isStkLocalActive = TRUE;
    ::isVarWindowActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    if ( !::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable(!::StkIsEmpty());
    }
}
*/


/////////////////////////////////////////////////////////////////////////////
// Stack pane.

void CStackFrame::OnEditInspectsource()
{
    // TODO: Add your command handler code here
    
    // Call from Source window.
    ::StkInspectSource();
}

void CStackFrame::OnUpdateEditInspectsource(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable or disable according to if the Stack window is getting focus.
    if ( ::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable( -1 != ::StkGetActiveLevel() );
    }
}

void CStackFrame::OnViewFormatfunctionlist()
{
    // TODO: Add your command handler code here

    // Open the dialog.
    CStackFormatDialog dlg;
    dlg.DoModal();
}

void CStackFrame::OnUpdateViewFormatfunctionlist(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable or disable according to if the Stack window is getting focus.
    if ( ::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable( -1 != ::StkGetActiveLevel() );
    }
}

void CStackFrame::OnViewFunctionsandlocals()
{
    // TODO: Add your command handler code here
    
    // Check the global flag.
    if ( !::bStkFunctionsOnly ) {
        return;
    }
    
    // Shown as Functions and Locals.
    ::bStkFunctionsOnly = FALSE;
    
    // TODO: Both Functions and Locals are shown.
    CRect rect;
    m_wndSplitter.GetClientRect(rect);
    m_wndSplitter.SetRowInfo(0, rect.Height()/2, 0);

    m_wndSplitter.RecalcLayout();
}

void CStackFrame::OnUpdateViewFunctionsandlocals(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable or disable according to if the Stack window is getting focus.
    if ( ::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else if ( -1 == ::StkGetActiveLevel() ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->SetRadio(!::bStkFunctionsOnly);
    }
}

void CStackFrame::OnViewFunctionsonly()
{
    // TODO: Add your command handler code here
    
    // Check the global flag.
    if ( ::bStkFunctionsOnly ) {
        return;
    }
    
    // Shown as Functions only.
    ::bStkFunctionsOnly = TRUE;
    
    // TODO: Only Functions are shown.
    CRect rect;
    m_wndSplitter.GetClientRect(rect);
    m_wndSplitter.SetRowInfo(0, rect.Height(), 0);

    m_wndSplitter.RecalcLayout();
}

void CStackFrame::OnUpdateViewFunctionsonly(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable or disable according to if the Stack window is getting focus.
    if ( ::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else if ( -1 == ::StkGetActiveLevel() ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->SetRadio(::bStkFunctionsOnly);
    }
}

void CStackFrame::OnShiftreturn()
{
    // TODO: Add your command handler code here
    
    // Mouse right down.
    if ( !::bStkLocalGetFocus ) {
        (m_wndSplitter.GetPane(0,0))->SendMessage(WM_RBUTTONDOWN);
    }
    else {
        (m_wndSplitter.GetPane(1,0))->SendMessage(WM_RBUTTONDOWN);
    }
}

void CStackFrame::OnStkTab()
{
    // TODO: Add your command handler code here
    
    // Toggle between Stack & Local pane.
    if ( !::bStkLocalGetFocus ) {
        SetActiveView((CView* )(m_wndSplitter.GetPane(1,0)));
    }
    else {
        SetActiveView((CView* )(m_wndSplitter.GetPane(0,0)));
    }
}

void CStackFrame::OnViewRununtil()
{
    // TODO: Add your command handler code here

    // Run until the specific address.
    ::StkRunUntil();
}

void CStackFrame::OnUpdateViewRununtil(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable or disable according to if the Stack window is getting focus.
    if ( ::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable( -1 != ::StkGetActiveLevel() );
    }
}

void CStackFrame::OnViewSetbreakpoint()
{
    // TODO: Add your command handler code here

    // Set the breakpoint at the specific address.
    ::StkSetBreakpoint();
}

void CStackFrame::OnUpdateViewSetbreakpoint(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Enable or disable according to if the Stack window is getting focus.
    if ( ::bStkLocalGetFocus ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable( -1 != ::StkGetActiveLevel() );
    }
}
