
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/STKVIEW.H__   1.7.1.0.1.0   11 Nov 1996 12:57:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/STKVIEW.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:20   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:10   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:24:42   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:51:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:43:30   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:49:00   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:51:16   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:04   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:44   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:04   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.31   18 Apr 1996 12:53:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:52   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:22:30   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:14   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:04   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:42   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:36   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:52   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:08   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:00   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:18   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:46   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:52   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:06   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:36   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:56   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:38   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:02   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:02   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:32   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:44   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:16   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:04   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:46   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:19:14   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:49:06   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:57:26   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:47:02   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:42   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKVIEW.H
//
//  Description: The header file for the class: CStackView.
//
//  Author: Chen Jun
//
//  Date: 07/29/95
//
//  Modification:
//      1. 07/29/95, Initial version of the class: CStackView.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _STKVIEW_
#define _STKVIEW_

#include "stkdoc.h"

#include "symblsvr.h"
#include "stkinit.h"      
#include "yyhgrid.h"

#define IDC_YYHGRID   888   

////////////////////////////////////////////////////////////////////////////
// CStackView form view

#ifndef __AFXEXT_H__
#include <afxext.h>
#endif

class CStackView : public CView
{
    DECLARE_DYNCREATE(CStackView)
protected:
    CStackView();           // protected constructor used by dynamic creation
    void InitialMember(void);

// Form Data
public:
    //{{AFX_DATA(CStackView)

	//}}AFX_DATA

// Attributes
public:
    CStackDoc* GetDocument();
    CYYHGrid m_Grid;
private:
    int m_nCurRow;

    int m_nMaxColumn;
    enum {
        levelColumn = 0,
        addressColumn,
        entryPointColumn,
        moduleColumn,
        functionColumn,
        totalColumn = 5,
    };

// Operations
private:
    // Get from Stack server.
    int m_nMaxLevel;
    
    CString m_strLevel;
    CString m_strAddress;
    CString m_strEntryPoint;
    CString m_strModule;
    CString m_strFunction;
    
    struct STKNode* m_pStkNode;
    void GetMaxLevel(void);
    void GetStackInfo(void);
    void ShowStackInfo(void);

private:
    // Initial grid.
    enum { 
        staticText = 5,
        alignHLeft = 0,
        alignHCenter = 2,
        alignVCenter = 1,
    };
    CRect m_rectClient;
 //   void InitialGrid(void);
    
private:
    // Update grid.
    void UpdateGrid(void);
    void HideColumn(void);

private:
    // Highlight the active row.   
    BOOL m_bUpdateStackOnly;
    //void HighLightRow(void);

private:
    // Reset the active row.
    enum { actionActiveCell = 0 };
   // void ResetRow(void);
    
private:

private:
// Implementation
public:
    // Public function.
    void UpdateStackWindow(BOOL bUpdateStackOnly);
    void InspectSource(void);
    void SetBreakpoint(void);
    void RunUntil(void);      	
    int GetActiveLevel(void);

protected:
     ~CStackView();
      void OnDraw(CDC* pDC) ;

    // Standard overrides of MFC classes.
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    // Generated message map functions
    //{{AFX_MSG(CStackView)
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnDestroy();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg LONG OnUpdateLocal(UINT,LONG);
	//}}AFX_MSG
	
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////// End of File ////////////////////////////////
