
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMBLEXT.H__   1.7.1.0.1.0   11 Nov 1996 12:58:44   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMBLEXT.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:44   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:32   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:04   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:12   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:40   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:34   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:36   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:35:22   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:24   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:54   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:50   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:34   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:36   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:06   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:38   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:08   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:04   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:22   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:06   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:46   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:24   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:48   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:40   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:52   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:44   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:22   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:04   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:08   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:12   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:06   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:02   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:00   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:02   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:14   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:38   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:30   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:36   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:44   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:26   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:26   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symblext.h
**
**  Description:
**     Contains declarations of external interfaces to handle bulk-data
**     access from the Symbol server.
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMBLEXT.H__   1.7.1.0.1.0   11 Nov 1996 12:58:44   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMBLEXT_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symblsvr.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/*****************************************************************************
** SymGetSymStats
**
** Purpose:
**    Retrieve the number of modules, functions, labels loaded.
**
** Input parameter:
**    none
** Output parameters:
**    numModules:      pointer to number of modules loaded
**    numFunctions:    pointer to number of functions loaded
**    numPublicLabels: pointer to number of public labels loaded
**    numUserLabels:   pointer to number of user-defined labels.
**
** Error:
**    Reports error if no symbol loaded
**
*****************************************************************************/
RETCODE EXPORT 
SymGetSymStats(U16 FAR* numModules, U32 FAR* numFunctions, U32 FAR*
               numPublicLabels, U32 FAR* numUserLabels); 


/***************************************************************************
** SymGetSiblingSymbols
**
** Purpose:
**    Get the specified number of sibling symbol descriptors from the input
**    descriptor <symDesc>. Fill the descriptors into the supplied
**    symDescArray[numRequested].  Return the actual number of symbol
**    descriptors filled in.
**    If the input <symDesc> is a NULL_DESCRIPTOR and the <basicSymType>
**    is SYM_MODULE, then retrieve all module descriptors started from the
**    modules list head.
**    If the input <symDesc> is a NULL_DESCRIPTOR and the <basicSymType>
**    is SYM_PUBLIC_LABEL, then retrieve all public label descriptors started
**    from the public_label list head.
**
** Input parameter:
**    symDesc:      symbol descriptor for starting point
**    basicSymType: type of symbol (modules, label, functions, etc.)
**    numRequested: number of requested sibling symbols.           
**
** Output parameter:
**    symDescArray: a caller supplied symbol descriptor array -
**                  symDescArray[numRequested].
**    numReturned:  actual number of symbol returned.              
**
** Error:
**    Returns error if no symbol loaded.
**    Returns error if <basicSymType> is not a valid type for the type of
**    <symDesc>.
**
*****************************************************************************/
RETCODE EXPORT
SymGetSiblingSymbols(SYM_DESCRIPTOR      symDesc,
                     SYM_TYPE_TYPE       basicSymType,
                     U16                 numRequested,
                     SYM_DESCRIPTOR FAR* symDescArray,
                     U16 FAR*            numReturned);


/***************************************************************************
** SymGetChildSymbolsOfModule
**
** Purpose:
**    Get the specified number of child symbol descriptors of <basicSymType>
**    that are child symbols of the input <moduleDesc>. Fill the child
**    descriptors into the supplied symDescArray. Return the actual number
**    of symbol descriptors filled in.
**
** Input parameter:
**    moduleDesc:   module symbol descriptor
**    basicSymType: type of symbol (functions, block, etc.)
**    numRequested: number of requested child symbols.           
**
** Output parameter:
**    symDescArray: a caller supplied symbol descriptor array -
**                  symDescArray[numRequested].
**    numReturned:  actual number of symbol returned.              
**
** Error:
**    Returns error if no symbol loaded.
**    Returns error if <basicSymType> is not a valid type for child symbol.
**
*****************************************************************************/
RETCODE EXPORT
SymGetChildSymbolsOfModule(SYM_DESCRIPTOR      moduleDesc,
                           SYM_TYPE_TYPE       basicSymType,
                           U16                 numRequested,
                           SYM_DESCRIPTOR FAR* symDescArray,
                           U16 FAR*            numReturned);

/*****************************************************************************
** SymGetLineNumbersOfModule
**
** Purpose:
**    Get the specified number of line number descriptors of the input
**    <moduleDesc>. Fill the line number descriptors into the supplied
**    lineDescArray. Return the actual number of descriptors filling in.
**
** Input parameter:
**    moduleDesc:   module symbol descriptor
**    numRequested: number of requested line numbers.           
**
** Output parameter:
**    lineDescArray: a caller supplied line number descriptor array -
**                   lineDescArray[numRequested].
**    numReturned:  actual number of line returned.              
**
** Error:
**    Returns error if no line numbers.
**
*****************************************************************************/
RETCODE EXPORT
SymGetLineNumbersOfModule(SYM_DESCRIPTOR          moduleDesc,
                          U16                     numRequested,
                          LINENUM_DESCRIPTOR FAR* lineDescArray,
                          U16 FAR*                numReturned);

/*****************************************************************************
** SymGetLineNumbersList
**
** Purpose:
**    Get the specified number of linenumber descriptors adjacent to the
**    input <lineDesc>. Fill the linenum descriptors into the supplied
**    lineDescArray. Return the actual number of descriptors filling in.
**
** Input parameter:
**    moduleDesc:   module contained the line numbers   
**    lineDesc:     start linenumber descriptor
**    numRequested: number of requested linenumbers.
**
** Output parameter:
**    lineDescArray: a caller supplied linenumber descriptor array -
**                   lineDescArray[numRequested].
**    numReturned:  actual number of line returned.              
**
** Error:
**    Returns error if no line numbers existed for the <moduleDesc>.
**
*****************************************************************************/
RETCODE EXPORT
SymGetLineNumbersList(SYM_DESCRIPTOR          moduleDesc,
                      LINENUM_DESCRIPTOR      startLineDesc,
                      U16                     numRequested,
                      LINENUM_DESCRIPTOR FAR* lineDescArray,
                      U16 FAR*                numReturned);

#ifdef __cplusplus
}
#endif

#define _SYMBLEXT_
#endif /* _SYMBLEXT_ */
/******************************** E O F *************************************/
