/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMCALC.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:58   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMCALC.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:58   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:48   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:18   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:22   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:22   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:52   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:08   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:37:32   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:02:08   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:16:58   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:20   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:46   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:06   Shirley
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:  SYMCALC.CPP
**
**  Description:
**      member function of class CSymSyntax
**
**  Status:  CODED
**
**    Rev 1.0   21 March 1996 13:30:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <memory.h>
#include <string.h>
#include "abibase.h"
#include "symblsvr.h"
#include "symcalc.h"
#include "symoptpr.h"
#include "symsyn.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
int nSymModifyMemory = 0;
                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern void ShowLine(char *);
extern STATUS AbiGetMemN(ADDR addr1, ADDR addr2,char* pchBuff);
extern STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
extern int SrcIsStatement(void);
extern int SrcIsIEEE(void);
extern void ConvEnumToAbiType( SEGMENTTYPE type , unsigned char& addrType );
extern void Omf51ConvPtrToSeg( char c , SEGMENTTYPE& type );
extern void UbrofConvPtrToSeg( char c , SEGMENTTYPE& type );
extern int GetBitValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode);
extern int GetSValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode);
extern int GetEnumValue(TYPE_INDEX typeIndex, SYM_TOKEN_NODE *pNode);
extern void MemoryTypeConvToSeg( MEMORY_TYPE t , SEGMENTTYPE& type );
extern int FindNextType(TYPE_INDEX oldType , TYPE_INDEX& nextIndex);
extern int GetUserVarValue(char *str,short& value);
extern int SetUserVarValue(char *str,short value);
extern int BuildDetailedType(TYPE_INDEX typeIndex, char *str);
extern int BuildCAddr( SEGMENTTYPE type , U32 addr , char* str );

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
*                                                                          
*  CheckOneOperate  --  check legal operate and convert token node                          
*  parameter :                                                             
*       nType  --  operator type
*  return value :                                                          
*       None                                                               
*                                                                          
***************************************************************************/
int CSymCalc::CheckOneOperate(int nType)
{   
	// m_nFlag == 0   --   char;
	//          1   --   unsigned char;
	//          2   --   short;
	//          3   --   unsigned short;
	//          4   --   long;
	//          5   --   unsigned long;
	//          6   --   double;
	if ( symType != SYMTOKEN_NUM && symType != SYMTOKEN_FLOAT &&
		symType != SYMTOKEN_SYMBOL ) return 6;
	switch ( nType ) {
	case 1 :
	case 2 :
	case 3 :
	case 4 :
	case 5 :
		break;
	default :
		return 6;
	}
	
	if ( symType == SYMTOKEN_SYMBOL ) {
//		if ( nComplexType ) return 10;  // not support
		if ( nComplexType == 1 ) {
			if ( nType == 5 ) {
			    TYPE_HEADER_TYPE typeHeader;
//			    TYPE_INDEX typeIndex;
			    char temp[256];
			
//			    typeIndex = pNode->typeIndex;
			    typeHeader.typeName = temp;
			    if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ) {
			        return 7;
			    }                              
			    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
		            return 7;
			    }
			    else {
			        if ( typeHeader.t.complexType == TY_TYPE ) {
			            while( 1 ) {
			                TYPE_INDEX  typeNext;
			                   
			                if (GOOD!=SymGetTypeTypeIndex(typeIndex,&typeNext) ) {
			                    return 7;
			                }
			                typeIndex = typeNext;
			                if (GOOD!=SymGetTypeHeader(typeIndex, &typeHeader) ){
			                    return 7;
			                }
			                if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
			                    break;
			                else if ( typeHeader.t.complexType != TY_TYPE )
			                    break;
			            }   
			            if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
		                    return 7;
			            }
			        }
			
			        if ( typeHeader.typeChoice==COMPLEX_TYPE_CLASS ) {
			        	if ( (typeHeader.t.complexType == TY_SMALL_PTR) || 
			        		(typeHeader.t.complexType == TY_OMF51_PTR) ) {
			            	return 0;
			            }
			        }
			        return 7;    
			    }
			}
			else return 10;  // not support
		}
		else if ( nComplexType == 2 ) return 11;
	}
	else if ( nType == 5 ) return 11;
	
	if ( m_nFlag == -1 ) {
		switch ( typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
			symType = SYMTOKEN_NUM;
			m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
			symType = SYMTOKEN_NUM;
			m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
			symType = SYMTOKEN_NUM;
			m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
			symType = SYMTOKEN_NUM;
			m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
			symType = SYMTOKEN_NUM;
			m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
			symType = SYMTOKEN_NUM;
			m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
			symType = SYMTOKEN_FLOAT;
			m_nFlag = 6;
			break;
	    case 99 :
			return 10;
	    default :
			symType = SYMTOKEN_NUM;
			m_nFlag = 1;
	        break;
	    }
	}		  
	if ( nType == 3 || nType == 4 ) {
		if ( m_nFlag == 6 ) return 11;
	}
	return 0;
}

/***************************************************************************
*                                                                          
*  CheckTwoOperate  --  check legal operate and convert token node                          
*  parameter :                                                             
*       pNode1  --  next token node
*       nType  --  operator type
*  return value :                                                          
*       None                                                               
*                                                                          
***************************************************************************/
int CSymCalc::CheckTwoOperate(CSymCalc *pNode1, int nType)
{   
	// m_nFlag == 0   --   char;
	//          1   --   unsigned char;
	//          2   --   short;
	//          3   --   unsigned short;
	//          4   --   long;
	//          5   --   unsigned long;
	//          6   --   double;
	if ( symType != SYMTOKEN_NUM && symType != SYMTOKEN_FLOAT &&
		symType != SYMTOKEN_SYMBOL ) return 6;
	if ( pNode1 == 0 ) return 6;
	if ( pNode1->symType!= SYMTOKEN_NUM && pNode1->symType!=SYMTOKEN_FLOAT &&
		pNode1->symType != SYMTOKEN_SYMBOL ) return 6;
	if ( nType < 10 || nType > 29 ) return 6;
	
	if ( symType == SYMTOKEN_SYMBOL ) {
		if ( nComplexType ) {
//			if ( pNode1->symType == SYMTOKEN_SYMBOL && pNode1->nComplexType )
//				return 10;  // not support
//			else return 11;
			return 11;
		}
		if ( pNode1->symType == SYMTOKEN_SYMBOL && pNode1->nComplexType ) 
			return 11;
	}
	
	if ( m_nFlag == -1 ) {
		switch ( typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
			symType = SYMTOKEN_NUM;
			m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
			symType = SYMTOKEN_NUM;
			m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
			symType = SYMTOKEN_NUM;
			m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
			symType = SYMTOKEN_NUM;
			m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
			symType = SYMTOKEN_NUM;
			m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
			symType = SYMTOKEN_NUM;
			m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
			symType = SYMTOKEN_FLOAT;
			m_nFlag = 6;
			break;
	    case 99 :
			return 10;
	    default :
			symType = SYMTOKEN_NUM;
			m_nFlag = 1;
	        break;
	    }
	}		  
	if ( pNode1->m_nFlag == -1 ) {
		switch ( pNode1->typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
			symType = SYMTOKEN_FLOAT;
			pNode1->m_nFlag = 6;
			break;
	    case 99 :
			return 10;
	    default :
//			symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 1;
	        break;
	    }
	}		  
	
	if ( m_nFlag > pNode1->m_nFlag ) {
		if ( GOOD != pNode1->ModifyResult(m_nFlag) ) return 12;
	}
	else if ( m_nFlag < pNode1->m_nFlag ) {
		if ( GOOD != ModifyResult(pNode1->m_nFlag) ) return 12;
	}
	
	if ( m_nFlag == 6 ) {
		if ( nType == 17 || nType == 18 ) return 11;
		if ( nType >= 25 ) return 11;
	}
	return 0;
}

/***************************************************************************
*                                                                          
*  ModifyResult  --  convert token node to required type
*  parameter :                                                             
*       nResultFlag  --  operand type
*  return value :                                                          
*       None                                                               
*                                                                          
***************************************************************************/
int CSymCalc::ModifyResult(int nResultFlag)
{
	unsigned char uch;
	short sh;           
	unsigned short ush;
	long lo;
	unsigned long ulo;
	double db;
		
	if ( nResultFlag <= m_nFlag ) return FAILURE;
	switch( nResultFlag ) {
	case 1 :                 
		if ( m_nFlag == 0 ) {
			uch = ( unsigned char ) result.c;
		}
		else return FAILURE;
		result.uc = uch;
		m_nFlag = nResultFlag;
		typeValue = BI_U8_UCHAR;
		symType = SYMTOKEN_NUM;
		break;
	case 2 :  
		if ( m_nFlag == 0 ) {
			sh = ( short ) result.c;
		}
		else if ( m_nFlag == 1 ) {
			sh = ( short ) result.uc;
		}
		else return FAILURE;
		result.i = sh;
		m_nFlag = nResultFlag;
		typeValue = BI_S16_SHORT;
		symType = SYMTOKEN_NUM;
		break;
	case 3 :
		if ( m_nFlag == 0 ) {
			ush = ( unsigned short ) result.c;
		}
		else if ( m_nFlag == 1 ) {
			ush = ( unsigned short ) result.uc;
		}    
		else if ( m_nFlag == 2 ) {
			ush = ( unsigned short ) result.i;
		}    
		else return FAILURE;
		result.ui = ush;
		m_nFlag = nResultFlag;
		typeValue = BI_S16_USHORT;
		symType = SYMTOKEN_NUM;
		break;
	case 4 :
		if ( m_nFlag == 0 ) {
			lo = ( long ) result.c;
		}
		else if ( m_nFlag == 1 ) {
			lo = ( long ) result.uc;
		}    
		else if ( m_nFlag == 2 ) {
			lo = ( long ) result.i;
		}    
		else if ( m_nFlag == 3 ) {
			lo = ( long ) result.ui;
		}    
		else return FAILURE;
		result.l = lo;
		m_nFlag = nResultFlag;
		typeValue = BI_S32_SLONG;
		symType = SYMTOKEN_NUM;
		break;
	case 5 :
		if ( m_nFlag == 0 ) {
			ulo = ( unsigned long ) result.c;
		}
		else if ( m_nFlag == 1 ) {
			ulo = ( unsigned long ) result.uc;
		}    
		else if ( m_nFlag == 2 ) {
			ulo = ( unsigned long ) result.i;
		}    
		else if ( m_nFlag == 3 ) {
			ulo = ( unsigned long ) result.ui;
		}    
		else if ( m_nFlag == 4 ) {
			ulo = ( unsigned long ) result.l;
		}    
		else return FAILURE;
		result.ul = ulo;
		m_nFlag = nResultFlag;
		typeValue = BI_U32_ULONG;
		symType = SYMTOKEN_NUM;
		break;
	case 6 :
		if ( m_nFlag == 0 ) {
			db = ( double ) result.c;
		}
		else if ( m_nFlag == 1 ) {
			db = ( double ) result.uc;
		}    
		else if ( m_nFlag == 2 ) {
			db = ( double ) result.i;
		}    
		else if ( m_nFlag == 3 ) {
			db = ( double ) result.ui;
		}    
		else if ( m_nFlag == 4 ) {
			db = ( double ) result.l;
		}    
		else if ( m_nFlag == 5 ) {
			db = ( double ) result.ul;
		}    
		else return FAILURE;
		result.d = db;
		m_nFlag = nResultFlag;
		typeValue = BI_F64;
		symType = SYMTOKEN_FLOAT;
		break;            
	default :
		return FAILURE;
	}
	return GOOD;
}

int CSymCalc::operator+(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c + pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc + pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i + pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui + pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l + pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul + pNode1.result.ul);
        break;
    case 6 :
		result.d = result.d + pNode1.result.d;
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator-(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c - pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc - pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i - pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui - pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l - pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul - pNode1.result.ul);
        break;
    case 6 :
		result.d = result.d - pNode1.result.d;
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator*(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c * pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc * pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i * pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui * pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l * pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul * pNode1.result.ul);
        break;
    case 6 :
		result.d = result.d * pNode1.result.d;
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator/(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		if ( pNode1.result.c == 0 ) return 13;
		result.c = (char)(result.c / pNode1.result.c);
        break;
    case 1 :
		if ( pNode1.result.uc == 0 ) return 13;
		result.uc = (unsigned char)(result.uc / pNode1.result.uc);
        break;
    case 2 :
		if ( pNode1.result.i == 0 ) return 13;
		result.i = (short)(result.i / pNode1.result.i);
        break;
    case 3 :
		if ( pNode1.result.ui == 0 ) return 13;
		result.ui = (unsigned short)(result.ui / pNode1.result.ui);
        break;
    case 4 :
		if ( pNode1.result.l == 0 ) return 13;
		result.l = (long)(result.l / pNode1.result.l);
        break;
    case 5 :
		if ( pNode1.result.ul == 0 ) return 13;
		result.ul = (unsigned long)(result.ul / pNode1.result.ul);
        break;
    case 6 :
		if ( pNode1.result.d == 0.0 ) return 13;
		result.d = result.d / pNode1.result.d;
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator%(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		if ( pNode1.result.c == 0 ) return 13;
		result.c = (char)(result.c % pNode1.result.c);
        break;
    case 1 :
		if ( pNode1.result.uc == 0 ) return 13;
		result.uc = (unsigned char)(result.uc % pNode1.result.uc);
        break;
    case 2 :
		if ( pNode1.result.i == 0 ) return 13;
		result.i = (short)(result.i % pNode1.result.i);
        break;
    case 3 :
		if ( pNode1.result.ui == 0 ) return 13;
		result.ui = (unsigned short)(result.ui % pNode1.result.ui);
        break;
    case 4 :
		if ( pNode1.result.l == 0 ) return 13;
		result.l = (long)(result.l % pNode1.result.l);
        break;
    case 5 :
		if ( pNode1.result.ul == 0 ) return 13;
		result.ul = (unsigned long)(result.ul % pNode1.result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator>>(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c >> pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc >> pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i >> pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui >> pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l >> pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul >> pNode1.result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator<<(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c << pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc << pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i << pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui << pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l << pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul << pNode1.result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator&(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c & pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc & pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i & pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui & pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l & pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul & pNode1.result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator^(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c ^ pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc ^ pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i ^ pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui ^ pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l ^ pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul ^ pNode1.result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator|(CSymCalc& pNode1)
{
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(result.c | pNode1.result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(result.uc | pNode1.result.uc);
        break;
    case 2 :
		result.i = (short)(result.i | pNode1.result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(result.ui | pNode1.result.ui);
        break;
    case 4 :
		result.l = (long)(result.l | pNode1.result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(result.ul | pNode1.result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}
    
int CSymCalc::operator&&(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c && pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc && pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i && pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui && pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l && pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul && pNode1.result.ul;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}
    
int CSymCalc::operator||(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c || pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc || pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i || pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui || pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l || pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul || pNode1.result.ul;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}

int CSymCalc::operator<(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c < pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc < pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i < pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui < pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l < pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul < pNode1.result.ul;
        break;
    case 6 :
		nFlag = result.d < pNode1.result.d;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}

int CSymCalc::operator>(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c > pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc > pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i > pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui > pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l > pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul > pNode1.result.ul;
        break;
    case 6 :
		nFlag = result.d > pNode1.result.d;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}

int CSymCalc::operator<=(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c <= pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc <= pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i <= pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui <= pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l <= pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul <= pNode1.result.ul;
        break;
    case 6 :
		nFlag = result.d <= pNode1.result.d;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}


int CSymCalc::operator>=(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c >= pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc >= pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i >= pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui >= pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l >= pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul >= pNode1.result.ul;
        break;
    case 6 :
		nFlag = result.d >= pNode1.result.d;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}


int CSymCalc::operator==(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c == pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc == pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i == pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui == pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l == pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul == pNode1.result.ul;
        break;
    case 6 :
		nFlag = result.d == pNode1.result.d;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}

int CSymCalc::operator!=(CSymCalc& pNode1)
{
	int nFlag;
//	if ( pNode1 == 0 ) return 10;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = result.c != pNode1.result.c;
        break;
    case 1 :
		nFlag = result.uc != pNode1.result.uc;
        break;
    case 2 :
		nFlag = result.i != pNode1.result.i;
        break;
    case 3 :
		nFlag = result.ui != pNode1.result.ui;
        break;
    case 4 :
		nFlag = result.l != pNode1.result.l;
        break;
    case 5 :
		nFlag = result.ul != pNode1.result.ul;
        break;
    case 6 :
		nFlag = result.d != pNode1.result.d;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}

int CSymCalc::Plus(void)
{
	if ( m_nFlag < 0 || m_nFlag > 6 ) return 10;
	
	return 0;
}

int CSymCalc::Minus(void)
{
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(-result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(-result.uc);
        break;
    case 2 :
		result.i = (short)(-result.i);
        break;
    case 3 :
		result.ui = (unsigned short)( - ((short)result.ui) );
        break;
    case 4 :
		result.l = (long)(-result.l);
        break;
    case 5 :
		result.ul = (unsigned long)( - ((long)result.ul) );
        break;
    case 6 :
		result.d = (double)(-result.d);
        break;
	default :
		return 10;
	}
	return 0;
}

int CSymCalc::BitNot(void)
{
	switch ( m_nFlag ) {
	case 0 :
		result.c = (char)(~result.c);
        break;
    case 1 :
		result.uc = (unsigned char)(~result.uc);
        break;
    case 2 :
		result.i = (short)(~result.i);
        break;
    case 3 :
		result.ui = (unsigned short)(~result.ui);
        break;
    case 4 :
		result.l = (long)(~result.l);
        break;
    case 5 :
		result.ul = (unsigned long)(~result.ul);
        break;
	default :
		return 10;
	}
	return 0;
}

int CSymCalc::LogNot(void)
{
	int nFlag;
	switch ( m_nFlag ) {
	case 0 :
		nFlag = !result.c;
        break;
    case 1 :
		nFlag = !result.uc;
        break;
    case 2 :
		nFlag = !result.i;
        break;
    case 3 :
		nFlag = !result.ui;
        break;
    case 4 :
		nFlag = !result.l;
        break;
    case 5 :
		nFlag = !result.ul;
        break;
	default :
		return 10;
	}                                        

	result.i = (short) nFlag;
	m_nFlag = 2;
	typeValue = BI_S16_SHORT;
	
	return 0;
}


void CSymCalc::Display(void)
{
	char temp[512];
	
	if ( nComplexType == 1 ) {
		int nLen;
		sprintf(temp,"Value(One Symbol) = ");
		nLen = strlen(temp);
		BuildDetailedType(typeIndex,&temp[nLen]);
		nLen = strlen(temp);
		temp[nLen] = ' ';
		nLen++;
		BuildCAddr(addr.segType,addr.addr,&temp[nLen]);
    	ShowLine(temp);
    	return;	
	}
	switch ( m_nFlag ) {
	case 0 :
		sprintf(temp , "Value(char) = %d (0x%02X)",result.c,result.c);
        break;
    case 1 :
		sprintf(temp , "Value(unsigned char) = %d (0x%02X)",result.uc,result.uc);
        break;
    case 2 :
		sprintf(temp , "Value(short) = %d (0x%04X)",result.i,result.i);
        break;
    case 3 :
		sprintf(temp , "Value(unsigned short) = %u (0x%04X)",result.ui,result.ui);
        break;
    case 4 :
		sprintf(temp , "Value(long) = %ld (0x%08lX)",result.l,result.l);
        break;
    case 5 :
		sprintf(temp , "Value(unsigned long) = %lu (0x%08lX)",result.ul,result.ul);
        break;
	case 6 :
		sprintf(temp , "Value(double) = %le",result.d);
        break;
	default :
		sprintf(temp , "Value = UNKNOWN");
		break;
	}                                        
	ShowLine( temp );
	return ;
}

int CSymCalc::DisplayValue(char* temp)
{                      	
	if ( nComplexType == 1 ) {
		BuildCAddr(addr.segType,addr.addr,temp);
    	return FAILURE;	
	}              
	if ( nComplexType != 0 ) {
		return FAILURE;
	}
	
	switch ( m_nFlag ) {
	case 0 :
		sprintf(temp , "%d (0x%02X)",result.c,result.c);
        break;
    case 1 :
		sprintf(temp , "%d (0x%02X)",result.uc,result.uc);
        break;
    case 2 :
		sprintf(temp , "%d (0x%04X)",result.i,result.i);
        break;
    case 3 :
		sprintf(temp , "%u (0x%04X)",result.ui,result.ui);
        break;
    case 4 :
		sprintf(temp , "%ld (0x%08lX)",result.l,result.l);
        break;
    case 5 :
		sprintf(temp , "%lu (0x%08lX)",result.ul,result.ul);
        break;
	case 6 :
		sprintf(temp , "%le",result.d);
        break;
	default :           
		sprintf(temp , "Value = UNKNOWN");
		return FAILURE;
	}                                        
	return GOOD;
}

int CSymCalc::GetStatus(BOOL& bResult)
{
	if ( SYMTOKEN_NUM != symType && SYMTOKEN_FLOAT != symType &&
		SYMTOKEN_SYMBOL != symType ) {
		return FAILURE;
	}

	if ( SYMTOKEN_SYMBOL == symType ) {
		if ( nComplexType ) return FAILURE;	
	}
	switch ( m_nFlag ) {
	case 0 :
		if ( 0 == result.c ) bResult = FALSE;
		else bResult = TRUE;
        break;
    case 1 :
		if ( 0 == result.uc ) bResult = FALSE;
		else bResult = TRUE;
        break;
    case 2 :
		if ( 0 == result.i ) bResult = FALSE;
		else bResult = TRUE;
        break;
    case 3 :
		if ( 0 == result.ui ) bResult = FALSE;
		else bResult = TRUE;
        break;
    case 4 :
		if ( 0 == result.l ) bResult = FALSE;
		else bResult = TRUE;
        break;
    case 5 :
		if ( 0 == result.ul ) bResult = FALSE;
		else bResult = TRUE;
        break;
	case 6 :
		if ( 0 == result.d ) bResult = FALSE;
		else bResult = TRUE;
        break;
	default :
		return FAILURE;
	}                                        
	return GOOD;
}

int CSymCalc::CheckValue(void)
{   
	if ( symType == SYMTOKEN_SYMBOL ) {
		if ( nComplexType == 2 ) return 10;  // not support
		else if ( nComplexType == 1 ) return 0;
	}
	
	if ( m_nFlag == -1 ) {
		switch ( typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
			m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
			m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
			m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
			m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
			m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
			m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
			m_nFlag = 6;
			break;
	    case 99 :
			return 10;
	    default :
			m_nFlag = 1;
	        break;
	    }
	}		  
	return 0;
}

int CSymCalc::PointValue(void)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];

	if ( nComplexType != 1 ) return 10;
    typeHeader.typeName = temp;
    if ( GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ) {
        return 7;
    }
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
		return 10;
    }

    switch(typeHeader.t.complexType) {
    case TY_SMALL_PTR :
        if ( GOOD != SymGetTypePointerTypeIndex( typeIndex , &typeNext ) ) {
            return 7;
        }                 
        if ( typeHeader.sizeCalculated == TRUE ) {
            ADDR    start , end;
            char    data[16];
            U32     address ;
            SEGMENTTYPE segType;

            address = 0;
            ConvEnumToAbiType( addr.segType ,
                         start.addrType );
            end.addrType = start.addrType;
            start.addr = (unsigned short) addr.addr;
            end.addr = start.addr + 
                       (unsigned short)(typeHeader.sizeInMAUs-1);
#ifdef _ZLR_
            if ( ICE_OK != AbiGetMemN(start,end,data) ) {
                return 14;
            }
#endif
            if ( typeHeader.sizeInMAUs == 3 ) {
                address = (U8) data[1];
                address = (address<<8) + (U8)data[2];
                if ( GOOD == SrcIsStatement() ) {
                    UbrofConvPtrToSeg(data[0],segType);
                }
                else {
                    Omf51ConvPtrToSeg(data[0],segType);
                }
            }
            else if ( typeHeader.sizeInMAUs == 2 ) {
                segType = addr.segType;
                address = (U8) data[0];
                address = (address<<8) + (U8)data[1];
            }
            else if ( typeHeader.sizeInMAUs == 1 ) {
                segType = addr.segType;
                address = (U8) data[0];
            }
            else {
                return 10;
            }
            addr.segType = segType;
            addr.addr = address;
        }
        else {
        	return 10;
        }
        break;
    case TY_OMF51_PTR :
        if ( typeHeader.sizeCalculated == TRUE ) {
            ADDR    start , end;
            char    data[16];
            U32     address ;
            SEGMENTTYPE segType;
            SEGMENTTYPE ssss;
            TYPE_OMF51_PTR_STRUCT omf51Ptr;

            if ( SymGetTypePointer51(typeIndex,&omf51Ptr) != GOOD )
                return 7;
			typeNext = omf51Ptr.typeIndex;
            address = 0;
            ConvEnumToAbiType( addr.segType , start.addrType );
            end.addrType = start.addrType;
            start.addr = (unsigned short) addr.addr;
            end.addr = start.addr + 
                       (unsigned short)(typeHeader.sizeInMAUs-1);
#ifdef _ZLR_
            if ( ICE_OK != AbiGetMemN(start,end,data) ) {
                return 14;
            }
#endif
            if ( typeHeader.sizeInMAUs == 3 ) {
                address = (U8) data[1];
                address = (address<<8) + (U8)data[2];
                if ( GOOD == SrcIsStatement() ) {
                    UbrofConvPtrToSeg(data[0],segType);
                }
                else {
                    Omf51ConvPtrToSeg(data[0],segType);
                }            
                ssss = segType;
            }
            else if ( typeHeader.sizeInMAUs == 2 ) {
                address = (U8) data[0];
                address = (address<<8) + (U8)data[1];
                MemoryTypeConvToSeg( omf51Ptr.memSpace,segType );
                ssss = segType;
                if ( SrcIsIEEE() == GOOD ) {
                    if ( (GOOD==SymGetTypeHeader(omf51Ptr.typeIndex, 
                        &typeHeader)) &&(typeHeader.typeChoice==
                        COMPLEX_TYPE_CLASS)&&
                        (typeHeader.t.complexType == TY_TYPE) 
                    ) {                    
                        TYPE_INDEX tttt;
                        if ( GOOD != SymGetTypeTypeType(
                            omf51Ptr.typeIndex,&tttt,&ssss) ){
                            if ( ssss != SEG_UNTYPED ) 
                                ssss = segType;
                        }    
                    }    
                }                              
            }
            else if ( typeHeader.sizeInMAUs == 1 ) {
                address = (U8) data[0];
                MemoryTypeConvToSeg( omf51Ptr.memSpace,segType );
                ssss = segType;
                if ( SrcIsIEEE() == GOOD ) {
                    if ( (GOOD==SymGetTypeHeader(omf51Ptr.typeIndex, 
                        &typeHeader)) &&(typeHeader.typeChoice==
                        COMPLEX_TYPE_CLASS)&&
                        (typeHeader.t.complexType == TY_TYPE) 
                    ) {                    
                        TYPE_INDEX tttt;
                        if ( GOOD != SymGetTypeTypeType(
                            omf51Ptr.typeIndex,&tttt,&ssss) ) {
                            if ( ssss != SEG_UNTYPED ) 
                                ssss = segType;
							typeNext = tttt;
                        }    
                    }    
                }                              
            }
            else {
                return 10;
            }
            addr.segType = segType;
            addr.addr = address;
        }
        else {
        	return 10;
        }
        break;
    default :
		return 10;
    }

	typeIndex = typeNext;
	return GetValue();
}


int CSymCalc::GetValue(void)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];

	if ( nComplexType != 1 ) return 10;
    typeHeader.typeName = temp;

	nComplexType = 0;
	
	SYM_TOKEN_NODE *pNode;
	
	pNode = new SYM_TOKEN_NODE;
	if ( pNode == 0 ) return 1;

	pNode->typeIndex = typeIndex;	
	pNode->addr.segType = addr.segType;
	pNode->addr.addr = addr.addr;
	
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ) {      
    	delete pNode;
        return 10;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        if ( FAILURE == GetSValue( typeIndex , pNode ) ) {
	    	delete pNode;
            return 10;
        }
    }
    else {
        if ( typeHeader.t.complexType == TY_TYPE ) {
            while( 1 ) {
                if ( GOOD != SymGetTypeTypeIndex(typeIndex,&typeNext) ) {
			    	delete pNode;
                    return 10;
                }
                typeIndex = typeNext;
                if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ){
			    	delete pNode;
                    return 10;
                }
                if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
                    break;
                else if ( typeHeader.t.complexType != TY_TYPE )
                    break;
            }            
            if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
                if ( FAILURE == GetSValue( typeIndex , pNode ) ) {
			    	delete pNode;
                    return 10;
                }
            }
        }

        if ( (typeHeader.typeChoice==COMPLEX_TYPE_CLASS)&&
            (typeHeader.t.complexType == TY_BITFIELD) ) {
            if ( FAILURE == GetBitValue( typeIndex , pNode ) ) {
		    	delete pNode;
                return 10;
            }
        }    
        else if (typeHeader.typeChoice==COMPLEX_TYPE_CLASS &&
            (typeHeader.t.complexType == TY_ENUM_C) ) {
            if ( FAILURE == GetEnumValue( typeIndex , pNode ) ) {
		    	delete pNode;
                return 10;
            }
        }    
        else if (typeHeader.typeChoice==COMPLEX_TYPE_CLASS) {
// This symbol is complex type such as Array , struct , pointer 
	        pNode->typeValue = (BUILT_IN_TYPE)99;  // means complex type 
	        pNode->nComplexType = 1;
        }
    }
	
	typeValue = pNode->typeValue;
	nComplexType = pNode->nComplexType;
	memcpy(&result , &(pNode->result) , sizeof(ExpressionValue));     

	delete pNode;    
	return 0;
}	

int CSymCalc::CheckStructOpt(CSymCalc* pNode1,int nType)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];

	if ( pNode1 == 0 ) return 3;
	if ( nType != 10 && nType != 11 ) return 3;
	
	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 1 ) return 11;
	if ( SYMTOKEN_SYMBOL != pNode1->symType ) return 11;
	if ( pNode1->nComplexType != 2 ) return 11;
	
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ) {      
        return 10;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        return 11;
    }
    else {
        if ( typeHeader.t.complexType == TY_TYPE ) {
            while( 1 ) {
                if ( GOOD != SymGetTypeTypeIndex(typeIndex,&typeNext) ) {
                    return 10;
                }
                typeIndex = typeNext;
                if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ){
                    return 10;
                }
                if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
                    break;
                else if ( typeHeader.t.complexType != TY_TYPE )
                    break;
            }            
            if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
                return 11;
            }
        }

        if ( (typeHeader.typeChoice==COMPLEX_TYPE_CLASS)&&
            ( TY_STRUCT == typeHeader.t.complexType || 
            TY_UNION == typeHeader.t.complexType ) ) {
            return 0;
        }    
    }
	
	return 11;
}

//int CSymCalc::Struct(CSymCalc* pNode1,int nType,class CSymSyntax *pObj)
int CSymCalc::Struct(CSymCalc* pNode1,int nType,void *pVoid)
{            
    class CSymSyntax *pObj;
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];
    TYPE_S_U_STRUCT  s;                
    U16 ui;                                                   
    int nFlag;      
    char *pName;                 
//    int i;

	pObj = (class CSymSyntax *)pVoid;        
	nFlag = 0;        
	if ( pNode1 == 0 ) return 3;
	if ( pObj == 0 ) return 3;
	if ( nType != 10 && nType != 11 ) return 3;
	
	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 1 ) return 11;
	if ( SYMTOKEN_SYMBOL != pNode1->symType ) return 11;
	if ( pNode1->nComplexType != 2 ) return 11;
	
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeIndex, &typeHeader) ) {      
        return 10;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        return 11;
    }
    if ( TY_STRUCT != typeHeader.t.complexType && 
        TY_UNION != typeHeader.t.complexType ) {
        return 11;
    }    

	if ( 0 != pObj->GetOneTokenName(pNode1->m_nTkNum, pName) ) {
		return 10;
	}

    ui = 0 ;
    s.name = temp ;
    while ( GOOD == SymGetTypeStructUnionNth( typeIndex , ui , &s ) ) {
    	if ( 0 == strcmp(s.name , pName) ) {
    		nFlag = 1;
    		break;    
    	}
        ui++;
    }    
   	if ( pName ) delete pName;
    if ( 0 == nFlag ) {
    	return 10;                
    }
	
    if ( SrcIsIEEE() == GOOD ) {              
        if ( GOOD==FindNextType(s.typeIndex, typeNext) ) {
            if (GOOD == SymGetTypeHeader(typeNext, &typeHeader) && 
                typeHeader.typeChoice==COMPLEX_TYPE_CLASS &&
                typeHeader.t.complexType == TY_BITFIELD ) {
//                son->addr.addr = node->result.addr + (s.offset>>3);
			    TYPE_BITFIELD_STRUCT bit;          
			    ADDR start , end;
			    char data[16] ;
			    U16 uj;
			    int i;
			    U32 address;

		    	if ( GOOD != SymGetTypeBitfield(typeNext,&bit) )
	    	    	return 10;
	            uj = s.offset >> 3;
	            address = addr.addr + uj;
	            bit.offset += (U8) (s.offset%8); 
			    switch( addr.segType ) {
			    case SEG_CODE :
			        start.addrType = end.addrType = 1;
			        break;
			    case SEG_DATA :
			        start.addrType = end.addrType = 3;
			        break;
			    case SEG_XDATA :
			        start.addrType = end.addrType = 2;
			        break;
			    case SEG_BIT :
			        start.addrType = end.addrType = 5;
			        break;
			    case SEG_REGISTER :
			        start.addrType = end.addrType = 4;
			        break;
			    default :
			        start.addrType = end.addrType = 0;
			        break;
			    }   
			    start.addr = (unsigned short)address ;
				nComplexType = 0;
			    switch ( bit.baseTypeIndex ) {
			    case BI_S8_SCHAR:
			    case BI_U8_UCHAR:
			    case BI_S8_CHAR:  
			        if ( (bit.offset+bit.size)>8 ) return 10;
			        end.addr = start.addr ;
			#ifdef _ZLR_        
			        if ( ICE_OK != AbiGetMemN(start,end,data) ) {
			            return 14;
			        }
			#else 
			        data[0] = 0;    
			#endif  
			        ui = data[0];
			        ui = ui >> bit.offset ;
			        uj = 1;
			        for(i=0;(unsigned int)i<bit.size;i++)
			            uj = uj << 1;
			        uj--;
			        ui = ui & uj;
			        if( bit.baseTypeIndex == BI_U8_UCHAR ) {            
				        typeValue = BI_U8_UCHAR;
				        result.uc = (unsigned char)ui;
			        }
			        else {
			            uj++;
			            if ( ui >= uj/2 )
			                i = (int)(ui-uj);
			            else 
			                i = (int)ui;
				        typeValue = BI_U8_UCHAR;
				        result.c = (char)i;
			        }
			        return GOOD;
			    case BI_S16_SINT:
			    case BI_U16_UINT:
			    case BI_S16_SHORT:
			    case BI_S16_USHORT:
			    case BI_S16_SHORTINT:
			    case BI_S16_SSHORT:
			
			    case BI_STACK_INT:
			    case BI_STACK_U:
			    case BI_STACK_UINT:
			
			        if ( (bit.offset+bit.size)>16 ) return 10;
			        end.addr = start.addr+1;
			#ifdef _ZLR_        
			        if ( ICE_OK != AbiGetMemN(start,end,data) ) {
			            return 14;
			        }
			#else 
			        data[0] = 0;    
			        data[1] = 0;
			#endif  
			        ui = (U16) data[0];
			        ui = (ui<<8) + (U8)data[1];
			
			        ui = ui >> bit.offset ;
			        uj = 1;
			        for(i=0;(unsigned int)i<bit.size;i++)
			            uj = uj << 1;
			        uj--;
			        ui = ui & uj;
			
			        if ( bit.baseTypeIndex==BI_U16_UINT || 
			            bit.baseTypeIndex==BI_S16_USHORT ||
			            bit.baseTypeIndex== BI_STACK_U ||
			            bit.baseTypeIndex== BI_STACK_UINT ) {
				        typeValue = BI_S16_USHORT;
				        result.ui = ui;
			        }
			        else {                 
			            uj++;
			            if ( ui >= uj/2 )
			                i = (int)(ui-uj);
			            else
			                i = (int)ui;
				        typeValue = BI_S16_SSHORT;
				        result.i = (short)i;
			        }
			        return GOOD;
			    default : // unsigned int ;
			        if ( (bit.offset+bit.size)>16 ) return 10;
			        end.addr = start.addr+1;
			#ifdef _ZLR_        
			        if ( ICE_OK != AbiGetMemN(start,end,data) ) {
			            return 14;
			        }
			#else 
			        data[0] = 0;    
			        data[1] = 0;
			#endif  
			        ui = (U16) data[0];
			        ui = (ui<<8) + (U8)data[1];
			
			        ui = ui >> bit.offset ;
			        uj = 1;
			        for(i=0;(unsigned int)i<bit.size;i++)
			            uj = uj << 1;
			        uj--;
			        ui = ui & uj;
			
			        typeValue = BI_S16_USHORT;
			        result.ui = ui;
			        return GOOD;
			    }
            
            }
        }
    }        

	typeIndex = s.typeIndex;
    addr.addr = addr.addr + s.offset;
	return GetValue();
}

int CSymCalc::CheckArrayOperate(CSymCalc* pNode1,int& nType ,unsigned long& ul)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];

	nType = 0;
	if ( pNode1 == 0 ) return 3;
	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 1 ) return 11;
	if ( SYMTOKEN_SYMBOL == pNode1->symType ) {
		if ( pNode1->nComplexType ) return 11;
	}
    if ( GOOD!=FindNextType(typeIndex, typeNext) ) {
	    return 11;
	}
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeNext, &typeHeader) ) {      
        return 10;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        return 11;
    }
	switch ( typeHeader.t.complexType ) {
	case TY_OMF51_ARRAY :
		nType = 1;
		break;
	case TY_C_ARRAY :
		nType = 0;
		break;
	default :
	    return 11;
    }    
	
	typeIndex = typeNext;
	if ( 0 != pNode1->CheckValue() ) return 10;
	switch ( pNode1->m_nFlag ) {
	case 0 :
		ul = (unsigned long)pNode1->result.c;
		break;
	case 1 :
		ul = (unsigned long)pNode1->result.uc;
		break;
	case 2 :	
		ul = (unsigned long)pNode1->result.i;
		break;
	case 3 :
		ul = (unsigned long)pNode1->result.ui;
		break;
	case 4 :
		ul = (unsigned long)pNode1->result.l;
		break;
	case 5 :
		ul = (unsigned long)pNode1->result.ul;
		break;
	default :
		return 10;
	}
	return 0;
}

int CSymCalc::CArray(unsigned long ul)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];
    U32              uOneSize ;
//    U32              uNowAddr;
    TYPE_C_ARRAY_STRUCT arr;                       

	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 1 ) return 11;
    if ( GOOD!=FindNextType(typeIndex, typeNext) ) {
	    return 11;
	}
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeNext, &typeHeader) ) {      
        return 10;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        return 11;
    }
	if ( TY_C_ARRAY != typeHeader.t.complexType ) {
	    return 11;
    }           
    if ( GOOD != SymGetTypeCArray(typeNext,&arr) ) 
    	return 10 ;
    typeIndex = arr.typeIndex ;
    if (GOOD!=SymGetTypeHeader(typeIndex,&typeHeader)) 
        return 10;
    if ( typeHeader.sizeCalculated == TRUE ) {
        uOneSize = typeHeader.sizeInMAUs;
    }
    else return 10;
    
    if ( 0 > arr.highBound ) return 10; 
    if ( ul > (unsigned long)arr.highBound ) return 16;
      
    addr.addr = addr.addr + ul*uOneSize;
    
	return GetValue();
}
	    
int CSymCalc::Omf51Array(unsigned long* pArray , int nDim)
{
    TYPE_HEADER_TYPE typeHeader;
    TYPE_INDEX       typeNext;
	char temp[256];
    U32              uOneSize ;
    U32              uNowAddr;
    U32				 uCo;
    TYPE_OMF51_ARRAY_STRUCT omf51Arr;
    unsigned long *pMaxArr;

	if ( pArray == 0 ) return 3;
	if ( nDim <= 0 ) return 3;
	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 1 ) return 11;
    if ( GOOD!=FindNextType(typeIndex, typeNext) ) {
	    return 11;
	}
    typeHeader.typeName = temp;
    if (GOOD != SymGetTypeHeader(typeNext, &typeHeader) ) {      
        return 10;
    }                              
    if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS ) {
        return 11;
    }
	if ( TY_OMF51_ARRAY != typeHeader.t.complexType ) {
	    return 11;
    }           

    if ( GOOD != SymGetTypeArray51(typeIndex,&omf51Arr) ) 
        return 10 ;
    if ( nDim != (int)omf51Arr.dim ) return 10;
    pMaxArr = new unsigned long [ nDim+1 ];
    if ( pMaxArr==0 ) return 1;
    memset( pMaxArr , 0 , (size_t)((nDim+1)*sizeof(unsigned long)) );
    typeNext = typeIndex;
    for( int nCur=0; nCur<nDim; nCur++) {                   
        U16 tt;
        if ( GOOD != SymGetTypeArrayDimSizeNth(typeNext,
                                     (U8)(nCur+1), &tt) ) {
            delete pMaxArr;                         
            return 10;     
        }
        pMaxArr[nCur] = tt;
	    if ( pArray[nCur] > (unsigned long)pMaxArr[nCur] ) {
            delete pMaxArr;                         
	    	return 16;
	    }
    }                                         
    typeNext = omf51Arr.typeIndex ;    
    if ( GOOD != SymGetTypeHeader(typeNext,&typeHeader) ) { 
        delete pMaxArr;
        return 10;
    }            
    
    if ( typeHeader.sizeCalculated == TRUE ) {
        uOneSize = typeHeader.sizeInMAUs;
    }
    else return 10;

	typeIndex = typeNext;
    uCo = 1;
    uNowAddr = 0;
    for( nCur=nDim-1; nCur>=0; nCur--) {                   
		uNowAddr += pArray[nCur]*uCo;
        uCo *= (pMaxArr[nCur]+1);
    }                                         
	
    addr.addr = addr.addr + uNowAddr*uOneSize;
    
	return GetValue();
}

/***************************************************************************
*                                                                          
*  CheckAssignOperate  --  check legal operate and convert token node                          
*  parameter :                                                             
*       pNode1  --  next token node
*       nType  --  operator type
*  return value :                                                          
*       None                                                               
*                                                                          
***************************************************************************/
int CSymCalc::CheckAssignOperate(CSymCalc *pNode1, int nType)
{   
	// m_nFlag == 0   --   char;
	//          1   --   unsigned char;
	//          2   --   short;
	//          3   --   unsigned short;
	//          4   --   long;
	//          5   --   unsigned long;
	//          6   --   double;
	if ( symType != SYMTOKEN_SYMBOL ) return 6;
	if ( pNode1 == 0 ) return 6;
	if ( pNode1->symType!= SYMTOKEN_NUM && pNode1->symType!=SYMTOKEN_FLOAT &&
		pNode1->symType != SYMTOKEN_SYMBOL ) return 6;
	if ( nType < 30 || nType > 35 ) return 6;
	
	if ( symType == SYMTOKEN_SYMBOL ) {
		if ( nComplexType ) {
			return 11;
		}
		if ( pNode1->symType == SYMTOKEN_SYMBOL && pNode1->nComplexType ) 
			return 11;
	}
	
	if ( m_nFlag == -1 ) {
		switch ( typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
			m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
			m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
			m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
			m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
			m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
			m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
			m_nFlag = 6;
			break;
	    case 99 :
			return 10;
	    default :
			m_nFlag = 1;
	        break;
	    }
	}		  
	if ( pNode1->m_nFlag == -1 ) {
		switch ( pNode1->typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
	    	pNode1->symType = SYMTOKEN_FLOAT;
			pNode1->m_nFlag = 6;
			break;
	    case 99 :
			return 10;
	    default :
	    	pNode1->symType = SYMTOKEN_NUM;
			pNode1->m_nFlag = 1;
	        break;
	    }
	}		  
	
	return 0;
}

/***************************************************************************
*                                                                          
*  CheckOperate  --  check legal operate and convert token node                          
*  parameter :                                                             
*       nType  --  operator type
*  return value :                                                          
*       None                                                               
*                                                                          
***************************************************************************/
int CSymCalc::CheckOperate(int nType)
{   
	// m_nFlag == 0   --   char;
	//          1   --   unsigned char;
	//          2   --   short;
	//          3   --   unsigned short;
	//          4   --   long;
	//          5   --   unsigned long;
	//          6   --   double;
	if ( symType != SYMTOKEN_SYMBOL ) return 6;
	if ( nType < 36 || nType > 39 ) return 6;
	
	if ( nComplexType ) {
		return 11;
	}
	
	if ( m_nFlag == -1 ) {
		switch ( typeValue ) {
	    case BI_BIT :
	    case BI_U8_UCHAR:
			m_nFlag = 1;
			break;
	    case BI_S8_SCHAR:
	    case BI_S8_CHAR:
			m_nFlag = 0;
			break;
	    case BI_S16_SINT:
	    case BI_S16_SHORT:
	    case BI_S16_SHORTINT:
	    case BI_S16_SSHORT:
	    case BI_STACK_INT:
			m_nFlag = 2;
			break;
	    case BI_STACK_U:
	    case BI_STACK_UINT:
	    case BI_S16_USHORT:
	    case BI_U16_UINT:
			m_nFlag = 3;
			break;
	    case BI_S32_SLONG:
	    case BI_S32_LONG:
			m_nFlag = 4;
			break;
	    case BI_U32_ULONG:
			m_nFlag = 5;
			break;
	    case BI_F32 :
	    case BI_F64 :    
			m_nFlag = 6;
			return 10;
//			break;
	    case 99 :
			return 10;
	    default :
			m_nFlag = 1;
	        break;
	    }
	}		  

	return 0;
}

int CSymCalc::ConvertValue(unsigned char& uc)
{
	switch ( m_nFlag ) {
	case 0 :
		uc = (unsigned char)result.c;
        break;
    case 1 :
		uc = (unsigned char)result.uc;
        break;
    case 2 :
		uc = (unsigned char)result.i;
        break;
    case 3 :
		uc = (unsigned char)result.ui;
        break;
    case 4 :
		uc = (unsigned char)result.l;
        break;
    case 5 :
		uc = (unsigned char)result.ul;
        break;              
    case 6 :
    	uc = (unsigned char)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}

int CSymCalc::ConvertValue(unsigned short& ui)
{
	switch ( m_nFlag ) {
	case 0 :
		ui = (unsigned short)result.c;
        break;
    case 1 :
		ui = (unsigned short)result.uc;
        break;
    case 2 :
		ui = (unsigned short)result.i;
        break;
    case 3 :
		ui = (unsigned short)result.ui;
        break;
    case 4 :
		ui = (unsigned short)result.l;
        break;
    case 5 :
		ui = (unsigned short)result.ul;
        break;
    case 6 :
    	ui = (unsigned short)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}

int CSymCalc::ConvertValue(unsigned long& ul)
{
	switch ( m_nFlag ) {
	case 0 :
		ul = (unsigned long)result.c;
        break;
    case 1 :
		ul = (unsigned long)result.uc;
        break;
    case 2 :
		ul = (unsigned long)result.i;
        break;
    case 3 :
		ul = (unsigned long)result.ui;
        break;
    case 4 :
		ul = (unsigned long)result.l;
        break;
    case 5 :
		ul = (unsigned long)result.ul;
        break;
    case 6 :
    	ul = (unsigned long)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}                          


int CSymCalc::ConvertValue(char& c)
{
	switch ( m_nFlag ) {
	case 0 :
		c = (char)result.c;
        break;
    case 1 :
		c = (char)result.uc;
        break;
    case 2 :
		c = (char)result.i;
        break;
    case 3 :
		c = (char)result.ui;
        break;
    case 4 :
		c = (char)result.l;
        break;
    case 5 :
		c = (char)result.ul;
        break;              
    case 6 :
    	c = (char)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}

int CSymCalc::ConvertValue(short& i)
{
	switch ( m_nFlag ) {
	case 0 :
		i = (short)result.c;
        break;
    case 1 :
		i = (short)result.uc;
        break;
    case 2 :
		i = (short)result.i;
        break;
    case 3 :
		i = (short)result.ui;
        break;
    case 4 :
		i = (short)result.l;
        break;
    case 5 :
		i = (short)result.ul;
        break;
    case 6 :
    	i = (short)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}

int CSymCalc::ConvertValue(long& l)
{
	switch ( m_nFlag ) {
	case 0 :
		l = (long)result.c;
        break;
    case 1 :
		l = (long)result.uc;
        break;
    case 2 :
		l = (long)result.i;
        break;
    case 3 :
		l = (long)result.ui;
        break;
    case 4 :
		l = (long)result.l;
        break;
    case 5 :
		l = (long)result.ul;
        break;
    case 6 :
    	l = (long)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}                          

int CSymCalc::ConvertValue(float& f)
{
	switch ( m_nFlag ) {
	case 0 :
		f = (float)result.c;
        break;
    case 1 :
		f = (float)result.uc;
        break;
    case 2 :
		f = (float)result.i;
        break;
    case 3 :
		f = (float)result.ui;
        break;
    case 4 :
		f = (float)result.l;
        break;
    case 5 :
		f = (float)result.ul;
        break;
    case 6 :
    	f = (float)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}                          

int CSymCalc::ConvertValue(double& d)
{
	switch ( m_nFlag ) {
	case 0 :
		d = (double)result.c;
        break;
    case 1 :
		d = (double)result.uc;
        break;
    case 2 :
		d = (double)result.i;
        break;
    case 3 :
		d = (double)result.ui;
        break;
    case 4 :
		d = (double)result.l;
        break;
    case 5 :
		d = (double)result.ul;
        break;
    case 6 :
    	d = (double)result.d;    
    	break;
	default :
		return 10;
	}                       
	return 0;                 
}                          

int CSymCalc::SetValue(CSymCalc* pNode1, void *pVoid)
{   
    ADDR start , end;
    char data[16] ;
    char temp[256];
    U8 uc;                                     
    short sh;
    U16 ui , uj , uk;
    U32 ul;
    float f;
    int num;
    double d;
    TYPE_INDEX nextIndex;     
    class CSymSyntax *pObj;
    char *pName;            
    char *pValue;

	pObj = (class CSymSyntax *)pVoid;        
	if ( pObj == 0 ) return 3;
	if ( pNode1 == 0 ) return 3;
	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 0 ) return 11;
	
	if ( -1 != m_nTkNum ) {
		if ( 0 != pNode1->ConvertValue(sh) ) {
			return 10;
		}
		if ( 0 != pObj->GetOneTokenName(m_nTkNum, pName) ) {
//			delete []pName;
			return 10;
		}
		if ( 0 != SetUserVarValue(pName,sh) ) {
			delete []pName;
			return 10;
		}
		delete []pName;
		return 0;
	}

    switch( addr.segType ) {
    case SEG_CODE :
        start.addrType = end.addrType = 1;
        break;
    case SEG_DATA :
        start.addrType = end.addrType = 3;
        break;
    case SEG_XDATA :
        start.addrType = end.addrType = 2;
        break;
    case SEG_BIT :
        start.addrType = end.addrType = 5;
        break;
    case SEG_REGISTER :
        start.addrType = end.addrType = 4;
        break;
    default :
        start.addrType = end.addrType = 0;
        break;
    }   
    start.addr = (unsigned short)addr.addr ;
    if ( GOOD != FindNextType(typeIndex,nextIndex) )
        return 11;
    if ( nextIndex >= 256 ) {
        int i;
        TYPE_HEADER_TYPE typeHeader;
        TYPE_BITFIELD_STRUCT bit;            
        
        typeHeader.typeName = temp;
        if (GOOD != SymGetTypeHeader(nextIndex, &typeHeader)) 
            return 11;
        if ( typeHeader.typeChoice != COMPLEX_TYPE_CLASS )
            return 11;
        if ( typeHeader.t.complexType != TY_BITFIELD ) {
            if ( typeHeader.t.complexType != TY_ENUM_C )
                return 11;                                
			if ( 0 != pNode1->ConvertValue(ui) ) {
				return 10;
			}
//			symType = SYMTOKEN_NUM;
//		    typeValue = BI_S16_USHORT;
//		    result.ui = ui;      
		    
            pValue = (char *) &ui;      
            data[0] = pValue[1];
            data[1] = pValue[0];
#ifdef _ZLR_        
            if ( ICE_OK != AbiSetMemN(start,data,2) ) {
                return 15;
            }
#endif  
            return GOOD;
        }    
        
        if ( GOOD != SymGetTypeBitfield(nextIndex,&bit) )
            return 11;
            
        switch ( bit.baseTypeIndex ) {
        case BI_S8_SCHAR:
        case BI_U8_UCHAR:
        case BI_S8_CHAR:  
            if ( (bit.offset+bit.size)>8 ) return 10;
            end.addr = start.addr ;
#ifdef _ZLR_        
            if ( ICE_OK != AbiGetMemN(start,end,data) ) {
                return 14;
            }
#else 
            data[0] = 0;    
#endif  
            ui = data[0];
            uj = 1;
            for(i=0;i<(int)bit.size;i++)
                uj = uj << 1;
            uj--;
            ui = ui & (~(uj<<bit.offset));

			if ( 0 != pNode1->ConvertValue(uc) ) {
				return 10;
			}
			uk = (unsigned short)uc;

            uk = uk&uj;
            ui = ui | ( uk << bit.offset ); 
            data[0] = ( char ) ui;
#ifdef _ZLR_        
            if ( ICE_OK != AbiSetMemN(start,data,1) ) {
                return 15;
            }
#endif  
            return GOOD;
        default :   
            if ( (bit.offset+bit.size)>16 ) return 10;
            end.addr = start.addr+1;
#ifdef _ZLR_        
            if ( ICE_OK != AbiGetMemN(start,end,data) ) {
                return 14;
            }
#else 
            data[0] = 0;    
            data[1] = 0;
#endif  
            ui = (U16) data[1];
            ui = (ui<<8) + (U8)data[0];
    
            uj = 1;
            for(i=0;i<(int)bit.size;i++)
                uj = uj << 1;
            uj--;
            ui = ui & (~(uj<<bit.offset));

			if ( 0 != pNode1->ConvertValue(sh) ) {
				return 10;
			}
			uk = (unsigned short)sh;
//			symType = SYMTOKEN_NUM;
//	        typeValue = BI_S16_USHORT;
//	        result.ui = uk;
            
            uk = uk&uj;
            ui = ui | ( uk << bit.offset ); 
            data[0] = ( char ) ( ui & 0xFF );
            data[1] = ( char ) ( ui >> 8 );
#ifdef _ZLR_        
            if ( ICE_OK != AbiSetMemN(start,data,2) ) {
                return 15;
            }
#endif  
            return GOOD;
        }
    }

    switch ( nextIndex ) {
    case BI_BIT :
		if ( 0 != pNode1->ConvertValue(uc) ) {
			return 10;
		}
        data[0] = (U8) uc;

#ifdef _ZLR_        
        if ( ICE_OK != AbiSetMemN(start,data,1) ) {
            return 15;
        }
#endif  
        return GOOD;
    case BI_S8_SCHAR:
    case BI_U8_UCHAR:
    case BI_S8_CHAR:
		if ( 0 != pNode1->ConvertValue(uc) ) {
			return 10;
		}
        data[0] = (U8) uc;
        
#ifdef _ZLR_        
        if ( ICE_OK != AbiSetMemN(start,data,1) ) {
            return 15;
        }
#endif  
        return GOOD;
    case BI_S16_SINT:
    case BI_U16_UINT:
    case BI_S16_SHORT:
    case BI_S16_USHORT:
    case BI_S16_SHORTINT:
    case BI_S16_SSHORT:

    case BI_STACK_INT:
    case BI_STACK_U:
    case BI_STACK_UINT:
		if ( 0 != pNode1->ConvertValue(ui) ) {
			return 10;
		}
        pValue = (char *) &ui;      
        data[0] = pValue[1];
        data[1] = pValue[0];
#ifdef _ZLR_        
        if ( ICE_OK != AbiSetMemN(start,data,2) ) {
            return 15;
        }
#endif  
        return GOOD;
    case BI_S32_SLONG:
    case BI_U32_ULONG:
    case BI_S32_LONG:
		if ( 0 != pNode1->ConvertValue(ul) ) {
			return 10;
		}
        pValue = (char *) &ul;      
        data[0] = pValue[3];
        data[1] = pValue[2];
        data[2] = pValue[1];
        data[3] = pValue[0];
#ifdef _ZLR_        
        if ( ICE_OK != AbiSetMemN(start,data,4) ) {
            return 15;
        }
#endif  
        return GOOD;
    case BI_F32 :
		if ( 0 != pNode1->ConvertValue(f) ) {
			return 10;
		}
        pValue = ( char * )&f;
        if ( GOOD == SrcIsStatement() || GOOD == SrcIsIEEE() ) {
            data[3] = pValue[0];
            data[2] = pValue[1];
            data[1] = pValue[2];
            data[0] = pValue[3];        
        }
        else {
            data[3] = pValue[3];
            data[2] = pValue[2];
            data[1] = pValue[1];
            data[0] = pValue[0];        
        }
#ifdef _ZLR_        
        if ( ICE_OK != AbiSetMemN(start,data,4) ) {
            return 15;
        }
#endif  
        return GOOD;
    case BI_F64 :    
        if ( GOOD == SrcIsStatement() || GOOD == SrcIsIEEE() ) {
			if ( 0 != pNode1->ConvertValue(f) ) {
				return 10;
			}
            pValue = ( char * )&f;
            data[3] = pValue[0];
            data[2] = pValue[1];
            data[1] = pValue[2];
            data[0] = pValue[3];        
#ifdef _ZLR_        
            if ( ICE_OK != AbiSetMemN(start,data,4) ) {
                return 15;
            }
#endif  
        }
        else {
			if ( 0 != pNode1->ConvertValue(d) ) {
				return 10;
			}
            pValue = ( char * )&d;
            data[0] = pValue[0];
            data[1] = pValue[1];
            data[2] = pValue[2];
            data[3] = pValue[3];        
            data[4] = pValue[4];
            data[5] = pValue[5];
            data[6] = pValue[6];
            data[7] = pValue[7];        
#ifdef _ZLR_        
            if ( ICE_OK != AbiSetMemN(start,data,7) ) {
                return 15;
            }
#endif  
        }
        return GOOD;
    default :
		if ( 0 != pNode1->ConvertValue(uc) ) {
			return 10;
		}
        data[0] = (U8) uc;
        
#ifdef _ZLR_        
        if ( ICE_OK != AbiSetMemN(start,data,1) ) {
            return 15;
        }
#endif  
        return GOOD;
    }
    return GOOD;        
}

int CSymCalc::Assignment(CSymCalc* pNode1,void* pVoid)
{
    int nErr;

	if ( pNode1 == 0 ) return 3;
	if ( SYMTOKEN_SYMBOL != symType ) return 11;
	if ( nComplexType != 0 ) return 11;
	if ( SYMTOKEN_SYMBOL != pNode1->symType && 
		SYMTOKEN_NUM != pNode1->symType &&
		SYMTOKEN_FLOAT != pNode1->symType ) {
		return 11;
	}
	if ( SYMTOKEN_SYMBOL == pNode1->symType ) {
		if ( pNode1->nComplexType != 0 ) return 11;
	}
	if ( -1 == pNode1->m_nFlag ) {
		if (0 != pNode1->CheckValue()) {
			return 10;
		}
	}
    nErr = SetValue(pNode1,pVoid);
    if ( GOOD == nErr ) {
        nSymModifyMemory = 1;
        return GOOD;
    }
    else {
        return nErr;
    }
}

int CSymCalc::Increment(void)
{
	switch ( m_nFlag ) {
	case 0 :
		(result.c)++;
        break;
    case 1 :
		(result.uc)++;
        break;
    case 2 :
		(result.i)++;
        break;
    case 3 :
		(result.ui)++;
        break;
    case 4 :
		(result.l)++;
        break;
    case 5 :
		(result.ul)++;
        break;
	default :
		return 10;
	}
	symType = SYMTOKEN_NUM;
	return 0;
}

int CSymCalc::Decrement(void)
{
	switch ( m_nFlag ) {
	case 0 :
		(result.c)--;
        break;
    case 1 :
		(result.uc)--;
        break;
    case 2 :
		(result.i)--;
        break;
    case 3 :
		(result.ui)--;
        break;
    case 4 :
		(result.l)--;
        break;
    case 5 :
		(result.ul)--;
        break;
	default :
		return 10;
	}
	symType = SYMTOKEN_NUM;
	return 0;
}
/******************************** E O F ***********************************/
