
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMHEAP.CPP   1.7.1.0.1.0   11 Nov 1996 12:57:52   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMHEAP.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:52   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:14:28   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:00   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:06   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:45:54   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:50   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:00   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:16   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:50   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:24   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:30   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:12   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:34   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:20   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:38   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:50   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:38   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:42   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:24   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:54   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:08   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:14   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:08   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:04   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:58   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:22   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:36   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:10   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:10   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:58   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:12   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:50   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:36   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMHEAP.CPP
**
**  Description:
**     This module implements a simple heap manager for malloc/free style
**  memory management.  It works with FAR pointers, so pointers can be freely
**  shared between applications and DLLs.  Allocation size is limited to <64K.
**  The primary advantage to using this heap manager is that few window 
**  handles are used.
**
**  Status: CODED         ( PRELIMINARY | CODED | REVIEWED | TESTED )
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMHEAP.CPP   1.7.1.0.1.0   11 Nov 1996 12:57:52   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
**  IMPLEMENTATION NOTES:
**  This implementation is a set of 64K heaps.  Within a heap, a boundary tag
**  scheme and first fit strategy is used (see "An Implementation of New and
**  Dispose using Boundary Tags", Branko J. Gerovac,  Pascal News # 19, 
**  September 1980).
**
**  Management of GlobalAlloc()'ed memory is done here.  Memory management
**  within individual 64K heap chunks is private to "chunk.c".
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                      
#include "basewind.h"
#include "hosterrs.h"
#include "heap.h"


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

				
#define ALLOC_FLAGS (GMEM_MOVEABLE | GMEM_ZEROINIT )


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
/* None */
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/



                       /****************************
                        *                          *
                        *     LOCAL VARIABLES      *
                        *                          *
                        ****************************/

/* Area information */

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/****************************************************************************
**
**  TFree -- free memory alloc'ed via Malloc()
**
*****************************************************************************/
RETCODE EXPORT TFree( LPSTR randomPointer ) {
   HANDLE *hPtr;
   HANDLE handle;

   hPtr = (HANDLE *)(randomPointer - sizeof(HANDLE));
   handle = *hPtr;
   if (GlobalFree(handle) == NULL)  
      return GOOD;
   else return ER_HEAP_CORRUPT;   
}


/****************************************************************************
**
**  TMalloc -- allocate numBytes of memory or fail
**
*****************************************************************************/

LPSTR EXPORT TMalloc( U32 numBytes ) {
   HANDLE handle;
   LPU8 ptr;
   HANDLE *hPtr;
   LPU8 bytePtr;
   U32 actualSize;
#ifdef TEST_CASE
   int i;
   U8 *testPtr;
#endif

   handle = GlobalAlloc( ALLOC_FLAGS, numBytes+sizeof(HANDLE));
   if (handle == (HANDLE)NULL) {
      return(NULL);
   }
   ptr = (LPU8)GlobalLock(handle);
   if (ptr==(LPU8)NULL) {
      return(NULL);
   }
   actualSize = GlobalSize(handle);
   
   /* move to the end to check limit */
   bytePtr = ptr + actualSize - numBytes - sizeof(HANDLE);

   /* keep handle as part of data so it can be freed eventually */
   hPtr = (HANDLE *)bytePtr;
   *hPtr = handle;
#ifdef TEST_CASE
   testPtr = ptr + actualSize - 1; /* set on last valid byte */
   for(i=0; i<100; i++) {
      *testPtr = 0x55; /* first should be ok, second should fail */
      testPtr++;
   }
#endif
   return((LPSTR)(bytePtr+sizeof(HANDLE)));
}

/******************************** E O F ***********************************/
