
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMMPOOL.CPP   1.7.1.0.1.0   11 Nov 1996 13:00:04   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMMPOOL.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:04   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:00   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:30   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:34   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:50   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:40   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:42   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:28   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:54   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:22   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:55:52   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:34:52   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:04:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:12   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:36   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:11:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:31:04   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:21:10   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:06:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:09:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:06:54   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:07:28   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:28:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:16   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:27:38   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:12   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:38:56   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:01:50   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:44:30   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:42:38   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:18   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:06   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:44   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:28   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:46   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:26   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: SYMMPOOL.CPP
**
** Title: Memory Pool
**
** Purpose:
**  Create and manage a pool of allocated memory.  Provides:
**    AllocBytes
**    GetString
**    PutBytes
**    PutString
**    PutU32
**  Base class = Table
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/SYMMPOOL.CPP   1.7.1.0.1.0   11 Nov 1996 13:00:04   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"                      
#include "mempool.h"

#ifdef DEBUG
#include "winio.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


#define MEMTABLE_EXPANSION_SIZE 4096L * 4L
#define MEMTABLE_INIT_SIZE      4096L * 4L

MemPool st;

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

//member functions for MemPool

MemPool::MemPool():Table()        // constructor
   {
   availMemOffset = 0L;
   bytesThrownAway = 0;  // initialize member vars

   initialSize = MEMTABLE_INIT_SIZE;
   expandSize  = MEMTABLE_EXPANSION_SIZE;
   };  // end of MemPool constructor


RETCODE MemPool::AllocBytes(U8 size, TABLE_OFFSET& tableDataOffset)
   {
   RETCODE retCode;
   U32  memoryLeft;

   tableDataOffset = 0;    // set to null in case of a memory failure
   if ((memoryLeft = (tableSize-availMemOffset)) < (U32)size)
      {  // not enough space or empty table; must get more
      if ((retCode = InitOrExtendTable(0)) != SUCCESS) return retCode;
      // a non-zero retcode means no memory was found; otherwise fall thru

      else
         { // found more memory;
         // jump over any unused bytes to preserve 64K boundary
         // move pointer past boundary of old partition

         availMemOffset+= memoryLeft;
         bytesThrownAway += (U16)memoryLeft;
         }
      } // end of if that checked for enough memory or retrieved more memory

   // set the return pointer to the head of the data
   tableDataOffset = availMemOffset;

   // bump pointer to available memory by size of data
   availMemOffset += size;

   return SUCCESS;
   }  // end of MemPool::AllocBytes


VOID MemPool::GetString(TABLE_OFFSET tableDataOffset,
                        U8 FAR       *outputString)
   {
   HPU8  symPtr;
   U8    length;

   symPtr = GetHugeDataPtr(tableDataOffset);
   length = *symPtr++;                 // first byte is length
   for (; length > 0; length--)  {
      *outputString++ = *symPtr++;     // copy name one byte at a time
      };
   *outputString = '\0';                 // terminate string
   };  // end of MemPool::MemGetString


VOID MemPool::ObliterateTable(VOID) {
   Table::ObliterateTable();
   availMemOffset = 0L;
   bytesThrownAway = 0;  // initialize member vars

   initialSize = MEMTABLE_INIT_SIZE;
   expandSize  = MEMTABLE_EXPANSION_SIZE;
}

RETCODE MemPool::PutBytes(U8 *inputDataPtr, U8 size,
                          TABLE_OFFSET& tableDataOffset)
   {
   RETCODE retCode;
   HPU8 tempHugePtr;

   retCode = AllocBytes(size, tableDataOffset);
   if (retCode != SUCCESS) return retCode;  // return if some error

   // tableDataOffset points to head of allocated memory
   // calculate pointer to this data
   tempHugePtr = hpTableObject + tableDataOffset;

   // store the data
   for (; size > 0; size--)  {
      *tempHugePtr++ = *inputDataPtr++;
      }
   return SUCCESS;
   }  // end of MemPool::PutBytes


RETCODE MemPool::PutString(LPSTR lpString, TABLE_OFFSET& tableDataOffset)
   {
   RETCODE retCode;
   U32  memoryLeft;
   HPU8 tempHugePtr;
   U16 length;       // length of input string
   U8 i;

   tableDataOffset = 0;    // set to null in case of a memory failure
   length = (U16)lstrlen(lpString);

// removing check for 0 length string; instead, it places size of 0 into
// memory.  GetString will correctly create a NULL return string
//   if (length == 0)  {
//      return ER_STRING_LENGTH_ZERO;
//      }
   length = min(length, 255);    // truncate long strings

   // check for enough memory where requirement is string length plus one
   // byte for the header length byte.

   if ((memoryLeft = (tableSize-availMemOffset)) < (U32)(length + 1))  {
      // not enough space or empty table; must get more
#ifdef DEBUG
      printf("extending st\n");
#endif
      if ((retCode = InitOrExtendTable(0)) != SUCCESS)  return retCode;
      // a non-zero retcode means no memory was found; otherwise fall thru
      else  {
         // found more memory;
         // jump over any unused bytes to preserve 64K boundary
         // move pointer past boundary of old partition

         availMemOffset += memoryLeft;
         bytesThrownAway += (U16)memoryLeft;
         }
      } // end of if that checked for enough memory or retrieved more memory

   // put string into table
   // set the return pointer to the head of the data
   tableDataOffset = availMemOffset;

   // set huge pointer to available memory
   tempHugePtr = hpTableObject + availMemOffset;

   // increment offset pointer, by size of data, to next available memory loc
   availMemOffset += length + 1;

   // store length, then string
   *tempHugePtr++ = (U8)(length);   // put length into first byte
   for (i = 1; i <= length;)  {     // copy rest of string
      *tempHugePtr++ = *lpString++;
      i++;
      }
   return SUCCESS;
   };  // end of MemPool::PutString


RETCODE MemPool::PutU32(U32 data)
   {
   RETCODE retCode;
   U32  memoryLeft;
   HPU8 tempHugePtr;

   if ((memoryLeft = (tableSize-availMemOffset)) < 4)  {
      // not enough space or empty table; must get more
      if ((retCode = InitOrExtendTable(0)) != SUCCESS) return retCode;
      // a non-zero retcode means no memory was found; otherwise fall thru

      else  {
         // found more memory;
         // jump over any unused bytes to preserve 64K boundary
         // move pointer past boundary of old partition

         availMemOffset+= memoryLeft;
         bytesThrownAway += (U16)memoryLeft;
         }
      } // end of "if" that checked for enough memory or retrieved more memory

   // put the bytes into table

   // set huge pointer to available memory
   tempHugePtr = hpTableObject + availMemOffset;

   // bump pointer to available memory by size of data
   availMemOffset += 4;    // increment by size of U32

   // store the data
   *(U32 *)tempHugePtr = data;

   return SUCCESS;
   }  // end of MemPool::PutU32

/******************************** E O F *************************************/
