/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMOBJ.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMOBJ.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:56   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:44   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:14   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:18   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:18   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:50   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:06   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:37:28   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:06   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:42   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:04   Shirley
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:  SYMOBJ.CPP
**
**  Description:
**      member function of class CSymObj
**
**  Status:  CODED
**
**    Rev 1.0   27 Feb. 1996 15:30:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <memory.h>
#include <string.h>
#include "symobj.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
*                                                                          *
*  InitStrCmd  --  save expression string to m_strCmd                      *
*  parameter :                                                             *
*       pStrSrc  --  expression string                                     *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::InitStrCmd(const char* pStrSrc, int flag)
{
    if ( m_strCmd ) delete []m_strCmd;
    m_strCmd = 0;
    if ( pStrSrc == 0 ) return;
    int nLen = strlen( pStrSrc );
    m_strCmd = new char [ nLen+1 ];
    if ( m_strCmd == 0 ) {
        m_nErrNo = 1;
        return;      
    }
    memcpy(m_strCmd , pStrSrc, nLen);
    m_strCmd[nLen] = '\0';
    m_nLen = nLen;   
    m_nCmdFlag = flag;
    return;
}

/***************************************************************************
*                                                                          *
*  SkipLeftSpace  --  skip over space                                      *
*  parameter :                                                             *
*       pStrSrc  --  input string                                          *
*       pStrRst  --  output string                                         *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::SkipLeftSpace(char* pStrSrc, char*& pStrRst)
{
    pStrRst = 0;
    if ( pStrSrc == 0 ) {
        m_nErrNo = 3;
        return;      
    }
    char *pStr;
    
    pStr = pStrSrc;
    while( *pStr == ' ' ) {
        pStr++;
    }
    pStrRst = pStr; 
    return;
}

/***************************************************************************
*                                                                          *
*  SkipLeftSpace  --  skip over space                                      *
*  parameter :                                                             *
*       nPos  --   start pos in string m_strCmd                            *
*       nResultPos  --  no whitespace first pos in string m_strCmd         *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::SkipLeftSpace(int nPos, int &nResultPos)
{
    nResultPos = nPos;
    if ( m_strCmd == 0 ) {
        m_nErrNo = 2;
        return;
    }    
//    if ( m_nLen <= nPos ) {
    if ( m_nLen == nPos ) {
    	return;
    }
    if ( m_nLen < nPos ) {
        m_nErrNo = 3;
        return;      
    }
    char *pStr;
    
    pStr = &m_strCmd[nPos];
    while( *pStr == ' ' ) {
        nResultPos++;
        pStr++;
    }
    return;
}

/***************************************************************************
*                                                                          *
*  SkipRightSpace  --  skip over space                                      *
*  parameter :                                                             *
*       pStrSrc  --  input string                                          *
*  return value :                                                          *
*       None                                                               *
*                                                                          *
***************************************************************************/
void CSymObj::SkipRightSpace(char* pStrSrc)
{
	int nLen;
	if ( 0 == pStrSrc ) return;
	nLen = strlen( pStrSrc );
	if ( 0 == nLen ) return;
	while( nLen ) {
		if ( pStrSrc[ nLen-1 ] != ' ' ) break;
		nLen--;
	}
	pStrSrc[nLen] = '\0'; 
    return;
}
/******************************** E O F ***********************************/
