/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMSTACK.H__   1.7.1.0.1.0   11 Nov 1996 12:59:56   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMSTACK.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:56   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:40   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:10   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:14   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:14   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:46   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:04   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:37:24   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:00   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:52   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:14   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:40   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:36:02   Shirley
** Initial revision.
** 
****************************************************************************/
/****************************************************************************
**
**  Name:  SYMSTACK.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymStack
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   13 March 1996 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMSTACK_H_
#define _SYMSTACK_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        
struct StackNode {
	void * pNode;
	struct StackNode *next;
	struct StackNode *prev;
public :
	StackNode() {
		pNode = 0;
		next = 0;
		prev = 0;
	}
};

class CSymStack {                 
public :
    CSymStack() {
    	m_pTop = 0;
    	m_pBottom = 0;
    }
    ~CSymStack() {      
		DeleteStack();
    }
     
private :       
	struct StackNode *m_pTop;
	struct StackNode *m_pBottom;
    
public :
	int IsEmpty(void);
	int DeleteStack(void);
	int Push(void* pNode);	
	int Pop(void*& pNode);
};
                
#endif
/******************************** E O F ***********************************/
